/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.perf;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.spongepowered.asm.util.PrettyPrinter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class Profiler {
    public static final int ROOT = 1;
    public static final int FINE = 2;
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    private final List<String> phases = new ArrayList<String>();
    private final Deque<Section> stack = new LinkedList<Section>();
    private boolean active;

    public Profiler() {
        this.phases.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46"));
    }

    public void setActive(boolean bl) {
        if (!this.active && bl || !bl) {
            this.reset();
        }
        this.active = bl;
    }

    public void reset() {
        for (Section section : this.sections.values()) {
            section.invalidate();
        }
        this.sections.clear();
        this.phases.clear();
        this.phases.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46"));
        this.stack.clear();
    }

    public Section get(String string) {
        Section section = this.sections.get(string);
        if (section == null) {
            section = this.active ? new LiveSection(string, this.phases.size() - (0xA0BDBF0 ^ 0xA0BDBF1)) : new Section(string);
            this.sections.put(string, section);
        }
        return section;
    }

    private Section getSubSection(String string, String string2, Section section) {
        Section section2 = this.sections.get(string);
        if (section2 == null) {
            section2 = new SubSection(string, this.phases.size() - (0xDCC24B7 ^ 0xDCC24B6), string2, section);
            this.sections.put(string, section2);
        }
        return section2;
    }

    boolean isHead(Section section) {
        return (this.stack.peek() == section ? 0xF4EFA7D2 ^ 0xF4EFA7D3 : 0xE0A8D307 ^ 0xE0A8D307) != 0;
    }

    public Section begin(String ... stringArray) {
        return this.begin(0x76912AA ^ 0x76912AA, stringArray);
    }

    public Section begin(int n, String ... stringArray) {
        return this.begin(n, Joiner.on((char)(0xF27C3BA8 ^ 0xF27C3B86)).join((Object[])stringArray));
    }

    public Section begin(String string) {
        return this.begin(0x6D10D82F ^ 0x6D10D82F, string);
    }

    public Section begin(int n, String string) {
        int n2 = (n & (0x7DC5F914 ^ 0x7DC5F915)) != 0 ? 0xCD8F0F ^ 0xCD8F0E : 0x1C2F8AC6 ^ 0x1C2F8AC6;
        int n3 = (n & (0xF7B4BD26 ^ 0xF7B4BD24)) != 0 ? 0x2CF5EE4F ^ 0x2CF5EE4E : 0xDDD561B0 ^ 0xDDD561B0;
        String string2 = string;
        Section section = this.stack.peek();
        if (section != null) {
            string2 = section.getName() + (n2 != 0 ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ab\ua4eb\ua031") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<")) + string2;
            if (section.isRoot() && n2 == 0) {
                int n4 = section.getName().lastIndexOf(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ab\ua4eb\ua031"));
                string = (n4 > (0xE578E120 ^ 0x1A871EDF) ? section.getName().substring(n4 + (0x12202E7C ^ 0x12202E78)) : section.getName()) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<") + string;
                n2 = 0x77D911C ^ 0x77D911D;
            }
        }
        Section section2 = this.get(n2 != 0 ? string : string2);
        if (n2 != 0 && section != null && this.active) {
            section2 = this.getSubSection(string2, section.getName(), section2);
        }
        section2.setFine(n3 != 0).setRoot(n2 != 0);
        this.stack.push(section2);
        return section2.start();
    }

    void end(Section section) {
        block5: {
            try {
                Section section2;
                Section section3 = section2 = this.stack.pop();
                while (section3 != section) {
                    if (section3 == null && this.active) {
                        if (section2 == null) {
                            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e4\ua4a0\ua065\ua945\u7d62\u8e42\u247f\u8b77\u3464f\ua7e7\ua4b6\ua07a\ua945\u7d7f\u8e59\u243a\u8b32\u347ab\ua7f2\ua4ac"));
                        }
                        throw new IllegalStateException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7f1\ua4bd\ua078\ua906\u7d7e\u8e0a\u246d\u8b36\u34642\ua7e8\ua4ba\ua065\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4a6\ua065\ua904\u7d75\u8e41\u2436\u8b77\u347fw\ua7e7\ua4b1\ua031\ua912\u7d77\u8e59\u243a") + section2);
                    }
                    section3 = this.stack.pop();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (!this.active) break block5;
                throw new IllegalStateException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e4\ua4a0\ua065\ua945\u7d62\u8e42\u247f\u8b77\u3464f\ua7e7\ua4b6\ua07a\ua945\u7d7f\u8e59\u243a\u8b32\u347ab\ua7f2\ua4ac"));
            }
        }
    }

    public void mark(String string) {
        long l = 0x2ACCF31549F9E0DBL ^ 0x2ACCF31549F9E0DBL;
        for (Section section : this.sections.values()) {
            l += section.getTime();
        }
        if (l == (0x123D5B95BB3DABB6L ^ 0x123D5B95BB3DABB6L)) {
            int n = this.phases.size();
            this.phases.set(n - (0x5CAA4EF6 ^ 0x5CAA4EF7), string);
            return;
        }
        this.phases.add(string);
        for (Section section : this.sections.values()) {
            section.mark();
        }
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public PrettyPrinter printer(boolean bl, boolean bl2) {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        int n = this.phases.size() + (0xE7057EDE ^ 0xE7057EDA);
        int[] nArray = new int[0xB1AAC3C3 ^ 0xB1AAC3C6];
        nArray[0x8239F975 ^ 0x8239F975] = 0x386529B5 ^ 0x386529B5;
        nArray[0x16B40738 ^ 0x16B40739] = 0xFDBD7315 ^ 0xFDBD7314;
        nArray[0x581AE816 ^ 0x581AE814] = 0x1FB1A34D ^ 0x1FB1A34F;
        nArray[0x28BBB806 ^ 0x28BBB805] = n - (0x549BA999 ^ 0x549BA99B);
        nArray[0xA9F85B1B ^ 0xA9F85B1F] = n - (0x804831CD ^ 0x804831CC);
        int[] nArray2 = nArray;
        Object[] objectArray = new Object[n * (0xF5B5E46 ^ 0xF5B5E44)];
        int n2 = 0xC6DC882D ^ 0xC6DC882D;
        int n3 = 0xBD9EF323 ^ 0xBD9EF323;
        while (n2 < n) {
            objectArray[n3 + (0xB9E3EAE8 ^ 0xB9E3EAE9)] = PrettyPrinter.Alignment.RIGHT;
            if (n2 == nArray2[0x3C3BBB5 ^ 0x3C3BBB5]) {
                objectArray[n3] = (bl2 ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6")) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7e3\ua4b6\ua065\ua90c\u7d79\u8e44");
                objectArray[n3 + (0x4E28DFB9 ^ 0x4E28DFB8)] = PrettyPrinter.Alignment.LEFT;
            } else {
                objectArray[n3] = n2 == nArray2[0xB64074A5 ^ 0xB64074A4] ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f5\ua031\ua931\u7d59\u8e7e\u245b\u8b1b") : (n2 == nArray2[0x2D8F4474 ^ 0x2D8F4477] ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f5\ua031\ua926\u7d79\u8e5f\u2474\u8b23") : (n2 == nArray2[0xAB041797 ^ 0xAB041793] ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7f0\ua4b2\ua03f\ua945") : (n2 - nArray2[0x6519AAF6 ^ 0x6519AAF4] < this.phases.size() ? this.phases.get(n2 - nArray2[0x9925AF75 ^ 0x9925AF77]) : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""))));
            }
            n3 = ++n2 * (0x661AD0F ^ 0x661AD0D);
        }
        prettyPrinter.table(objectArray).th().hr().add();
        for (Section section : this.sections.values()) {
            if (section.isFine() && !bl || bl2 && section.getDelegate() != section) continue;
            this.printSectionRow(prettyPrinter, n, nArray2, section, bl2);
            if (!bl2) continue;
            for (Section section2 : this.sections.values()) {
                Section section3 = section2.getDelegate();
                if (section2.isFine() && !bl || section3 != section || section3 == section2) continue;
                this.printSectionRow(prettyPrinter, n, nArray2, section2, bl2);
            }
        }
        return prettyPrinter.add();
    }

    private void printSectionRow(PrettyPrinter prettyPrinter, int n, int[] nArray, Section section, boolean bl) {
        long[] lArray;
        int n2 = section.getDelegate() != section ? 0xF87F6D73 ^ 0xF87F6D72 : 0x373DD3F9 ^ 0x373DD3F9;
        Object[] objectArray = new Object[n];
        int n3 = 0x8973ACB4 ^ 0x8973ACB5;
        if (bl) {
            objectArray[0x62B2F3C5 ^ 0x62B2F3C5] = n2 != 0 ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4eb\ua031") + section.getBaseName() : section.getName();
        } else {
            objectArray[0x24511599 ^ 0x24511599] = (n2 != 0 ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("9\ua7a6") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6")) + section.getName();
        }
        long[] lArray2 = lArray = section.getTimes();
        int n4 = lArray2.length;
        for (int i = 0xEA764EB9 ^ 0xEA764EB9; i < n4; ++i) {
            long l = lArray2[i];
            if (n3 == nArray[0x393767A8 ^ 0x393767A9]) {
                objectArray[n3++] = section.getTotalTime() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7eb\ua4a6");
            }
            if (n3 < nArray[0x652B864D ^ 0x652B864F] || n3 >= objectArray.length) continue;
            objectArray[n3++] = l + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7eb\ua4a6");
        }
        objectArray[nArray[0x525F6D93 ^ 0x525F6D90]] = section.getTotalCount();
        objectArray[nArray[0x4DDAD5D ^ 0x4DDAD59]] = new DecimalFormat(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f5\ua032\ua946\u7d35\u8e1a\u2434\u8b67\u3427\"\ua7a6\ua4b8\ua062")).format(section.getTotalAverageTime());
        for (int i = 0x4D1EB79 ^ 0x4D1EB79; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            objectArray[i] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("?");
        }
        prettyPrinter.tr(objectArray);
    }

    class SubSection
    extends LiveSection {
        private final String baseName;
        private final Section root;

        SubSection(String string, int n, String string2, Section section) {
            super(string, n);
            this.baseName = string2;
            this.root = section;
        }

        @Override
        Section invalidate() {
            this.root.invalidate();
            return super.invalidate();
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public void setInfo(String string) {
            this.root.setInfo(string);
            super.setInfo(string);
        }

        @Override
        Section getDelegate() {
            return this.root;
        }

        @Override
        Section start() {
            this.root.start();
            return super.start();
        }

        @Override
        public Section end() {
            this.root.stop();
            return super.end();
        }

        @Override
        public Section next(String string) {
            super.stop();
            return this.root.next(string);
        }
    }

    class LiveSection
    extends Section {
        private int cursor;
        private long[] times;
        private long start;
        private long time;
        private long markedTime;
        private int count;
        private int markedCount;

        LiveSection(String string, int n) {
            super(string);
            this.cursor = 0xF9596DA0 ^ 0xF9596DA0;
            this.times = new long[0x707DFBC ^ 0x707DFBC];
            this.start = 0xAC1A09AA778CC801L ^ 0xAC1A09AA778CC801L;
            this.cursor = n;
        }

        @Override
        Section start() {
            this.start = System.currentTimeMillis();
            return this;
        }

        @Override
        protected Section stop() {
            if (this.start > (0xC629B703317A0CC9L ^ 0xC629B703317A0CC9L)) {
                this.time += System.currentTimeMillis() - this.start;
            }
            this.start = 0x77A5F73822AAE0CAL ^ 0x77A5F73822AAE0CAL;
            this.count += 0xCE47F239 ^ 0xCE47F238;
            return this;
        }

        @Override
        public Section end() {
            this.stop();
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        @Override
        void mark() {
            if (this.cursor >= this.times.length) {
                this.times = Arrays.copyOf(this.times, this.cursor + (0xB3004561 ^ 0xB3004565));
            }
            this.times[this.cursor] = this.time;
            this.markedTime += this.time;
            this.markedCount += this.count;
            this.time = 0x8C6B9B4CE49DFDC6L ^ 0x8C6B9B4CE49DFDC6L;
            this.count = 0xA9B65E07 ^ 0xA9B65E07;
            this.cursor += 0x2F806B1 ^ 0x2F806B0;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public long getTotalTime() {
            return this.time + this.markedTime;
        }

        @Override
        public double getSeconds() {
            return (double)this.time * 0.001;
        }

        @Override
        public double getTotalSeconds() {
            return (double)(this.time + this.markedTime) * 0.001;
        }

        @Override
        public long[] getTimes() {
            long[] lArray = new long[this.cursor + (0xAF323217 ^ 0xAF323216)];
            System.arraycopy(this.times, 0xC4E450BD ^ 0xC4E450BD, lArray, 0x42E26884 ^ 0x42E26884, Math.min(this.times.length, this.cursor));
            lArray[this.cursor] = this.time;
            return lArray;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int getTotalCount() {
            return this.count + this.markedCount;
        }

        @Override
        public double getAverageTime() {
            return this.count > 0 ? (double)this.time / (double)this.count : 0.0;
        }

        @Override
        public double getTotalAverageTime() {
            return this.count > 0 ? (double)(this.time + this.markedTime) / (double)(this.count + this.markedCount) : 0.0;
        }
    }

    public class Section {
        static final String SEPARATOR_ROOT = " -> ";
        static final String SEPARATOR_CHILD = ".";
        private final String name;
        private boolean root;
        private boolean fine;
        protected boolean invalidated;
        private String info;

        Section(String string) {
            this.name = string;
            this.info = string;
        }

        Section getDelegate() {
            return this;
        }

        Section invalidate() {
            this.invalidated = 0xC272E675 ^ 0xC272E674;
            return this;
        }

        Section setRoot(boolean bl) {
            this.root = bl;
            return this;
        }

        public boolean isRoot() {
            return this.root;
        }

        Section setFine(boolean bl) {
            this.fine = bl;
            return this;
        }

        public boolean isFine() {
            return this.fine;
        }

        public String getName() {
            return this.name;
        }

        public String getBaseName() {
            return this.name;
        }

        public void setInfo(String string) {
            this.info = string;
        }

        public String getInfo() {
            return this.info;
        }

        Section start() {
            return this;
        }

        protected Section stop() {
            return this;
        }

        public Section end() {
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        public Section next(String string) {
            this.end();
            return Profiler.this.begin(string);
        }

        void mark() {
        }

        public long getTime() {
            return 0x104D56E4BF518DE0L ^ 0x104D56E4BF518DE0L;
        }

        public long getTotalTime() {
            return 0xFCABE79196070DA6L ^ 0xFCABE79196070DA6L;
        }

        public double getSeconds() {
            return 0.0;
        }

        public double getTotalSeconds() {
            return 0.0;
        }

        public long[] getTimes() {
            return new long[0xE3C1776C ^ 0xE3C1776D];
        }

        public int getCount() {
            return 0x2F06A7BB ^ 0x2F06A7BB;
        }

        public int getTotalCount() {
            return 0xB662102C ^ 0xB662102C;
        }

        public double getAverageTime() {
            return 0.0;
        }

        public double getTotalAverageTime() {
            return 0.0;
        }

        public final String toString() {
            return this.name;
        }
    }
}

