/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.asm.util.ObfuscationUtil;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;
import org.spongepowered.tools.obfuscation.mapping.IMappingProvider;
import org.spongepowered.tools.obfuscation.mapping.IMappingWriter;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public abstract class ObfuscationEnvironment
implements IObfuscationEnvironment {
    protected final ObfuscationType type;
    protected final IMappingProvider mappingProvider;
    protected final IMappingWriter mappingWriter;
    protected final RemapperProxy remapper = new RemapperProxy();
    protected final IMixinAnnotationProcessor ap;
    protected final String outFileName;
    protected final List<String> inFileNames;
    private boolean initDone;

    protected ObfuscationEnvironment(ObfuscationType obfuscationType) {
        this.type = obfuscationType;
        this.ap = obfuscationType.getAnnotationProcessor();
        this.inFileNames = obfuscationType.getInputFileNames();
        this.outFileName = obfuscationType.getOutputFileName();
        this.mappingProvider = this.getMappingProvider(this.ap, this.ap.getProcessingEnvironment().getFiler());
        this.mappingWriter = this.getMappingWriter(this.ap, this.ap.getProcessingEnvironment().getFiler());
    }

    public String toString() {
        return this.type.toString();
    }

    protected abstract IMappingProvider getMappingProvider(Messager var1, Filer var2);

    protected abstract IMappingWriter getMappingWriter(Messager var1, Filer var2);

    private boolean initMappings() {
        if (!this.initDone) {
            this.initDone = 0x7EF7965A ^ 0x7EF7965B;
            if (this.inFileNames == null) {
                this.ap.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7ee\ua4b0\ua031") + this.type.getConfig().getInputFileOption() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e7\ua4a7\ua076\ua910\u7d7b\u8e4f\u2474\u8b23\u3437e\ua7e7\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b24\u3462b\ua7f6\ua4b9\ua078\ua900\u7d72\u8e06\u243a\u8b38\u3475t\ua7f3\ua4a6\ua072\ua904\u7d62\u8e43\u2475\u8b39\u3437b\ua7f4\ua4ba\ua072\ua900\u7d65\u8e59\u2473\u8b39\u34702\ua7f1\ua4bc\ua07d\ua909\u7d36\u8e44\u2475\u8b23\u3437}\ua7e5\ua4b6\ua064\ua917"));
                return (0x468894EE ^ 0x468894EE) != 0;
            }
            int n = 0xA318064E ^ 0xA318064E;
            for (String string : this.inFileNames) {
                File file = new File(string);
                try {
                    if (!file.isFile()) continue;
                    this.ap.printMessage(Diagnostic.Kind.NOTE, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^\ua7e9\ua4b4\ua075\ua90c\u7d78\u8e4d\u243a") + this.type + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7eb\ua4b4\ua061\ua915\u7d7f\u8e44\u247d\u8b24\u3437t\ua7f4\ua4ba\ua07c\ua945") + file.getAbsolutePath());
                    this.mappingProvider.read(file);
                    ++n;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (n < (0x36F7DA48 ^ 0x36F7DA49)) {
                this.ap.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\\\ua7e9\ua4f5\ua067\ua904\u7d7a\u8e43\u247e\u8b77\u347e|\ua7f6\ua4a0\ua065\ua945\u7d70\u8e43\u2476\u8b32\u34642\ua7e0\ua4ba\ua063\ua945") + this.type + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e5\ua4ba\ua064\ua909\u7d72\u8e0a\u2478\u8b32\u3437`\ua7e3\ua4b4\ua075\ua949\u7d36\u8e5a\u2468\u8b38\u3474w\ua7f5\ua4a6\ua078\ua90b\u7d71\u8e0a\u2477\u8b36\u346e2\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b24\u3462q\ua7e3\ua4a6\ua062\ua903\u7d63\u8e46\u2434"));
                this.mappingProvider.clear();
            }
        }
        return (!this.mappingProvider.isEmpty() ? 0x5F6577D8 ^ 0x5F6577D9 : 0x1C15BB4 ^ 0x1C15BB4) != 0;
    }

    public ObfuscationType getType() {
        return this.type;
    }

    @Override
    public MappingMethod getObfMethod(MemberInfo memberInfo) {
        MappingMethod mappingMethod = this.getObfMethod(memberInfo.asMethodMapping());
        if (mappingMethod != null || !memberInfo.isFullyQualified()) {
            return mappingMethod;
        }
        TypeHandle typeHandle = this.ap.getTypeProvider().getTypeHandle(memberInfo.owner);
        if (typeHandle == null || typeHandle.isImaginary()) {
            return null;
        }
        TypeMirror typeMirror = typeHandle.getElement().getSuperclass();
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        String string = ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString();
        return this.getObfMethod(new MemberInfo(memberInfo.name, string.replace((char)(0x2A394C29 ^ 0x2A394C07), (char)(0x18D1A7F9 ^ 0x18D1A7D6)), memberInfo.desc, memberInfo.matchAll));
    }

    @Override
    public MappingMethod getObfMethod(MappingMethod mappingMethod) {
        return this.getObfMethod(mappingMethod, (0x35454E93 ^ 0x35454E92) != 0);
    }

    @Override
    public MappingMethod getObfMethod(MappingMethod mappingMethod, boolean bl) {
        if (this.initMappings()) {
            Object object;
            int n = 0x1EDDC29B ^ 0x1EDDC29A;
            MappingMethod mappingMethod2 = null;
            for (object = mappingMethod; object != null && mappingMethod2 == null; object = ((MappingMethod)object).getSuper()) {
                mappingMethod2 = this.mappingProvider.getMethodMapping((MappingMethod)object);
            }
            if (mappingMethod2 == null) {
                if (bl) {
                    return null;
                }
                mappingMethod2 = mappingMethod.copy();
                n = 0xF50A395F ^ 0xF50A395F;
            }
            if ((object = this.getObfClass(mappingMethod2.getOwner())) == null || ((String)object).equals(mappingMethod.getOwner()) || ((String)object).equals(mappingMethod2.getOwner())) {
                return n != 0 ? mappingMethod2 : null;
            }
            if (n != 0) {
                return mappingMethod2.move((String)object);
            }
            String string = ObfuscationUtil.mapDescriptor(mappingMethod2.getDesc(), this.remapper);
            return new MappingMethod((String)object, mappingMethod2.getSimpleName(), string);
        }
        return null;
    }

    @Override
    public MemberInfo remapDescriptor(MemberInfo memberInfo) {
        String string;
        String string2;
        int n = 0x434BFE18 ^ 0x434BFE18;
        String string3 = memberInfo.owner;
        if (string3 != null && (string2 = this.remapper.map(string3)) != null) {
            string3 = string2;
            n = 0x44F5AE7D ^ 0x44F5AE7C;
        }
        if ((string2 = memberInfo.desc) != null && !(string = ObfuscationUtil.mapDescriptor(memberInfo.desc, this.remapper)).equals(memberInfo.desc)) {
            string2 = string;
            n = 0x3AB6DA89 ^ 0x3AB6DA88;
        }
        return n != 0 ? new MemberInfo(memberInfo.name, string3, string2, memberInfo.matchAll) : null;
    }

    @Override
    public String remapDescriptor(String string) {
        return ObfuscationUtil.mapDescriptor(string, this.remapper);
    }

    @Override
    public MappingField getObfField(MemberInfo memberInfo) {
        return this.getObfField(memberInfo.asFieldMapping(), (0xFFED91AD ^ 0xFFED91AC) != 0);
    }

    @Override
    public MappingField getObfField(MappingField mappingField) {
        return this.getObfField(mappingField, (0xF08FDCB6 ^ 0xF08FDCB7) != 0);
    }

    @Override
    public MappingField getObfField(MappingField mappingField, boolean bl) {
        String string;
        if (!this.initMappings()) {
            return null;
        }
        MappingField mappingField2 = this.mappingProvider.getFieldMapping(mappingField);
        if (mappingField2 == null) {
            if (bl) {
                return null;
            }
            mappingField2 = mappingField;
        }
        if ((string = this.getObfClass(mappingField2.getOwner())) == null || string.equals(mappingField.getOwner()) || string.equals(mappingField2.getOwner())) {
            return mappingField2 != mappingField ? mappingField2 : null;
        }
        return mappingField2.move(string);
    }

    @Override
    public String getObfClass(String string) {
        if (!this.initMappings()) {
            return null;
        }
        return this.mappingProvider.getClassMapping(string);
    }

    @Override
    public void writeMappings(Collection<IMappingConsumer> collection) {
        IMappingConsumer.MappingSet<MappingField> mappingSet = new IMappingConsumer.MappingSet<MappingField>();
        IMappingConsumer.MappingSet<MappingMethod> mappingSet2 = new IMappingConsumer.MappingSet<MappingMethod>();
        for (IMappingConsumer iMappingConsumer : collection) {
            mappingSet.addAll(iMappingConsumer.getFieldMappings(this.type));
            mappingSet2.addAll(iMappingConsumer.getMethodMappings(this.type));
        }
        this.mappingWriter.write(this.outFileName, this.type, mappingSet, mappingSet2);
    }

    final class RemapperProxy
    implements ObfuscationUtil.IClassRemapper {
        RemapperProxy() {
        }

        @Override
        public String map(String string) {
            if (ObfuscationEnvironment.this.mappingProvider == null) {
                return null;
            }
            return ObfuscationEnvironment.this.mappingProvider.getClassMapping(string);
        }

        @Override
        public String unmap(String string) {
            if (ObfuscationEnvironment.this.mappingProvider == null) {
                return null;
            }
            return ObfuscationEnvironment.this.mappingProvider.getClassMapping(string);
        }
    }
}

