/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.mirror;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.FieldHandle;
import org.spongepowered.tools.obfuscation.mirror.MethodHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeReference;
import org.spongepowered.tools.obfuscation.mirror.TypeUtils;
import org.spongepowered.tools.obfuscation.mirror.mapping.ResolvableMappingMethod;

public class TypeHandle {
    private final String name;
    private final PackageElement pkg;
    private final TypeElement element;
    private TypeReference reference;

    public TypeHandle(PackageElement packageElement, String string) {
        this.name = string.replace((char)(0xC45AE6EC ^ 0xC45AE6C2), (char)(0xB657BC47 ^ 0xB657BC68));
        this.pkg = packageElement;
        this.element = null;
    }

    public TypeHandle(TypeElement typeElement) {
        this.pkg = TypeUtils.getPackage(typeElement);
        this.name = TypeUtils.getInternalName(typeElement);
        this.element = typeElement;
    }

    public TypeHandle(DeclaredType declaredType) {
        this((TypeElement)declaredType.asElement());
    }

    public final String toString() {
        return this.name.replace((char)(0x630D6760 ^ 0x630D674F), (char)(0xB966293E ^ 0xB9662910));
    }

    public final String getName() {
        return this.name;
    }

    public final PackageElement getPackage() {
        return this.pkg;
    }

    public final TypeElement getElement() {
        return this.element;
    }

    protected TypeElement getTargetElement() {
        return this.element;
    }

    public AnnotationHandle getAnnotation(Class<? extends Annotation> clazz) {
        return AnnotationHandle.of(this.getTargetElement(), clazz);
    }

    public final List<? extends Element> getEnclosedElements() {
        return TypeHandle.getEnclosedElements(this.getTargetElement());
    }

    public <T extends Element> List<T> getEnclosedElements(ElementKind ... elementKindArray) {
        return TypeHandle.getEnclosedElements(this.getTargetElement(), elementKindArray);
    }

    public TypeMirror getType() {
        return this.getTargetElement() != null ? this.getTargetElement().asType() : null;
    }

    public TypeHandle getSuperclass() {
        TypeElement typeElement = this.getTargetElement();
        if (typeElement == null) {
            return null;
        }
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror == null || typeMirror.getKind() == TypeKind.NONE) {
            return null;
        }
        return new TypeHandle((DeclaredType)typeMirror);
    }

    public List<TypeHandle> getInterfaces() {
        if (this.getTargetElement() == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TypeMirror typeMirror : this.getTargetElement().getInterfaces()) {
            builder.add((Object)new TypeHandle((DeclaredType)typeMirror));
        }
        return builder.build();
    }

    public boolean isPublic() {
        return (this.getTargetElement() != null && this.getTargetElement().getModifiers().contains((Object)Modifier.PUBLIC) ? 0x5BA34A35 ^ 0x5BA34A34 : 0x26E8AB8A ^ 0x26E8AB8A) != 0;
    }

    public boolean isImaginary() {
        return (this.getTargetElement() == null ? 0x126788ED ^ 0x126788EC : 0x9CB3DEE5 ^ 0x9CB3DEE5) != 0;
    }

    public boolean isSimulated() {
        return (0x4141A5F3 ^ 0x4141A5F3) != 0;
    }

    public final TypeReference getReference() {
        if (this.reference == null) {
            this.reference = new TypeReference(this);
        }
        return this.reference;
    }

    public MappingMethod getMappingMethod(String string, String string2) {
        return new ResolvableMappingMethod(this, string, string2);
    }

    public String findDescriptor(MemberInfo memberInfo) {
        String string = memberInfo.desc;
        if (string == null) {
            ElementKind[] elementKindArray = new ElementKind[0x608B8EEE ^ 0x608B8EEF];
            elementKindArray[0xE51CE51A ^ 0xE51CE51A] = ElementKind.METHOD;
            for (ExecutableElement executableElement : this.getEnclosedElements(elementKindArray)) {
                if (!executableElement.getSimpleName().toString().equals(memberInfo.name)) continue;
                string = TypeUtils.getDescriptor(executableElement);
                break;
            }
        }
        return string;
    }

    public final FieldHandle findField(VariableElement variableElement) {
        return this.findField(variableElement, (0x44F58317 ^ 0x44F58316) != 0);
    }

    public final FieldHandle findField(VariableElement variableElement, boolean bl) {
        return this.findField(variableElement.getSimpleName().toString(), TypeUtils.getTypeName(variableElement.asType()), bl);
    }

    public final FieldHandle findField(String string, String string2) {
        return this.findField(string, string2, (0x8B17645A ^ 0x8B17645B) != 0);
    }

    public FieldHandle findField(String string, String string2, boolean bl) {
        String string3 = TypeUtils.stripGenerics(string2);
        ElementKind[] elementKindArray = new ElementKind[0xF805BB82 ^ 0xF805BB83];
        elementKindArray[0x7695E3EF ^ 0x7695E3EF] = ElementKind.FIELD;
        for (VariableElement variableElement : this.getEnclosedElements(elementKindArray)) {
            if (TypeHandle.compareElement(variableElement, string, string2, bl)) {
                return new FieldHandle(this.getTargetElement(), variableElement);
            }
            if (!TypeHandle.compareElement(variableElement, string, string3, bl)) continue;
            return new FieldHandle(this.getTargetElement(), variableElement, (0xE8E99190 ^ 0xE8E99191) != 0);
        }
        return null;
    }

    public final MethodHandle findMethod(ExecutableElement executableElement) {
        return this.findMethod(executableElement, (0x3B740484 ^ 0x3B740485) != 0);
    }

    public final MethodHandle findMethod(ExecutableElement executableElement, boolean bl) {
        return this.findMethod(executableElement.getSimpleName().toString(), TypeUtils.getJavaSignature(executableElement), bl);
    }

    public final MethodHandle findMethod(String string, String string2) {
        return this.findMethod(string, string2, (0x9FB8E567 ^ 0x9FB8E566) != 0);
    }

    public MethodHandle findMethod(String string, String string2, boolean bl) {
        String string3 = TypeUtils.stripGenerics(string2);
        return TypeHandle.findMethod(this, string, string2, string3, bl);
    }

    protected static MethodHandle findMethod(TypeHandle typeHandle, String string, String string2, String string3, boolean bl) {
        ElementKind[] elementKindArray = new ElementKind[0xA3632566 ^ 0xA3632564];
        elementKindArray[0x1A2A3C62 ^ 0x1A2A3C62] = ElementKind.CONSTRUCTOR;
        elementKindArray[0xBDC48602 ^ 0xBDC48603] = ElementKind.METHOD;
        for (ExecutableElement executableElement : TypeHandle.getEnclosedElements(typeHandle.getTargetElement(), elementKindArray)) {
            if (!TypeHandle.compareElement(executableElement, string, string2, bl) && !TypeHandle.compareElement(executableElement, string, string3, bl)) continue;
            return new MethodHandle(typeHandle, executableElement);
        }
        return null;
    }

    protected static boolean compareElement(Element element, String string, String string2, boolean bl) {
        try {
            boolean bl2;
            String string3 = element.getSimpleName().toString();
            String string4 = TypeUtils.getJavaSignature(element);
            String string5 = TypeUtils.stripGenerics(string4);
            boolean bl3 = bl2 = bl ? string.equals(string3) : string.equalsIgnoreCase(string3);
            return (bl2 && (string2.length() == 0 || string2.equals(string4) || string2.equals(string5)) ? 0x6F316583 ^ 0x6F316582 : 0x78C78609 ^ 0x78C78609) != 0;
        }
        catch (NullPointerException nullPointerException) {
            return (0x133EFFD ^ 0x133EFFD) != 0;
        }
    }

    protected static <T extends Element> List<T> getEnclosedElements(TypeElement typeElement, ElementKind ... elementKindArray) {
        block7: {
            block6: {
                if (elementKindArray == null) break block6;
                if (elementKindArray.length >= (0xF703DB17 ^ 0xF703DB16)) break block7;
            }
            return TypeHandle.getEnclosedElements(typeElement);
        }
        if (typeElement == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        block0: for (Element element : typeElement.getEnclosedElements()) {
            ElementKind[] elementKindArray2 = elementKindArray;
            int n = elementKindArray2.length;
            for (int i = 0xC4D5F990 ^ 0xC4D5F990; i < n; ++i) {
                ElementKind elementKind = elementKindArray2[i];
                if (element.getKind() != elementKind) continue;
                builder.add((Object)element);
                continue block0;
            }
        }
        return builder.build();
    }

    protected static List<? extends Element> getEnclosedElements(TypeElement typeElement) {
        return typeElement != null ? typeElement.getEnclosedElements() : Collections.emptyList();
    }
}

