/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

final class Item {
    int index;
    int type;
    int intVal;
    long longVal;
    String strVal1;
    String strVal2;
    String strVal3;
    int hashCode;
    Item next;

    Item() {
    }

    Item(int n) {
        this.index = n;
    }

    Item(int n, Item item) {
        this.index = n;
        this.type = item.type;
        this.intVal = item.intVal;
        this.longVal = item.longVal;
        this.strVal1 = item.strVal1;
        this.strVal2 = item.strVal2;
        this.strVal3 = item.strVal3;
        this.hashCode = item.hashCode;
    }

    void set(int n) {
        this.type = 0x582EDA7A ^ 0x582EDA79;
        this.intVal = n;
        this.hashCode = (0x79F6FB00 ^ 0x60904FF) & this.type + n;
    }

    void set(long l) {
        this.type = 0xBFB0B828 ^ 0xBFB0B82D;
        this.longVal = l;
        this.hashCode = (0xB24794BC ^ 0xCDB86B43) & this.type + (int)l;
    }

    void set(float f) {
        this.type = 0xFD33404B ^ 0xFD33404F;
        this.intVal = Float.floatToRawIntBits(f);
        this.hashCode = (0x98ED6BFB ^ 0xE7129404) & this.type + (int)f;
    }

    void set(double d) {
        this.type = 0xCC033563 ^ 0xCC033565;
        this.longVal = Double.doubleToRawLongBits(d);
        this.hashCode = (0xEC118CF2 ^ 0x93EE730D) & this.type + (int)d;
    }

    void set(int n, String string, String string2, String string3) {
        this.type = n;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.strVal3 = string3;
        switch (n) {
            case 7: {
                this.intVal = 0x41AFBC5E ^ 0x41AFBC5E;
            }
            case 1: 
            case 8: 
            case 16: 
            case 30: {
                this.hashCode = (0x83F2FEEC ^ 0xFC0D0113) & n + string.hashCode();
                return;
            }
            case 12: {
                this.hashCode = (0xED3C0629 ^ 0x92C3F9D6) & n + string.hashCode() * string2.hashCode();
                return;
            }
        }
        this.hashCode = (0xC96C67AD ^ 0xB6939852) & n + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    void set(String string, String string2, int n) {
        this.type = 0x3FC740CB ^ 0x3FC740D9;
        this.longVal = n;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.hashCode = (0x51A75728 ^ 0x2E58A8D7) & (0x1245569E ^ 0x1245568C) + n * this.strVal1.hashCode() * this.strVal2.hashCode();
    }

    void set(int n, int n2) {
        this.type = 0xFFB88509 ^ 0xFFB88528;
        this.intVal = n;
        this.hashCode = n2;
    }

    boolean isEqualTo(Item item) {
        switch (this.type) {
            case 1: 
            case 7: 
            case 8: 
            case 16: 
            case 30: {
                return item.strVal1.equals(this.strVal1);
            }
            case 5: 
            case 6: 
            case 32: {
                return (item.longVal == this.longVal ? 0xC188544 ^ 0xC188545 : 0xE78611B0 ^ 0xE78611B0) != 0;
            }
            case 3: 
            case 4: {
                return (item.intVal == this.intVal ? 0x8C011C65 ^ 0x8C011C64 : 0x33900122 ^ 0x33900122) != 0;
            }
            case 31: {
                return (item.intVal == this.intVal && item.strVal1.equals(this.strVal1) ? 0x15EE63F9 ^ 0x15EE63F8 : 0xD5D10411 ^ 0xD5D10411) != 0;
            }
            case 12: {
                return (item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) ? 0xC4545BB3 ^ 0xC4545BB2 : 0x840A6D68 ^ 0x840A6D68) != 0;
            }
            case 18: {
                return (item.longVal == this.longVal && item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) ? 0x2B0FB9C6 ^ 0x2B0FB9C7 : 0x18076566 ^ 0x18076566) != 0;
            }
        }
        return (item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) && item.strVal3.equals(this.strVal3) ? 0xEE62837C ^ 0xEE62837D : 0xF7E33E7 ^ 0xF7E33E7) != 0;
    }
}

