/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.signature;

import org.spongepowered.asm.lib.signature.SignatureVisitor;

public class SignatureWriter
extends SignatureVisitor {
    private final StringBuilder buf = new StringBuilder();
    private boolean hasFormals;
    private boolean hasParameters;
    private int argumentStack;

    public SignatureWriter() {
        super(0x5F0C32B5 ^ 0x5F0932B5);
    }

    public void visitFormalTypeParameter(String string) {
        if (!this.hasFormals) {
            this.hasFormals = 0xA9524C36 ^ 0xA9524C37;
            this.buf.append((char)(0xAD51356C ^ 0xAD513550));
        }
        this.buf.append(string);
        this.buf.append((char)(0x33E40F61 ^ 0x33E40F5B));
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.buf.append((char)(0x4165E0B5 ^ 0x4165E08F));
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = 0x41577E46 ^ 0x41577E47;
            this.buf.append((char)(0x4CF85858 ^ 0x4CF85870));
        }
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.buf.append((char)(0xC3CBD2AC ^ 0xC3CBD284));
        }
        this.buf.append((char)(0xDC583352 ^ 0xDC58337B));
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.buf.append((char)(0x148A78AA ^ 0x148A78F4));
        return this;
    }

    public void visitBaseType(char c) {
        this.buf.append(c);
    }

    public void visitTypeVariable(String string) {
        this.buf.append((char)(0xBBB17E77 ^ 0xBBB17E23));
        this.buf.append(string);
        this.buf.append((char)(0xB424FADD ^ 0xB424FAE6));
    }

    public SignatureVisitor visitArrayType() {
        this.buf.append((char)(0xDA0805F4 ^ 0xDA0805AF));
        return this;
    }

    public void visitClassType(String string) {
        this.buf.append((char)(0xAB670C62 ^ 0xAB670C2E));
        this.buf.append(string);
        this.argumentStack *= 0xFB0E1F48 ^ 0xFB0E1F4A;
    }

    public void visitInnerClassType(String string) {
        this.endArguments();
        this.buf.append((char)(0x2057012C ^ 0x20570102));
        this.buf.append(string);
        this.argumentStack *= 0xAF0850C6 ^ 0xAF0850C4;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % (0x7E375036 ^ 0x7E375034) == 0) {
            this.argumentStack += 0xD10100ED ^ 0xD10100EC;
            this.buf.append((char)(0x54BFBFC8 ^ 0x54BFBFF4));
        }
        this.buf.append((char)(0x867F826 ^ 0x867F80C));
    }

    public SignatureVisitor visitTypeArgument(char c) {
        if (this.argumentStack % (0xBD62F60A ^ 0xBD62F608) == 0) {
            this.argumentStack += 0xC4C4B1B2 ^ 0xC4C4B1B3;
            this.buf.append((char)(0x3B186C05 ^ 0x3B186C39));
        }
        if (c != (0xAEE60329 ^ 0xAEE60314)) {
            this.buf.append(c);
        }
        return this;
    }

    public void visitEnd() {
        this.endArguments();
        this.buf.append((char)(0x1C990089 ^ 0x1C9900B2));
    }

    public String toString() {
        return this.buf.toString();
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = 0x8EA0AB29 ^ 0x8EA0AB29;
            this.buf.append((char)(0xDD255C55 ^ 0xDD255C6B));
        }
    }

    private void endArguments() {
        if (this.argumentStack % (0x291E4AF0 ^ 0x291E4AF2) != 0) {
            this.buf.append((char)(0xC5C667ED ^ 0xC5C667D3));
        }
        this.argumentStack /= 0x70AA5CFB ^ 0x70AA5CF9;
    }
}

