/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.TypeAnnotationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInsnNode {
    public static final int INSN = 0;
    public static final int INT_INSN = 1;
    public static final int VAR_INSN = 2;
    public static final int TYPE_INSN = 3;
    public static final int FIELD_INSN = 4;
    public static final int METHOD_INSN = 5;
    public static final int INVOKE_DYNAMIC_INSN = 6;
    public static final int JUMP_INSN = 7;
    public static final int LABEL = 8;
    public static final int LDC_INSN = 9;
    public static final int IINC_INSN = 10;
    public static final int TABLESWITCH_INSN = 11;
    public static final int LOOKUPSWITCH_INSN = 12;
    public static final int MULTIANEWARRAY_INSN = 13;
    public static final int FRAME = 14;
    public static final int LINE = 15;
    protected int opcode;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    AbstractInsnNode prev;
    AbstractInsnNode next;
    int index;

    protected AbstractInsnNode(int n) {
        this.opcode = n;
        this.index = 0x138F3161 ^ 0xEC70CE9E;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public abstract int getType();

    public AbstractInsnNode getPrevious() {
        return this.prev;
    }

    public AbstractInsnNode getNext() {
        return this.next;
    }

    public abstract void accept(MethodVisitor var1);

    protected final void acceptAnnotations(MethodVisitor methodVisitor) {
        TypeAnnotationNode typeAnnotationNode;
        int n;
        int n2 = this.visibleTypeAnnotations == null ? 0x33D48FF ^ 0x33D48FF : this.visibleTypeAnnotations.size();
        for (n = 0x85B1C0D9 ^ 0x85B1C0D9; n < n2; ++n) {
            typeAnnotationNode = this.visibleTypeAnnotations.get(n);
            typeAnnotationNode.accept(methodVisitor.visitInsnAnnotation(typeAnnotationNode.typeRef, typeAnnotationNode.typePath, typeAnnotationNode.desc, (0x8D8D7D21 ^ 0x8D8D7D20) != 0));
        }
        n2 = this.invisibleTypeAnnotations == null ? 0x170D8468 ^ 0x170D8468 : this.invisibleTypeAnnotations.size();
        for (n = 0x26527D57 ^ 0x26527D57; n < n2; ++n) {
            typeAnnotationNode = this.invisibleTypeAnnotations.get(n);
            typeAnnotationNode.accept(methodVisitor.visitInsnAnnotation(typeAnnotationNode.typeRef, typeAnnotationNode.typePath, typeAnnotationNode.desc, (0x5ECAF169 ^ 0x5ECAF169) != 0));
        }
    }

    public abstract AbstractInsnNode clone(Map<LabelNode, LabelNode> var1);

    static LabelNode clone(LabelNode labelNode, Map<LabelNode, LabelNode> map) {
        return map.get(labelNode);
    }

    static LabelNode[] clone(List<LabelNode> list, Map<LabelNode, LabelNode> map) {
        LabelNode[] labelNodeArray = new LabelNode[list.size()];
        for (int i = 0xA82E1C49 ^ 0xA82E1C49; i < labelNodeArray.length; ++i) {
            labelNodeArray[i] = map.get(list.get(i));
        }
        return labelNodeArray;
    }

    protected final AbstractInsnNode cloneAnnotations(AbstractInsnNode abstractInsnNode) {
        TypeAnnotationNode typeAnnotationNode;
        TypeAnnotationNode typeAnnotationNode2;
        int n;
        if (abstractInsnNode.visibleTypeAnnotations != null) {
            this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>();
            for (n = 0x3FF48C89 ^ 0x3FF48C89; n < abstractInsnNode.visibleTypeAnnotations.size(); ++n) {
                typeAnnotationNode2 = abstractInsnNode.visibleTypeAnnotations.get(n);
                typeAnnotationNode = new TypeAnnotationNode(typeAnnotationNode2.typeRef, typeAnnotationNode2.typePath, typeAnnotationNode2.desc);
                typeAnnotationNode2.accept(typeAnnotationNode);
                this.visibleTypeAnnotations.add(typeAnnotationNode);
            }
        }
        if (abstractInsnNode.invisibleTypeAnnotations != null) {
            this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>();
            for (n = 0x980D7049 ^ 0x980D7049; n < abstractInsnNode.invisibleTypeAnnotations.size(); ++n) {
                typeAnnotationNode2 = abstractInsnNode.invisibleTypeAnnotations.get(n);
                typeAnnotationNode = new TypeAnnotationNode(typeAnnotationNode2.typeRef, typeAnnotationNode2.typePath, typeAnnotationNode2.desc);
                typeAnnotationNode2.accept(typeAnnotationNode);
                this.invisibleTypeAnnotations.add(typeAnnotationNode);
            }
        }
        return this;
    }
}

