/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameNode
extends AbstractInsnNode {
    public int type;
    public List<Object> local;
    public List<Object> stack;

    private FrameNode() {
        super(0x583D9B82 ^ 0xA7C2647D);
    }

    public FrameNode(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        super(0x9F99431F ^ 0x6066BCE0);
        this.type = n;
        switch (n) {
            case -1: 
            case 0: {
                this.local = FrameNode.asList(n2, objectArray);
                this.stack = FrameNode.asList(n3, objectArray2);
                break;
            }
            case 1: {
                this.local = FrameNode.asList(n2, objectArray);
                break;
            }
            case 2: {
                this.local = Arrays.asList(new Object[n2]);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.stack = FrameNode.asList(0x8BC3CB7A ^ 0x8BC3CB7B, objectArray2);
            }
        }
    }

    @Override
    public int getType() {
        return 0x4F18869D ^ 0x4F188693;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        switch (this.type) {
            case -1: 
            case 0: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), this.stack.size(), FrameNode.asArray(this.stack));
                break;
            }
            case 1: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), 0xBEAD1DF8 ^ 0xBEAD1DF8, null);
                break;
            }
            case 2: {
                methodVisitor.visitFrame(this.type, this.local.size(), null, 0xA492467D ^ 0xA492467D, null);
                break;
            }
            case 3: {
                methodVisitor.visitFrame(this.type, 0xED6815F3 ^ 0xED6815F3, null, 0x38FC2F28 ^ 0x38FC2F28, null);
                break;
            }
            case 4: {
                methodVisitor.visitFrame(this.type, 0xB87A7527 ^ 0xB87A7527, null, 0x10857E70 ^ 0x10857E71, FrameNode.asArray(this.stack));
            }
        }
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> map) {
        Object object;
        int n;
        FrameNode frameNode = new FrameNode();
        frameNode.type = this.type;
        if (this.local != null) {
            frameNode.local = new ArrayList<Object>();
            for (n = 0x50ABF1D2 ^ 0x50ABF1D2; n < this.local.size(); ++n) {
                object = this.local.get(n);
                if (object instanceof LabelNode) {
                    object = map.get(object);
                }
                frameNode.local.add(object);
            }
        }
        if (this.stack != null) {
            frameNode.stack = new ArrayList<Object>();
            for (n = 0x8B63DF43 ^ 0x8B63DF43; n < this.stack.size(); ++n) {
                object = this.stack.get(n);
                if (object instanceof LabelNode) {
                    object = map.get(object);
                }
                frameNode.stack.add(object);
            }
        }
        return frameNode;
    }

    private static List<Object> asList(int n, Object[] objectArray) {
        return Arrays.asList(objectArray).subList(0x26AADC0B ^ 0x26AADC0B, n);
    }

    private static Object[] asArray(List<Object> list) {
        Object[] objectArray = new Object[list.size()];
        for (int i = 0xEA0FD779 ^ 0xEA0FD779; i < objectArray.length; ++i) {
            Object object = list.get(i);
            if (object instanceof LabelNode) {
                object = ((LabelNode)object).getLabel();
            }
            objectArray[i] = object;
        }
        return objectArray;
    }
}

