/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.IincInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.LocalVariableAnnotationNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.LookupSwitchInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MultiANewArrayInsnNode;
import org.spongepowered.asm.lib.tree.ParameterNode;
import org.spongepowered.asm.lib.tree.TableSwitchInsnNode;
import org.spongepowered.asm.lib.tree.TryCatchBlockNode;
import org.spongepowered.asm.lib.tree.TypeAnnotationNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;

public class MethodNode
extends MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List<String> exceptions;
    public List<ParameterNode> parameters;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public Object annotationDefault;
    public List<AnnotationNode>[] visibleParameterAnnotations;
    public List<AnnotationNode>[] invisibleParameterAnnotations;
    public InsnList instructions;
    public List<TryCatchBlockNode> tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List<LocalVariableNode> localVariables;
    public List<LocalVariableAnnotationNode> visibleLocalVariableAnnotations;
    public List<LocalVariableAnnotationNode> invisibleLocalVariableAnnotations;
    private boolean visited;

    public MethodNode() {
        this(0x74FF694E ^ 0x74FA694E);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    public MethodNode(int n) {
        super(n);
        this.instructions = new InsnList();
    }

    public MethodNode(int n, String string, String string2, String string3, String[] stringArray) {
        this(0xFF0F41A4 ^ 0xFF0A41A4, n, string, string2, string3, stringArray);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    public MethodNode(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        super(n);
        int n3;
        this.access = n2;
        this.name = string;
        this.desc = string2;
        this.signature = string3;
        this.exceptions = new ArrayList<String>(stringArray == null ? 0x59653F31 ^ 0x59653F31 : stringArray.length);
        int n4 = (n2 & (0x615E4DE1 ^ 0x615E49E1)) != 0 ? 0x5277DC5D ^ 0x5277DC5C : (n3 = 0x4D8739C9 ^ 0x4D8739C9);
        if (n3 == 0) {
            this.localVariables = new ArrayList<LocalVariableNode>(0x2E5953E2 ^ 0x2E5953E7);
        }
        this.tryCatchBlocks = new ArrayList<TryCatchBlockNode>();
        if (stringArray != null) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
        this.instructions = new InsnList();
    }

    public void visitParameter(String string, int n) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterNode>(0xD7792BE ^ 0xD7792BB);
        }
        this.parameters.add(new ParameterNode(string, n));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode((List<Object>)new ArrayList<Object>(0x99A43A95 ^ 0x99A43A95){

            @Override
            public boolean add(Object object) {
                MethodNode.this.annotationDefault = object;
                return super.add(object);
            }
        });
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(0x7B469116 ^ 0x7B469117);
            }
            this.visibleAnnotations.add(annotationNode);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(0xE05D0DC8 ^ 0xE05D0DC9);
            }
            this.invisibleAnnotations.add(annotationNode);
        }
        return annotationNode;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xE46D8BF3 ^ 0xE46D8BF2);
            }
            this.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x35245E43 ^ 0x35245E42);
            }
            this.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleParameterAnnotations == null) {
                int n2 = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[n2];
            }
            if (this.visibleParameterAnnotations[n] == null) {
                this.visibleParameterAnnotations[n] = new ArrayList<AnnotationNode>(0x6FC9A05C ^ 0x6FC9A05D);
            }
            this.visibleParameterAnnotations[n].add(annotationNode);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int n3 = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[n3];
            }
            if (this.invisibleParameterAnnotations[n] == null) {
                this.invisibleParameterAnnotations[n] = new ArrayList<AnnotationNode>(0xCE021FA3 ^ 0xCE021FA2);
            }
            this.invisibleParameterAnnotations[n].add(annotationNode);
        }
        return annotationNode;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(0x9EB68A ^ 0x9EB68B);
        }
        this.attrs.add(attribute);
    }

    public void visitCode() {
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.instructions.add(new FrameNode(n, n2, objectArray == null ? null : this.getLabelNodes(objectArray), n3, objectArray2 == null ? null : this.getLabelNodes(objectArray2)));
    }

    public void visitInsn(int n) {
        this.instructions.add(new InsnNode(n));
    }

    public void visitIntInsn(int n, int n2) {
        this.instructions.add(new IntInsnNode(n, n2));
    }

    public void visitVarInsn(int n, int n2) {
        this.instructions.add(new VarInsnNode(n, n2));
    }

    public void visitTypeInsn(int n, String string) {
        this.instructions.add(new TypeInsnNode(n, string));
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.instructions.add(new FieldInsnNode(n, string, string2, string3));
    }

    @Deprecated
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (this.api >= (0x61013A3D ^ 0x61043A3D)) {
            super.visitMethodInsn(n, string, string2, string3);
            return;
        }
        this.instructions.add(new MethodInsnNode(n, string, string2, string3));
    }

    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (this.api < (0x216F616 ^ 0x213F616)) {
            super.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.instructions.add(new MethodInsnNode(n, string, string2, string3, bl));
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.instructions.add(new InvokeDynamicInsnNode(string, string2, handle, objectArray));
    }

    public void visitJumpInsn(int n, Label label) {
        this.instructions.add(new JumpInsnNode(n, this.getLabelNode(label)));
    }

    public void visitLabel(Label label) {
        this.instructions.add(this.getLabelNode(label));
    }

    public void visitLdcInsn(Object object) {
        this.instructions.add(new LdcInsnNode(object));
    }

    public void visitIincInsn(int n, int n2) {
        this.instructions.add(new IincInsnNode(n, n2));
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        this.instructions.add(new TableSwitchInsnNode(n, n2, this.getLabelNode(label), this.getLabelNodes(labelArray)));
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.instructions.add(new LookupSwitchInsnNode(this.getLabelNode(label), nArray, this.getLabelNodes(labelArray)));
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.instructions.add(new MultiANewArrayInsnNode(string, n));
    }

    public AnnotationVisitor visitInsnAnnotation(int n, TypePath typePath, String string, boolean bl) {
        AbstractInsnNode abstractInsnNode = this.instructions.getLast();
        while (true) {
            if (abstractInsnNode.getOpcode() != (0x3295DF1C ^ 0xCD6A20E3)) break;
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (abstractInsnNode.visibleTypeAnnotations == null) {
                abstractInsnNode.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x93D3A9BE ^ 0x93D3A9BF);
            }
            abstractInsnNode.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (abstractInsnNode.invisibleTypeAnnotations == null) {
                abstractInsnNode.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x2170F5C8 ^ 0x2170F5C9);
            }
            abstractInsnNode.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(this.getLabelNode(label), this.getLabelNode(label2), this.getLabelNode(label3), string));
    }

    public AnnotationVisitor visitTryCatchAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TryCatchBlockNode tryCatchBlockNode = this.tryCatchBlocks.get((n & (0xEC48E6E1 ^ 0xECB719E1)) >> (0x84DCF8A6 ^ 0x84DCF8AE));
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (tryCatchBlockNode.visibleTypeAnnotations == null) {
                tryCatchBlockNode.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x8DBF8459 ^ 0x8DBF8458);
            }
            tryCatchBlockNode.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (tryCatchBlockNode.invisibleTypeAnnotations == null) {
                tryCatchBlockNode.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x254FAFF9 ^ 0x254FAFF8);
            }
            tryCatchBlockNode.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.localVariables.add(new LocalVariableNode(string, string2, string3, this.getLabelNode(label), this.getLabelNode(label2), n));
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        LocalVariableAnnotationNode localVariableAnnotationNode = new LocalVariableAnnotationNode(n, typePath, this.getLabelNodes(labelArray), this.getLabelNodes(labelArray2), nArray, string);
        if (bl) {
            if (this.visibleLocalVariableAnnotations == null) {
                this.visibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>(0xDA494642 ^ 0xDA494643);
            }
            this.visibleLocalVariableAnnotations.add(localVariableAnnotationNode);
        } else {
            if (this.invisibleLocalVariableAnnotations == null) {
                this.invisibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>(0x5FCB5845 ^ 0x5FCB5844);
            }
            this.invisibleLocalVariableAnnotations.add(localVariableAnnotationNode);
        }
        return localVariableAnnotationNode;
    }

    public void visitLineNumber(int n, Label label) {
        this.instructions.add(new LineNumberNode(n, this.getLabelNode(label)));
    }

    public void visitMaxs(int n, int n2) {
        this.maxStack = n;
        this.maxLocals = n2;
    }

    public void visitEnd() {
    }

    protected LabelNode getLabelNode(Label label) {
        if (!(label.info instanceof LabelNode)) {
            label.info = new LabelNode();
        }
        return (LabelNode)label.info;
    }

    private LabelNode[] getLabelNodes(Label[] labelArray) {
        LabelNode[] labelNodeArray = new LabelNode[labelArray.length];
        for (int i = 0x817C44DF ^ 0x817C44DF; i < labelArray.length; ++i) {
            labelNodeArray[i] = this.getLabelNode(labelArray[i]);
        }
        return labelNodeArray;
    }

    private Object[] getLabelNodes(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0x3ECD77A0 ^ 0x3ECD77A0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof Label) {
                object = this.getLabelNode((Label)object);
            }
            objectArray2[i] = object;
        }
        return objectArray2;
    }

    public void check(int n) {
        if (n == (0x770680D7 ^ 0x770280D7)) {
            Object object;
            int n2;
            if (this.visibleTypeAnnotations != null && this.visibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleTypeAnnotations != null && this.invisibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            int n3 = this.tryCatchBlocks == null ? 0x4AE3CC23 ^ 0x4AE3CC23 : this.tryCatchBlocks.size();
            for (n2 = 0x65A98DC8 ^ 0x65A98DC8; n2 < n3; ++n2) {
                object = this.tryCatchBlocks.get(n2);
                if (((TryCatchBlockNode)object).visibleTypeAnnotations != null && ((TryCatchBlockNode)object).visibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (((TryCatchBlockNode)object).invisibleTypeAnnotations == null || ((TryCatchBlockNode)object).invisibleTypeAnnotations.size() <= 0) continue;
                throw new RuntimeException();
            }
            for (n2 = 0xEE4A442A ^ 0xEE4A442A; n2 < this.instructions.size(); ++n2) {
                object = this.instructions.get(n2);
                if (((AbstractInsnNode)object).visibleTypeAnnotations != null && ((AbstractInsnNode)object).visibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (((AbstractInsnNode)object).invisibleTypeAnnotations != null && ((AbstractInsnNode)object).invisibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (!(object instanceof MethodInsnNode)) continue;
                int n4 = ((MethodInsnNode)object).itf;
                if (n4 == (((AbstractInsnNode)object).opcode == (0xCE782D84 ^ 0xCE782D3D) ? 0xF892DA3F ^ 0xF892DA3E : 0xDF5A94D3 ^ 0xDF5A94D3)) continue;
                throw new RuntimeException();
            }
            if (this.visibleLocalVariableAnnotations != null && this.visibleLocalVariableAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleLocalVariableAnnotations != null && this.invisibleLocalVariableAnnotations.size() > 0) {
                throw new RuntimeException();
            }
        }
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        MethodVisitor methodVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, stringArray);
        if (methodVisitor != null) {
            this.accept(methodVisitor);
        }
    }

    public void accept(MethodVisitor methodVisitor) {
        AnnotationNode annotationNode;
        int n;
        List<AnnotationNode> list;
        int n2;
        int n3 = this.parameters == null ? 0x4B8EE39D ^ 0x4B8EE39D : this.parameters.size();
        for (n2 = 0xD2B31259 ^ 0xD2B31259; n2 < n3; ++n2) {
            list = this.parameters.get(n2);
            methodVisitor.visitParameter(((ParameterNode)((Object)list)).name, ((ParameterNode)((Object)list)).access);
        }
        if (this.annotationDefault != null) {
            list = methodVisitor.visitAnnotationDefault();
            AnnotationNode.accept((AnnotationVisitor)((Object)list), null, this.annotationDefault);
            if (list != null) {
                ((AnnotationVisitor)((Object)list)).visitEnd();
            }
        }
        n3 = this.visibleAnnotations == null ? 0x32E6FA91 ^ 0x32E6FA91 : this.visibleAnnotations.size();
        for (n2 = 0x1875B408 ^ 0x1875B408; n2 < n3; ++n2) {
            list = this.visibleAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitAnnotation(((AnnotationNode)((Object)list)).desc, (0x48D0AEB5 ^ 0x48D0AEB4) != 0));
        }
        n3 = this.invisibleAnnotations == null ? 0x89EFC26D ^ 0x89EFC26D : this.invisibleAnnotations.size();
        for (n2 = 0x848ACB24 ^ 0x848ACB24; n2 < n3; ++n2) {
            list = this.invisibleAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitAnnotation(((AnnotationNode)((Object)list)).desc, (0x801CC501 ^ 0x801CC501) != 0));
        }
        n3 = this.visibleTypeAnnotations == null ? 0xBECA34B5 ^ 0xBECA34B5 : this.visibleTypeAnnotations.size();
        for (n2 = 0xA29057FF ^ 0xA29057FF; n2 < n3; ++n2) {
            list = this.visibleTypeAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitTypeAnnotation(((TypeAnnotationNode)((Object)list)).typeRef, ((TypeAnnotationNode)((Object)list)).typePath, ((TypeAnnotationNode)((Object)list)).desc, (0x7998C5D7 ^ 0x7998C5D6) != 0));
        }
        n3 = this.invisibleTypeAnnotations == null ? 0x2C6F1499 ^ 0x2C6F1499 : this.invisibleTypeAnnotations.size();
        for (n2 = 0x37F08119 ^ 0x37F08119; n2 < n3; ++n2) {
            list = this.invisibleTypeAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitTypeAnnotation(((TypeAnnotationNode)((Object)list)).typeRef, ((TypeAnnotationNode)((Object)list)).typePath, ((TypeAnnotationNode)((Object)list)).desc, (0xA46035B8 ^ 0xA46035B8) != 0));
        }
        n3 = this.visibleParameterAnnotations == null ? 0xFCC82797 ^ 0xFCC82797 : this.visibleParameterAnnotations.length;
        for (n2 = 0xFEC162B5 ^ 0xFEC162B5; n2 < n3; ++n2) {
            list = this.visibleParameterAnnotations[n2];
            if (list == null) continue;
            for (n = 0x691B2BDB ^ 0x691B2BDB; n < list.size(); ++n) {
                annotationNode = list.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, (0xF7DCAC82 ^ 0xF7DCAC83) != 0));
            }
        }
        n3 = this.invisibleParameterAnnotations == null ? 0x4C273C69 ^ 0x4C273C69 : this.invisibleParameterAnnotations.length;
        for (n2 = 0x3CADA299 ^ 0x3CADA299; n2 < n3; ++n2) {
            list = this.invisibleParameterAnnotations[n2];
            if (list == null) continue;
            for (n = 0x26CA9921 ^ 0x26CA9921; n < list.size(); ++n) {
                annotationNode = list.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, (0xD47AEC4D ^ 0xD47AEC4D) != 0));
            }
        }
        if (this.visited) {
            this.instructions.resetLabels();
        }
        n3 = this.attrs == null ? 0xED924DFA ^ 0xED924DFA : this.attrs.size();
        for (n2 = 0x73559D8A ^ 0x73559D8A; n2 < n3; ++n2) {
            methodVisitor.visitAttribute(this.attrs.get(n2));
        }
        if (this.instructions.size() > 0) {
            methodVisitor.visitCode();
            n3 = this.tryCatchBlocks == null ? 0x1DB2B481 ^ 0x1DB2B481 : this.tryCatchBlocks.size();
            for (n2 = 0xFA47C582 ^ 0xFA47C582; n2 < n3; ++n2) {
                this.tryCatchBlocks.get(n2).updateIndex(n2);
                this.tryCatchBlocks.get(n2).accept(methodVisitor);
            }
            this.instructions.accept(methodVisitor);
            n3 = this.localVariables == null ? 0x729FD48 ^ 0x729FD48 : this.localVariables.size();
            for (n2 = 0x45232362 ^ 0x45232362; n2 < n3; ++n2) {
                this.localVariables.get(n2).accept(methodVisitor);
            }
            n3 = this.visibleLocalVariableAnnotations == null ? 0x68B52AA5 ^ 0x68B52AA5 : this.visibleLocalVariableAnnotations.size();
            for (n2 = 0x88BD83C8 ^ 0x88BD83C8; n2 < n3; ++n2) {
                this.visibleLocalVariableAnnotations.get(n2).accept(methodVisitor, (0xD625D4F3 ^ 0xD625D4F2) != 0);
            }
            n3 = this.invisibleLocalVariableAnnotations == null ? 0xCE074B40 ^ 0xCE074B40 : this.invisibleLocalVariableAnnotations.size();
            for (n2 = 0xB5970CB3 ^ 0xB5970CB3; n2 < n3; ++n2) {
                this.invisibleLocalVariableAnnotations.get(n2).accept(methodVisitor, (0xABEC6EF0 ^ 0xABEC6EF0) != 0);
            }
            methodVisitor.visitMaxs(this.maxStack, this.maxLocals);
            this.visited = 0xB1FE97B1 ^ 0xB1FE97B0;
        }
        methodVisitor.visitEnd();
    }
}

