/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import java.util.List;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MultiANewArrayInsnNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import org.spongepowered.asm.lib.tree.analysis.BasicValue;
import org.spongepowered.asm.lib.tree.analysis.Interpreter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicInterpreter
extends Interpreter<BasicValue>
implements Opcodes {
    public BasicInterpreter() {
        super(0x942A2DD6 ^ 0x942F2DD6);
    }

    protected BasicInterpreter(int n) {
        super(n);
    }

    @Override
    public BasicValue newValue(Type type) {
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        switch (type.getSort()) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return BasicValue.INT_VALUE;
            }
            case 6: {
                return BasicValue.FLOAT_VALUE;
            }
            case 7: {
                return BasicValue.LONG_VALUE;
            }
            case 8: {
                return BasicValue.DOUBLE_VALUE;
            }
            case 9: 
            case 10: {
                return BasicValue.REFERENCE_VALUE;
            }
        }
        throw new Error(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a1\ua074\ua917\u7d78\u8e4b\u2476\u8b77\u3472`\ua7f4\ua4ba\ua063"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BasicValue newOperation(AbstractInsnNode abstractInsnNode) throws AnalyzerException {
        switch (abstractInsnNode.getOpcode()) {
            case 1: {
                return this.newValue(Type.getObjectType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("|\ua7f3\ua4b9\ua07d")));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return BasicValue.INT_VALUE;
            }
            case 9: 
            case 10: {
                return BasicValue.LONG_VALUE;
            }
            case 11: 
            case 12: 
            case 13: {
                return BasicValue.FLOAT_VALUE;
            }
            case 14: 
            case 15: {
                return BasicValue.DOUBLE_VALUE;
            }
            case 16: 
            case 17: {
                return BasicValue.INT_VALUE;
            }
            case 18: {
                Object object = ((LdcInsnNode)abstractInsnNode).cst;
                if (object instanceof Integer) {
                    return BasicValue.INT_VALUE;
                }
                if (object instanceof Float) {
                    return BasicValue.FLOAT_VALUE;
                }
                if (object instanceof Long) {
                    return BasicValue.LONG_VALUE;
                }
                if (object instanceof Double) {
                    return BasicValue.DOUBLE_VALUE;
                }
                if (object instanceof String) {
                    return this.newValue(Type.getObjectType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438A\ua7f2\ua4a7\ua078\ua90b\u7d71")));
                }
                if (object instanceof Type) {
                    int n = ((Type)object).getSort();
                    if (n == (0xB92C85A5 ^ 0xB92C85AF)) return this.newValue(Type.getObjectType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438Q\ua7ea\ua4b4\ua062\ua916")));
                    if (n == (0x7B392AFF ^ 0x7B392AF6)) {
                        return this.newValue(Type.getObjectType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438Q\ua7ea\ua4b4\ua062\ua916")));
                    }
                    if (n != (0x4159FC0B ^ 0x4159FC00)) throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b1b\u3453Q\ua7a6\ua4b6\ua07e\ua90b\u7d65\u8e5e\u247b\u8b39\u34632") + object);
                    return this.newValue(Type.getObjectType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438{\ua7e8\ua4a3\ua07e\ua90e\u7d73\u8e05\u2457\u8b32\u3463z\ua7e9\ua4b1\ua045\ua91c\u7d66\u8e4f")));
                }
                if (!(object instanceof Handle)) throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b1b\u3453Q\ua7a6\ua4b6\ua07e\ua90b\u7d65\u8e5e\u247b\u8b39\u34632") + object);
                return this.newValue(Type.getObjectType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438{\ua7e8\ua4a3\ua07e\ua90e\u7d73\u8e05\u2457\u8b32\u3463z\ua7e9\ua4b1\ua059\ua904\u7d78\u8e4e\u2476\u8b32")));
            }
            case 168: {
                return BasicValue.RETURNADDRESS_VALUE;
            }
            case 178: {
                return this.newValue(Type.getType(((FieldInsnNode)abstractInsnNode).desc));
            }
            case 187: {
                return this.newValue(Type.getObjectType(((TypeInsnNode)abstractInsnNode).desc));
            }
        }
        throw new Error(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a1\ua074\ua917\u7d78\u8e4b\u2476\u8b77\u3472`\ua7f4\ua4ba\ua063\ua94b"));
    }

    @Override
    public BasicValue copyOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue) throws AnalyzerException {
        return basicValue;
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue) throws AnalyzerException {
        switch (abstractInsnNode.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: {
                return BasicValue.INT_VALUE;
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                return BasicValue.FLOAT_VALUE;
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                return BasicValue.LONG_VALUE;
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                return BasicValue.DOUBLE_VALUE;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: {
                return null;
            }
            case 180: {
                return this.newValue(Type.getType(((FieldInsnNode)abstractInsnNode).desc));
            }
            case 188: {
                switch (((IntInsnNode)abstractInsnNode).operand) {
                    case 4: {
                        return this.newValue(Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7dc")));
                    }
                    case 5: {
                        return this.newValue(Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7c5")));
                    }
                    case 8: {
                        return this.newValue(Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7c4")));
                    }
                    case 9: {
                        return this.newValue(Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7d5")));
                    }
                    case 10: {
                        return this.newValue(Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7cf")));
                    }
                    case 6: {
                        return this.newValue(Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7c0")));
                    }
                    case 7: {
                        return this.newValue(Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7c2")));
                    }
                    case 11: {
                        return this.newValue(Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7cc")));
                    }
                }
                throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b36\u3465`\ua7e7\ua4ac\ua031\ua911\u7d6f\u8e5a\u247f"));
            }
            case 189: {
                String string = ((TypeInsnNode)abstractInsnNode).desc;
                return this.newValue(Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I") + Type.getObjectType(string)));
            }
            case 190: {
                return BasicValue.INT_VALUE;
            }
            case 191: {
                return null;
            }
            case 192: {
                String string = ((TypeInsnNode)abstractInsnNode).desc;
                return this.newValue(Type.getObjectType(string));
            }
            case 193: {
                return BasicValue.INT_VALUE;
            }
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
        }
        throw new Error(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a1\ua074\ua917\u7d78\u8e4b\u2476\u8b77\u3472`\ua7f4\ua4ba\ua063\ua94b"));
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue, BasicValue basicValue2) throws AnalyzerException {
        switch (abstractInsnNode.getOpcode()) {
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return BasicValue.INT_VALUE;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return BasicValue.FLOAT_VALUE;
            }
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return BasicValue.LONG_VALUE;
            }
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return BasicValue.DOUBLE_VALUE;
            }
            case 50: {
                return BasicValue.REFERENCE_VALUE;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return BasicValue.INT_VALUE;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
        }
        throw new Error(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a1\ua074\ua917\u7d78\u8e4b\u2476\u8b77\u3472`\ua7f4\ua4ba\ua063\ua94b"));
    }

    @Override
    public BasicValue ternaryOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue, BasicValue basicValue2, BasicValue basicValue3) throws AnalyzerException {
        return null;
    }

    @Override
    public BasicValue naryOperation(AbstractInsnNode abstractInsnNode, List<? extends BasicValue> list) throws AnalyzerException {
        int n = abstractInsnNode.getOpcode();
        if (n == (0x672F3D36 ^ 0x672F3DF3)) {
            return this.newValue(Type.getType(((MultiANewArrayInsnNode)abstractInsnNode).desc));
        }
        if (n == (0x4B9655C6 ^ 0x4B96557C)) {
            return this.newValue(Type.getReturnType(((InvokeDynamicInsnNode)abstractInsnNode).desc));
        }
        return this.newValue(Type.getReturnType(((MethodInsnNode)abstractInsnNode).desc));
    }

    @Override
    public void returnOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue, BasicValue basicValue2) throws AnalyzerException {
    }

    @Override
    public BasicValue merge(BasicValue basicValue, BasicValue basicValue2) {
        if (!basicValue.equals(basicValue2)) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return basicValue;
    }
}

