/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import java.util.ArrayList;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.IincInsnNode;
import org.spongepowered.asm.lib.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MultiANewArrayInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import org.spongepowered.asm.lib.tree.analysis.Interpreter;
import org.spongepowered.asm.lib.tree.analysis.Value;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frame<V extends Value> {
    private V returnValue;
    private V[] values;
    private int locals;
    private int top;

    public Frame(int n, int n2) {
        this.values = new Value[n + n2];
        this.locals = n;
    }

    public Frame(Frame<? extends V> frame) {
        this(frame.locals, frame.values.length - frame.locals);
        this.init(frame);
    }

    public Frame<V> init(Frame<? extends V> frame) {
        this.returnValue = frame.returnValue;
        System.arraycopy(frame.values, 0xEDE91DC4 ^ 0xEDE91DC4, this.values, 0xFD0BFF0E ^ 0xFD0BFF0E, this.values.length);
        this.top = frame.top;
        return this;
    }

    public void setReturn(V v) {
        this.returnValue = v;
    }

    public int getLocals() {
        return this.locals;
    }

    public int getMaxStackSize() {
        return this.values.length - this.locals;
    }

    public V getLocal(int n) throws IndexOutOfBoundsException {
        if (n >= this.locals) {
            throw new IndexOutOfBoundsException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("F\ua7f4\ua4ac\ua078\ua90b\u7d71\u8e0a\u246e\u8b38\u3437s\ua7e5\ua4b6\ua074\ua916\u7d65\u8e0a\u247b\u8b39\u3437{\ua7e8\ua4b0\ua069\ua90c\u7d65\u8e5e\u247b\u8b39\u34632\ua7ea\ua4ba\ua072\ua904\u7d7a\u8e0a\u246c\u8b36\u3465{\ua7e7\ua4b7\ua07d\ua900"));
        }
        return this.values[n];
    }

    public void setLocal(int n, V v) throws IndexOutOfBoundsException {
        if (n >= this.locals) {
            throw new IndexOutOfBoundsException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("F\ua7f4\ua4ac\ua078\ua90b\u7d71\u8e0a\u246e\u8b38\u3437s\ua7e5\ua4b6\ua074\ua916\u7d65\u8e0a\u247b\u8b39\u3437{\ua7e8\ua4b0\ua069\ua90c\u7d65\u8e5e\u247b\u8b39\u34632\ua7ea\ua4ba\ua072\ua904\u7d7a\u8e0a\u246c\u8b36\u3465{\ua7e7\ua4b7\ua07d\ua900\u7d36") + n);
        }
        this.values[n] = v;
    }

    public int getStackSize() {
        return this.top;
    }

    public V getStack(int n) throws IndexOutOfBoundsException {
        return this.values[n + this.locals];
    }

    public void clearStack() {
        this.top = 0x5CCDD84E ^ 0x5CCDD84E;
    }

    public V pop() throws IndexOutOfBoundsException {
        if (this.top == 0) {
            throw new IndexOutOfBoundsException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u246a\u8b38\u34672\ua7e9\ua4a5\ua074\ua917\u7d77\u8e44\u247e\u8b77\u3478t\ua7e0\ua4f5\ua070\ua90b\u7d36\u8e4f\u2477\u8b27\u3463k\ua7a6\ua4a6\ua065\ua904\u7d75\u8e41\u2434"));
        }
        return this.values[(this.top -= 0xF6CEE8BC ^ 0xF6CEE8BD) + this.locals];
    }

    public void push(V v) throws IndexOutOfBoundsException {
        if (this.top + this.locals >= this.values.length) {
            throw new IndexOutOfBoundsException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a6\ua064\ua903\u7d70\u8e43\u2479\u8b3e\u3472|\ua7f2\ua4f5\ua07c\ua904\u7d6e\u8e43\u2477\u8b22\u347a2\ua7f5\ua4a1\ua070\ua906\u7d7d\u8e0a\u2469\u8b3e\u346dw\ua7a8"));
        }
        int n = this.top;
        this.top = n + (0xFC5CFE6C ^ 0xFC5CFE6D);
        this.values[n + this.locals] = v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(AbstractInsnNode abstractInsnNode, Interpreter<V> interpreter) throws AnalyzerException {
        switch (abstractInsnNode.getOpcode()) {
            case 0: {
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.push(interpreter.copyOperation(abstractInsnNode, this.getLocal(((VarInsnNode)abstractInsnNode).var)));
                return;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                V v = this.pop();
                V v2 = this.pop();
                this.push(interpreter.binaryOperation(abstractInsnNode, v2, v));
                return;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                Object e = interpreter.copyOperation(abstractInsnNode, this.pop());
                int n = ((VarInsnNode)abstractInsnNode).var;
                this.setLocal(n, e);
                if (e.getSize() == (0xA9A250ED ^ 0xA9A250EF)) {
                    this.setLocal(n + (0xB920F0FB ^ 0xB920F0FA), interpreter.newValue(null));
                }
                if (n <= 0) return;
                V v = this.getLocal(n - (0xFD082839 ^ 0xFD082838));
                if (v == null) return;
                if (v.getSize() != (0x98E7691C ^ 0x98E7691E)) return;
                this.setLocal(n - (0xEAAD4B82 ^ 0xEAAD4B83), interpreter.newValue(null));
                return;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                V v = this.pop();
                V v3 = this.pop();
                V v4 = this.pop();
                interpreter.ternaryOperation(abstractInsnNode, v4, v3, v);
                return;
            }
            case 87: {
                if (this.pop().getSize() != (0xFF738896 ^ 0xFF738894)) return;
                throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d46\u8e65\u244a"));
            }
            case 88: {
                if (this.pop().getSize() != (0x95875F70 ^ 0x95875F71)) return;
                if (this.pop().getSize() == (0x5F0E045A ^ 0x5F0E045B)) return;
                throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d46\u8e65\u244a\u8b65"));
            }
            case 89: {
                V v = this.pop();
                if (v.getSize() != (0x61BC3A4A ^ 0x61BC3A4B)) {
                    throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a"));
                }
                this.push(v);
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                return;
            }
            case 90: {
                V v = this.pop();
                V v5 = this.pop();
                if (v.getSize() != (0x6B84D07B ^ 0x6B84D07A)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b08\u344f#"));
                if (v5.getSize() != (0xEBC9B505 ^ 0xEBC9B504)) {
                    throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b08\u344f#"));
                }
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                this.push(v5);
                this.push(v);
                return;
            }
            case 91: {
                V v = this.pop();
                if (v.getSize() != (0x89723C7D ^ 0x89723C7C)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b08\u344f "));
                V v6 = this.pop();
                if (v6.getSize() == (0x6D398B18 ^ 0x6D398B19)) {
                    V v7 = this.pop();
                    if (v7.getSize() != (0x49998A2D ^ 0x49998A2C)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b08\u344f "));
                    this.push(interpreter.copyOperation(abstractInsnNode, v));
                    this.push(v7);
                    this.push(v6);
                    this.push(v);
                    return;
                }
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                this.push(v6);
                this.push(v);
                return;
            }
            case 92: {
                V v = this.pop();
                if (v.getSize() == (0xEB263A8C ^ 0xEB263A8D)) {
                    V v8 = this.pop();
                    if (v8.getSize() != (0xF97C9E07 ^ 0xF97C9E06)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b65"));
                    this.push(v8);
                    this.push(v);
                    this.push(interpreter.copyOperation(abstractInsnNode, v8));
                    this.push(interpreter.copyOperation(abstractInsnNode, v));
                    return;
                }
                this.push(v);
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                return;
            }
            case 93: {
                V v = this.pop();
                if (v.getSize() == (0x1547DDCC ^ 0x1547DDCD)) {
                    V v9 = this.pop();
                    if (v9.getSize() != (0xD8873A4B ^ 0xD8873A4A)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b65\u3448J\ua7b7"));
                    V v10 = this.pop();
                    if (v10.getSize() != (0xDA35C528 ^ 0xDA35C529)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b65\u3448J\ua7b7"));
                    this.push(interpreter.copyOperation(abstractInsnNode, v9));
                    this.push(interpreter.copyOperation(abstractInsnNode, v));
                    this.push(v10);
                    this.push(v9);
                    this.push(v);
                    return;
                }
                V v11 = this.pop();
                if (v11.getSize() != (0x574ECAC8 ^ 0x574ECAC9)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b65\u3448J\ua7b7"));
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                this.push(v11);
                this.push(v);
                return;
            }
            case 94: {
                V v = this.pop();
                if (v.getSize() == (0xCBA3DFCD ^ 0xCBA3DFCC)) {
                    V v12 = this.pop();
                    if (v12.getSize() != (0x60EC5EA9 ^ 0x60EC5EA8)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b65\u3448J\ua7b4"));
                    V v13 = this.pop();
                    if (v13.getSize() == (0x815C3C4C ^ 0x815C3C4D)) {
                        V v14 = this.pop();
                        if (v14.getSize() != (0xE8CC68FF ^ 0xE8CC68FE)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b65\u3448J\ua7b4"));
                        this.push(interpreter.copyOperation(abstractInsnNode, v12));
                        this.push(interpreter.copyOperation(abstractInsnNode, v));
                        this.push(v14);
                        this.push(v13);
                        this.push(v12);
                        this.push(v);
                        return;
                    }
                    this.push(interpreter.copyOperation(abstractInsnNode, v12));
                    this.push(interpreter.copyOperation(abstractInsnNode, v));
                    this.push(v13);
                    this.push(v12);
                    this.push(v);
                    return;
                }
                V v15 = this.pop();
                if (v15.getSize() == (0x86C7FB3 ^ 0x86C7FB2)) {
                    V v16 = this.pop();
                    if (v16.getSize() != (0xBDD4B640 ^ 0xBDD4B641)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d52\u8e7f\u244a\u8b65\u3448J\ua7b4"));
                    this.push(interpreter.copyOperation(abstractInsnNode, v));
                    this.push(v16);
                    this.push(v15);
                    this.push(v);
                    return;
                }
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                this.push(v15);
                this.push(v);
                return;
            }
            case 95: {
                V v = this.pop();
                V v17 = this.pop();
                if (v17.getSize() != (0x8729398C ^ 0x8729398D)) throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d45\u8e7d\u245b\u8b07"));
                if (v.getSize() != (0x8F834BEF ^ 0x8F834BEE)) {
                    throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b22\u3464w\ua7a6\ua4ba\ua077\ua945\u7d45\u8e7d\u245b\u8b07"));
                }
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                this.push(interpreter.copyOperation(abstractInsnNode, v17));
                return;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                V v = this.pop();
                V v18 = this.pop();
                this.push(interpreter.binaryOperation(abstractInsnNode, v18, v));
                return;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                V v = this.pop();
                V v19 = this.pop();
                this.push(interpreter.binaryOperation(abstractInsnNode, v19, v));
                return;
            }
            case 132: {
                int n = ((IincInsnNode)abstractInsnNode).var;
                this.setLocal(n, interpreter.unaryOperation(abstractInsnNode, this.getLocal(n)));
                return;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                V v = this.pop();
                V v20 = this.pop();
                this.push(interpreter.binaryOperation(abstractInsnNode, v20, v));
                return;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                V v = this.pop();
                V v21 = this.pop();
                interpreter.binaryOperation(abstractInsnNode, v21, v);
                return;
            }
            case 167: {
                return;
            }
            case 168: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 169: {
                return;
            }
            case 170: 
            case 171: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                V v = this.pop();
                interpreter.unaryOperation(abstractInsnNode, v);
                interpreter.returnOperation(abstractInsnNode, v, this.returnValue);
                return;
            }
            case 177: {
                if (this.returnValue == null) return;
                throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4b6\ua07e\ua908\u7d66\u8e4b\u246e\u8b3e\u3475~\ua7e3\ua4f5\ua063\ua900\u7d62\u8e5f\u2468\u8b39\u3437f\ua7ff\ua4a5\ua074"));
            }
            case 178: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 179: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 180: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 181: {
                V v = this.pop();
                V v22 = this.pop();
                interpreter.binaryOperation(abstractInsnNode, v22, v);
                return;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ArrayList<V> arrayList = new ArrayList<V>();
                String string = ((MethodInsnNode)abstractInsnNode).desc;
                for (int i = Type.getArgumentTypes(string).length; i > 0; --i) {
                    arrayList.add(0xDF86974B ^ 0xDF86974B, this.pop());
                }
                if (abstractInsnNode.getOpcode() != (0x449864D8 ^ 0x44986460)) {
                    arrayList.add(0xF6A06891 ^ 0xF6A06891, this.pop());
                }
                if (Type.getReturnType(string) == Type.VOID_TYPE) {
                    interpreter.naryOperation(abstractInsnNode, arrayList);
                    return;
                }
                this.push(interpreter.naryOperation(abstractInsnNode, arrayList));
                return;
            }
            case 186: {
                ArrayList<V> arrayList = new ArrayList<V>();
                String string = ((InvokeDynamicInsnNode)abstractInsnNode).desc;
                for (int i = Type.getArgumentTypes(string).length; i > 0; --i) {
                    arrayList.add(0xF0DE3D8A ^ 0xF0DE3D8A, this.pop());
                }
                if (Type.getReturnType(string) == Type.VOID_TYPE) {
                    interpreter.naryOperation(abstractInsnNode, arrayList);
                    return;
                }
                this.push(interpreter.naryOperation(abstractInsnNode, arrayList));
                return;
            }
            case 187: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 188: 
            case 189: 
            case 190: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 191: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 192: 
            case 193: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 194: 
            case 195: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 197: {
                ArrayList<V> arrayList = new ArrayList<V>();
                for (int i = ((MultiANewArrayInsnNode)abstractInsnNode).dims; i > 0; --i) {
                    arrayList.add(0x3E14CE6A ^ 0x3E14CE6A, this.pop());
                }
                this.push(interpreter.naryOperation(abstractInsnNode, arrayList));
                return;
            }
            case 198: 
            case 199: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            default: {
                throw new RuntimeException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945") + abstractInsnNode.getOpcode());
            }
        }
    }

    public boolean merge(Frame<? extends V> frame, Interpreter<V> interpreter) throws AnalyzerException {
        if (this.top != frame.top) {
            throw new AnalyzerException(null, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4b6\ua07e\ua908\u7d66\u8e4b\u246e\u8b3e\u3475~\ua7e3\ua4f5\ua062\ua911\u7d77\u8e49\u2471\u8b77\u347fw\ua7ef\ua4b2\ua079\ua911\u7d65"));
        }
        int n = 0x9D2BED03 ^ 0x9D2BED03;
        for (int i = 0xCCB048FE ^ 0xCCB048FE; i < this.locals + this.top; ++i) {
            V v = interpreter.merge(this.values[i], frame.values[i]);
            if (v.equals(this.values[i])) continue;
            this.values[i] = v;
            n = 0xB286030A ^ 0xB286030B;
        }
        return n != 0;
    }

    public boolean merge(Frame<? extends V> frame, boolean[] blArray) {
        int n = 0x2D059958 ^ 0x2D059958;
        for (int i = 0x229C8ED5 ^ 0x229C8ED5; i < this.locals; ++i) {
            if (blArray[i] || this.values[i].equals(frame.values[i])) continue;
            this.values[i] = frame.values[i];
            n = 0xD03CE1CB ^ 0xD03CE1CA;
        }
        return n != 0;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0xF9B05B83 ^ 0xF9B05B83; n < this.getLocals(); ++n) {
            stringBuilder.append(this.getLocal(n));
        }
        stringBuilder.append((char)(0x411D3BC0 ^ 0x411D3BE0));
        for (n = 0xADDF518C ^ 0xADDF518C; n < this.getStackSize(); ++n) {
            stringBuilder.append(this.getStack(n).toString());
        }
        return stringBuilder.toString();
    }
}

