/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.analysis.Analyzer;
import org.spongepowered.asm.lib.tree.analysis.BasicValue;
import org.spongepowered.asm.lib.tree.analysis.Frame;
import org.spongepowered.asm.lib.tree.analysis.SimpleVerifier;
import org.spongepowered.asm.lib.util.CheckAnnotationAdapter;
import org.spongepowered.asm.lib.util.CheckFieldAdapter;
import org.spongepowered.asm.lib.util.CheckMethodAdapter;
import org.spongepowered.asm.lib.util.Textifier;
import org.spongepowered.asm.lib.util.TraceMethodVisitor;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckClassAdapter
extends ClassVisitor {
    private int version;
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;
    private Map<Label, Integer> labels = new HashMap<Label, Integer>();
    private boolean checkDataFlow;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != (0xE5BC138F ^ 0xE5BC138E)) {
            System.err.println(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("D\ua7e3\ua4a7\ua078\ua903\u7d7f\u8e4f\u2469\u8b77\u3463z\ua7e3\ua4f5\ua076\ua90c\u7d60\u8e4f\u2474\u8b77\u3474~\ua7e7\ua4a6\ua062\ua94b"));
            System.err.println(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("G\ua7f5\ua4b4\ua076\ua900\u7d2c\u8e0a\u2459\u8b3f\u3472q\ua7ed\ua496\ua07d\ua904\u7d65\u8e59\u245b\u8b33\u3476b\ua7f2\ua4b0\ua063\ua945\u7d2a\u8e4c\u246f\u8b3b\u347bk\ua7a6\ua4a4\ua064\ua904\u7d7a\u8e43\u247c\u8b3e\u3472v\ua7a6\ua4b6\ua07d\ua904\u7d65\u8e59\u243a\u8b39\u3476\u007f\ua7e3\ua4f5\ua07e\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4b3\ua078\ua909\u7d73\u8e0a\u2474\u8b36\u347aw\ua7b8"));
            return;
        }
        ClassReader classReader = stringArray[0xBC31D113 ^ 0xBC31D113].endsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("<\ua7e5\ua4b9\ua070\ua916\u7d65")) ? new ClassReader(new FileInputStream(stringArray[0x7B8F91E7 ^ 0x7B8F91E7])) : new ClassReader(stringArray[0x8290A02A ^ 0x8290A02A]);
        CheckClassAdapter.verify(classReader, (0xF160863F ^ 0xF160863F) != 0, new PrintWriter(System.err));
    }

    public static void verify(ClassReader classReader, ClassLoader classLoader, boolean bl, PrintWriter printWriter) {
        ClassNode classNode = new ClassNode();
        classReader.accept(new CheckClassAdapter(classNode, (0x263E0E10 ^ 0x263E0E10) != 0), 0x545448F4 ^ 0x545448F6);
        Type type = classNode.superName == null ? null : Type.getObjectType(classNode.superName);
        List<MethodNode> list = classNode.methods;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator<String> iterator = classNode.interfaces.iterator();
        while (iterator.hasNext()) {
            arrayList.add(Type.getObjectType(iterator.next()));
        }
        for (int i = 0x466CBE78 ^ 0x466CBE78; i < list.size(); ++i) {
            MethodNode methodNode = list.get(i);
            SimpleVerifier simpleVerifier = new SimpleVerifier(Type.getObjectType(classNode.name), type, arrayList, ((classNode.access & (0x4CF290B4 ^ 0x4CF292B4)) != 0 ? 0x6261F705 ^ 0x6261F704 : 0x58BE25DA ^ 0x58BE25DA) != 0);
            Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(simpleVerifier);
            if (classLoader != null) {
                simpleVerifier.setClassLoader(classLoader);
            }
            try {
                analyzer.analyze(classNode.name, methodNode);
                if (!bl) {
                    continue;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
            }
            CheckClassAdapter.printAnalyzerResult(methodNode, analyzer, printWriter);
        }
        printWriter.flush();
    }

    public static void verify(ClassReader classReader, boolean bl, PrintWriter printWriter) {
        CheckClassAdapter.verify(classReader, null, bl, printWriter);
    }

    static void printAnalyzerResult(MethodNode methodNode, Analyzer<BasicValue> analyzer, PrintWriter printWriter) {
        int n;
        Frame<BasicValue>[] frameArray = analyzer.getFrames();
        Textifier textifier = new Textifier();
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(textifier);
        printWriter.println(methodNode.name + methodNode.desc);
        for (n = 0x9558765E ^ 0x9558765E; n < methodNode.instructions.size(); ++n) {
            methodNode.instructions.get(n).accept(traceMethodVisitor);
            StringBuilder stringBuilder = new StringBuilder();
            Frame<BasicValue> frame = frameArray[n];
            if (frame == null) {
                stringBuilder.append((char)(0xB4C7D2E7 ^ 0xB4C7D2D8));
            } else {
                int n2;
                for (n2 = 0x264EBDA4 ^ 0x264EBDA4; n2 < frame.getLocals(); ++n2) {
                    stringBuilder.append(CheckClassAdapter.getShortName(frame.getLocal(n2).toString())).append((char)(0x36446AB ^ 0x364468B));
                }
                stringBuilder.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7bc\ua4f5"));
                for (n2 = 0xF2821707 ^ 0xF2821707; n2 < frame.getStackSize(); ++n2) {
                    stringBuilder.append(CheckClassAdapter.getShortName(frame.getStack(n2).toString())).append((char)(0x147C900 ^ 0x147C920));
                }
            }
            while (true) {
                if (stringBuilder.length() >= methodNode.maxStack + methodNode.maxLocals + (0x3B1F023B ^ 0x3B1F023A)) break;
                stringBuilder.append((char)(0x72E1B8BA ^ 0x72E1B89A));
            }
            printWriter.print(Integer.toString(n + (0x7282A170 ^ 0x728327D0)).substring(0x7601294D ^ 0x7601294C));
            printWriter.print(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2") + stringBuilder + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7bc\ua4f5") + textifier.text.get(textifier.text.size() - (0x2E386BE4 ^ 0x2E386BE5)));
        }
        for (n = 0x2F726A1C ^ 0x2F726A1C; n < methodNode.tryCatchBlocks.size(); ++n) {
            methodNode.tryCatchBlocks.get(n).accept(traceMethodVisitor);
            printWriter.print(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2") + textifier.text.get(textifier.text.size() - (0xB88D7024 ^ 0xB88D7025)));
        }
        printWriter.println();
    }

    private static String getShortName(String string) {
        int n = string.lastIndexOf(0x1F739A7E ^ 0x1F739A51);
        int n2 = string.length();
        if (string.charAt(n2 - (0xBC319F7D ^ 0xBC319F7C)) == (0xBF6B2A6A ^ 0xBF6B2A51)) {
            --n2;
        }
        return n == (0xE282D8CA ^ 0x1D7D2735) ? string : string.substring(n + (0xA75B7128 ^ 0xA75B7129), n2);
    }

    public CheckClassAdapter(ClassVisitor classVisitor) {
        this(classVisitor, (0x7838F76E ^ 0x7838F76F) != 0);
    }

    public CheckClassAdapter(ClassVisitor classVisitor, boolean bl) {
        this(0x244AE2F8 ^ 0x244FE2F8, classVisitor, bl);
        if (this.getClass() != CheckClassAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckClassAdapter(int n, ClassVisitor classVisitor, boolean bl) {
        super(n, classVisitor);
        this.checkDataFlow = bl;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        if (this.start) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("d\ua7ef\ua4a6\ua078\ua911\u7d36\u8e47\u246f\u8b24\u34632\ua7e4\ua4b0\ua031\ua906\u7d77\u8e46\u2476\u8b32\u34732\ua7e9\ua4bb\ua07d\ua91c\u7d36\u8e45\u2474\u8b34\u3472"));
        }
        this.start = 0xAF6DB63E ^ 0xAF6DB63F;
        this.checkState();
        CheckClassAdapter.checkAccess(n2, 0xD01DE4BD ^ 0xD01B928C);
        if (string == null || !string.endsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("b\ua7e7\ua4b6\ua07a\ua904\u7d71\u8e4f\u2437\u8b3e\u3479t\ua7e9"))) {
            CheckMethodAdapter.checkInternalName(string, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e44\u247b\u8b3a\u3472"));
        }
        if (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string)) {
            if (string3 != null) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("F\ua7ee\ua4b0\ua031\ua916\u7d63\u8e5a\u247f\u8b25\u3437q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e44\u247b\u8b3a\u34722\ua7e9\ua4b3\ua031\ua911\u7d7e\u8e4f\u243a\u8b18\u3475x\ua7e3\ua4b6\ua065\ua945\u7d75\u8e46\u247b\u8b24\u34642\ua7eb\ua4a0\ua062\ua911\u7d36\u8e48\u247f\u8b77\u3430|\ua7f3\ua4b9\ua07d\ua942"));
            }
        } else {
            CheckMethodAdapter.checkInternalName(string3, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4bb\ua070\ua908\u7d73"));
        }
        if (string2 != null) {
            CheckClassAdapter.checkClassSignature(string2);
        }
        if ((n2 & (0x1D715604 ^ 0x1D715404)) != 0 && !\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string3)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("F\ua7ee\ua4b0\ua031\ua916\u7d63\u8e5a\u247f\u8b25\u3437q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e44\u247b\u8b3a\u34722\ua7e9\ua4b3\ua031\ua90c\u7d78\u8e5e\u247f\u8b25\u3471s\ua7e5\ua4b0\ua062\ua945\u7d7b\u8e5f\u2469\u8b23\u3437p\ua7e3\ua4f5\ua036\ua90f\u7d77\u8e5c\u247b\u8b78\u347bs\ua7e8\ua4b2\ua03e\ua92a\u7d74\u8e40\u247f\u8b34\u34635"));
        }
        if (stringArray != null) {
            for (int i = 0x3723E578 ^ 0x3723E578; i < stringArray.length; ++i) {
                CheckMethodAdapter.checkInternalName(stringArray[i], \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("{\ua7e8\ua4a1\ua074\ua917\u7d70\u8e4b\u2479\u8b32\u3437|\ua7e7\ua4b8\ua074\ua945\u7d77\u8e5e\u243a\u8b3e\u3479v\ua7e3\ua4ad\ua031") + i);
            }
        }
        this.version = n;
        super.visit(n, n2, string, string2, string3, stringArray);
    }

    @Override
    public void visitSource(String string, String string2) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("d\ua7ef\ua4a6\ua078\ua911\u7d45\u8e45\u246f\u8b25\u3474w\ua7a6\ua4b6\ua070\ua90b\u7d36\u8e48\u247f\u8b77\u3474s\ua7ea\ua4b9\ua074\ua901\u7d36\u8e45\u2474\u8b3b\u346e2\ua7e9\ua4bb\ua072\ua900\u7d38"));
        }
        this.source = 0xA6E3AA8B ^ 0xA6E3AA8A;
        super.visitSource(string, string2);
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("d\ua7ef\ua4a6\ua078\ua911\u7d59\u8e5f\u246e\u8b32\u3465Q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e49\u247b\u8b39\u3437p\ua7e3\ua4f5\ua072\ua904\u7d7a\u8e46\u247f\u8b33\u3437}\ua7e8\ua4b9\ua068\ua945\u7d79\u8e44\u2479\u8b32\u3439"));
        }
        this.outer = 0x28DC5529 ^ 0x28DC5528;
        if (string == null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b38\u3462f\ua7e3\ua4a7\ua031\ua906\u7d7a\u8e4b\u2469\u8b24\u3437}\ua7f1\ua4bb\ua074\ua917"));
        }
        if (string3 != null) {
            CheckMethodAdapter.checkMethodDesc(string3);
        }
        super.visitOuterClass(string, string2, string3);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(string, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e44\u247b\u8b3a\u3472"));
        if (string2 != null) {
            CheckMethodAdapter.checkInternalName(string2, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("}\ua7f3\ua4a1\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4bb\ua070\ua908\u7d73"));
        }
        if (string3 != null) {
            int n2;
            for (n2 = 0xB6275151 ^ 0xB6275151; n2 < string3.length() && Character.isDigit(string3.charAt(n2)); ++n2) {
            }
            if (n2 == 0 || n2 < string3.length()) {
                CheckMethodAdapter.checkIdentifier(string3, n2, 0xF5A53FC6 ^ 0xA5AC039, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("{\ua7e8\ua4bb\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4bb\ua070\ua908\u7d73"));
            }
        }
        CheckClassAdapter.checkAccess(n, 0xDE351B84 ^ 0xDE356D9B);
        super.visitInnerClass(string, string2, string3, n);
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 0x99A1C0A1 ^ 0x99A7907E);
        CheckMethodAdapter.checkUnqualifiedName(this.version, string, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("t\ua7ef\ua4b0\ua07d\ua901\u7d36\u8e44\u247b\u8b3a\u3472"));
        CheckMethodAdapter.checkDesc(string2, (0x74F31500 ^ 0x74F31500) != 0);
        if (string3 != null) {
            CheckClassAdapter.checkFieldSignature(string3);
        }
        if (object != null) {
            CheckMethodAdapter.checkConstant(object);
        }
        FieldVisitor fieldVisitor = super.visitField(n, string, string2, string3, object);
        return new CheckFieldAdapter(fieldVisitor);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 0xC3737B91 ^ 0xC375666E);
        if (!\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(string) && !\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7e5\ua4b9\ua078\ua90b\u7d7f\u8e5e\u2424").equals(string)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, string, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2474\u8b36\u347aw"));
        }
        CheckMethodAdapter.checkMethodDesc(string2);
        if (string3 != null) {
            CheckClassAdapter.checkMethodSignature(string3);
        }
        if (stringArray != null) {
            for (int i = 0x4CC070CC ^ 0x4CC070CC; i < stringArray.length; ++i) {
                CheckMethodAdapter.checkInternalName(stringArray[i], \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("w\ua7fe\ua4b6\ua074\ua915\u7d62\u8e43\u2475\u8b39\u3437|\ua7e7\ua4b8\ua074\ua945\u7d77\u8e5e\u243a\u8b3e\u3479v\ua7e3\ua4ad\ua031") + i);
            }
        }
        CheckMethodAdapter checkMethodAdapter = this.checkDataFlow ? new CheckMethodAdapter(n, string, string2, super.visitMethod(n, string, string2, string3, stringArray), this.labels) : new CheckMethodAdapter(super.visitMethod(n, string, string2, string3, stringArray), this.labels);
        checkMethodAdapter.version = this.version;
        return checkMethodAdapter;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.checkState();
        CheckMethodAdapter.checkDesc(string, (0xE520586C ^ 0xE520586C) != 0);
        return new CheckAnnotationAdapter(super.visitAnnotation(string, bl));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.checkState();
        int n2 = n >>> (0x1B62BE13 ^ 0x1B62BE0B);
        if (n2 != 0) {
            if (n2 != (0x8154D4FE ^ 0x8154D4EF)) {
                if (n2 != (0x25E68EC2 ^ 0x25E68ED2)) {
                    throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua063\ua900\u7d70\u8e4f\u2468\u8b32\u3479q\ua7e3\ua4f5\ua062\ua90a\u7d64\u8e5e\u243a\u8b67\u346f") + Integer.toHexString(n2));
                }
            }
        }
        CheckClassAdapter.checkTypeRefAndPath(n, typePath);
        CheckMethodAdapter.checkDesc(string, (0xD44EE951 ^ 0xD44EE951) != 0);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(n, typePath, string, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkState();
        if (attribute == null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b36\u3463f\ua7f4\ua4bc\ua073\ua910\u7d62\u8e4f\u243a\u8b7f\u347ag\ua7f5\ua4a1\ua031\ua90b\u7d79\u8e5e\u243a\u8b35\u34722\ua7e8\ua4a0\ua07d\ua909\u7d3f"));
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitEnd() {
        this.checkState();
        this.end = 0x7AB99CD1 ^ 0x7AB99CD0;
        super.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u246c\u8b3e\u3464{\ua7f2\ua4f5\ua07c\ua900\u7d7b\u8e48\u247f\u8b25\u3437p\ua7e3\ua4b3\ua07e\ua917\u7d73\u8e0a\u246c\u8b3e\u3464{\ua7f2\ua4f5\ua079\ua904\u7d65\u8e0a\u2478\u8b32\u3472|\ua7a6\ua4b6\ua070\ua909\u7d7a\u8e4f\u247e\u8b79"));
        }
        if (this.end) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u246c\u8b3e\u3464{\ua7f2\ua4f5\ua07c\ua900\u7d7b\u8e48\u247f\u8b25\u3437s\ua7e0\ua4a1\ua074\ua917\u7d36\u8e5c\u2473\u8b24\u347ef\ua7c3\ua4bb\ua075\ua945\u7d7e\u8e4b\u2469\u8b77\u3475w\ua7e3\ua4bb\ua031\ua906\u7d77\u8e46\u2476\u8b32\u3473<"));
        }
    }

    static void checkAccess(int n, int n2) {
        if ((n & (n2 ^ (0x9B6A4685 ^ 0x6495B97A))) != 0) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b36\u3474q\ua7e3\ua4a6\ua062\ua945\u7d70\u8e46\u247b\u8b30\u3464(\ua7a6") + n);
        }
        int n3 = (n & (0x28C0516F ^ 0x28C0516E)) == 0 ? 0x563D53B ^ 0x563D53B : 0xB2D27F89 ^ 0xB2D27F88;
        int n4 = (n & (0x9E9B6752 ^ 0x9E9B6750)) == 0 ? 0x64F7291 ^ 0x64F7291 : 0xB2460F7F ^ 0xB2460F7E;
        int n5 = (n & (0x8EDD4C7E ^ 0x8EDD4C7A)) == 0 ? 0x8F73B38D ^ 0x8F73B38D : 0x1646FEDF ^ 0x1646FEDE;
        if (n3 + n4 + n5 > (0x25DC30FE ^ 0x25DC30FF)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("b\ua7f3\ua4b7\ua07d\ua90c\u7d75\u8e0a\u246a\u8b25\u347ed\ua7e7\ua4a1\ua074\ua945\u7d77\u8e44\u247e\u8b77\u3467`\ua7e9\ua4a1\ua074\ua906\u7d62\u8e4f\u247e\u8b77\u3476`\ua7e3\ua4f5\ua07c\ua910\u7d62\u8e5f\u247b\u8b3b\u347bk\ua7a6\ua4b0\ua069\ua906\u7d7a\u8e5f\u2469\u8b3e\u3461w\ua7bc\ua4f5") + n);
        }
        int n6 = (n & (0x7B84186B ^ 0x7B84187B)) == 0 ? 0x1FFAE29E ^ 0x1FFAE29E : 0x9FA379D1 ^ 0x9FA379D0;
        int n7 = (n & (0xE7F1F836 ^ 0xE7F1FC36)) == 0 ? 0xB07C424E ^ 0xB07C424E : 0x48E74DA2 ^ 0x48E74DA3;
        if (n6 + n7 > (0xAF3DDD09 ^ 0xAF3DDD08)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("t\ua7ef\ua4bb\ua070\ua909\u7d36\u8e4b\u2474\u8b33\u3437s\ua7e4\ua4a6\ua065\ua917\u7d77\u8e49\u246e\u8b77\u3476`\ua7e3\ua4f5\ua07c\ua910\u7d62\u8e5f\u247b\u8b3b\u347bk\ua7a6\ua4b0\ua069\ua906\u7d7a\u8e5f\u2469\u8b3e\u3461w\ua7bc\ua4f5") + n);
        }
    }

    public static void checkClassSignature(String string) {
        int n = 0x43AF1531 ^ 0x43AF1531;
        if (CheckClassAdapter.getChar(string, 0xB5408B5A ^ 0xB5408B5A) == (0x63F546CF ^ 0x63F546F3)) {
            n = CheckClassAdapter.checkFormalTypeParameters(string, n);
        }
        n = CheckClassAdapter.checkClassTypeSignature(string, n);
        while (true) {
            if (CheckClassAdapter.getChar(string, n) != (0x917B7410 ^ 0x917B745C)) break;
            n = CheckClassAdapter.checkClassTypeSignature(string, n);
        }
        if (n != string.length()) {
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("(\ua7a6\ua4b0\ua063\ua917\u7d79\u8e58\u243a\u8b36\u34632\ua7ef\ua4bb\ua075\ua900\u7d6e\u8e0a") + n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkMethodSignature(String string) {
        int n = 0x161DAFE4 ^ 0x161DAFE4;
        if (CheckClassAdapter.getChar(string, 0x7CC556C4 ^ 0x7CC556C4) == (0x5AA609EA ^ 0x5AA609D6)) {
            n = CheckClassAdapter.checkFormalTypeParameters(string, n);
        }
        n = CheckClassAdapter.checkChar((char)(0x54B2C7B7 ^ 0x54B2C79F), string, n);
        while (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("H\ua7c5\ua497\ua042\ua92c\u7d50\u8e60\u245e\u8b1b\u344cF").indexOf(CheckClassAdapter.getChar(string, n)) != (0xA62E4F82 ^ 0x59D1B07D)) {
            n = CheckClassAdapter.checkTypeSignature(string, n);
        }
        n = CheckClassAdapter.checkChar((char)(0x96B200AD ^ 0x96B20084), string, n);
        n = CheckClassAdapter.getChar(string, n) == (0x6108399C ^ 0x610839CA) ? ++n : CheckClassAdapter.checkTypeSignature(string, n);
        while (CheckClassAdapter.getChar(string, n) == (0xC8BB5F76 ^ 0xC8BB5F28)) {
            if (CheckClassAdapter.getChar(string, ++n) == (0x1196C4EA ^ 0x1196C4A6)) {
                n = CheckClassAdapter.checkClassTypeSignature(string, n);
                continue;
            }
            n = CheckClassAdapter.checkTypeVariableSignature(string, n);
        }
        if (n != string.length()) {
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("(\ua7a6\ua4b0\ua063\ua917\u7d79\u8e58\u243a\u8b36\u34632\ua7ef\ua4bb\ua075\ua900\u7d6e\u8e0a") + n);
        }
    }

    public static void checkFieldSignature(String string) {
        int n = CheckClassAdapter.checkFieldTypeSignature(string, 0x1222160E ^ 0x1222160E);
        if (n != string.length()) {
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("(\ua7a6\ua4b0\ua063\ua917\u7d79\u8e58\u243a\u8b36\u34632\ua7ef\ua4bb\ua075\ua900\u7d6e\u8e0a") + n);
        }
    }

    static void checkTypeRefAndPath(int n, TypePath typePath) {
        int n2 = 0x2AECAD3 ^ 0x2AECAD3;
        switch (n >>> (0x7F4EAF39 ^ 0x7F4EAF21)) {
            case 0: 
            case 1: 
            case 22: {
                n2 = 0x59D2AC08 ^ 0xA62DAC08;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                n2 = 0x6A40B805 ^ 0x9540B805;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: {
                n2 = 0xFDE1D491 ^ 0x21E2B91;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                n2 = 0x6759BBD ^ 0xF9759B42;
                break;
            }
            default: {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua063\ua900\u7d70\u8e4f\u2468\u8b32\u3479q\ua7e3\ua4f5\ua062\ua90a\u7d64\u8e5e\u243a\u8b67\u346f") + Integer.toHexString(n >>> (0x33ECCE15 ^ 0x33ECCE0D)));
            }
        }
        if ((n & (n2 ^ (0x712AA6B3 ^ 0x8ED5594C))) != 0) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua063\ua900\u7d70\u8e4f\u2468\u8b32\u3479q\ua7e3\ua4f5\ua021\ua91d") + Integer.toHexString(n));
        }
        if (typePath != null) {
            for (int i = 0x297152A6 ^ 0x297152A6; i < typePath.getLength(); ++i) {
                int n3 = typePath.getStep(i);
                if (n3 != 0) {
                    if (n3 != (0xC015CF8 ^ 0xC015CF9)) {
                        if (n3 != (0x410AA4B1 ^ 0x410AA4B2)) {
                            if (n3 != (0xC482B5B ^ 0xC482B59)) {
                                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua061\ua904\u7d62\u8e42\u243a\u8b24\u3463w\ua7f6\ua4f5") + i + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4bb\ua031") + typePath);
                            }
                        }
                    }
                }
                if (n3 == (0xE13658BD ^ 0xE13658BE) || typePath.getStepArgument(i) == 0) continue;
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua061\ua904\u7d62\u8e42\u243a\u8b24\u3463w\ua7f6\ua4f5\ua070\ua917\u7d71\u8e5f\u2477\u8b32\u3479f\ua7a6\ua4b3\ua07e\ua917\u7d36\u8e59\u246e\u8b32\u34672") + i + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4bb\ua031") + typePath);
            }
        }
    }

    private static int checkFormalTypeParameters(String string, int n) {
        n = CheckClassAdapter.checkChar((char)(0x6D8AF9B2 ^ 0x6D8AF98E), string, n);
        n = CheckClassAdapter.checkFormalTypeParameter(string, n);
        while (true) {
            if (CheckClassAdapter.getChar(string, n) == (0x2FA01CE0 ^ 0x2FA01CDE)) break;
            n = CheckClassAdapter.checkFormalTypeParameter(string, n);
        }
        return n + (0x98E5041A ^ 0x98E5041B);
    }

    private static int checkFormalTypeParameter(String string, int n) {
        n = CheckClassAdapter.checkIdentifier(string, n);
        n = CheckClassAdapter.checkChar((char)(0x20162D93 ^ 0x20162DA9), string, n);
        if (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^\ua7dd\ua481").indexOf(CheckClassAdapter.getChar(string, n)) != (0x3223E02D ^ 0xCDDC1FD2)) {
            n = CheckClassAdapter.checkFieldTypeSignature(string, n);
        }
        while (true) {
            if (CheckClassAdapter.getChar(string, n) != (0x697AA1BA ^ 0x697AA180)) break;
            n = CheckClassAdapter.checkFieldTypeSignature(string, n + (0x9C376D2F ^ 0x9C376D2E));
        }
        return n;
    }

    private static int checkFieldTypeSignature(String string, int n) {
        switch (CheckClassAdapter.getChar(string, n)) {
            case 'L': {
                return CheckClassAdapter.checkClassTypeSignature(string, n);
            }
            case '[': {
                return CheckClassAdapter.checkTypeSignature(string, n + (0x8F05464A ^ 0x8F05464B));
            }
        }
        return CheckClassAdapter.checkTypeVariableSignature(string, n);
    }

    private static int checkClassTypeSignature(String string, int n) {
        n = CheckClassAdapter.checkChar((char)(0x43A049FA ^ 0x43A049B6), string, n);
        n = CheckClassAdapter.checkIdentifier(string, n);
        while (true) {
            if (CheckClassAdapter.getChar(string, n) != (0x2F873862 ^ 0x2F87384D)) break;
            n = CheckClassAdapter.checkIdentifier(string, n + (0x1493593B ^ 0x1493593A));
        }
        if (CheckClassAdapter.getChar(string, n) == (0x79451CAC ^ 0x79451C90)) {
            n = CheckClassAdapter.checkTypeArguments(string, n);
        }
        while (true) {
            if (CheckClassAdapter.getChar(string, n) != (0x5CD558AA ^ 0x5CD55884)) break;
            n = CheckClassAdapter.checkIdentifier(string, n + (0xAB7E22B0 ^ 0xAB7E22B1));
            if (CheckClassAdapter.getChar(string, n) != (0xE8E13408 ^ 0xE8E13434)) continue;
            n = CheckClassAdapter.checkTypeArguments(string, n);
        }
        return CheckClassAdapter.checkChar((char)(0x99FA6D03 ^ 0x99FA6D38), string, n);
    }

    private static int checkTypeArguments(String string, int n) {
        n = CheckClassAdapter.checkChar((char)(0x3B2201D1 ^ 0x3B2201ED), string, n);
        n = CheckClassAdapter.checkTypeArgument(string, n);
        while (true) {
            if (CheckClassAdapter.getChar(string, n) == (0xB2791A5F ^ 0xB2791A61)) break;
            n = CheckClassAdapter.checkTypeArgument(string, n);
        }
        return n + (0xFDA3F339 ^ 0xFDA3F338);
    }

    private static int checkTypeArgument(String string, int n) {
        block5: {
            block4: {
                char c = CheckClassAdapter.getChar(string, n);
                if (c == (0x738ACDC9 ^ 0x738ACDE3)) {
                    return n + (0x5C1C2A20 ^ 0x5C1C2A21);
                }
                if (c == (0xC7E98E92 ^ 0xC7E98EB9)) break block4;
                if (c != (0xFB763E1F ^ 0xFB763E32)) break block5;
            }
            ++n;
        }
        return CheckClassAdapter.checkFieldTypeSignature(string, n);
    }

    private static int checkTypeVariableSignature(String string, int n) {
        n = CheckClassAdapter.checkChar((char)(0x4D65F1BF ^ 0x4D65F1EB), string, n);
        n = CheckClassAdapter.checkIdentifier(string, n);
        return CheckClassAdapter.checkChar((char)(0x37600CC3 ^ 0x37600CF8), string, n);
    }

    private static int checkTypeSignature(String string, int n) {
        switch (CheckClassAdapter.getChar(string, n)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + (0x9AC80D3A ^ 0x9AC80D3B);
            }
        }
        return CheckClassAdapter.checkFieldTypeSignature(string, n);
    }

    private static int checkIdentifier(String string, int n) {
        if (!Character.isJavaIdentifierStart(CheckClassAdapter.getChar(string, n))) {
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("(\ua7a6\ua4bc\ua075\ua900\u7d78\u8e5e\u2473\u8b31\u347ew\ua7f4\ua4f5\ua074\ua91d\u7d66\u8e4f\u2479\u8b23\u3472v\ua7a6\ua4b4\ua065\ua945\u7d7f\u8e44\u247e\u8b32\u346f2") + n);
        }
        ++n;
        while (Character.isJavaIdentifierPart(CheckClassAdapter.getChar(string, n))) {
            ++n;
        }
        return n;
    }

    private static int checkChar(char c, String string, int n) {
        if (CheckClassAdapter.getChar(string, n) == c) {
            return n + (0xD8C5BF33 ^ 0xD8C5BF32);
        }
        throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("(\ua7a6\ua4f2") + c + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("5\ua7a6\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7e7\ua4a1\ua031\ua90c\u7d78\u8e4e\u247f\u8b2f\u3437") + n);
    }

    private static char getChar(String string, int n) {
        return (char)(n < string.length() ? string.charAt(n) : 0x7A3C9B41 ^ 0x7A3C9B41);
    }
}

