/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.util;

import org.spongepowered.asm.lib.signature.SignatureVisitor;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class TraceSignatureVisitor
extends SignatureVisitor {
    private final StringBuilder declaration;
    private boolean isInterface;
    private boolean seenFormalParameter;
    private boolean seenInterfaceBound;
    private boolean seenParameter;
    private boolean seenInterface;
    private StringBuilder returnType;
    private StringBuilder exceptions;
    private int argumentStack;
    private int arrayStack;
    private String separator = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("");

    public TraceSignatureVisitor(int n) {
        super(0xFB2D8070 ^ 0xFB288070);
        this.isInterface = (n & (0xB00DD165 ^ 0xB00DD365)) != 0 ? 0xCD4FAA8E ^ 0xCD4FAA8F : 0xF28A2485 ^ 0xF28A2485;
        this.declaration = new StringBuilder();
    }

    private TraceSignatureVisitor(StringBuilder stringBuilder) {
        super(0x3ED4A08A ^ 0x3ED1A08A);
        this.declaration = stringBuilder;
    }

    public void visitFormalTypeParameter(String string) {
        this.declaration.append(this.seenFormalParameter ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(">\ua7a6") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".")).append(string);
        this.seenFormalParameter = 0xF520A7A2 ^ 0xF520A7A3;
        this.seenInterfaceBound = 0x819010BE ^ 0x819010BE;
    }

    public SignatureVisitor visitClassBound() {
        this.separator = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77");
        this.startType();
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.separator = this.seenInterfaceBound ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(">\ua7a6") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77");
        this.seenInterfaceBound = 0x114273B3 ^ 0x114273B2;
        this.startType();
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        this.separator = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77");
        this.startType();
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.separator = this.seenInterface ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(">\ua7a6") : (this.isInterface ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4b8\ua061\ua909\u7d73\u8e47\u247f\u8b39\u3463a\ua7a6"));
        this.seenInterface = 0x81149E86 ^ 0x81149E87;
        this.startType();
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (this.seenParameter) {
            this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(">\ua7a6"));
        } else {
            this.seenParameter = 0xE253647A ^ 0xE253647B;
            this.declaration.append((char)(0xC0D2B2DA ^ 0xC0D2B2F2));
        }
        this.startType();
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (this.seenParameter) {
            this.seenParameter = 0x2B9FE904 ^ 0x2B9FE904;
        } else {
            this.declaration.append((char)(0xBA9DC874 ^ 0xBA9DC85C));
        }
        this.declaration.append((char)(0xC1246E9 ^ 0xC1246C0));
        this.returnType = new StringBuilder();
        return new TraceSignatureVisitor(this.returnType);
    }

    public SignatureVisitor visitExceptionType() {
        if (this.exceptions == null) {
            this.exceptions = new StringBuilder();
        } else {
            this.exceptions.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(">\ua7a6"));
        }
        return new TraceSignatureVisitor(this.exceptions);
    }

    public void visitBaseType(char c) {
        switch (c) {
            case 'V': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("d\ua7e9\ua4bc\ua075"));
                break;
            }
            case 'B': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("p\ua7ff\ua4a1\ua074"));
                break;
            }
            case 'J': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("~\ua7e9\ua4bb\ua076"));
                break;
            }
            case 'Z': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("p\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44"));
                break;
            }
            case 'I': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("{\ua7e8\ua4a1"));
                break;
            }
            case 'S': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("a\ua7ee\ua4ba\ua063\ua911"));
                break;
            }
            case 'C': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7ee\ua4b4\ua063"));
                break;
            }
            case 'F': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("t\ua7ea\ua4ba\ua070\ua911"));
                break;
            }
            default: {
                this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("v\ua7e9\ua4a0\ua073\ua909\u7d73"));
            }
        }
        this.endType();
    }

    public void visitTypeVariable(String string) {
        this.declaration.append(string);
        this.endType();
    }

    public SignatureVisitor visitArrayType() {
        this.startType();
        this.arrayStack |= 0xF29ADA9 ^ 0xF29ADA8;
        return this;
    }

    public void visitClassType(String string) {
        if (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string)) {
            int n;
            int n2 = this.argumentStack % (0xA875FEEA ^ 0xA875FEE8) != 0 || this.seenParameter ? 0xD131CECC ^ 0xD131CECD : (n = 0x887A4A8 ^ 0x887A4A8);
            if (n != 0) {
                this.declaration.append(this.separator).append(string.replace((char)(0x467A11BB ^ 0x467A1194), (char)(0x7F82DE96 ^ 0x7F82DEB8)));
            }
        } else {
            this.declaration.append(this.separator).append(string.replace((char)(0xD173A7F0 ^ 0xD173A7DF), (char)(0x2913868D ^ 0x291386A3)));
        }
        this.separator = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("");
        this.argumentStack *= 0x2341BDEC ^ 0x2341BDEE;
    }

    public void visitInnerClassType(String string) {
        if (this.argumentStack % (0xAEBE7C37 ^ 0xAEBE7C35) != 0) {
            this.declaration.append((char)(0x3B951CB0 ^ 0x3B951C8E));
        }
        this.argumentStack /= 0x33C93361 ^ 0x33C93363;
        this.declaration.append((char)(0xB7007360 ^ 0xB700734E));
        this.declaration.append(this.separator).append(string.replace((char)(0xD1080B38 ^ 0xD1080B17), (char)(0x1E7C663C ^ 0x1E7C6612)));
        this.separator = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("");
        this.argumentStack *= 0x8FB2E1A0 ^ 0x8FB2E1A2;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % (0xFA997299 ^ 0xFA99729B) == 0) {
            this.argumentStack += 0x6884B4C5 ^ 0x6884B4C4;
            this.declaration.append((char)(0xC167BEB9 ^ 0xC167BE85));
        } else {
            this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(">\ua7a6"));
        }
        this.declaration.append((char)(0xB13F1B7E ^ 0xB13F1B41));
    }

    public SignatureVisitor visitTypeArgument(char c) {
        if (this.argumentStack % (0xAF9BD5BA ^ 0xAF9BD5B8) == 0) {
            this.argumentStack += 0x26D668E7 ^ 0x26D668E6;
            this.declaration.append((char)(0x3E3FF303 ^ 0x3E3FF33F));
        } else {
            this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(">\ua7a6"));
        }
        if (c == (0x9F18E25D ^ 0x9F18E276)) {
            this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("-\ua7a6\ua4b0\ua069\ua911\u7d73\u8e44\u247e\u8b24\u3437"));
        } else if (c == (0x486B89FD ^ 0x486B89D0)) {
            this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("-\ua7a6\ua4a6\ua064\ua915\u7d73\u8e58\u243a"));
        }
        this.startType();
        return this;
    }

    public void visitEnd() {
        if (this.argumentStack % (0x9F8835CC ^ 0x9F8835CE) != 0) {
            this.declaration.append((char)(0xA12436C6 ^ 0xA12436F8));
        }
        this.argumentStack /= 0xAF9DD93D ^ 0xAF9DD93F;
        this.endType();
    }

    public String getDeclaration() {
        return this.declaration.toString();
    }

    public String getReturnType() {
        return this.returnType == null ? null : this.returnType.toString();
    }

    public String getExceptions() {
        return this.exceptions == null ? null : this.exceptions.toString();
    }

    private void endFormals() {
        if (this.seenFormalParameter) {
            this.declaration.append((char)(0xF229C69A ^ 0xF229C6A4));
            this.seenFormalParameter = 0xD5C8D36A ^ 0xD5C8D36A;
        }
    }

    private void startType() {
        this.arrayStack *= 0x4E0BF897 ^ 0x4E0BF895;
    }

    private void endType() {
        if (this.arrayStack % (0x2B3EBC3C ^ 0x2B3EBC3E) == 0) {
            this.arrayStack /= 0x4CA277A ^ 0x4CA2778;
        } else {
            while (true) {
                if (this.arrayStack % (0xCE6A95B7 ^ 0xCE6A95B5) == 0) break;
                this.arrayStack /= 0xA870B85C ^ 0xA870B85E;
                this.declaration.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7db"));
            }
        }
    }
}

