/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.gen;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.gen.AccessorGenerator;
import org.spongepowered.asm.mixin.gen.AccessorInfo;
import org.spongepowered.asm.util.Bytecode;

public class AccessorGeneratorMethodProxy
extends AccessorGenerator {
    private final MethodNode targetMethod;
    private final Type[] argTypes;
    private final Type returnType;
    private final boolean isInstanceMethod;

    public AccessorGeneratorMethodProxy(AccessorInfo accessorInfo) {
        super(accessorInfo);
        this.targetMethod = accessorInfo.getTargetMethod();
        this.argTypes = accessorInfo.getArgTypes();
        this.returnType = accessorInfo.getReturnType();
        this.isInstanceMethod = !Bytecode.hasFlag(this.targetMethod, 0xC76E3CD0 ^ 0xC76E3CD8) ? 0xA4381F01 ^ 0xA4381F00 : 0x3E336E2F ^ 0x3E336E2F;
    }

    @Override
    public MethodNode generate() {
        int n = Bytecode.getArgsSize(this.argTypes) + this.returnType.getSize() + (this.isInstanceMethod ? 0xC6274217 ^ 0xC6274216 : 0x58965DD4 ^ 0x58965DD4);
        MethodNode methodNode = this.createMethod(n, n);
        if (this.isInstanceMethod) {
            methodNode.instructions.add(new VarInsnNode(0x165087E9 ^ 0x165087F0, 0xA9E3F099 ^ 0xA9E3F099));
        }
        Bytecode.loadArgs(this.argTypes, methodNode.instructions, this.isInstanceMethod ? 0x73B61E8 ^ 0x73B61E9 : 0x2D9A3DE3 ^ 0x2D9A3DE3);
        boolean bl = Bytecode.hasFlag(this.targetMethod, 0x82F30EE4 ^ 0x82F30EE6);
        int n2 = this.isInstanceMethod ? (bl ? 0x9C0F5887 ^ 0x9C0F5830 : 0x7A6F7838 ^ 0x7A6F788E) : 0x24FAAD01 ^ 0x24FAADB9;
        methodNode.instructions.add(new MethodInsnNode(n2, this.info.getClassNode().name, this.targetMethod.name, this.targetMethod.desc, (0x5A868863 ^ 0x5A868863) != 0));
        methodNode.instructions.add(new InsnNode(this.returnType.getOpcode(0x48497A57 ^ 0x48497AFB)));
        return methodNode;
    }
}

