/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.callback;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.points.BeforeReturn;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.Locals;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class CallbackInjector
extends Injector {
    private final boolean cancellable;
    private final LocalCapture localCapture;
    private final String identifier;
    private final Map<Integer, String> ids = new HashMap<Integer, String>();
    private int totalInjections = 0xED86D1C2 ^ 0xED86D1C2;
    private int callbackInfoVar = 0x4EA87297 ^ 0xB1578D68;
    private String lastId;
    private String lastDesc;
    private Target lastTarget;
    private String callbackInfoClass;

    public CallbackInjector(InjectionInfo injectionInfo, boolean bl, LocalCapture localCapture, String string) {
        super(injectionInfo);
        this.cancellable = bl;
        this.localCapture = localCapture;
        this.identifier = string;
    }

    @Override
    protected void sanityCheck(Target target, List<InjectionPoint> list) {
        super.sanityCheck(target, list);
        if (target.isStatic != this.isStatic) {
            throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("5\ua7f5\ua4a1\ua070\ua911\u7d7f\u8e49\u243d\u8b77\u347a}\ua7e2\ua4bc\ua077\ua90c\u7d73\u8e58\u243a\u8b38\u34712\ua7e5\ua4b4\ua07d\ua909\u7d74\u8e4b\u2479\u8b3c\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u247e\u8b38\u3472a\ua7a6\ua4bb\ua07e\ua911\u7d36\u8e47\u247b\u8b23\u3474z\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u347e|\ua7a6") + this);
        }
        if (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(target.method.name)) {
            for (InjectionPoint injectionPoint : list) {
                if (injectionPoint.getClass().equals(BeforeReturn.class)) continue;
                throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e43\u2474\u8b3d\u3472q\ua7f2\ua4bc\ua07e\ua90b\u7d36\u8e5a\u2475\u8b3e\u3479f\ua7a6\ua4a1\ua068\ua915\u7d73\u8e0a") + injectionPoint.getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u246e\u8b3e\u3479u\ua7a6\ua4b4\ua031\ua906\u7d62\u8e45\u2468\u8b77\u347e|\ua7a6") + this + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("<\ua7a6\ua49a\ua07f\ua909\u7d6f\u8e0a\u2448\u8b12\u3443G\ua7d4\ua49b\ua031\ua904\u7d7a\u8e46\u2475\u8b20\u3472v\ua7a6\ua4b3\ua07e\ua917\u7d36\u8e4b\u243a\u8b34\u3463}\ua7f4\ua4f5\ua065\ua904\u7d64\u8e4d\u247f\u8b23"));
            }
        }
    }

    @Override
    protected void addTargetNode(Target target, List<InjectionNodes.InjectionNode> list, AbstractInsnNode abstractInsnNode, Set<InjectionPoint> set) {
        InjectionNodes.InjectionNode injectionNode = target.addInjectionNode(abstractInsnNode);
        for (InjectionPoint injectionPoint : set) {
            String string = injectionPoint.getId();
            if (Strings.isNullOrEmpty((String)string)) continue;
            String string2 = this.ids.get(injectionNode.getId());
            if (string2 != null && !string2.equals(string)) {
                Object[] objectArray = new Object[0x6658E6AA ^ 0x6658E6AF];
                objectArray[0x42D38F1 ^ 0x42D38F1] = Bytecode.getOpcodeName(abstractInsnNode);
                objectArray[0xE82A64CA ^ 0xE82A64CB] = target.toString();
                objectArray[0x3040E931 ^ 0x3040E933] = string;
                objectArray[0x40214ECE ^ 0x40214ECD] = this.info;
                objectArray[0x5898CFF3 ^ 0x5898CFF7] = string2;
                Injector.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e9\ua4bb\ua077\ua909\u7d7f\u8e49\u246e\u8b3e\u3479u\ua7a6\ua4bc\ua075\ua945\u7d70\u8e45\u2468\u8b77\u346co\ua7a6\ua4bc\ua07f\ua916\u7d78\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f9\ua031\ua903\u7d79\u8e5f\u2474\u8b33\u3437{\ua7e2\ua4f5\ua06a\ua918\u7d36\u8e45\u2474\u8b77\u346co\ua7aa\ua4f5\ua061\ua917\u7d73\u8e5c\u2473\u8b38\u3462a\ua7ea\ua4ac\ua031\ua901\u7d73\u8e4c\u2473\u8b39\u3472v\ua7a6\ua4b4\ua062\ua945\u7d6d\u8e57"), objectArray);
                break;
            }
            this.ids.put(injectionNode.getId(), string);
        }
        list.add(injectionNode);
        this.totalInjections += 0x6E908B7B ^ 0x6E908B7A;
    }

    @Override
    protected void inject(Target target, InjectionNodes.InjectionNode injectionNode) {
        LocalVariableNode[] localVariableNodeArray = null;
        if (this.localCapture.isCaptureLocals() || this.localCapture.isPrintLocals()) {
            localVariableNodeArray = Locals.getLocalsAt(this.classNode, target.method, injectionNode.getCurrentTarget());
        }
        this.inject(new Callback(this.methodNode, target, injectionNode, localVariableNodeArray, this.localCapture.isCaptureLocals()));
    }

    private void inject(Callback callback) {
        MethodNode methodNode;
        block18: {
            block17: {
                if (this.localCapture.isPrintLocals()) {
                    this.printLocals(callback);
                    this.info.addCallbackInvocation(this.methodNode);
                    return;
                }
                methodNode = this.methodNode;
                if (!callback.checkDescriptor(this.methodNode.desc)) {
                    if (this.info.getTargets().size() > (0x9335B2EC ^ 0x9335B2ED)) {
                        return;
                    }
                    if (callback.canCaptureLocals) {
                        MethodNode methodNode2 = Bytecode.findMethod(this.classNode, this.methodNode.name, callback.getDescriptor());
                        if (methodNode2 != null && Annotations.getVisible(methodNode2, Surrogate.class) != null) {
                            methodNode = methodNode2;
                        } else {
                            String string = this.generateBadLVTMessage(callback);
                            switch (1.$SwitchMap$org$spongepowered$asm$mixin$injection$callback$LocalCapture[this.localCapture.ordinal()]) {
                                case 1: {
                                    Object[] objectArray = new Object[0x39EAA35D ^ 0x39EAA35C];
                                    objectArray[0xF846A0E6 ^ 0xF846A0E6] = string;
                                    Injector.logger.error(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4bf\ua074\ua906\u7d62\u8e43\u2475\u8b39\u3437w\ua7f4\ua4a7\ua07e\ua917\u7d2c\u8e0a\u2461\u8b2a"), objectArray);
                                    methodNode = this.generateErrorMethod(callback, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("}\ua7f4\ua4b2\ua03e\ua916\u7d66\u8e45\u2474\u8b30\u3472b\ua7e9\ua4a2\ua074\ua917\u7d73\u8e4e\u2435\u8b36\u3464\u007f\ua7a9\ua4b8\ua078\ua91d\u7d7f\u8e44\u2435\u8b3e\u3479x\ua7e3\ua4b6\ua065\ua90c\u7d79\u8e44\u2435\u8b23\u347f`\ua7e9\ua4a2\ua070\ua907\u7d7a\u8e4f\u2469\u8b78\u345e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b12\u3465`\ua7e9\ua4a7"), string);
                                    break;
                                }
                                case 2: {
                                    Object[] objectArray = new Object[0xF08DACCE ^ 0xF08DACCF];
                                    objectArray[0x1A883A54 ^ 0x1A883A54] = string;
                                    Injector.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4bf\ua074\ua906\u7d62\u8e43\u2475\u8b39\u3437e\ua7e7\ua4a7\ua07f\ua90c\u7d78\u8e4d\u2420\u8b77\u346co"), objectArray);
                                    return;
                                }
                                default: {
                                    Object[] objectArray = new Object[0x30706960 ^ 0x30706961];
                                    objectArray[0xA6B44769 ^ 0xA6B44769] = string;
                                    Injector.logger.error(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7f4\ua4bc\ua065\ua90c\u7d75\u8e4b\u2476\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3471s\ua7ef\ua4b9\ua064\ua917\u7d73\u8e10\u243a\u8b2c\u346a"), objectArray);
                                    throw new InjectionError(string);
                                }
                            }
                        }
                    } else {
                        String string = this.methodNode.desc.replace(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^\ua7e9\ua4a7\ua076\ua94a\u7d65\u8e5a\u2475\u8b39\u3470w\ua7f6\ua4ba\ua066\ua900\u7d64\u8e4f\u247e\u8b78\u3476a\ua7eb\ua4fa\ua07c\ua90c\u7d6e\u8e43\u2474\u8b78\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b78\u3474s\ua7ea\ua4b9\ua073\ua904\u7d75\u8e41\u2435\u8b14\u3476~\ua7ea\ua4b7\ua070\ua906\u7d7d\u8e63\u2474\u8b31\u3478)"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^\ua7e9\ua4a7\ua076\ua94a\u7d65\u8e5a\u2475\u8b39\u3470w\ua7f6\ua4ba\ua066\ua900\u7d64\u8e4f\u247e\u8b78\u3476a\ua7eb\ua4fa\ua07c\ua90c\u7d6e\u8e43\u2474\u8b78\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b78\u3474s\ua7ea\ua4b9\ua073\ua904\u7d75\u8e41\u2435\u8b14\u3476~\ua7ea\ua4b7\ua070\ua906\u7d7d\u8e63\u2474\u8b31\u3478@\ua7e3\ua4a1\ua064\ua917\u7d78\u8e4b\u2478\u8b3b\u3472)"));
                        if (callback.checkDescriptor(string)) {
                            throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b77\u3478|\ua7a6") + this.info + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("3\ua7a6\ua496\ua070\ua909\u7d7a\u8e48\u247b\u8b34\u347c[\ua7e8\ua4b3\ua07e\ua937\u7d73\u8e5e\u246f\u8b25\u3479s\ua7e4\ua4b9\ua074\ua945\u7d7f\u8e59\u243a\u8b25\u3472c\ua7f3\ua4bc\ua063\ua900\u7d72\u8e0b"));
                        }
                        MethodNode methodNode3 = Bytecode.findMethod(this.classNode, this.methodNode.name, callback.getDescriptor());
                        if (methodNode3 != null && Annotations.getVisible(methodNode3, Surrogate.class) != null) {
                            methodNode = methodNode3;
                        } else {
                            throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b77\u3478|\ua7a6") + this.info + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("3\ua7a6\ua490\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732") + callback.getDescriptor() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e4\ua4a0\ua065\ua945\u7d70\u8e45\u246f\u8b39\u34732") + this.methodNode.desc);
                        }
                    }
                }
                this.dupReturnValue(callback);
                if (this.cancellable) break block17;
                if (this.totalInjections <= (0x642F38A6 ^ 0x642F38A7)) break block18;
            }
            this.createCallbackInfo(callback, (0xEDEB1716 ^ 0xEDEB1717) != 0);
        }
        this.invokeCallback(callback, methodNode);
        this.injectCancellationCode(callback);
        callback.inject();
        this.info.notifyInjected(callback.target);
    }

    private String generateBadLVTMessage(Callback callback) {
        int n = callback.target.indexOf(callback.node);
        List<String> list = CallbackInjector.summariseLocals(this.methodNode.desc, callback.target.arguments.length + (0xFA8C6F1E ^ 0xFA8C6F1F));
        List<String> list2 = CallbackInjector.summariseLocals(callback.getDescriptorWithAllLocals(), callback.frameSize);
        Object[] objectArray = new Object[0xF5285B64 ^ 0xF5285B61];
        objectArray[0xBFC540AC ^ 0xBFC540AC] = callback.target;
        objectArray[0x1B39797B ^ 0x1B39797A] = n;
        objectArray[0x1F758D8C ^ 0x1F758D8E] = this;
        objectArray[0xFAFCC100 ^ 0xFAFCC103] = list;
        objectArray[0x8BF2BAA5 ^ 0x8BF2BAA1] = list2;
        return String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^\ua7d0\ua481\ua031\ua90c\u7d78\u8e0a\u243f\u8b24\u3437z\ua7e7\ua4a6\ua031\ua90c\u7d78\u8e49\u2475\u8b3a\u3467s\ua7f2\ua4bc\ua073\ua909\u7d73\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua062\ua945\u7d77\u8e5e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d33\u8e4e\u243a\u8b3e\u34792\ua7e5\ua4b4\ua07d\ua909\u7d74\u8e4b\u2479\u8b3c\u34377\ua7f5\ua4fb\ua01b\ua920\u7d6e\u8e5a\u247f\u8b34\u3463w\ua7e2\ua4ef\ua031\ua940\u7d65\u8e20\u243a\u8b77\u3437T\ua7e9\ua4a0\ua07f\ua901\u7d2c\u8e0a\u243f\u8b24"), objectArray);
    }

    private MethodNode generateErrorMethod(Callback callback, String string, String string2) {
        MethodNode methodNode = this.info.addMethod(this.methodNode.access, this.methodNode.name + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("6\ua7eb\ua4bc\ua062\ua916\u7d7f\u8e44\u247d"), callback.getDescriptor());
        methodNode.maxLocals = Bytecode.getFirstNonArgLocalIndex(Type.getArgumentTypes(callback.getDescriptor()), (!this.isStatic ? 0xF5A9EE07 ^ 0xF5A9EE06 : 0x89AE880 ^ 0x89AE880) != 0);
        methodNode.maxStack = 0xF0434CC6 ^ 0xF0434CC5;
        InsnList insnList = methodNode.instructions;
        insnList.add(new TypeInsnNode(0xC8F333E2 ^ 0xC8F33359, string));
        insnList.add(new InsnNode(0x455FE254 ^ 0x455FE20D));
        insnList.add(new LdcInsnNode(string2));
        insnList.add(new MethodInsnNode(0x75279DD0 ^ 0x75279D67, string, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7ca\ua4bf\ua070\ua913\u7d77\u8e05\u2476\u8b36\u3479u\ua7a9\ua486\ua065\ua917\u7d7f\u8e44\u247d\u8b6c\u343eD"), (0x4D388131 ^ 0x4D388131) != 0));
        insnList.add(new InsnNode(0xE0905C93 ^ 0xE0905C2C));
        return methodNode;
    }

    /*
     * Unable to fully structure code
     */
    private void printLocals(Callback var1_1) {
        block4: {
            var2_2 = Type.getArgumentTypes(var1_1.getDescriptorWithAllLocals());
            var3_3 = new SignaturePrinter(var1_1.target.method, var1_1.argNames);
            var4_4 = new SignaturePrinter(this.methodNode.name, var1_1.target.returnType, var2_2, var1_1.argNames);
            var4_4.setModifiers(this.methodNode);
            var5_5 = new PrettyPrinter();
            var5_5.kv(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2459\u8b3b\u3476a\ua7f5"), this.classNode.name.replace((char)(-100169154 ^ -100169199), (char)(-1959096474 ^ -1959096504)));
            var5_5.kv(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2457\u8b32\u3463z\ua7e9\ua4b1"), var3_3);
            var5_5.kv(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2457\u8b36\u346f2\ua7ca\ua49a\ua052\ua924\u7d5a\u8e79"), var1_1.target.getMaxLocals());
            var5_5.kv(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46\u243a\u8b11\u3465s\ua7eb\ua4b0\ua031\ua936\u7d7f\u8e50\u247f"), var1_1.frameSize);
            var5_5.kv(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e7\ua4b9\ua07d\ua907\u7d77\u8e49\u2471\u8b77\u3459s\ua7eb\ua4b0"), this.methodNode.name);
            v0 = new Object[181551042 ^ 181551040];
            v0[1419982654 ^ 1419982654] = var1_1.node.getClass().getSimpleName();
            v0[-1671372746 ^ -1671372745] = Bytecode.getOpcodeName(var1_1.node.getCurrentTarget().getOpcode());
            var5_5.kv(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a6\ua065\ua917\u7d63\u8e49\u246e\u8b3e\u3478|"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f5\ua034\ua916"), v0);
            var5_5.hr();
            if (var1_1.locals.length <= var1_1.frameSize) break block4;
            v1 = new Object[-975771726 ^ -975771727];
            v1[-914804331 ^ -914804331] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^\ua7c9\ua496\ua050\ua929");
            v1[173711176 ^ 173711177] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("F\ua7df\ua485\ua054");
            v1[-1802524504 ^ -1802524502] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\\\ua7c7\ua498\ua054");
            var5_5.add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6\ua4f0\ua062\ua945\u7d36\u8e0f\u2428\u8b67\u34642\ua7a6\ua4f0\ua062"), v1);
            for (var6_6 = -205407622 ^ -205407622; var6_6 < var1_1.locals.length; ++var6_6) {
                v2 = var7_7 = var6_6 == var1_1.frameSize ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(",") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2");
                if (var1_1.locals[var6_6] != null) {
                    v3 = new Object[1155583087 ^ 1155583082];
                    v3[-1396410752 ^ -1396410752] = var7_7;
                    v3[-321806472 ^ -321806471] = var6_6;
                    v3[2055429889 ^ 2055429891] = SignaturePrinter.getTypeName(var1_1.localTypes[var6_6], (boolean)(704392878 ^ 704392878));
                    v3[-871934184 ^ -871934181] = CallbackInjector.meltSnowman(var6_6, var1_1.locals[var6_6].name);
                    v3[-975061726 ^ -975061722] = var6_6 >= var1_1.frameSize ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7e5\ua4b4\ua061\ua911\u7d63\u8e58\u247f\u8b69") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("");
                    var5_5.add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f5\ua04a\ua940\u7d25\u8e4e\u2447\u8b77\u34377\ua7b4\ua4e5\ua062\ua945\u7d36\u8e0f\u2437\u8b62\u3427a\ua7a6\ua4f0\ua062"), v3);
                    continue;
                }
                if (var6_6 <= 0) ** GOTO lbl-1000
                if (var1_1.localTypes[var6_6 - (-1480171101 ^ -1480171102)] == null) ** GOTO lbl-1000
                if (var1_1.localTypes[var6_6 - (1452934421 ^ 1452934420)].getSize() > (1388828427 ^ 1388828426)) {
                    v4 = -854901413 ^ -854901414;
                } else lbl-1000:
                // 3 sources

                {
                    v4 = -927367075 ^ -927367075;
                }
                var8_8 = v4;
                v5 = new Object[-1480716569 ^ -1480716572];
                v5[762710319 ^ 762710319] = var7_7;
                v5[-994501360 ^ -994501359] = var6_6;
                v5[-789829607 ^ -789829605] = var8_8 != 0 ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7f2\ua4ba\ua061\ua95b") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("?");
                var5_5.add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f5\ua04a\ua940\u7d25\u8e4e\u2447\u8b77\u34377\ua7b4\ua4e5\ua062"), v5);
            }
            var5_5.hr();
        }
        var5_5.add().add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("=\ua7ac\ua4ff")).add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ac\ua4f5\ua054\ua91d\u7d66\u8e4f\u2479\u8b23\u3472v\ua7a6\ua4b6\ua070\ua909\u7d7a\u8e48\u247b\u8b34\u347c2\ua7f5\ua4bc\ua076\ua90b\u7d77\u8e5e\u246f\u8b25\u3472")).add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ac\ua4f5\ua03e"));
        v6 = new Object[67680705 ^ 67680704];
        v6[-636962927 ^ -636962927] = var4_4;
        var5_5.add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f5\ua06a"), v6);
        var5_5.add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6\ua4f5\ua031\ua94a\u7d39\u8e0a\u2457\u8b32\u3463z\ua7e9\ua4b1\ua031\ua907\u7d79\u8e4e\u2463")).add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("o")).add().print(System.err);
    }

    private void createCallbackInfo(Callback callback, boolean bl) {
        if (callback.target != this.lastTarget) {
            this.lastId = null;
            this.lastDesc = null;
        }
        this.lastTarget = callback.target;
        String string = this.getIdentifier(callback);
        String string2 = callback.getCallbackInfoConstructorDescriptor();
        if (string.equals(this.lastId) && string2.equals(this.lastDesc) && !callback.isAtReturn && !this.cancellable) {
            return;
        }
        this.instanceCallbackInfo(callback, string, string2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadOrCreateCallbackInfo(Callback callback) {
        if (!this.cancellable) {
            if (this.totalInjections <= (0x94ACF041 ^ 0x94ACF040)) {
                this.createCallbackInfo(callback, (0x88B827F2 ^ 0x88B827F2) != 0);
                return;
            }
        }
        callback.add(new VarInsnNode(0x1FE3F6BD ^ 0x1FE3F6A4, this.callbackInfoVar), (0xF63ECFB2 ^ 0xF63ECFB2) != 0, (0x8DC34FA4 ^ 0x8DC34FA5) != 0);
    }

    private void dupReturnValue(Callback callback) {
        if (!callback.isAtReturn) {
            return;
        }
        callback.add(new InsnNode(0xD6BBBA3A ^ 0xD6BBBA63));
        callback.add(new VarInsnNode(callback.target.returnType.getOpcode(0x237D86D6 ^ 0x237D86E0), callback.marshalVar()));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void instanceCallbackInfo(Callback var1_1, String var2_2, String var3_3, boolean var4_4) {
        this.lastId = var2_2;
        this.lastDesc = var3_3;
        this.callbackInfoVar = var1_1.marshalVar();
        this.callbackInfoClass = var1_1.target.getCallbackInfoClass();
        if (!var4_4) ** GOTO lbl-1000
        if (this.totalInjections > (1082730071 ^ 1082730070) && !var1_1.isAtReturn && !this.cancellable) {
            v0 = 55164989 ^ 55164988;
        } else lbl-1000:
        // 2 sources

        {
            v0 = -477476103 ^ -477476103;
        }
        var5_5 = v0;
        var1_1.add(new TypeInsnNode(485396032 ^ 485396219, this.callbackInfoClass), (boolean)(196405421 ^ 196405420), (boolean)(!var4_4 ? -1791388806 ^ -1791388805 : -1223940928 ^ -1223940928), var5_5);
        var1_1.add(new InsnNode(1499403221 ^ 1499403148), (boolean)(-2076679188 ^ -2076679187), (boolean)(816542825 ^ 816542824), var5_5);
        var1_1.add(new LdcInsnNode(var2_2), (boolean)(765072219 ^ 765072218), (boolean)(!var4_4 ? 838633244 ^ 838633245 : 2013223722 ^ 2013223722), var5_5);
        var1_1.add(new InsnNode(this.cancellable ? -2090544063 ^ -2090544059 : -464068975 ^ -464068974), (boolean)(-522976087 ^ -522976088), (boolean)(!var4_4 ? 1371295471 ^ 1371295470 : 1003869001 ^ 1003869001), var5_5);
        if (var1_1.isAtReturn) {
            var1_1.add(new VarInsnNode(var1_1.target.returnType.getOpcode(1149444858 ^ 1149444847), var1_1.marshalVar()), (boolean)(-855251454 ^ -855251453), (boolean)(!var4_4 ? -1504374945 ^ -1504374946 : 420551384 ^ 420551384));
            var1_1.add(new MethodInsnNode(-1642172000 ^ -1642172137, this.callbackInfoClass, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28"), var3_3, (boolean)(-787238390 ^ -787238390)));
        } else {
            var1_1.add(new MethodInsnNode(-279344140 ^ -279344317, this.callbackInfoClass, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28"), var3_3, (boolean)(-1376825212 ^ -1376825212)), (boolean)(-1872667647 ^ -1872667647), (boolean)(1504849856 ^ 1504849856), var5_5);
        }
        if (var4_4) {
            var1_1.target.addLocalVariable(this.callbackInfoVar, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7e7\ua4b9\ua07d\ua907\u7d77\u8e49\u2471\u8b1e\u3479t\ua7e9") + this.callbackInfoVar, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^") + this.callbackInfoClass + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(")"));
            var1_1.add(new VarInsnNode(1086251623 ^ 1086251613, this.callbackInfoVar), (boolean)(-871645724 ^ -871645724), (boolean)(-1911704919 ^ -1911704919), var5_5);
        }
    }

    private void invokeCallback(Callback callback, MethodNode methodNode) {
        if (!this.isStatic) {
            callback.add(new VarInsnNode(0xF927AD5B ^ 0xF927AD42, 0xAD0BC57B ^ 0xAD0BC57B), (0x61066F64 ^ 0x61066F64) != 0, (0xF5470806 ^ 0xF5470807) != 0);
        }
        if (callback.captureArgs()) {
            Bytecode.loadArgs(callback.target.arguments, callback, this.isStatic ? 0x86292E3A ^ 0x86292E3A : 0x92E3B164 ^ 0x92E3B165, 0x323CDCE0 ^ 0xCDC3231F);
        }
        this.loadOrCreateCallbackInfo(callback);
        if (callback.canCaptureLocals) {
            Locals.loadLocals(callback.localTypes, callback, callback.frameSize, callback.extraArgs);
        }
        this.invokeHandler(callback, methodNode);
    }

    private String getIdentifier(Callback callback) {
        String string = Strings.isNullOrEmpty((String)this.identifier) ? callback.target.method.name : this.identifier;
        String string2 = this.ids.get(callback.node.getId());
        return string + (Strings.isNullOrEmpty((String)string2) ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("(") + string2);
    }

    protected void injectCancellationCode(Callback callback) {
        if (!this.cancellable) {
            return;
        }
        callback.add(new VarInsnNode(0x8748E974 ^ 0x8748E96D, this.callbackInfoVar));
        callback.add(new MethodInsnNode(0xE68389B2 ^ 0xE6838904, this.callbackInfoClass, CallbackInfo.getIsCancelledMethodName(), CallbackInfo.getIsCancelledMethodSig(), (0x71191785 ^ 0x71191785) != 0));
        LabelNode labelNode = new LabelNode();
        callback.add(new JumpInsnNode(0x7E84B209 ^ 0x7E84B290, labelNode));
        this.injectReturnCode(callback);
        callback.add(labelNode);
    }

    protected void injectReturnCode(Callback callback) {
        if (callback.target.returnType.equals(Type.VOID_TYPE)) {
            callback.add(new InsnNode(0xBD81CD8E ^ 0xBD81CD3F));
        } else {
            callback.add(new VarInsnNode(0x423EC996 ^ 0x423EC98F, callback.marshalVar()));
            String string = CallbackInfoReturnable.getReturnAccessor(callback.target.returnType);
            String string2 = CallbackInfoReturnable.getReturnDescriptor(callback.target.returnType);
            callback.add(new MethodInsnNode(0x9E7B647B ^ 0x9E7B64CD, this.callbackInfoClass, string, string2, (0xF6EBEB35 ^ 0xF6EBEB35) != 0));
            if (callback.target.returnType.getSort() == (0x5D4415CF ^ 0x5D4415C5)) {
                callback.add(new TypeInsnNode(0x238363EF ^ 0x2383632F, callback.target.returnType.getInternalName()));
            }
            callback.add(new InsnNode(callback.target.returnType.getOpcode(0xEBD33F95 ^ 0xEBD33F39)));
        }
    }

    protected boolean isStatic() {
        return this.isStatic;
    }

    private static List<String> summariseLocals(String string, int n) {
        return CallbackInjector.summariseLocals(Type.getArgumentTypes(string), n);
    }

    private static List<String> summariseLocals(Type[] typeArray, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (typeArray != null) {
            while (n < typeArray.length) {
                if (typeArray[n] != null) {
                    arrayList.add(typeArray[n].toString());
                }
                ++n;
            }
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String meltSnowman(int n, String string) {
        String string2;
        if (string != null) {
            if ((0xF2B3CEF1 ^ 0xF2B3E8F2) == string.charAt(0x150B41E ^ 0x150B41E)) {
                string2 = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("d\ua7e7\ua4a7") + n;
                return string2;
            }
        }
        string2 = string;
        return string2;
    }

    private class Callback
    extends InsnList {
        private final MethodNode handler;
        private final AbstractInsnNode head;
        final Target target;
        final InjectionNodes.InjectionNode node;
        final LocalVariableNode[] locals;
        final Type[] localTypes;
        final int frameSize;
        final int extraArgs;
        final boolean canCaptureLocals;
        final boolean isAtReturn;
        final String desc;
        final String descl;
        final String[] argNames;
        int ctor;
        int invoke;
        private int marshalVar = 0xF1A8833F ^ 0xE577CC0;
        private boolean captureArgs = 0xC2DB52BF ^ 0xC2DB52BE;

        Callback(MethodNode methodNode, Target target, InjectionNodes.InjectionNode injectionNode, LocalVariableNode[] localVariableNodeArray, boolean bl) {
            this.handler = methodNode;
            this.target = target;
            this.head = target.insns.getFirst();
            this.node = injectionNode;
            this.locals = localVariableNodeArray;
            this.localTypes = localVariableNodeArray != null ? new Type[localVariableNodeArray.length] : null;
            this.frameSize = Bytecode.getFirstNonArgLocalIndex(target.arguments, (!CallbackInjector.this.isStatic() ? 0x75C8870A ^ 0x75C8870B : 0xE5DB51F0 ^ 0xE5DB51F0) != 0);
            ArrayList<String> arrayList = null;
            if (localVariableNodeArray != null) {
                int n = CallbackInjector.this.isStatic() ? 0x3F22636 ^ 0x3F22636 : 0x3B53F955 ^ 0x3B53F954;
                arrayList = new ArrayList<String>();
                for (int i = 0x54D61793 ^ 0x54D61793; i <= localVariableNodeArray.length; ++i) {
                    if (i == this.frameSize) {
                        arrayList.add(target.returnType == Type.VOID_TYPE ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7ef") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7ef\ua4a7"));
                    }
                    if (i >= localVariableNodeArray.length || localVariableNodeArray[i] == null) continue;
                    this.localTypes[i] = Type.getType(localVariableNodeArray[i].desc);
                    if (i < n) continue;
                    arrayList.add(CallbackInjector.meltSnowman(i, localVariableNodeArray[i].name));
                }
            }
            this.extraArgs = Math.max(0x8797AC62 ^ 0x8797AC62, Bytecode.getFirstNonArgLocalIndex(this.handler) - (this.frameSize + (0x39B69D40 ^ 0x39B69D41)));
            String[] stringArray = this.argNames = arrayList != null ? arrayList.toArray(new String[arrayList.size()]) : null;
            int n = bl && localVariableNodeArray != null && localVariableNodeArray.length > this.frameSize ? 0xB5EEC606 ^ 0xB5EEC607 : (int)((this.canCaptureLocals = 0x7C824204 ^ 0x7C824204) ? 1 : 0);
            this.isAtReturn = this.node.getCurrentTarget() instanceof InsnNode && this.isValueReturnOpcode(this.node.getCurrentTarget().getOpcode()) ? 0x7901420F ^ 0x7901420E : 0x3B0269DE ^ 0x3B0269DE;
            this.desc = target.getCallbackDescriptor(this.localTypes, target.arguments);
            this.descl = target.getCallbackDescriptor((0x65B0489D ^ 0x65B0489C) != 0, this.localTypes, target.arguments, this.frameSize, this.extraArgs);
            this.invoke = target.arguments.length + (this.canCaptureLocals ? this.localTypes.length - this.frameSize : 0x319BE071 ^ 0x319BE071);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean isValueReturnOpcode(int n) {
            int n2;
            if (n >= (0xCE6886CD ^ 0xCE688661)) {
                if (n < (0x86E68E32 ^ 0x86E68E83)) {
                    n2 = 0x7F1B17F3 ^ 0x7F1B17F2;
                    return n2 != 0;
                }
            }
            n2 = 0xCE7EEE27 ^ 0xCE7EEE27;
            return n2 != 0;
        }

        String getDescriptor() {
            return this.canCaptureLocals ? this.descl : this.desc;
        }

        String getDescriptorWithAllLocals() {
            return this.target.getCallbackDescriptor((0x11BF2739 ^ 0x11BF2738) != 0, this.localTypes, this.target.arguments, this.frameSize, 0xA24ADEEC ^ 0xA24AA113);
        }

        String getCallbackInfoConstructorDescriptor() {
            return this.isAtReturn ? CallbackInfo.getConstructorDescriptor(this.target.returnType) : CallbackInfo.getConstructorDescriptor();
        }

        void add(AbstractInsnNode abstractInsnNode, boolean bl, boolean bl2) {
            this.add(abstractInsnNode, bl, bl2, (0xA8E8CC07 ^ 0xA8E8CC07) != 0);
        }

        void add(AbstractInsnNode abstractInsnNode, boolean bl, boolean bl2, boolean bl3) {
            if (bl3) {
                this.target.insns.insertBefore(this.head, abstractInsnNode);
            } else {
                this.add(abstractInsnNode);
            }
            this.ctor += bl ? 0xFA19BD4B ^ 0xFA19BD4A : 0x6D2E2B28 ^ 0x6D2E2B28;
            this.invoke += bl2 ? 0xB49AB200 ^ 0xB49AB201 : 0x2C3860C9 ^ 0x2C3860C9;
        }

        void inject() {
            this.target.insertBefore(this.node, (InsnList)this);
            this.target.addToStack(Math.max(this.invoke, this.ctor));
        }

        boolean checkDescriptor(String string) {
            Type[] typeArray;
            if (this.getDescriptor().equals(string)) {
                return (0xDB644F17 ^ 0xDB644F16) != 0;
            }
            if (this.target.getSimpleCallbackDescriptor().equals(string) && !this.canCaptureLocals) {
                this.captureArgs = 0x8F425786 ^ 0x8F425786;
                return (0x3DC1F9D6 ^ 0x3DC1F9D7) != 0;
            }
            Type[] typeArray2 = Type.getArgumentTypes(string);
            if (typeArray2.length != (typeArray = Type.getArgumentTypes(this.descl)).length) {
                return (0x63737909 ^ 0x63737909) != 0;
            }
            for (int i = 0x881E086C ^ 0x881E086C; i < typeArray.length; ++i) {
                Type type = typeArray2[i];
                if (type.equals(typeArray[i])) continue;
                if (type.getSort() == (0xFFFBCD5 ^ 0xFFFBCDC)) {
                    return (0x27FDB98F ^ 0x27FDB98F) != 0;
                }
                if (Annotations.getInvisibleParameter(this.handler, Coerce.class, i) == null) {
                    return (0x8E166514 ^ 0x8E166514) != 0;
                }
                if (Injector.canCoerce(typeArray2[i], typeArray[i])) continue;
                return (0xC067D28 ^ 0xC067D28) != 0;
            }
            return (0x5DB0C932 ^ 0x5DB0C933) != 0;
        }

        boolean captureArgs() {
            return this.captureArgs;
        }

        int marshalVar() {
            if (this.marshalVar < 0) {
                this.marshalVar = this.target.allocateLocal();
            }
            return this.marshalVar;
        }
    }
}

