/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.code.ReadOnlyInsnList;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class InjectorTarget {
    private final ISliceContext context;
    private final Map<String, ReadOnlyInsnList> cache = new HashMap<String, ReadOnlyInsnList>();
    private final Target target;
    private final String mergedBy;
    private final int mergedPriority;

    public InjectorTarget(ISliceContext iSliceContext, Target target) {
        this.context = iSliceContext;
        this.target = target;
        AnnotationNode annotationNode = Annotations.getVisible(target.method, MixinMerged.class);
        this.mergedBy = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        this.mergedPriority = Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463"), 0xF2555FF1 ^ 0xF2555C19);
    }

    public String toString() {
        return this.target.toString();
    }

    public Target getTarget() {
        return this.target;
    }

    public MethodNode getMethod() {
        return this.target.method;
    }

    public boolean isMerged() {
        return (this.mergedBy != null ? 0x98A6A3FF ^ 0x98A6A3FE : 0xF02F4FB ^ 0xF02F4FB) != 0;
    }

    public String getMergedBy() {
        return this.mergedBy;
    }

    public int getMergedPriority() {
        return this.mergedPriority;
    }

    public InsnList getSlice(String string) {
        ReadOnlyInsnList readOnlyInsnList = this.cache.get(string);
        if (readOnlyInsnList == null) {
            MethodSlice methodSlice = this.context.getSlice(string);
            readOnlyInsnList = methodSlice != null ? methodSlice.getSlice(this.target.method) : new ReadOnlyInsnList(this.target.method.instructions);
            this.cache.put(string, readOnlyInsnList);
        }
        return readOnlyInsnList;
    }

    public InsnList getSlice(InjectionPoint injectionPoint) {
        return this.getSlice(injectionPoint.getSlice());
    }

    public void dispose() {
        for (ReadOnlyInsnList readOnlyInsnList : this.cache.values()) {
            readOnlyInsnList.dispose();
        }
        this.cache.clear();
    }
}

