/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.modify;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.modify.ModifyVariableInjector;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.struct.Target;

@InjectionPoint.AtCode(value="LOAD")
public class BeforeLoadLocal
extends ModifyVariableInjector.ContextualInjectionPoint {
    private final Type returnType;
    private final LocalVariableDiscriminator discriminator;
    private final int opcode;
    private final int ordinal;
    private boolean opcodeAfter;

    protected BeforeLoadLocal(InjectionPointData injectionPointData) {
        this(injectionPointData, 0xA668D2C1 ^ 0xA668D2D4, (0x17B51A21 ^ 0x17B51A21) != 0);
    }

    protected BeforeLoadLocal(InjectionPointData injectionPointData, int n, boolean bl) {
        super(injectionPointData.getContext());
        this.returnType = injectionPointData.getMethodReturnType();
        this.discriminator = injectionPointData.getLocalVariableDiscriminator();
        this.opcode = injectionPointData.getOpcode(this.returnType.getOpcode(n));
        this.ordinal = injectionPointData.getOrdinal();
        this.opcodeAfter = bl;
    }

    @Override
    boolean find(Target target, Collection<AbstractInsnNode> collection) {
        SearchState searchState = new SearchState(this.ordinal, this.discriminator.printLVT());
        ListIterator<AbstractInsnNode> listIterator = target.method.instructions.iterator();
        while (listIterator.hasNext()) {
            int n;
            AbstractInsnNode abstractInsnNode = listIterator.next();
            if (searchState.isPendingCheck()) {
                n = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, abstractInsnNode);
                searchState.check(collection, abstractInsnNode, n);
                continue;
            }
            if (!(abstractInsnNode instanceof VarInsnNode) || abstractInsnNode.getOpcode() != this.opcode) continue;
            if (this.ordinal != (0x550F2F1E ^ 0xAAF0D0E1) && searchState.success()) continue;
            searchState.register((VarInsnNode)abstractInsnNode);
            if (this.opcodeAfter) {
                searchState.setPendingCheck();
                continue;
            }
            n = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, abstractInsnNode);
            searchState.check(collection, abstractInsnNode, n);
        }
        return searchState.success();
    }

    static class SearchState {
        private final boolean print;
        private final int targetOrdinal;
        private int ordinal = 0x238CF568 ^ 0x238CF568;
        private boolean pendingCheck = 0xAD8662DF ^ 0xAD8662DF;
        private boolean found = 0xD45BC508 ^ 0xD45BC508;
        private VarInsnNode varNode;

        SearchState(int n, boolean bl) {
            this.targetOrdinal = n;
            this.print = bl;
        }

        boolean success() {
            return this.found;
        }

        boolean isPendingCheck() {
            return this.pendingCheck;
        }

        void setPendingCheck() {
            this.pendingCheck = 0xB76153B4 ^ 0xB76153B5;
        }

        void register(VarInsnNode varInsnNode) {
            this.varNode = varInsnNode;
        }

        void check(Collection<AbstractInsnNode> collection, AbstractInsnNode abstractInsnNode, int n) {
            this.pendingCheck = 0xBD52AF7A ^ 0xBD52AF7A;
            if (n != this.varNode.var) {
                if (n > (0xE054FCB ^ 0xF1FAB035) || !this.print) {
                    return;
                }
            }
            if (this.targetOrdinal == (0x47DCE702 ^ 0xB82318FD) || this.targetOrdinal == this.ordinal) {
                collection.add(abstractInsnNode);
                this.found = 0xA396F953 ^ 0xA396F952;
            }
            this.ordinal += 0x3CB485A6 ^ 0x3CB485A7;
            this.varNode = null;
        }
    }
}

