/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.points;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.points.BeforeInvoke;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

@InjectionPoint.AtCode(value="FIELD")
public class BeforeFieldAccess
extends BeforeInvoke {
    private static final String ARRAY_GET = "get";
    private static final String ARRAY_SET = "set";
    private static final String ARRAY_LENGTH = "length";
    public static final int ARRAY_SEARCH_FUZZ_DEFAULT = 8;
    private final int opcode;
    private final int arrOpcode;
    private final int fuzzFactor;

    public BeforeFieldAccess(InjectionPointData injectionPointData) {
        super(injectionPointData);
        int[] nArray = new int[0x13495C36 ^ 0x13495C33];
        nArray[0x848B744B ^ 0x848B744B] = 0x488FEF70 ^ 0x488FEFC4;
        nArray[0x9456E8C ^ 0x9456E8D] = 0x470D3885 ^ 0x470D3830;
        nArray[0xEEE0EA35 ^ 0xEEE0EA37] = 0x3B4EC0BE ^ 0x3B4EC00C;
        nArray[0xCFE39EDD ^ 0xCFE39EDE] = 0x4B02A111 ^ 0x4B02A1A2;
        nArray[0x6DD24DF7 ^ 0x6DD24DF3] = 0xD49DEF3A ^ 0x2B6210C5;
        this.opcode = injectionPointData.getOpcode(0x3718A2BE ^ 0xC8E75D41, nArray);
        String string = injectionPointData.get(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("s\ua7f4\ua4a7\ua070\ua91c"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(""));
        this.arrOpcode = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("u\ua7e3\ua4a1").equalsIgnoreCase(string) ? 0x1308998C ^ 0x130899A2 : (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("a\ua7e3\ua4a1").equalsIgnoreCase(string) ? 0x1F02DD8 ^ 0x1F02D97 : (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("~\ua7e3\ua4bb\ua076\ua911\u7d7e").equalsIgnoreCase(string) ? 0xDFDC1176 ^ 0xDFDC11C8 : 0xCF81D499 ^ 0xCF81D499));
        this.fuzzFactor = Math.min(Math.max(injectionPointData.get(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("t\ua7f3\ua4af\ua06b"), 0x2A7A4DAE ^ 0x2A7A4DA6), 0x9B8E90EF ^ 0x9B8E90EE), 0x551DB97F ^ 0x551DB95F);
    }

    public int getFuzzFactor() {
        return this.fuzzFactor;
    }

    public int getArrayOpcode() {
        return this.arrOpcode;
    }

    private int getArrayOpcode(String string) {
        if (this.arrOpcode != (0xF29ED518 ^ 0xF29ED5A6)) {
            return Type.getType(string).getElementType().getOpcode(this.arrOpcode);
        }
        return this.arrOpcode;
    }

    @Override
    protected boolean matchesInsn(AbstractInsnNode abstractInsnNode) {
        block6: {
            block7: {
                if (!(abstractInsnNode instanceof FieldInsnNode)) break block6;
                if (((FieldInsnNode)abstractInsnNode).getOpcode() == this.opcode) break block7;
                if (this.opcode != (0xB22A66E0 ^ 0x4DD5991F)) break block6;
            }
            if (this.arrOpcode == 0) {
                return (0x665F8B67 ^ 0x665F8B66) != 0;
            }
            if (abstractInsnNode.getOpcode() != (0x626D7355 ^ 0x626D73E7)) {
                if (abstractInsnNode.getOpcode() != (0x475B92ED ^ 0x475B9259)) {
                    return (0x310298DA ^ 0x310298DA) != 0;
                }
            }
            return (Type.getType(((FieldInsnNode)abstractInsnNode).desc).getSort() == (0xB0217C06 ^ 0xB0217C0F) ? 0xF7117301 ^ 0xF7117300 : 0x836FF09B ^ 0x836FF09B) != 0;
        }
        return (0xAE8C70E3 ^ 0xAE8C70E3) != 0;
    }

    @Override
    protected boolean addInsn(InsnList insnList, Collection<AbstractInsnNode> collection, AbstractInsnNode abstractInsnNode) {
        if (this.arrOpcode > 0) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
            int n = this.getArrayOpcode(fieldInsnNode.desc);
            Object[] objectArray = new Object[0x75602FE2 ^ 0x75602FE1];
            objectArray[0x70EB8B3C ^ 0x70EB8B3C] = this.className;
            objectArray[0x5F6090A4 ^ 0x5F6090A5] = Bytecode.getOpcodeName(n);
            objectArray[0x6B4528E8 ^ 0x6B4528EA] = this.fuzzFactor;
            this.log(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("i\ua7fb\ua4f5\ua02f\ua945\u7d28\u8e0a\u2424\u8b77\u34292\ua7f5\ua4b0\ua070\ua917\u7d75\u8e42\u2473\u8b39\u34702\ua7e0\ua4ba\ua063\ua945\u7d77\u8e58\u2468\u8b36\u346e2\ua7e7\ua4b6\ua072\ua900\u7d65\u8e59\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d6d\u8e57\u243a\u8b31\u3462h\ua7fc\ua4e8\ua06a\ua918"), objectArray);
            if (BeforeFieldAccess.findArrayNode(insnList, fieldInsnNode, n, this.fuzzFactor) == null) {
                Object[] objectArray2 = new Object[0xBCDBEDE ^ 0xBCDBEDF];
                objectArray2[0xF607A01D ^ 0xF607A01D] = this.className;
                this.log(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("i\ua7fb\ua4f5\ua02f\ua945\u7d28\u8e0a\u2424\u8b77\u34292\ua7b8\ua4f5\ua077\ua904\u7d7f\u8e46\u247f\u8b33\u3437f\ua7e9\ua4f5\ua07d\ua90a\u7d75\u8e4b\u246e\u8b32\u3437\u007f\ua7e7\ua4a1\ua072\ua90d\u7d7f\u8e44\u247d\u8b77\u347e|\ua7f5\ua4bb"), objectArray2);
                return (0xE4F17CC1 ^ 0xE4F17CC1) != 0;
            }
        }
        Object[] objectArray = new Object[0xC64873B7 ^ 0xC64873B6];
        objectArray[0x4D970E01 ^ 0x4D970E01] = this.className;
        this.log(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("i\ua7fb\ua4f5\ua02f\ua945\u7d28\u8e0a\u2424\u8b77\u34292\ua7b8\ua4f5\ua070\ua901\u7d72\u8e43\u2474\u8b30\u3437\u007f\ua7e7\ua4a1\ua072\ua90d\u7d7f\u8e44\u247d\u8b77\u347e|\ua7f5\ua4bb"), objectArray);
        return super.addInsn(insnList, collection, abstractInsnNode);
    }

    public static AbstractInsnNode findArrayNode(InsnList insnList, FieldInsnNode fieldInsnNode, int n, int n2) {
        int n3 = 0x1341F987 ^ 0x1341F987;
        ListIterator<AbstractInsnNode> listIterator = insnList.iterator(insnList.indexOf(fieldInsnNode) + (0x3A8B2DBC ^ 0x3A8B2DBD));
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode.getOpcode() == n) {
                return abstractInsnNode;
            }
            if (abstractInsnNode.getOpcode() == (0x95F90E5C ^ 0x95F90EE2) && n3 == 0) {
                return null;
            }
            if (abstractInsnNode instanceof FieldInsnNode) {
                FieldInsnNode fieldInsnNode2 = (FieldInsnNode)abstractInsnNode;
                if (fieldInsnNode2.desc.equals(fieldInsnNode.desc) && fieldInsnNode2.name.equals(fieldInsnNode.name) && fieldInsnNode2.owner.equals(fieldInsnNode.owner)) {
                    return null;
                }
            }
            if (n3++ <= n2) continue;
            return null;
        }
        return null;
    }
}

