/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InvalidMemberDescriptorException;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionPointException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class InjectionPointData {
    private static final Pattern AT_PATTERN = InjectionPointData.createPattern();
    private final Map<String, String> args = new HashMap<String, String>();
    private final IMixinContext context;
    private final MethodNode method;
    private final AnnotationNode parent;
    private final String at;
    private final String type;
    private final InjectionPoint.Selector selector;
    private final String target;
    private final String slice;
    private final int ordinal;
    private final int opcode;
    private final String id;

    public InjectionPointData(IMixinContext iMixinContext, MethodNode methodNode, AnnotationNode annotationNode, String string, List<String> list, String string2, String string3, int n, int n2, String string4) {
        this.context = iMixinContext;
        this.method = methodNode;
        this.parent = annotationNode;
        this.at = string;
        this.target = string2;
        this.slice = Strings.nullToEmpty((String)string3);
        this.ordinal = Math.max(0x78A3ED53 ^ 0x875C12AC, n);
        this.opcode = n2;
        this.id = string4;
        this.parseArgs(list);
        this.args.put(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("f\ua7e7\ua4a7\ua076\ua900\u7d62"), string2);
        this.args.put(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("}\ua7f4\ua4b1\ua078\ua90b\u7d77\u8e46"), String.valueOf(n));
        this.args.put(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("}\ua7f6\ua4b6\ua07e\ua901\u7d73"), String.valueOf(n2));
        Matcher matcher = AT_PATTERN.matcher(string);
        this.type = InjectionPointData.parseType(matcher, string);
        this.selector = InjectionPointData.parseSelector(matcher);
    }

    private void parseArgs(List<String> list) {
        if (list == null) {
            return;
        }
        for (String string : list) {
            if (string == null) continue;
            int n = string.indexOf(0x4E1FA410 ^ 0x4E1FA42D);
            if (n > (0x60B50074 ^ 0x9F4AFF8B)) {
                this.args.put(string.substring(0xC3722C75 ^ 0xC3722C75, n), string.substring(n + (0x97EDD7F6 ^ 0x97EDD7F7)));
                continue;
            }
            this.args.put(string, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(""));
        }
    }

    public String getAt() {
        return this.at;
    }

    public String getType() {
        return this.type;
    }

    public InjectionPoint.Selector getSelector() {
        return this.selector;
    }

    public IMixinContext getContext() {
        return this.context;
    }

    public MethodNode getMethod() {
        return this.method;
    }

    public Type getMethodReturnType() {
        return Type.getReturnType(this.method.desc);
    }

    public AnnotationNode getParent() {
        return this.parent;
    }

    public String getSlice() {
        return this.slice;
    }

    public LocalVariableDiscriminator getLocalVariableDiscriminator() {
        return LocalVariableDiscriminator.parse(this.parent);
    }

    public String get(String string, String string2) {
        String string3 = this.args.get(string);
        return string3 != null ? string3 : string2;
    }

    public int get(String string, int n) {
        return InjectionPointData.parseInt(this.get(string, String.valueOf(n)), n);
    }

    public boolean get(String string, boolean bl) {
        return InjectionPointData.parseBoolean(this.get(string, String.valueOf(bl)), bl);
    }

    public MemberInfo get(String string) {
        try {
            return MemberInfo.parseAndValidate(this.get(string, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("")), this.context);
        }
        catch (InvalidMemberDescriptorException invalidMemberDescriptorException) {
            Object[] objectArray = new Object[0x4EB6F8AA ^ 0x4EB6F8AE];
            objectArray[0xA67ECA1A ^ 0xA67ECA1A] = this.at;
            objectArray[0x9AC3E86E ^ 0x9AC3E86F] = string;
            objectArray[0xA20A95E8 ^ 0xA20A95EA] = this.target;
            objectArray[0xC5981EB8 ^ 0xC5981EBB] = InjectionInfo.describeInjector(this.context, this.parent, this.method);
            throw new InvalidInjectionPointException(this.context, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246a\u8b36\u3465a\ua7ef\ua4bb\ua076\ua945\u7d56\u8e6b\u246e\u8b7f\u34357\ua7f5\ua4f7\ua038\ua94b\u7d33\u8e59\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b77\u34357\ua7f5\ua4f7\ua031\ua90a\u7d78\u8e0a\u243f\u8b24"), objectArray);
        }
    }

    public MemberInfo getTarget() {
        try {
            return MemberInfo.parseAndValidate(this.target, this.context);
        }
        catch (InvalidMemberDescriptorException invalidMemberDescriptorException) {
            Object[] objectArray = new Object[0x6F9AA450 ^ 0x6F9AA453];
            objectArray[0x3F3A04FC ^ 0x3F3A04FC] = this.at;
            objectArray[0x60484D33 ^ 0x60484D32] = this.target;
            objectArray[0x54A8CBF8 ^ 0x54A8CBFA] = InjectionInfo.describeInjector(this.context, this.parent, this.method);
            throw new InvalidInjectionPointException(this.context, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246a\u8b36\u3465a\ua7ef\ua4bb\ua076\ua945\u7d56\u8e6b\u246e\u8b7f\u34357\ua7f5\ua4f7\ua038\ua945\u7d72\u8e4f\u2469\u8b34\u3465{\ua7f6\ua4a1\ua07e\ua917\u7d36\u8e08\u243f\u8b24\u34352\ua7e9\ua4bb\ua031\ua940\u7d65"), objectArray);
        }
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public int getOpcode(int n) {
        return this.opcode > 0 ? this.opcode : n;
    }

    public int getOpcode(int n, int ... nArray) {
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i = 0xFA3F645D ^ 0xFA3F645D; i < n2; ++i) {
            int n3 = nArray2[i];
            if (this.opcode != n3) continue;
            return this.opcode;
        }
        return n;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.type;
    }

    private static Pattern createPattern() {
        Object[] objectArray = new Object[0x969B181A ^ 0x969B181B];
        objectArray[0xA650C6A9 ^ 0xA650C6A9] = Joiner.on((char)(0x53C8AF6B ^ 0x53C8AF17)).join((Object[])InjectionPoint.Selector.values());
        return Pattern.compile(String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("L\ua7ae\ua48e\ua04f\ua95f\u7d4b\u8e01\u2433\u8b6d\u3428:\ua7a3\ua4a6\ua038\ua95a\u7d32"), objectArray));
    }

    public static String parseType(String string) {
        Matcher matcher = AT_PATTERN.matcher(string);
        return InjectionPointData.parseType(matcher, string);
    }

    private static String parseType(Matcher matcher, String string) {
        return matcher.matches() ? matcher.group(0x91E546A8 ^ 0x91E546A9) : string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static InjectionPoint.Selector parseSelector(Matcher matcher) {
        InjectionPoint.Selector selector;
        if (matcher.matches()) {
            if (matcher.group(0x6D074C47 ^ 0x6D074C45) != null) {
                selector = InjectionPoint.Selector.valueOf(matcher.group(0x627EB6D9 ^ 0x627EB6DB));
                return selector;
            }
        }
        selector = InjectionPoint.Selector.DEFAULT;
        return selector;
    }

    private static int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private static boolean parseBoolean(String string, boolean bl) {
        try {
            return Boolean.parseBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }
}

