/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InjectionValidationException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class InjectorGroupInfo {
    private final String name;
    private final List<InjectionInfo> members = new ArrayList<InjectionInfo>();
    private final boolean isDefault;
    private int minCallbackCount = 0xE3491BDD ^ 0x1CB6E422;
    private int maxCallbackCount = 0x677C15FB ^ 0x1883EA04;

    public InjectorGroupInfo(String string) {
        this(string, (0x58557F07 ^ 0x58557F07) != 0);
    }

    InjectorGroupInfo(String string, boolean bl) {
        this.name = string;
        this.isDefault = bl;
    }

    public String toString() {
        Object[] objectArray = new Object[0xFB67056F ^ 0xFB67056C];
        objectArray[0xF13F5AC6 ^ 0xF13F5AC6] = this.getName();
        objectArray[0xA5A7B995 ^ 0xA5A7B994] = this.getMinRequired();
        objectArray[0x271F432B ^ 0x271F4329] = this.getMaxAllowed();
        return String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("R\ua7c1\ua4a7\ua07e\ua910\u7d66\u8e02\u2474\u8b36\u347aw\ua7bb\ua4f0\ua062\ua949\u7d36\u8e47\u2473\u8b39\u342a7\ua7e2\ua4f9\ua031\ua908\u7d77\u8e52\u2427\u8b72\u3473;"), objectArray);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getName() {
        return this.name;
    }

    public int getMinRequired() {
        return Math.max(this.minCallbackCount, 0x19D8C435 ^ 0x19D8C434);
    }

    public int getMaxAllowed() {
        return Math.min(this.maxCallbackCount, 0xB78E58BC ^ 0xC871A743);
    }

    public Collection<InjectionInfo> getMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    public void setMinRequired(int n) {
        if (n < (0xA4130C85 ^ 0xA4130C84)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2469\u8b32\u34632\ua7fc\ua4b0\ua063\ua90a\u7d36\u8e45\u2468\u8b77\u3479w\ua7e1\ua4b4\ua065\ua90c\u7d60\u8e4f\u243a\u8b21\u3476~\ua7f3\ua4b0\ua031\ua903\u7d79\u8e58\u243a\u8b3e\u3479x\ua7e3\ua4b6\ua065\ua90a\u7d64\u8e0a\u247d\u8b25\u3478g\ua7f6\ua4f5\ua07c\ua90c\u7d78\u8e0a\u2479\u8b38\u3462|\ua7f2\ua4fb\ua031\ua924\u7d62\u8e5e\u247f\u8b3a\u3467f\ua7e3\ua4b1\ua031\ua911\u7d79\u8e0a\u2469\u8b32\u34632\ua7eb\ua4bc\ua07f\ua958") + n + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e9\ua4bb\ua031") + this);
        }
        if (this.minCallbackCount > 0 && this.minCallbackCount != n) {
            Object[] objectArray = new Object[0x394DB3D8 ^ 0x394DB3DB];
            objectArray[0xA5942D0E ^ 0xA5942D0E] = n;
            objectArray[0x91D6AD11 ^ 0x91D6AD10] = this.name;
            objectArray[0xEF9A3E73 ^ 0xEF9A3E71] = this.minCallbackCount;
            LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b")).warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e9\ua4bb\ua077\ua909\u7d7f\u8e49\u246e\u8b3e\u3479u\ua7a6\ua4b8\ua078\ua90b\u7d36\u8e5c\u247b\u8b3b\u3462w\ua7a6\ua4f2\ua06a\ua918\u7d31\u8e0a\u2475\u8b39\u3437R\ua7c1\ua4a7\ua07e\ua910\u7d66\u8e02\u2461\u8b2a\u343e>\ua7a6\ua4a5\ua063\ua900\u7d60\u8e43\u2475\u8b22\u3464~\ua7ff\ua4f5\ua062\ua915\u7d73\u8e49\u2473\u8b31\u347ew\ua7e2\ua4f5\ua06a\ua918"), objectArray);
        }
        this.minCallbackCount = Math.max(this.minCallbackCount, n);
    }

    public void setMaxAllowed(int n) {
        if (n < (0x977AC38A ^ 0x977AC38B)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2469\u8b32\u34632\ua7fc\ua4b0\ua063\ua90a\u7d36\u8e45\u2468\u8b77\u3479w\ua7e1\ua4b4\ua065\ua90c\u7d60\u8e4f\u243a\u8b21\u3476~\ua7f3\ua4b0\ua031\ua903\u7d79\u8e58\u243a\u8b3e\u3479x\ua7e3\ua4b6\ua065\ua90a\u7d64\u8e0a\u247d\u8b25\u3478g\ua7f6\ua4f5\ua07c\ua904\u7d6e\u8e0a\u2479\u8b38\u3462|\ua7f2\ua4fb\ua031\ua924\u7d62\u8e5e\u247f\u8b3a\u3467f\ua7e3\ua4b1\ua031\ua911\u7d79\u8e0a\u2469\u8b32\u34632\ua7eb\ua4b4\ua069\ua958") + n + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e9\ua4bb\ua031") + this);
        }
        if (this.maxCallbackCount < (0x8BC657C1 ^ 0xF439A83E) && this.maxCallbackCount != n) {
            Object[] objectArray = new Object[0x71CF74DD ^ 0x71CF74DE];
            objectArray[0xBA89481B ^ 0xBA89481B] = n;
            objectArray[0x3ECC84CF ^ 0x3ECC84CE] = this.name;
            objectArray[0x9B74C0FA ^ 0x9B74C0F8] = this.maxCallbackCount;
            LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b")).warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e9\ua4bb\ua077\ua909\u7d7f\u8e49\u246e\u8b3e\u3479u\ua7a6\ua4b8\ua070\ua91d\u7d36\u8e5c\u247b\u8b3b\u3462w\ua7a6\ua4f2\ua06a\ua918\u7d31\u8e0a\u2475\u8b39\u3437R\ua7c1\ua4a7\ua07e\ua910\u7d66\u8e02\u2461\u8b2a\u343e>\ua7a6\ua4a5\ua063\ua900\u7d60\u8e43\u2475\u8b22\u3464~\ua7ff\ua4f5\ua062\ua915\u7d73\u8e49\u2473\u8b31\u347ew\ua7e2\ua4f5\ua06a\ua918"), objectArray);
        }
        this.maxCallbackCount = Math.min(this.maxCallbackCount, n);
    }

    public InjectorGroupInfo add(InjectionInfo injectionInfo) {
        this.members.add(injectionInfo);
        return this;
    }

    public InjectorGroupInfo validate() throws InjectionValidationException {
        if (this.members.size() == 0) {
            return this;
        }
        int n = 0x9458B42F ^ 0x9458B42F;
        for (InjectionInfo injectionInfo : this.members) {
            n += injectionInfo.getInjectedCallbackCount();
        }
        int n2 = this.getMinRequired();
        int n3 = this.getMaxAllowed();
        if (n < n2) {
            Object[] objectArray = new Object[0x93326639 ^ 0x9332663B];
            objectArray[0x21AC988D ^ 0x21AC988D] = n2;
            objectArray[0xEA7520F8 ^ 0xEA7520F9] = n;
            throw new InjectionValidationException(this, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("w\ua7fe\ua4a5\ua074\ua906\u7d62\u8e4f\u247e\u8b77\u3432v\ua7a6\ua4bc\ua07f\ua913\u7d79\u8e49\u247b\u8b23\u347e}\ua7e8\ua4fd\ua062\ua94c\u7d36\u8e48\u246f\u8b23\u3437}\ua7e8\ua4b9\ua068\ua945\u7d33\u8e4e\u243a\u8b24\u3462q\ua7e5\ua4b0\ua074\ua901\u7d73\u8e4e"), objectArray));
        }
        if (n > n3) {
            Object[] objectArray = new Object[0x785A00DA ^ 0x785A00D8];
            objectArray[0xDA42BFCC ^ 0xDA42BFCC] = n3;
            objectArray[0xDF9E6D6 ^ 0xDF9E6D7] = n;
            throw new InjectionValidationException(this, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7e7\ua4ad\ua078\ua908\u7d63\u8e47\u243a\u8b38\u34712\ua7a3\ua4b1\ua031\ua90c\u7d78\u8e5c\u2475\u8b34\u3476f\ua7ef\ua4ba\ua07f\ua94d\u7d65\u8e03\u243a\u8b36\u347b~\ua7e9\ua4a2\ua074\ua901\u7d36\u8e48\u246f\u8b23\u34377\ua7e2\ua4f5\ua062\ua910\u7d75\u8e49\u247f\u8b32\u3473w\ua7e2"), objectArray));
        }
        return this;
    }

    public static final class Map
    extends HashMap<String, InjectorGroupInfo> {
        private static final long serialVersionUID = 1L;
        private static final InjectorGroupInfo NO_GROUP = new InjectorGroupInfo(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\\\ua7c9\ua49b\ua054"), (0xB1B1F42E ^ 0xB1B1F42F) != 0);

        @Override
        public InjectorGroupInfo get(Object object) {
            return this.forName(object.toString());
        }

        public InjectorGroupInfo forName(String string) {
            InjectorGroupInfo injectorGroupInfo = (InjectorGroupInfo)super.get(string);
            if (injectorGroupInfo == null) {
                injectorGroupInfo = new InjectorGroupInfo(string);
                this.put(string, injectorGroupInfo);
            }
            return injectorGroupInfo;
        }

        public InjectorGroupInfo parseGroup(MethodNode methodNode, String string) {
            return this.parseGroup(Annotations.getInvisible(methodNode, Group.class), string);
        }

        public InjectorGroupInfo parseGroup(AnnotationNode annotationNode, String string) {
            Integer n;
            if (annotationNode == null) {
                return NO_GROUP;
            }
            String string2 = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("|\ua7e7\ua4b8\ua074"));
            if (string2 == null || string2.isEmpty()) {
                string2 = string;
            }
            InjectorGroupInfo injectorGroupInfo = this.forName(string2);
            Integer n2 = (Integer)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4bb"));
            if (n2 != null) {
                if (n2 != (0x6B85074 ^ 0xF947AF8B)) {
                    injectorGroupInfo.setMinRequired(n2);
                }
            }
            if ((n = (Integer)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7e7\ua4ad"))) != null) {
                if (n != (0xB0FF6EA5 ^ 0x4F00915A)) {
                    injectorGroupInfo.setMaxAllowed(n);
                }
            }
            return injectorGroupInfo;
        }

        public void validateAll() throws InjectionValidationException {
            for (InjectorGroupInfo injectorGroupInfo : this.values()) {
                injectorGroupInfo.validate();
            }
        }
    }
}

