/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class Target
implements Comparable<Target>,
Iterable<AbstractInsnNode> {
    public final ClassNode classNode;
    public final MethodNode method;
    public final InsnList insns;
    public final boolean isStatic;
    public final boolean isCtor;
    public final Type[] arguments;
    public final Type returnType;
    private final int maxStack;
    private final int maxLocals;
    private final InjectionNodes injectionNodes = new InjectionNodes();
    private String callbackInfoClass;
    private String callbackDescriptor;
    private int[] argIndices;
    private List<Integer> argMapVars;
    private LabelNode start;
    private LabelNode end;

    public Target(ClassNode classNode, MethodNode methodNode) {
        this.classNode = classNode;
        this.method = methodNode;
        this.insns = methodNode.instructions;
        this.isStatic = Bytecode.methodIsStatic(methodNode);
        this.isCtor = methodNode.name.equals(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28"));
        this.arguments = Type.getArgumentTypes(methodNode.desc);
        this.returnType = Type.getReturnType(methodNode.desc);
        this.maxStack = methodNode.maxStack;
        this.maxLocals = methodNode.maxLocals;
    }

    public InjectionNodes.InjectionNode addInjectionNode(AbstractInsnNode abstractInsnNode) {
        return this.injectionNodes.add(abstractInsnNode);
    }

    public InjectionNodes.InjectionNode getInjectionNode(AbstractInsnNode abstractInsnNode) {
        return this.injectionNodes.get(abstractInsnNode);
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getCurrentMaxLocals() {
        return this.method.maxLocals;
    }

    public int getCurrentMaxStack() {
        return this.method.maxStack;
    }

    public int allocateLocal() {
        return this.allocateLocals(0x5D6F1B21 ^ 0x5D6F1B20);
    }

    public int allocateLocals(int n) {
        int n2 = this.method.maxLocals;
        this.method.maxLocals += n;
        return n2;
    }

    public void addToLocals(int n) {
        this.setMaxLocals(this.maxLocals + n);
    }

    public void setMaxLocals(int n) {
        if (n > this.method.maxLocals) {
            this.method.maxLocals = n;
        }
    }

    public void addToStack(int n) {
        this.setMaxStack(this.maxStack + n);
    }

    public void setMaxStack(int n) {
        if (n > this.method.maxStack) {
            this.method.maxStack = n;
        }
    }

    public int[] generateArgMap(Type[] typeArray, int n) {
        if (this.argMapVars == null) {
            this.argMapVars = new ArrayList<Integer>();
        }
        int[] nArray = new int[typeArray.length];
        int n2 = 0xA6D53E2 ^ 0xA6D53E2;
        for (int i = n; i < typeArray.length; ++i) {
            int n3 = typeArray[i].getSize();
            nArray[i] = this.allocateArgMapLocal(n2, n3);
            n2 += n3;
        }
        return nArray;
    }

    private int allocateArgMapLocal(int n, int n2) {
        if (n >= this.argMapVars.size()) {
            int n3 = this.allocateLocals(n2);
            for (int i = 0x54020B45 ^ 0x54020B45; i < n2; ++i) {
                this.argMapVars.add(n3 + i);
            }
            return n3;
        }
        int n4 = this.argMapVars.get(n);
        if (n2 > (0x211D09C0 ^ 0x211D09C1) && n + n2 > this.argMapVars.size()) {
            int n5 = this.allocateLocals(0xA4802C0B ^ 0xA4802C0A);
            if (n5 == n4 + (0x18FAC7DF ^ 0x18FAC7DE)) {
                this.argMapVars.add(n5);
                return n4;
            }
            this.argMapVars.set(n, n5);
            this.argMapVars.add(this.allocateLocals(0x11D070B ^ 0x11D070A));
            return n5;
        }
        return n4;
    }

    public int[] getArgIndices() {
        if (this.argIndices == null) {
            this.argIndices = this.calcArgIndices(this.isStatic ? 0xDB9CE9E2 ^ 0xDB9CE9E2 : 0x6A28BB92 ^ 0x6A28BB93);
        }
        return this.argIndices;
    }

    private int[] calcArgIndices(int n) {
        int[] nArray = new int[this.arguments.length];
        for (int i = 0x2BFAA32 ^ 0x2BFAA32; i < this.arguments.length; ++i) {
            nArray[i] = n;
            n += this.arguments[i].getSize();
        }
        return nArray;
    }

    public String getCallbackInfoClass() {
        if (this.callbackInfoClass == null) {
            this.callbackInfoClass = CallbackInfo.getCallInfoClassName(this.returnType);
        }
        return this.callbackInfoClass;
    }

    public String getSimpleCallbackDescriptor() {
        Object[] objectArray = new Object[0xAB35D9B5 ^ 0xAB35D9B4];
        objectArray[0xAA75D55F ^ 0xAA75D55F] = this.getCallbackInfoClass();
        return String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7ca\ua4f0\ua062\ua95e\u7d3f\u8e7c"), objectArray);
    }

    public String getCallbackDescriptor(Type[] typeArray, Type[] typeArray2) {
        return this.getCallbackDescriptor((0x53B9F775 ^ 0x53B9F775) != 0, typeArray, typeArray2, 0x6D138AB5 ^ 0x6D138AB5, 0xC8B4A91F ^ 0xC8B4D6E0);
    }

    public String getCallbackDescriptor(boolean bl, Type[] typeArray, Type[] typeArray2, int n, int n2) {
        if (this.callbackDescriptor == null) {
            Object[] objectArray = new Object[0xB280758 ^ 0xB28075A];
            objectArray[0x1B97899D ^ 0x1B97899D] = this.method.desc.substring(0x4EC414D0 ^ 0x4EC414D1, this.method.desc.indexOf(0x6D97EE84 ^ 0x6D97EEAD));
            objectArray[0xE7A305A0 ^ 0xE7A305A1] = this.getCallbackInfoClass();
            this.callbackDescriptor = String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7a3\ua4a6\ua05d\ua940\u7d65\u8e11\u2433\u8b01"), objectArray);
        }
        if (!bl || typeArray == null) {
            return this.callbackDescriptor;
        }
        StringBuilder stringBuilder = new StringBuilder(this.callbackDescriptor.substring(0x61F0F747 ^ 0x61F0F747, this.callbackDescriptor.indexOf(0x8ECBCD60 ^ 0x8ECBCD49)));
        for (int i = n; i < typeArray.length && n2 > 0; ++i) {
            if (typeArray[i] == null) continue;
            stringBuilder.append(typeArray[i].getDescriptor());
            --n2;
        }
        return stringBuilder.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(";\ua7d0")).toString();
    }

    public String toString() {
        Object[] objectArray = new Object[0x679FD585 ^ 0x679FD586];
        objectArray[0x26BF403A ^ 0x26BF403A] = this.classNode.name;
        objectArray[0xB64AE103 ^ 0xB64AE102] = this.method.name;
        objectArray[0x4C58B254 ^ 0x4C58B256] = this.method.desc;
        return String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4ef\ua02b\ua940\u7d65\u8e0f\u2469"), objectArray);
    }

    @Override
    public int compareTo(Target target) {
        if (target == null) {
            return 0xC37D9212 ^ 0xBC826DED;
        }
        return this.toString().compareTo(target.toString());
    }

    public int indexOf(InjectionNodes.InjectionNode injectionNode) {
        return this.insns.indexOf(injectionNode.getCurrentTarget());
    }

    public int indexOf(AbstractInsnNode abstractInsnNode) {
        return this.insns.indexOf(abstractInsnNode);
    }

    public AbstractInsnNode get(int n) {
        return this.insns.get(n);
    }

    @Override
    public Iterator<AbstractInsnNode> iterator() {
        return this.insns.iterator();
    }

    public MethodInsnNode findInitNodeFor(TypeInsnNode typeInsnNode) {
        int n = this.indexOf(typeInsnNode);
        ListIterator<AbstractInsnNode> listIterator = this.insns.iterator(n);
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() != (0x20E03B86 ^ 0x20E03B31)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodInsnNode.name) || !methodInsnNode.owner.equals(typeInsnNode.desc)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public MethodInsnNode findSuperInitNode() {
        if (!this.isCtor) {
            return null;
        }
        return Bytecode.findSuperInit(this.method, ClassInfo.forName(this.classNode.name).getSuperName());
    }

    public void insertBefore(InjectionNodes.InjectionNode injectionNode, InsnList insnList) {
        this.insns.insertBefore(injectionNode.getCurrentTarget(), insnList);
    }

    public void insertBefore(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        this.insns.insertBefore(abstractInsnNode, insnList);
    }

    public void replaceNode(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        this.insns.insertBefore(abstractInsnNode, abstractInsnNode2);
        this.insns.remove(abstractInsnNode);
        this.injectionNodes.replace(abstractInsnNode, abstractInsnNode2);
    }

    public void replaceNode(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2, InsnList insnList) {
        this.insns.insertBefore(abstractInsnNode, insnList);
        this.insns.remove(abstractInsnNode);
        this.injectionNodes.replace(abstractInsnNode, abstractInsnNode2);
    }

    public void wrapNode(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2, InsnList insnList, InsnList insnList2) {
        this.insns.insertBefore(abstractInsnNode, insnList);
        this.insns.insert(abstractInsnNode, insnList2);
        this.injectionNodes.replace(abstractInsnNode, abstractInsnNode2);
    }

    public void replaceNode(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        this.insns.insertBefore(abstractInsnNode, insnList);
        this.removeNode(abstractInsnNode);
    }

    public void removeNode(AbstractInsnNode abstractInsnNode) {
        this.insns.remove(abstractInsnNode);
        this.injectionNodes.remove(abstractInsnNode);
    }

    public void addLocalVariable(int n, String string, String string2) {
        if (this.start == null) {
            this.start = new LabelNode(new Label());
            this.end = new LabelNode(new Label());
            this.insns.insert(this.start);
            this.insns.add(this.end);
        }
        this.addLocalVariable(n, string, string2, this.start, this.end);
    }

    private void addLocalVariable(int n, String string, String string2, LabelNode labelNode, LabelNode labelNode2) {
        if (this.method.localVariables == null) {
            this.method.localVariables = new ArrayList<LocalVariableNode>();
        }
        this.method.localVariables.add(new LocalVariableNode(string, string2, null, labelNode, labelNode2, n));
    }
}

