/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.refmap;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class RemappingReferenceMapper
implements IReferenceMapper {
    private static final String DEFAULT_RESOURCE_PATH_PROPERTY = "net.minecraftforge.gradle.GradleStart.srg.srg-mcp";
    private static final String DEFAULT_MAPPING_ENV = "searge";
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private static final Map<String, Map<String, String>> srgs = new HashMap<String, Map<String, String>>();
    private final IReferenceMapper refMap;
    private final Map<String, String> mappings;
    private final Map<String, Map<String, String>> cache = new HashMap<String, Map<String, String>>();

    private RemappingReferenceMapper(MixinEnvironment mixinEnvironment, IReferenceMapper iReferenceMapper) {
        this.refMap = iReferenceMapper;
        this.refMap.setContext(RemappingReferenceMapper.getMappingEnv(mixinEnvironment));
        String string = RemappingReferenceMapper.getResource(mixinEnvironment);
        this.mappings = RemappingReferenceMapper.loadSrgs(string);
        Object[] objectArray = new Object[0xE41708CE ^ 0xE41708CC];
        objectArray[0x3E133CAB ^ 0x3E133CAB] = iReferenceMapper.getResourceName();
        objectArray[0xD92D924B ^ 0xD92D924A] = string;
        logger.info(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("@\ua7e3\ua4b8\ua070\ua915\u7d66\u8e43\u2474\u8b30\u3437`\ua7e3\ua4b3\ua05c\ua904\u7d66\u8e0a\u2461\u8b2a\u3437g\ua7f5\ua4bc\ua07f\ua902\u7d36\u8e51\u2467"), objectArray);
    }

    @Override
    public boolean isDefault() {
        return this.refMap.isDefault();
    }

    @Override
    public String getResourceName() {
        return this.refMap.getResourceName();
    }

    @Override
    public String getStatus() {
        return this.refMap.getStatus();
    }

    @Override
    public String getContext() {
        return this.refMap.getContext();
    }

    @Override
    public void setContext(String string) {
    }

    @Override
    public String remap(String string, String string2) {
        Map<String, String> map = this.getCache(string);
        String string3 = map.get(string2);
        if (string3 == null) {
            string3 = this.refMap.remap(string, string2);
            for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
                string3 = string3.replace(entry.getKey(), entry.getValue());
            }
            map.put(string2, string3);
        }
        return string3;
    }

    private Map<String, String> getCache(String string) {
        Map<String, String> map = this.cache.get(string);
        if (map == null) {
            map = new HashMap<String, String>();
            this.cache.put(string, map);
        }
        return map;
    }

    @Override
    public String remapWithContext(String string, String string2, String string3) {
        return this.refMap.remapWithContext(string, string2, string3);
    }

    private static Map<String, String> loadSrgs(String string) {
        if (srgs.containsKey(string)) {
            return srgs.get(string);
        }
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        srgs.put(string, hashMap);
        File file = new File(string);
        if (!file.isFile()) {
            return hashMap;
        }
        try {
            Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Object>(){

                public Object getResult() {
                    return null;
                }

                public boolean processLine(String string) throws IOException {
                    if (Strings.isNullOrEmpty((String)string) || string.startsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("1"))) {
                        return (0x2B70CB7B ^ 0x2B70CB7A) != 0;
                    }
                    int n = 0x1DE2AD66 ^ 0x1DE2AD66;
                    int n2 = 0x9926853B ^ 0x9926853B;
                    int n3 = string.startsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("_\ua7c2\ua4ef\ua031")) ? 0x2AECF00A ^ 0x2AECF008 : (string.startsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7c2\ua4ef\ua031")) ? 0x1632A6C1 ^ 0x1632A6C0 : (n2 = 0x409F94B7 ^ 0x409F94B7));
                    if (n3 > 0) {
                        String[] stringArray = string.substring(0x4638B962 ^ 0x4638B966).split(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2"), 0x84A57AF4 ^ 0x84A57AF0);
                        hashMap.put(stringArray[n].substring(stringArray[n].lastIndexOf(0xCD35BB5D ^ 0xCD35BB72) + (0x7C2AF62A ^ 0x7C2AF62B)), stringArray[n2].substring(stringArray[n2].lastIndexOf(0x4F67AB7E ^ 0x4F67AB51) + (0xB5A25BB6 ^ 0xB5A25BB7)));
                    }
                    return (0x9ECCF9F3 ^ 0x9ECCF9F2) != 0;
                }
            });
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[0xBEF014DF ^ 0xBEF014DE];
            objectArray[0x924C860D ^ 0x924C860D] = string;
            logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437`\ua7e3\ua4b4\ua075\ua945\u7d7f\u8e44\u246a\u8b22\u34632\ua7d5\ua487\ua056\ua945\u7d70\u8e43\u2476\u8b32\u342d2\ua7fd\ua4a8"), objectArray);
            logger.catching((Throwable)iOException);
        }
        return hashMap;
    }

    public static IReferenceMapper of(MixinEnvironment mixinEnvironment, IReferenceMapper iReferenceMapper) {
        if (!iReferenceMapper.isDefault() && RemappingReferenceMapper.hasData(mixinEnvironment)) {
            return new RemappingReferenceMapper(mixinEnvironment, iReferenceMapper);
        }
        return iReferenceMapper;
    }

    private static boolean hasData(MixinEnvironment mixinEnvironment) {
        String string = RemappingReferenceMapper.getResource(mixinEnvironment);
        return (string != null && new File(string).exists() ? 0x713D0F80 ^ 0x713D0F81 : 0xF21E33AC ^ 0xF21E33AC) != 0;
    }

    private static String getResource(MixinEnvironment mixinEnvironment) {
        String string = mixinEnvironment.getOptionValue(MixinEnvironment.Option.REFMAP_REMAP_RESOURCE);
        return Strings.isNullOrEmpty((String)string) ? System.getProperty(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("|\ua7e3\ua4a1\ua03f\ua908\u7d7f\u8e44\u247f\u8b34\u3465s\ua7e0\ua4a1\ua077\ua90a\u7d64\u8e4d\u247f\u8b79\u3470`\ua7e7\ua4b1\ua07d\ua900\u7d38\u8e6d\u2468\u8b36\u3473~\ua7e3\ua486\ua065\ua904\u7d64\u8e5e\u2434\u8b24\u3465u\ua7a8\ua4a6\ua063\ua902\u7d3b\u8e47\u2479\u8b27")) : string;
    }

    private static String getMappingEnv(MixinEnvironment mixinEnvironment) {
        String string = mixinEnvironment.getOptionValue(MixinEnvironment.Option.REFMAP_REMAP_SOURCE_ENV);
        return Strings.isNullOrEmpty((String)string) ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("a\ua7e3\ua4b4\ua063\ua902\u7d73") : string;
    }
}

