/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public abstract class MemberRef {
    private static final int[] H_OPCODES;

    public abstract boolean isField();

    public abstract int getOpcode();

    public abstract void setOpcode(int var1);

    public abstract String getOwner();

    public abstract void setOwner(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract String getDesc();

    public abstract void setDesc(String var1);

    public String toString() {
        String string = Bytecode.getOpcodeName(this.getOpcode());
        Object[] objectArray = new Object[0x61151FDF ^ 0x61151FDA];
        objectArray[0x22424E0D ^ 0x22424E0D] = string;
        objectArray[0x1D423389 ^ 0x1D423388] = this.getOwner();
        objectArray[0xA3413FC0 ^ 0xA3413FC2] = this.getName();
        objectArray[0xED959526 ^ 0xED959525] = this.isField() ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("(") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("");
        objectArray[0x8D37442A ^ 0x8D37442E] = this.getDesc();
        return String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f5\ua077\ua90a\u7d64\u8e0a\u243f\u8b24\u34397\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MemberRef)) {
            return (0x4C01A9D3 ^ 0x4C01A9D3) != 0;
        }
        MemberRef memberRef = (MemberRef)object;
        return (this.getOpcode() == memberRef.getOpcode() && this.getOwner().equals(memberRef.getOwner()) && this.getName().equals(memberRef.getName()) && this.getDesc().equals(memberRef.getDesc()) ? 0x277BCB00 ^ 0x277BCB01 : 0xE577F92C ^ 0xE577F92C) != 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    static int opcodeFromTag(int n) {
        return n >= 0 && n < H_OPCODES.length ? H_OPCODES[n] : 0xFE625786 ^ 0xFE625786;
    }

    static int tagFromOpcode(int n) {
        for (int i = 0xBAA6CF39 ^ 0xBAA6CF38; i < H_OPCODES.length; ++i) {
            if (H_OPCODES[i] != n) continue;
            return i;
        }
        return 0xBF21FCF5 ^ 0xBF21FCF5;
    }

    static {
        int[] nArray = new int[0x3977F521 ^ 0x3977F52B];
        nArray[0x83074ECB ^ 0x83074ECB] = 0x839B19D1 ^ 0x839B19D1;
        nArray[0x6668AF45 ^ 0x6668AF44] = 0x7386ABD9 ^ 0x7386AB6D;
        nArray[0x5D1FE19C ^ 0x5D1FE19E] = 0x4A950DB1 ^ 0x4A950D03;
        nArray[0x5145CC75 ^ 0x5145CC76] = 0x8660CD62 ^ 0x8660CDD7;
        nArray[0x97EEA4AC ^ 0x97EEA4A8] = 0x18B86A67 ^ 0x18B86AD4;
        nArray[0xE9E0FE9C ^ 0xE9E0FE99] = 0x65CD965E ^ 0x65CD96E8;
        nArray[0xF2975ABE ^ 0xF2975AB8] = 0x3E40B8BC ^ 0x3E40B804;
        nArray[0x74409440 ^ 0x74409447] = 0xC481004D ^ 0xC48100FA;
        nArray[0x5B31C768 ^ 0x5B31C760] = 0x3847EC08 ^ 0x3847ECBF;
        nArray[0x1CDED336 ^ 0x1CDED33F] = 0xD32F22EA ^ 0xD32F2253;
        H_OPCODES = nArray;
    }

    public static final class Handle
    extends MemberRef {
        private org.spongepowered.asm.lib.Handle handle;

        public Handle(org.spongepowered.asm.lib.Handle handle) {
            this.handle = handle;
        }

        public org.spongepowered.asm.lib.Handle getMethodHandle() {
            return this.handle;
        }

        @Override
        public boolean isField() {
            switch (this.handle.getTag()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return (0x956C545C ^ 0x956C545C) != 0;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return (0x73A8069F ^ 0x73A8069E) != 0;
                }
            }
            throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476u\ua7a6") + this.handle.getTag() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("<"));
        }

        @Override
        public int getOpcode() {
            int n = MemberRef.opcodeFromTag(this.handle.getTag());
            if (n == 0) {
                throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476u\ua7a6") + this.handle.getTag() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("<"));
            }
            return n;
        }

        @Override
        public void setOpcode(int n) {
            int n2 = MemberRef.tagFromOpcode(n);
            if (n2 == 0) {
                throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945") + Bytecode.getOpcodeName(n) + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("<"));
            }
            int n3 = n2 == (0x600FC53A ^ 0x600FC533) ? 0x10696FB6 ^ 0x10696FB7 : 0x8875A18E ^ 0x8875A18E;
            this.handle = new org.spongepowered.asm.lib.Handle(n2, this.handle.getOwner(), this.handle.getName(), this.handle.getDesc(), n3 != 0);
        }

        @Override
        public String getOwner() {
            return this.handle.getOwner();
        }

        @Override
        public void setOwner(String string) {
            int n = this.handle.getTag() == (0x76C0B109 ^ 0x76C0B100) ? 0x29C37C7A ^ 0x29C37C7B : 0x8287CFA ^ 0x8287CFA;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), string, this.handle.getName(), this.handle.getDesc(), n != 0);
        }

        @Override
        public String getName() {
            return this.handle.getName();
        }

        @Override
        public void setName(String string) {
            int n = this.handle.getTag() == (0x208467EF ^ 0x208467E6) ? 0xF6162521 ^ 0xF6162520 : 0x91F2F762 ^ 0x91F2F762;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), string, this.handle.getDesc(), n != 0);
        }

        @Override
        public String getDesc() {
            return this.handle.getDesc();
        }

        @Override
        public void setDesc(String string) {
            int n = this.handle.getTag() == (0xF4381FDE ^ 0xF4381FD7) ? 0x2FDC02CD ^ 0x2FDC02CC : 0x8788F74A ^ 0x8788F74A;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), this.handle.getName(), string, n != 0);
        }
    }

    public static final class Field
    extends MemberRef {
        private static final int OPCODES = 183;
        public final FieldInsnNode insn;

        public Field(FieldInsnNode fieldInsnNode) {
            this.insn = fieldInsnNode;
        }

        @Override
        public boolean isField() {
            return (0xE3465B44 ^ 0xE3465B45) != 0;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int n) {
            if ((n & (0x46128D16 ^ 0x46128DA1)) == 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d70\u8e45\u2468\u8b77\u3471{\ua7e3\ua4b9\ua075\ua945\u7d7f\u8e44\u2469\u8b23\u3465g\ua7e5\ua4a1\ua078\ua90a\u7d78\u8e10\u243a\u8b67\u346f") + Integer.toHexString(n));
            }
            this.insn.setOpcode(n);
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOwner(String string) {
            this.insn.owner = string;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setName(String string) {
            this.insn.name = string;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setDesc(String string) {
            this.insn.desc = string;
        }
    }

    public static final class Method
    extends MemberRef {
        private static final int OPCODES = 191;
        public final MethodInsnNode insn;

        public Method(MethodInsnNode methodInsnNode) {
            this.insn = methodInsnNode;
        }

        @Override
        public boolean isField() {
            return (0x303D2BAD ^ 0x303D2BAD) != 0;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int n) {
            if ((n & (0xA9CC281D ^ 0xA9CC28A2)) == 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d70\u8e45\u2468\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901\u7d36\u8e43\u2474\u8b24\u3463`\ua7f3\ua4b6\ua065\ua90c\u7d79\u8e44\u2420\u8b77\u3427j") + Integer.toHexString(n));
            }
            this.insn.setOpcode(n);
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOwner(String string) {
            this.insn.owner = string;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setName(String string) {
            this.insn.name = string;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setDesc(String string) {
            this.insn.desc = string;
        }
    }
}

