/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.transformer.MethodMapper;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.ClassSignature;
import org.spongepowered.asm.util.perf.Profiler;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class ClassInfo {
    public static final int INCLUDE_PRIVATE = 2;
    public static final int INCLUDE_STATIC = 8;
    public static final int INCLUDE_ALL = 10;
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private static final Profiler profiler = MixinEnvironment.getProfiler();
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final Map<String, ClassInfo> cache = new HashMap<String, ClassInfo>();
    private static final ClassInfo OBJECT = new ClassInfo();
    private final String name;
    private final String superName;
    private final String outerName;
    private final boolean isProbablyStatic;
    private final Set<String> interfaces;
    private final Set<Method> methods;
    private final Set<Field> fields;
    private final Set<MixinInfo> mixins = new HashSet<MixinInfo>();
    private final Map<ClassInfo, ClassInfo> correspondingTypes = new HashMap<ClassInfo, ClassInfo>();
    private final MixinInfo mixin;
    private final MethodMapper methodMapper;
    private final boolean isMixin;
    private final boolean isInterface;
    private final int access;
    private ClassInfo superClass;
    private ClassInfo outerClass;
    private ClassSignature signature;

    private ClassInfo() {
        this.name = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
        this.superName = null;
        this.outerName = null;
        this.isProbablyStatic = 0xDA4A1865 ^ 0xDA4A1864;
        Object[] objectArray = new Method[0x4F55E370 ^ 0x4F55E375];
        objectArray[0x4B6DDE2 ^ 0x4B6DDE2] = new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("|\ua7e9\ua4a1\ua078\ua903\u7d6f\u8e6b\u2476\u8b3b"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7af\ua483"));
        objectArray[0xB04C2B6F ^ 0xB04C2B6E] = new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7cc\ua4fc\ua047"));
        objectArray[0x276CEE39 ^ 0x276CEE3B] = new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7cc\ua49c\ua038\ua933"));
        objectArray[0xA9805DA7 ^ 0xA9805DA4] = new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7af\ua483"));
        objectArray[0x8AA5D144 ^ 0x8AA5D140] = new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("t\ua7ef\ua4bb\ua070\ua909\u7d7f\u8e50\u247f"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7af\ua483"));
        this.methods = ImmutableSet.of((Object)new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("u\ua7e3\ua4a1\ua052\ua909\u7d77\u8e59\u2469"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua052\ua909\u7d77\u8e59\u2469\u8b6c")), (Object)new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("z\ua7e7\ua4a6\ua079\ua926\u7d79\u8e4e\u247f"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7af\ua49c")), (Object)new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("w\ua7f7\ua4a0\ua070\ua909\u7d65"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7ca\ua4bf\ua070\ua913\u7d77\u8e05\u2476\u8b36\u3479u\ua7a9\ua49a\ua073\ua90f\u7d73\u8e49\u246e\u8b6c\u343eH")), (Object)new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7ea\ua4ba\ua07f\ua900"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua05e\ua907\u7d7c\u8e4f\u2479\u8b23\u342c")), (Object)new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("f\ua7e9\ua486\ua065\ua917\u7d7f\u8e44\u247d"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua042\ua911\u7d64\u8e43\u2474\u8b30\u342c")), (Object)new Method(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("|\ua7e9\ua4a1\ua078\ua903\u7d6f"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":\ua7af\ua483")), (Object[])objectArray);
        this.fields = Collections.emptySet();
        this.isInterface = 0xE45D7E0F ^ 0xE45D7E0F;
        this.interfaces = Collections.emptySet();
        this.access = 0x43540A01 ^ 0x43540A00;
        this.isMixin = 0xF267364 ^ 0xF267364;
        this.mixin = null;
        this.methodMapper = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ClassInfo(ClassNode classNode) {
        Profiler.Section section = profiler.begin(0x80B2514D ^ 0x80B2514C, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7ea\ua4b4\ua062\ua916\u7d38\u8e47\u247f\u8b23\u3476"));
        try {
            void var4_7;
            this.name = classNode.name;
            this.superName = classNode.superName != null ? classNode.superName : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
            this.methods = new HashSet<Method>();
            this.fields = new HashSet<Field>();
            this.isInterface = (classNode.access & (0x93911F1C ^ 0x93911D1C)) != 0 ? 0x7A32B3AA ^ 0x7A32B3AB : 0xFF4845CC ^ 0xFF4845CC;
            this.interfaces = new HashSet<String>();
            this.access = classNode.access;
            this.isMixin = classNode instanceof MixinInfo.MixinClassNode;
            this.mixin = this.isMixin ? ((MixinInfo.MixinClassNode)classNode).getMixin() : null;
            this.interfaces.addAll(classNode.interfaces);
            for (MethodNode object2 : classNode.methods) {
                this.addMethod(object2, this.isMixin);
            }
            int n = 0xBB30D3B6 ^ 0xBB30D3B7;
            String string = classNode.outerClass;
            for (FieldNode fieldNode : classNode.fields) {
                if ((fieldNode.access & (0xEF3EFEAB ^ 0xEF3EEEAB)) != 0 && fieldNode.name.startsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("f\ua7ee\ua4bc\ua062\ua941"))) {
                    String string2;
                    n = 0xEF28BD3E ^ 0xEF28BD3E;
                    if (var4_7 == null && (string2 = fieldNode.desc) != null && string2.startsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^"))) {
                        String string3 = string2.substring(0xA0093BFD ^ 0xA0093BFC, string2.length() - (0x6D29AFFF ^ 0x6D29AFFE));
                    }
                }
                this.fields.add(new Field(fieldNode, this.isMixin));
            }
            this.isProbablyStatic = n;
            this.outerName = var4_7;
            this.methodMapper = new MethodMapper(MixinEnvironment.getCurrentEnvironment(), this);
            this.signature = ClassSignature.ofLazy(classNode);
        }
        finally {
            section.end();
        }
    }

    void addInterface(String string) {
        this.interfaces.add(string);
        this.getSignature().addInterface(string);
    }

    void addMethod(MethodNode methodNode) {
        this.addMethod(methodNode, (0xC19DD243 ^ 0xC19DD242) != 0);
    }

    private void addMethod(MethodNode methodNode, boolean bl) {
        if (!methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("."))) {
            this.methods.add(new Method(methodNode, bl));
        }
    }

    void addMixin(MixinInfo mixinInfo) {
        if (this.isMixin) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u247b\u8b33\u34732\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a") + this.name + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e0\ua4ba\ua063\ua945") + mixinInfo.getClassName() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u3463z\ua7e3\ua4f5\ua065\ua904\u7d64\u8e4d\u247f\u8b23\u3437{\ua7f5\ua4f5\ua070\ua945\u7d7b\u8e43\u2462\u8b3e\u3479"));
        }
        this.mixins.add(mixinInfo);
    }

    public Set<MixinInfo> getMixins() {
        return Collections.unmodifiableSet(this.mixins);
    }

    public boolean isMixin() {
        return this.isMixin;
    }

    public boolean isPublic() {
        return ((this.access & (0x637C56E7 ^ 0x637C56E6)) != 0 ? 0xDAE7C0C7 ^ 0xDAE7C0C6 : 0x1652F092 ^ 0x1652F092) != 0;
    }

    public boolean isAbstract() {
        return ((this.access & (0x92947692 ^ 0x92947292)) != 0 ? 0xE8CB1C14 ^ 0xE8CB1C15 : 0xB1B8E4E2 ^ 0xB1B8E4E2) != 0;
    }

    public boolean isSynthetic() {
        return ((this.access & (0xD921A40B ^ 0xD921B40B)) != 0 ? 0xEAD2D8E0 ^ 0xEAD2D8E1 : 0x44A1C6A2 ^ 0x44A1C6A2) != 0;
    }

    public boolean isProbablyStatic() {
        return this.isProbablyStatic;
    }

    public boolean isInner() {
        return (this.outerName != null ? 0x142408D9 ^ 0x142408D8 : 0x300E4943 ^ 0x300E4943) != 0;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public Set<String> getInterfaces() {
        return Collections.unmodifiableSet(this.interfaces);
    }

    public String toString() {
        return this.name;
    }

    public MethodMapper getMethodMapper() {
        return this.methodMapper;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.name.replace((char)(0x461889B9 ^ 0x46188996), (char)(0x12CDA3D3 ^ 0x12CDA3FD));
    }

    public String getSuperName() {
        return this.superName;
    }

    public ClassInfo getSuperClass() {
        if (this.superClass == null && this.superName != null) {
            this.superClass = ClassInfo.forName(this.superName);
        }
        return this.superClass;
    }

    public String getOuterName() {
        return this.outerName;
    }

    public ClassInfo getOuterClass() {
        if (this.outerClass == null && this.outerName != null) {
            this.outerClass = ClassInfo.forName(this.outerName);
        }
        return this.outerClass;
    }

    public ClassSignature getSignature() {
        return this.signature.wake();
    }

    List<ClassInfo> getTargets() {
        if (this.mixin != null) {
            ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
            arrayList.add(this);
            arrayList.addAll(this.mixin.getTargets());
            return arrayList;
        }
        return ImmutableList.of((Object)this);
    }

    public Set<Method> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    public Set<Method> getInterfaceMethods(boolean bl) {
        HashSet<Method> hashSet = new HashSet<Method>();
        if (!this.isInterface) {
            for (ClassInfo classInfo = this.addMethodsRecursive(hashSet, bl); classInfo != null && classInfo != OBJECT; classInfo = classInfo.addMethodsRecursive(hashSet, bl)) {
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (((Method)iterator.next()).isAbstract()) continue;
            iterator.remove();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private ClassInfo addMethodsRecursive(Set<Method> set, boolean bl) {
        if (this.isInterface) {
            for (Method object : this.methods) {
                if (!object.isAbstract()) {
                    set.remove(object);
                }
                set.add(object);
            }
        } else if (!this.isMixin && bl) {
            for (MixinInfo mixinInfo : this.mixins) {
                mixinInfo.getClassInfo().addMethodsRecursive(set, bl);
            }
        }
        for (String string : this.interfaces) {
            ClassInfo.forName(string).addMethodsRecursive(set, bl);
        }
        return this.getSuperClass();
    }

    public boolean hasSuperClass(String string) {
        return this.hasSuperClass(string, Traversal.NONE);
    }

    public boolean hasSuperClass(String string, Traversal traversal) {
        if (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string)) {
            return (0xE5B1E7C5 ^ 0xE5B1E7C4) != 0;
        }
        return (this.findSuperClass(string, traversal) != null ? 0x8E35DF2A ^ 0x8E35DF2B : 0xB730EA48 ^ 0xB730EA48) != 0;
    }

    public boolean hasSuperClass(ClassInfo classInfo) {
        return this.hasSuperClass(classInfo, Traversal.NONE, (0xB480B294 ^ 0xB480B294) != 0);
    }

    public boolean hasSuperClass(ClassInfo classInfo, Traversal traversal) {
        return this.hasSuperClass(classInfo, traversal, (0xBD0BD59A ^ 0xBD0BD59A) != 0);
    }

    public boolean hasSuperClass(ClassInfo classInfo, Traversal traversal, boolean bl) {
        if (OBJECT == classInfo) {
            return (0xB41D162B ^ 0xB41D162A) != 0;
        }
        return (this.findSuperClass(classInfo.name, traversal, bl) != null ? 0x2E364296 ^ 0x2E364297 : 0xEBFF990C ^ 0xEBFF990C) != 0;
    }

    public ClassInfo findSuperClass(String string) {
        return this.findSuperClass(string, Traversal.NONE);
    }

    public ClassInfo findSuperClass(String string, Traversal traversal) {
        return this.findSuperClass(string, traversal, (0xB188A189 ^ 0xB188A189) != 0, new HashSet<String>());
    }

    public ClassInfo findSuperClass(String string, Traversal traversal, boolean bl) {
        if (ClassInfo.OBJECT.name.equals(string)) {
            return null;
        }
        return this.findSuperClass(string, traversal, bl, new HashSet<String>());
    }

    private ClassInfo findSuperClass(String string, Traversal traversal, boolean bl, Set<String> set) {
        Object object;
        Iterator<MixinInfo> iterator;
        ClassInfo classInfo = this.getSuperClass();
        if (classInfo != null) {
            iterator = classInfo.getTargets().iterator();
            while (iterator.hasNext()) {
                ClassInfo object2 = (ClassInfo)iterator.next();
                if (string.equals(object2.getName())) {
                    return classInfo;
                }
                object = object2.findSuperClass(string, traversal.next(), bl, set);
                if (object == null) continue;
                return object;
            }
        }
        if (bl && (iterator = this.findInterface(string)) != null) {
            return iterator;
        }
        if (traversal.canTraverse()) {
            for (MixinInfo mixinInfo : this.mixins) {
                object = mixinInfo.getClassName();
                if (set.contains(object)) continue;
                set.add((String)object);
                ClassInfo classInfo2 = mixinInfo.getClassInfo();
                if (string.equals(classInfo2.getName())) {
                    return classInfo2;
                }
                ClassInfo classInfo3 = classInfo2.findSuperClass(string, Traversal.ALL, bl, set);
                if (classInfo3 == null) continue;
                return classInfo3;
            }
        }
        return null;
    }

    private ClassInfo findInterface(String string) {
        for (String string2 : this.getInterfaces()) {
            ClassInfo classInfo = ClassInfo.forName(string2);
            if (string.equals(string2)) {
                return classInfo;
            }
            ClassInfo classInfo2 = classInfo.findInterface(string);
            if (classInfo2 == null) continue;
            return classInfo2;
        }
        return null;
    }

    ClassInfo findCorrespondingType(ClassInfo classInfo) {
        if (classInfo == null || !classInfo.isMixin || this.isMixin) {
            return null;
        }
        ClassInfo classInfo2 = this.correspondingTypes.get(classInfo);
        if (classInfo2 == null) {
            classInfo2 = this.findSuperTypeForMixin(classInfo);
            this.correspondingTypes.put(classInfo, classInfo2);
        }
        return classInfo2;
    }

    private ClassInfo findSuperTypeForMixin(ClassInfo classInfo) {
        for (ClassInfo classInfo2 = this; classInfo2 != null && classInfo2 != OBJECT; classInfo2 = classInfo2.getSuperClass()) {
            for (MixinInfo mixinInfo : classInfo2.mixins) {
                if (!mixinInfo.getClassInfo().equals(classInfo)) continue;
                return classInfo2;
            }
        }
        return null;
    }

    public boolean hasMixinInHierarchy() {
        if (!this.isMixin) {
            return (0xE1A420AB ^ 0xE1A420AB) != 0;
        }
        for (ClassInfo classInfo = this.getSuperClass(); classInfo != null && classInfo != OBJECT; classInfo = classInfo.getSuperClass()) {
            if (!classInfo.isMixin) continue;
            return (0x90CD208A ^ 0x90CD208B) != 0;
        }
        return (0x8C4E027B ^ 0x8C4E027B) != 0;
    }

    public boolean hasMixinTargetInHierarchy() {
        if (this.isMixin) {
            return (0x6C43FD3C ^ 0x6C43FD3C) != 0;
        }
        for (ClassInfo classInfo = this.getSuperClass(); classInfo != null && classInfo != OBJECT; classInfo = classInfo.getSuperClass()) {
            if (classInfo.mixins.size() <= 0) continue;
            return (0x8F4F27 ^ 0x8F4F26) != 0;
        }
        return (0x132A9A52 ^ 0x132A9A52) != 0;
    }

    public Method findMethodInHierarchy(MethodNode methodNode, SearchType searchType) {
        return this.findMethodInHierarchy(methodNode.name, methodNode.desc, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(MethodNode methodNode, SearchType searchType, int n) {
        return this.findMethodInHierarchy(methodNode.name, methodNode.desc, searchType, Traversal.NONE, n);
    }

    public Method findMethodInHierarchy(MethodInsnNode methodInsnNode, SearchType searchType) {
        return this.findMethodInHierarchy(methodInsnNode.name, methodInsnNode.desc, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(MethodInsnNode methodInsnNode, SearchType searchType, int n) {
        return this.findMethodInHierarchy(methodInsnNode.name, methodInsnNode.desc, searchType, Traversal.NONE, n);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType) {
        return this.findMethodInHierarchy(string, string2, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType, Traversal traversal) {
        return this.findMethodInHierarchy(string, string2, searchType, traversal, 0xBB18FE7D ^ 0xBB18FE7D);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n) {
        return (Method)this.findInHierarchy(string, string2, searchType, traversal, n, Member.Type.METHOD);
    }

    public Field findFieldInHierarchy(FieldNode fieldNode, SearchType searchType) {
        return this.findFieldInHierarchy(fieldNode.name, fieldNode.desc, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(FieldNode fieldNode, SearchType searchType, int n) {
        return this.findFieldInHierarchy(fieldNode.name, fieldNode.desc, searchType, Traversal.NONE, n);
    }

    public Field findFieldInHierarchy(FieldInsnNode fieldInsnNode, SearchType searchType) {
        return this.findFieldInHierarchy(fieldInsnNode.name, fieldInsnNode.desc, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(FieldInsnNode fieldInsnNode, SearchType searchType, int n) {
        return this.findFieldInHierarchy(fieldInsnNode.name, fieldInsnNode.desc, searchType, Traversal.NONE, n);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType) {
        return this.findFieldInHierarchy(string, string2, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType, Traversal traversal) {
        return this.findFieldInHierarchy(string, string2, searchType, traversal, 0x9FE22A58 ^ 0x9FE22A58);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n) {
        return (Field)this.findInHierarchy(string, string2, searchType, traversal, n, Member.Type.FIELD);
    }

    private <M extends Member> M findInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n, Member.Type type) {
        ClassInfo classInfo;
        ClassInfo classInfo2;
        if (searchType == SearchType.ALL_CLASSES) {
            classInfo2 = this.findMember(string, string2, n, type);
            if (classInfo2 != null) {
                return (M)classInfo2;
            }
            if (traversal.canTraverse()) {
                for (MixinInfo object : this.mixins) {
                    classInfo = object.getClassInfo().findMember(string, string2, n, type);
                    if (classInfo == null) continue;
                    return (M)this.cloneMember(classInfo);
                }
            }
        }
        if ((classInfo2 = this.getSuperClass()) != null) {
            for (ClassInfo classInfo3 : classInfo2.getTargets()) {
                classInfo = classInfo3.findInHierarchy(string, string2, SearchType.ALL_CLASSES, traversal.next(), n & (0x6614662A ^ 0x99EB99D7), type);
                if (classInfo == null) continue;
                return (M)classInfo;
            }
        }
        if (type == Member.Type.METHOD && (this.isInterface || MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces())) {
            for (String string3 : this.interfaces) {
                classInfo = ClassInfo.forName(string3);
                if (classInfo == null) {
                    Object[] objectArray = new Object[0x86D92F8C ^ 0x86D92F8E];
                    objectArray[0xB1319AC3 ^ 0xB1319AC3] = string3;
                    objectArray[0xE11174DA ^ 0xE11174DB] = this.name;
                    logger.debug(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437`\ua7e3\ua4a6\ua07e\ua909\u7d60\u8e4f\u243a\u8b33\u3472q\ua7ea\ua4b4\ua063\ua900\u7d72\u8e0a\u2473\u8b39\u3463w\ua7f4\ua4b3\ua070\ua906\u7d73\u8e0a\u2461\u8b2a\u3437}\ua7e8\ua4f5\ua06a\ua918"), objectArray);
                    continue;
                }
                M m = classInfo.findInHierarchy(string, string2, SearchType.ALL_CLASSES, traversal.next(), n & (0x1C7A062F ^ 0xE385F9D2), type);
                if (m == null) continue;
                return (M)(this.isInterface ? m : new InterfaceMethod((Member)m));
            }
        }
        return null;
    }

    private <M extends Member> M cloneMember(M m) {
        if (m instanceof Method) {
            return (M)new Method(m);
        }
        return (M)new Field(m);
    }

    public Method findMethod(MethodNode methodNode) {
        return this.findMethod(methodNode.name, methodNode.desc, methodNode.access);
    }

    public Method findMethod(MethodNode methodNode, int n) {
        return this.findMethod(methodNode.name, methodNode.desc, n);
    }

    public Method findMethod(MethodInsnNode methodInsnNode) {
        return this.findMethod(methodInsnNode.name, methodInsnNode.desc, 0x44F0C157 ^ 0x44F0C157);
    }

    public Method findMethod(MethodInsnNode methodInsnNode, int n) {
        return this.findMethod(methodInsnNode.name, methodInsnNode.desc, n);
    }

    public Method findMethod(String string, String string2, int n) {
        return (Method)this.findMember(string, string2, n, Member.Type.METHOD);
    }

    public Field findField(FieldNode fieldNode) {
        return this.findField(fieldNode.name, fieldNode.desc, fieldNode.access);
    }

    public Field findField(FieldInsnNode fieldInsnNode, int n) {
        return this.findField(fieldInsnNode.name, fieldInsnNode.desc, n);
    }

    public Field findField(String string, String string2, int n) {
        return (Field)this.findMember(string, string2, n, Member.Type.FIELD);
    }

    private <M extends Member> M findMember(String string, String string2, int n, Member.Type type) {
        Set<Member> set = type == Member.Type.METHOD ? this.methods : this.fields;
        for (Member member : set) {
            if (!member.equals(string, string2) || !member.matchesFlags(n)) continue;
            return (M)member;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClassInfo)) {
            return (0x906DED89 ^ 0x906DED89) != 0;
        }
        return ((ClassInfo)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static ClassInfo fromClassNode(ClassNode classNode) {
        ClassInfo classInfo = cache.get(classNode.name);
        if (classInfo == null) {
            classInfo = new ClassInfo(classNode);
            cache.put(classNode.name, classInfo);
        }
        return classInfo;
    }

    public static ClassInfo forName(String string) {
        ClassInfo classInfo = cache.get(string = string.replace((char)(0xCE5A067A ^ 0xCE5A0654), (char)(0x6B6701F ^ 0x6B67030)));
        if (classInfo == null) {
            try {
                ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(string);
                classInfo = new ClassInfo(classNode);
            }
            catch (Exception exception) {
                logger.catching(Level.TRACE, (Throwable)exception);
                Object[] objectArray = new Object[0xAF295E8 ^ 0xAF295EB];
                objectArray[0x68E880F6 ^ 0x68E880F6] = string;
                objectArray[0x8784812D ^ 0x8784812C] = exception.getClass().getName();
                objectArray[0xCFE37ED0 ^ 0xCFE37ED2] = exception.getMessage();
                logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e46\u2475\u8b36\u3473{\ua7e8\ua4b2\ua031\ua906\u7d7a\u8e4b\u2469\u8b24\u342d2\ua7fd\ua4a8\ua031\ua94d\u7d6d\u8e57\u2420\u8b77\u346co\ua7af"), objectArray);
            }
            cache.put(string, classInfo);
            Object[] objectArray = new Object[0x386C95F5 ^ 0x386C95F4];
            objectArray[0xC59D5332 ^ 0xC59D5332] = string;
            logger.trace(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("S\ua7e2\ua4b1\ua074\ua901\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4b8\ua074\ua911\u7d77\u8e4e\u247b\u8b23\u34762\ua7e0\ua4ba\ua063\ua945\u7d6d\u8e57\u243a\u8b23\u34782\ua7eb\ua4b0\ua065\ua904\u7d72\u8e4b\u246e\u8b36\u3437q\ua7e7\ua4b6\ua079\ua900"), objectArray);
        }
        return classInfo;
    }

    public static ClassInfo forType(Type type) {
        if (type.getSort() == (0x540A1C87 ^ 0x540A1C8E)) {
            return ClassInfo.forType(type.getElementType());
        }
        if (type.getSort() < (0x78F2498D ^ 0x78F24984)) {
            return null;
        }
        return ClassInfo.forName(type.getClassName().replace((char)(0x1E3B4DA ^ 0x1E3B4F4), (char)(0x8CF6C411 ^ 0x8CF6C43E)));
    }

    public static ClassInfo getCommonSuperClass(String string, String string2) {
        if (string == null || string2 == null) {
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClass(ClassInfo.forName(string), ClassInfo.forName(string2));
    }

    public static ClassInfo getCommonSuperClass(Type type, Type type2) {
        block3: {
            block2: {
                if (type == null || type2 == null) break block2;
                if (type.getSort() != (0x9B35C3D9 ^ 0x9B35C3D3)) break block2;
                if (type2.getSort() == (0x80A66C31 ^ 0x80A66C3B)) break block3;
            }
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClass(ClassInfo.forType(type), ClassInfo.forType(type2));
    }

    private static ClassInfo getCommonSuperClass(ClassInfo classInfo, ClassInfo classInfo2) {
        return ClassInfo.getCommonSuperClass(classInfo, classInfo2, (0xF43EE3BB ^ 0xF43EE3BB) != 0);
    }

    public static ClassInfo getCommonSuperClassOrInterface(String string, String string2) {
        if (string == null || string2 == null) {
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClassOrInterface(ClassInfo.forName(string), ClassInfo.forName(string2));
    }

    public static ClassInfo getCommonSuperClassOrInterface(Type type, Type type2) {
        block3: {
            block2: {
                if (type == null || type2 == null) break block2;
                if (type.getSort() != (0xBE9A7269 ^ 0xBE9A7263)) break block2;
                if (type2.getSort() == (0xB727F8F5 ^ 0xB727F8FF)) break block3;
            }
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClassOrInterface(ClassInfo.forType(type), ClassInfo.forType(type2));
    }

    public static ClassInfo getCommonSuperClassOrInterface(ClassInfo classInfo, ClassInfo classInfo2) {
        return ClassInfo.getCommonSuperClass(classInfo, classInfo2, (0x4BFC2BC0 ^ 0x4BFC2BC1) != 0);
    }

    private static ClassInfo getCommonSuperClass(ClassInfo classInfo, ClassInfo classInfo2, boolean bl) {
        if (classInfo.hasSuperClass(classInfo2, Traversal.NONE, bl)) {
            return classInfo2;
        }
        if (classInfo2.hasSuperClass(classInfo, Traversal.NONE, bl)) {
            return classInfo;
        }
        if (classInfo.isInterface() || classInfo2.isInterface()) {
            return OBJECT;
        }
        do {
            if ((classInfo = classInfo.getSuperClass()) != null) continue;
            return OBJECT;
        } while (!classInfo2.hasSuperClass(classInfo, Traversal.NONE, bl));
        return classInfo;
    }

    static {
        cache.put(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62"), OBJECT);
    }

    class Field
    extends Member {
        public Field(Member member) {
            super(member);
        }

        public Field(FieldNode fieldNode) {
            this(fieldNode, (0xD4871634 ^ 0xD4871634) != 0);
        }

        public Field(FieldNode fieldNode, boolean bl) {
            super(Member.Type.FIELD, fieldNode.name, fieldNode.desc, fieldNode.access, bl);
            this.setUnique((Annotations.getVisible(fieldNode, Unique.class) != null ? 0x1737B963 ^ 0x1737B962 : 0x1305F491 ^ 0x1305F491) != 0);
            if (Annotations.getVisible(fieldNode, Shadow.class) != null) {
                int n;
                int n2 = Annotations.getVisible(fieldNode, Final.class) != null ? 0x80DACEDA ^ 0x80DACEDB : (n = 0x4CA43BAE ^ 0x4CA43BAE);
                int n3 = Annotations.getVisible(fieldNode, Mutable.class) != null ? 0x93CCE47E ^ 0x93CCE47F : 0xA2BDC345 ^ 0xA2BDC345;
                this.setDecoratedFinal(n != 0, n3 != 0);
            }
        }

        public Field(String string, String string2, int n) {
            super(Member.Type.FIELD, string, string2, n, (0xCBDCFE0F ^ 0xCBDCFE0F) != 0);
        }

        public Field(String string, String string2, int n, boolean bl) {
            super(Member.Type.FIELD, string, string2, n, bl);
        }

        @Override
        public ClassInfo getOwner() {
            return ClassInfo.this;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Field)) {
                return (0xE489ABF0 ^ 0xE489ABF0) != 0;
            }
            return super.equals(object);
        }

        @Override
        protected String getDisplayFormat() {
            return \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4ef\ua034\ua916");
        }
    }

    public class InterfaceMethod
    extends Method {
        private final ClassInfo owner;

        public InterfaceMethod(Member member) {
            super(member);
            this.owner = member.getOwner();
        }

        @Override
        public ClassInfo getOwner() {
            return this.owner;
        }

        @Override
        public ClassInfo getImplementor() {
            return ClassInfo.this;
        }
    }

    public class Method
    extends Member {
        private final List<FrameData> frames;
        private boolean isAccessor;

        public Method(Member member) {
            super(member);
            this.frames = member instanceof Method ? ((Method)member).frames : null;
        }

        public Method(MethodNode methodNode) {
            this(methodNode, (0xE4F50E1 ^ 0xE4F50E1) != 0);
            this.setUnique((Annotations.getVisible(methodNode, Unique.class) != null ? 0xE61C16B4 ^ 0xE61C16B5 : 0xC15B1D70 ^ 0xC15B1D70) != 0);
            Class[] classArray = new Class[0x559C42D0 ^ 0x559C42D2];
            classArray[0x94B7E13F ^ 0x94B7E13F] = Accessor.class;
            classArray[0x6BA5843 ^ 0x6BA5842] = Invoker.class;
            this.isAccessor = Annotations.getSingleVisible(methodNode, classArray) != null ? 0xD91B65E ^ 0xD91B65F : 0x2EB54054 ^ 0x2EB54054;
        }

        public Method(MethodNode methodNode, boolean bl) {
            super(Member.Type.METHOD, methodNode.name, methodNode.desc, methodNode.access, bl);
            this.frames = this.gatherFrames(methodNode);
            this.setUnique((Annotations.getVisible(methodNode, Unique.class) != null ? 0x8C717301 ^ 0x8C717300 : 0x34257FE8 ^ 0x34257FE8) != 0);
            Class[] classArray = new Class[0xA1E5A4B4 ^ 0xA1E5A4B6];
            classArray[0x6B4BF21B ^ 0x6B4BF21B] = Accessor.class;
            classArray[0xF700BCD5 ^ 0xF700BCD4] = Invoker.class;
            this.isAccessor = Annotations.getSingleVisible(methodNode, classArray) != null ? 0xDCEE4CD1 ^ 0xDCEE4CD0 : 0xFFD7AAAE ^ 0xFFD7AAAE;
        }

        public Method(String string, String string2) {
            super(Member.Type.METHOD, string, string2, 0xE555004D ^ 0xE555004C, (0x270A6D20 ^ 0x270A6D20) != 0);
            this.frames = null;
        }

        public Method(String string, String string2, int n) {
            super(Member.Type.METHOD, string, string2, n, (0x5FF987E3 ^ 0x5FF987E3) != 0);
            this.frames = null;
        }

        public Method(String string, String string2, int n, boolean bl) {
            super(Member.Type.METHOD, string, string2, n, bl);
            this.frames = null;
        }

        private List<FrameData> gatherFrames(MethodNode methodNode) {
            ArrayList<FrameData> arrayList = new ArrayList<FrameData>();
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (!(abstractInsnNode instanceof FrameNode)) continue;
                arrayList.add(new FrameData(methodNode.instructions.indexOf(abstractInsnNode), (FrameNode)abstractInsnNode));
            }
            return arrayList;
        }

        public List<FrameData> getFrames() {
            return this.frames;
        }

        @Override
        public ClassInfo getOwner() {
            return ClassInfo.this;
        }

        public boolean isAccessor() {
            return this.isAccessor;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Method)) {
                return (0x5C6410D8 ^ 0x5C6410D8) != 0;
            }
            return super.equals(object);
        }
    }

    static abstract class Member {
        private final Type type;
        private final String memberName;
        private final String memberDesc;
        private final boolean isInjected;
        private final int modifiers;
        private String currentName;
        private String currentDesc;
        private boolean decoratedFinal;
        private boolean decoratedMutable;
        private boolean unique;

        protected Member(Member member) {
            this(member.type, member.memberName, member.memberDesc, member.modifiers, member.isInjected);
            this.currentName = member.currentName;
            this.currentDesc = member.currentDesc;
            this.unique = member.unique;
        }

        protected Member(Type type, String string, String string2, int n) {
            this(type, string, string2, n, (0x5AA17448 ^ 0x5AA17448) != 0);
        }

        protected Member(Type type, String string, String string2, int n, boolean bl) {
            this.type = type;
            this.memberName = string;
            this.memberDesc = string2;
            this.isInjected = bl;
            this.currentName = string;
            this.currentDesc = string2;
            this.modifiers = n;
        }

        public String getOriginalName() {
            return this.memberName;
        }

        public String getName() {
            return this.currentName;
        }

        public String getOriginalDesc() {
            return this.memberDesc;
        }

        public String getDesc() {
            return this.currentDesc;
        }

        public boolean isInjected() {
            return this.isInjected;
        }

        public boolean isRenamed() {
            return (!this.currentName.equals(this.memberName) ? 0xBF023B32 ^ 0xBF023B33 : 0x866FD22D ^ 0x866FD22D) != 0;
        }

        public boolean isRemapped() {
            return (!this.currentDesc.equals(this.memberDesc) ? 0x9E50E484 ^ 0x9E50E485 : 0x3D799001 ^ 0x3D799001) != 0;
        }

        public boolean isPrivate() {
            return ((this.modifiers & (0x36D7298E ^ 0x36D7298C)) != 0 ? 0x44028C68 ^ 0x44028C69 : 0x95AE4C5A ^ 0x95AE4C5A) != 0;
        }

        public boolean isStatic() {
            return ((this.modifiers & (0xDB5CFF69 ^ 0xDB5CFF61)) != 0 ? 0x6DD1CCCC ^ 0x6DD1CCCD : 0xB1F54FB8 ^ 0xB1F54FB8) != 0;
        }

        public boolean isAbstract() {
            return ((this.modifiers & (0x1386E716 ^ 0x1386E316)) != 0 ? 0xEE2CCF00 ^ 0xEE2CCF01 : 0x68B38533 ^ 0x68B38533) != 0;
        }

        public boolean isFinal() {
            return ((this.modifiers & (0xA6C9ABA3 ^ 0xA6C9ABB3)) != 0 ? 0xA466C3AF ^ 0xA466C3AE : 0xB69A6DE1 ^ 0xB69A6DE1) != 0;
        }

        public boolean isSynthetic() {
            return ((this.modifiers & (0x4B30452D ^ 0x4B30552D)) != 0 ? 0xF135537D ^ 0xF135537C : 0x3BF6A29C ^ 0x3BF6A29C) != 0;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public void setUnique(boolean bl) {
            this.unique = bl;
        }

        public boolean isDecoratedFinal() {
            return this.decoratedFinal;
        }

        public boolean isDecoratedMutable() {
            return this.decoratedMutable;
        }

        public void setDecoratedFinal(boolean bl, boolean bl2) {
            this.decoratedFinal = bl;
            this.decoratedMutable = bl2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean matchesFlags(int n) {
            int n2;
            if (((this.modifiers ^ (0x62F71776 ^ 0x9D08E889) | n & (0xAF94AB46 ^ 0xAF94AB44)) & (0x24980F0C ^ 0x24980F0E)) != 0) {
                if (((this.modifiers ^ (0x1D4122F6 ^ 0xE2BEDD09) | n & (0xFBAD0A46 ^ 0xFBAD0A4E)) & (0xE1A0BD63 ^ 0xE1A0BD6B)) != 0) {
                    n2 = 0x4AB7A18 ^ 0x4AB7A19;
                    return n2 != 0;
                }
            }
            n2 = 0x9D8B3FCD ^ 0x9D8B3FCD;
            return n2 != 0;
        }

        public abstract ClassInfo getOwner();

        public ClassInfo getImplementor() {
            return this.getOwner();
        }

        public int getAccess() {
            return this.modifiers;
        }

        public String renameTo(String string) {
            this.currentName = string;
            return string;
        }

        public String remapTo(String string) {
            this.currentDesc = string;
            return string;
        }

        public boolean equals(String string, String string2) {
            return ((this.memberName.equals(string) || this.currentName.equals(string)) && (this.memberDesc.equals(string2) || this.currentDesc.equals(string2)) ? 0xF7821391 ^ 0xF7821390 : 0x33301AD0 ^ 0x33301AD0) != 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Member)) {
                return (0x88EF8C3E ^ 0x88EF8C3E) != 0;
            }
            Member member = (Member)object;
            return ((member.memberName.equals(this.memberName) || member.currentName.equals(this.currentName)) && (member.memberDesc.equals(this.memberDesc) || member.currentDesc.equals(this.currentDesc)) ? 0x2942DAA1 ^ 0x2942DAA0 : 0x3FEB71F4 ^ 0x3FEB71F4) != 0;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            Object[] objectArray = new Object[0xA26CF8BE ^ 0xA26CF8BC];
            objectArray[0xE6B46EE3 ^ 0xE6B46EE3] = this.memberName;
            objectArray[0x9E48D3AC ^ 0x9E48D3AD] = this.memberDesc;
            return String.format(this.getDisplayFormat(), objectArray);
        }

        protected String getDisplayFormat() {
            return \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f0\ua062");
        }

        static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type METHOD = new Type();
            public static final /* enum */ Type FIELD = new Type();
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String string) {
                return Enum.valueOf(Type.class, string);
            }

            static {
                Type[] typeArray = new Type[0x22E3109A ^ 0x22E31098];
                typeArray[0x5E90EE34 ^ 0x5E90EE34] = METHOD;
                typeArray[0x6C107BE3 ^ 0x6C107BE2] = FIELD;
                $VALUES = typeArray;
            }
        }
    }

    public static class FrameData {
        private static final String[] FRAMETYPES;
        public final int index;
        public final int type;
        public final int locals;

        FrameData(int n, int n2, int n3) {
            this.index = n;
            this.type = n2;
            this.locals = n3;
        }

        FrameData(int n, FrameNode frameNode) {
            this.index = n;
            this.type = frameNode.type;
            this.locals = frameNode.local != null ? frameNode.local.size() : 0xB31698 ^ 0xB31698;
        }

        public String toString() {
            Object[] objectArray = new Object[0x6D675F13 ^ 0x6D675F10];
            objectArray[0x72FE5541 ^ 0x72FE5541] = this.index;
            objectArray[0x2C2BBE93 ^ 0x2C2BBE92] = FRAMETYPES[this.type + (0x9024C3FE ^ 0x9024C3FF)];
            objectArray[0xE6E95F2C ^ 0xE6E95F2E] = this.locals;
            return String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7f4\ua4b4\ua07c\ua900\u7d52\u8e4b\u246e\u8b36\u344c{\ua7e8\ua4b1\ua074\ua91d\u7d2b\u8e0f\u247e\u8b7b\u3437f\ua7ff\ua4a5\ua074\ua958\u7d33\u8e59\u2436\u8b77\u347b}\ua7e5\ua4b4\ua07d\ua916\u7d2b\u8e0f\u247e\u8b0a"), objectArray);
        }

        static {
            String[] stringArray = new String[0x67A6EDA1 ^ 0x67A6EDA7];
            stringArray[0x9B566E98 ^ 0x9B566E98] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\\\ua7c3\ua482");
            stringArray[0x35119EA4 ^ 0x35119EA5] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7d3\ua499\ua05d");
            stringArray[0xDB22246D ^ 0xDB22246F] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("S\ua7d6\ua485\ua054\ua92b\u7d52");
            stringArray[0x2415603A ^ 0x24156039] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7ce\ua49a\ua041");
            stringArray[0x82F36B49 ^ 0x82F36B4D] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("A\ua7c7\ua498\ua054");
            stringArray[0xAF97547F ^ 0xAF97547A] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("A\ua7c7\ua498\ua054\ua954");
            FRAMETYPES = stringArray;
        }
    }

    public static final class Traversal
    extends Enum<Traversal> {
        public static final /* enum */ Traversal NONE = new Traversal(null, (0x60C876CB ^ 0x60C876CB) != 0, SearchType.SUPER_CLASSES_ONLY);
        public static final /* enum */ Traversal ALL = new Traversal(null, (0x982FBCAC ^ 0x982FBCAD) != 0, SearchType.ALL_CLASSES);
        public static final /* enum */ Traversal IMMEDIATE = new Traversal(NONE, (0xFD2AC6A7 ^ 0xFD2AC6A6) != 0, SearchType.SUPER_CLASSES_ONLY);
        public static final /* enum */ Traversal SUPER = new Traversal(ALL, (0xDB7600B4 ^ 0xDB7600B4) != 0, SearchType.SUPER_CLASSES_ONLY);
        private final Traversal next;
        private final boolean traverse;
        private final SearchType searchType;
        private static final /* synthetic */ Traversal[] $VALUES;

        public static Traversal[] values() {
            return (Traversal[])$VALUES.clone();
        }

        public static Traversal valueOf(String string) {
            return Enum.valueOf(Traversal.class, string);
        }

        private Traversal(Traversal traversal, boolean bl, SearchType searchType) {
            this.next = traversal != null ? traversal : this;
            this.traverse = bl;
            this.searchType = searchType;
        }

        public Traversal next() {
            return this.next;
        }

        public boolean canTraverse() {
            return this.traverse;
        }

        public SearchType getSearchType() {
            return this.searchType;
        }

        static {
            Traversal[] traversalArray = new Traversal[0xFCD9F18D ^ 0xFCD9F189];
            traversalArray[0xFA83DF3E ^ 0xFA83DF3E] = NONE;
            traversalArray[0xE5A4B1AA ^ 0xE5A4B1AB] = ALL;
            traversalArray[0x26F4EC12 ^ 0x26F4EC10] = IMMEDIATE;
            traversalArray[0xB1D956FC ^ 0xB1D956FF] = SUPER;
            $VALUES = traversalArray;
        }
    }

    public static final class SearchType
    extends Enum<SearchType> {
        public static final /* enum */ SearchType ALL_CLASSES = new SearchType();
        public static final /* enum */ SearchType SUPER_CLASSES_ONLY = new SearchType();
        private static final /* synthetic */ SearchType[] $VALUES;

        public static SearchType[] values() {
            return (SearchType[])$VALUES.clone();
        }

        public static SearchType valueOf(String string) {
            return Enum.valueOf(SearchType.class, string);
        }

        static {
            SearchType[] searchTypeArray = new SearchType[0x77F8732B ^ 0x77F87329];
            searchTypeArray[0x3C87AFAF ^ 0x3C87AFAF] = ALL_CLASSES;
            searchTypeArray[0xC00E94EB ^ 0xC00E94EA] = SUPER_CLASSES_ONLY;
            $VALUES = searchTypeArray;
        }
    }
}

