/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.signature.SignatureReader;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionClassExporter;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.ConstraintParser;
import org.spongepowered.asm.util.perf.Profiler;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

class MixinApplicatorStandard {
    protected static final List<Class<? extends Annotation>> CONSTRAINED_ANNOTATIONS = ImmutableList.of(Overwrite.class, Inject.class, ModifyArg.class, ModifyArgs.class, Redirect.class, ModifyVariable.class, ModifyConstant.class);
    protected static final int[] INITIALISER_OPCODE_BLACKLIST;
    protected final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected final TargetClassContext context;
    protected final String targetName;
    protected final ClassNode targetClass;
    protected final Profiler profiler = MixinEnvironment.getProfiler();
    protected final boolean mergeSignatures;

    MixinApplicatorStandard(TargetClassContext targetClassContext) {
        this.context = targetClassContext;
        this.targetName = targetClassContext.getClassName();
        this.targetClass = targetClassContext.getClassNode();
        ExtensionClassExporter extensionClassExporter = (ExtensionClassExporter)targetClassContext.getExtensions().getExtension(ExtensionClassExporter.class);
        this.mergeSignatures = extensionClassExporter.isDecompilerActive() && MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE_MERGESIGNATURES) ? 0x49584B90 ^ 0x49584B91 : 0x3D2FD04E ^ 0x3D2FD04E;
    }

    void apply(SortedSet<MixinInfo> sortedSet) {
        ArrayList<MixinTargetContext> arrayList = new ArrayList<MixinTargetContext>();
        for (MixinInfo object2 : sortedSet) {
            Object[] objectArray = new Object[0xA6D91FA4 ^ 0xA6D91FA7];
            objectArray[0xCF2A3F2A ^ 0xCF2A3F2A] = object2.getName();
            objectArray[0x2F2653F5 ^ 0x2F2653F4] = object2.getParent();
            objectArray[0xE6AE8AE9 ^ 0xE6AE8AEB] = this.targetName;
            this.logger.log(object2.getLoggingLevel(), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("_\ua7ef\ua4ad\ua078\ua90b\u7d71\u8e0a\u2461\u8b2a\u3437t\ua7f4\ua4ba\ua07c\ua945\u7d6d\u8e57\u243a\u8b3e\u3479f\ua7e9\ua4f5\ua06a\ua918"), objectArray);
            arrayList.add(object2.createContextFor(this.context));
        }
        Object object = null;
        try {
            for (MixinTargetContext mixinTargetContext : arrayList) {
                object = mixinTargetContext;
                ((MixinTargetContext)object).preApply(this.targetName, this.targetClass);
            }
            ApplicatorPass[] exception = ApplicatorPass.values();
            int n = exception.length;
            for (int i = 0xD08C6C8C ^ 0xD08C6C8C; i < n; ++i) {
                ApplicatorPass applicatorPass = exception[i];
                String[] stringArray = new String[0x72701384 ^ 0x72701386];
                stringArray[0xDD331AF3 ^ 0xDD331AF3] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("b\ua7e7\ua4a6\ua062");
                stringArray[0x757220 ^ 0x757221] = applicatorPass.name().toLowerCase();
                Profiler.Section section = this.profiler.begin(stringArray);
                for (MixinTargetContext mixinTargetContext : arrayList) {
                    object = mixinTargetContext;
                    this.applyMixin((MixinTargetContext)object, applicatorPass);
                }
                section.end();
            }
            for (MixinTargetContext mixinTargetContext : arrayList) {
                object = mixinTargetContext;
                ((MixinTargetContext)object).postApply(this.targetName, this.targetClass);
            }
        }
        catch (InvalidMixinException invalidMixinException) {
            throw invalidMixinException;
        }
        catch (Exception exception) {
            throw new InvalidMixinException((IMixinContext)object, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u3473w\ua7e2\ua4f5") + exception.getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7f1\ua4bd\ua078\ua909\u7d65\u8e5e\u243a\u8b36\u3467b\ua7ea\ua4ac\ua078\ua90b\u7d71\u8e0a\u246e\u8b3f\u34722\ua7eb\ua4bc\ua069\ua90c\u7d78\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4ef\ua031") + exception.getMessage(), (Throwable)exception);
        }
        this.applySourceMap(this.context);
        this.context.processDebugTasks();
    }

    protected final void applyMixin(MixinTargetContext mixinTargetContext, ApplicatorPass applicatorPass) {
        switch (1.$SwitchMap$org$spongepowered$asm$mixin$transformer$MixinApplicatorStandard$ApplicatorPass[applicatorPass.ordinal()]) {
            case 1: {
                this.applySignature(mixinTargetContext);
                this.applyInterfaces(mixinTargetContext);
                this.applyAttributes(mixinTargetContext);
                this.applyAnnotations(mixinTargetContext);
                this.applyFields(mixinTargetContext);
                this.applyMethods(mixinTargetContext);
                this.applyInitialisers(mixinTargetContext);
                break;
            }
            case 2: {
                this.prepareInjections(mixinTargetContext);
                break;
            }
            case 3: {
                this.applyAccessors(mixinTargetContext);
                this.applyInjections(mixinTargetContext);
                break;
            }
            default: {
                throw new IllegalStateException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b27\u3476a\ua7f5\ua4f5\ua062\ua915\u7d73\u8e49\u2473\u8b31\u347ew\ua7e2\ua4f5") + (Object)((Object)applicatorPass));
            }
        }
    }

    protected void applySignature(MixinTargetContext mixinTargetContext) {
        if (this.mergeSignatures) {
            this.context.mergeSignature(mixinTargetContext.getSignature());
        }
    }

    protected void applyInterfaces(MixinTargetContext mixinTargetContext) {
        for (String string : mixinTargetContext.getInterfaces()) {
            if (this.targetClass.interfaces.contains(string)) continue;
            this.targetClass.interfaces.add(string);
            mixinTargetContext.getTargetClassInfo().addInterface(string);
        }
    }

    protected void applyAttributes(MixinTargetContext mixinTargetContext) {
        if (mixinTargetContext.shouldSetSourceFile()) {
            this.targetClass.sourceFile = mixinTargetContext.getSourceFile();
        }
        this.targetClass.version = Math.max(this.targetClass.version, mixinTargetContext.getMinRequiredClassVersion());
    }

    protected void applyAnnotations(MixinTargetContext mixinTargetContext) {
        ClassNode classNode = mixinTargetContext.getClassNode();
        Bytecode.mergeAnnotations(classNode, this.targetClass);
    }

    protected void applyFields(MixinTargetContext mixinTargetContext) {
        this.mergeShadowFields(mixinTargetContext);
        this.mergeNewFields(mixinTargetContext);
    }

    protected void mergeShadowFields(MixinTargetContext mixinTargetContext) {
        for (Map.Entry<FieldNode, ClassInfo.Field> entry : mixinTargetContext.getShadowFields()) {
            FieldNode fieldNode = entry.getKey();
            FieldNode fieldNode2 = this.findTargetField(fieldNode);
            if (fieldNode2 == null) continue;
            Bytecode.mergeAnnotations(fieldNode, fieldNode2);
            if (!entry.getValue().isDecoratedMutable()) continue;
            if (Bytecode.hasFlag(fieldNode2, 0x2AD19FC4 ^ 0x2AD19FC6)) continue;
            fieldNode2.access &= 0x85D80915 ^ 0x7A27F6FA;
        }
    }

    protected void mergeNewFields(MixinTargetContext mixinTargetContext) {
        for (FieldNode fieldNode : mixinTargetContext.getFields()) {
            FieldNode fieldNode2 = this.findTargetField(fieldNode);
            if (fieldNode2 != null) continue;
            this.targetClass.fields.add(fieldNode);
            if (fieldNode.signature == null) continue;
            if (this.mergeSignatures) {
                SignatureVisitor signatureVisitor = mixinTargetContext.getSignature().getRemapper();
                new SignatureReader(fieldNode.signature).accept(signatureVisitor);
                fieldNode.signature = signatureVisitor.toString();
                continue;
            }
            fieldNode.signature = null;
        }
    }

    protected void applyMethods(MixinTargetContext mixinTargetContext) {
        for (MethodNode methodNode : mixinTargetContext.getShadowMethods()) {
            this.applyShadowMethod(mixinTargetContext, methodNode);
        }
        for (MethodNode methodNode : mixinTargetContext.getMethods()) {
            this.applyNormalMethod(mixinTargetContext, methodNode);
        }
    }

    protected void applyShadowMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            Bytecode.mergeAnnotations(methodNode, methodNode2);
        }
    }

    protected void applyNormalMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        mixinTargetContext.transformMethod(methodNode);
        if (!methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("."))) {
            this.checkMethodVisibility(mixinTargetContext, methodNode);
            this.checkMethodConstraints(mixinTargetContext, methodNode);
            this.mergeMethod(mixinTargetContext, methodNode);
        } else if (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7e5\ua4b9\ua078\ua90b\u7d7f\u8e5e\u2424").equals(methodNode.name)) {
            this.appendInsns(mixinTargetContext, methodNode);
        }
    }

    protected void mergeMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        Object object;
        int n = Annotations.getVisible(methodNode, Overwrite.class) != null ? 0x2B6B463B ^ 0x2B6B463A : 0xC554F35C ^ 0xC554F35C;
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            if (this.isAlreadyMerged(mixinTargetContext, methodNode, n != 0, methodNode2)) {
                return;
            }
            object = Annotations.getInvisible(methodNode, Intrinsic.class);
            if (object != null) {
                if (this.mergeIntrinsic(mixinTargetContext, methodNode, n != 0, methodNode2, (AnnotationNode)object)) {
                    mixinTargetContext.getTarget().methodMerged(methodNode);
                    return;
                }
            } else {
                if (mixinTargetContext.requireOverwriteAnnotations() && !n) {
                    Object[] objectArray = new Object[0x311A5C35 ^ 0x311A5C31];
                    objectArray[0x541F37FA ^ 0x541F37FA] = methodNode.name;
                    objectArray[0x1864A401 ^ 0x1864A400] = methodNode.desc;
                    objectArray[0x9D4CDB4F ^ 0x9D4CDB4D] = mixinTargetContext;
                    objectArray[0x4552A523 ^ 0x4552A520] = mixinTargetContext.getTarget().getClassName();
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f0\ua062\ua945\u7d7f\u8e44\u243a\u8b72\u34642\ua7e5\ua4b4\ua07f\ua90b\u7d79\u8e5e\u243a\u8b38\u3461w\ua7f4\ua4a2\ua063\ua90c\u7d62\u8e4f\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua945\u7d7f\u8e44\u243a\u8b72\u34642\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u3457]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437{\ua7f5\ua4f5\ua063\ua900\u7d67\u8e5f\u2473\u8b25\u3472v\ua7a6\ua4b7\ua068\ua945\u7d62\u8e42\u247f\u8b77\u3467s\ua7f4\ua4b0\ua07f\ua911\u7d36\u8e49\u2475\u8b39\u3471{\ua7e1\ua4a0\ua063\ua904\u7d62\u8e43\u2475\u8b39"), objectArray));
                }
                this.targetClass.methods.remove(methodNode2);
            }
        } else if (n) {
            Object[] objectArray = new Object[0xED74F35A ^ 0xED74F358];
            objectArray[0x1520AF23 ^ 0x1520AF23] = methodNode.name;
            objectArray[0xA1C9785E ^ 0xA1C9785F] = mixinTargetContext.getTargetClassRef();
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2438\u8b72\u34640\ua7a6\ua4a2\ua070\ua916\u7d36\u8e44\u2475\u8b23\u3437~\ua7e9\ua4b6\ua070\ua911\u7d73\u8e4e\u243a\u8b3e\u34792\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua940\u7d65"), objectArray));
        }
        this.targetClass.methods.add(methodNode);
        mixinTargetContext.methodMerged(methodNode);
        if (methodNode.signature != null) {
            if (this.mergeSignatures) {
                object = mixinTargetContext.getSignature().getRemapper();
                new SignatureReader(methodNode.signature).accept((SignatureVisitor)object);
                methodNode.signature = object.toString();
            } else {
                methodNode.signature = null;
            }
        }
    }

    protected boolean isAlreadyMerged(MixinTargetContext mixinTargetContext, MethodNode methodNode, boolean bl, MethodNode methodNode2) {
        AnnotationNode annotationNode = Annotations.getVisible(methodNode2, MixinMerged.class);
        if (annotationNode == null) {
            if (Annotations.getVisible(methodNode2, Final.class) != null) {
                Object[] objectArray = new Object[0x91B15A85 ^ 0x91B15A87];
                objectArray[0x982506C2 ^ 0x982506C2] = methodNode.name;
                objectArray[0xC86C4E3B ^ 0xC86C4E3A] = mixinTargetContext;
                this.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437b\ua7f4\ua4ba\ua079\ua90c\u7d74\u8e43\u246e\u8b32\u34732\ua7e0\ua4ba\ua063\ua945\u7d56\u8e6c\u2473\u8b39\u3476~\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7a6\ua4bc\ua07f\ua945\u7d6d\u8e57\u2434\u8b77\u3444y\ua7ef\ua4a5\ua061\ua90c\u7d78\u8e4d\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua94b"), objectArray);
                return (0x36EA1AB3 ^ 0x36EA1AB2) != 0;
            }
            return (0x19DF642 ^ 0x19DF642) != 0;
        }
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("a\ua7e3\ua4a6\ua062\ua90c\u7d79\u8e44\u2453\u8b33"));
        if (!this.context.getSessionId().equals(string)) {
            throw new ClassFormatError(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b17\u345a{\ua7fe\ua4bc\ua07f\ua928\u7d73\u8e58\u247d\u8b32\u34732\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4b3\ua07e\ua910\u7d78\u8e4e\u243a\u8b3e\u3479") + mixinTargetContext + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e7\ua4a1\ua031") + methodNode.name + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4bb\ua031") + this.targetClass.name);
        }
        if (Bytecode.hasFlag(methodNode2, 0x41192379 ^ 0x41193339)) {
            if (Bytecode.hasFlag(methodNode, 0x27AF5DAD ^ 0x27AF4DED)) {
                if (mixinTargetContext.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
                    Object[] objectArray = new Object[0x1FC5B5CC ^ 0x1FC5B5CE];
                    objectArray[0xA2A2C996 ^ 0xA2A2C996] = methodNode.name;
                    objectArray[0x3DC4EC34 ^ 0x3DC4EC35] = mixinTargetContext;
                    this.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("A\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34\u3437p\ua7f4\ua4bc\ua075\ua902\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua906\u7d7a\u8e4b\u2469\u8b3f\u3437t\ua7e9\ua4a7\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb"), objectArray);
                }
                return (0xAE44B7F0 ^ 0xAE44B7F1) != 0;
            }
        }
        String string2 = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        int n = (Integer)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463"));
        if (n >= mixinTargetContext.getPriority() && !string2.equals(mixinTargetContext.getClassName())) {
            Object[] objectArray = new Object[0x3321D8B1 ^ 0x3321D8B2];
            objectArray[0xE305475C ^ 0xE305475C] = methodNode.name;
            objectArray[0x8A869524 ^ 0x8A869525] = mixinTargetContext;
            objectArray[0x5AF67DF1 ^ 0x5AF67DF3] = string2;
            this.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2475\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d36\u8e4c\u2475\u8b25\u3437i\ua7fb\ua4f5\ua078\ua90b\u7d36\u8e51\u2467\u8b7b\u3437b\ua7f4\ua4b0\ua067\ua90c\u7d79\u8e5f\u2469\u8b3b\u346e2\ua7f1\ua4a7\ua078\ua911\u7d62\u8e4f\u2474\u8b77\u3475k\ua7a6\ua4ae\ua06c\ua94b\u7d36\u8e79\u2471\u8b3e\u3467b\ua7ef\ua4bb\ua076\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a8"), objectArray);
            return (0x4AFDCF6F ^ 0x4AFDCF6E) != 0;
        }
        if (Annotations.getVisible(methodNode2, Final.class) != null) {
            Object[] objectArray = new Object[0x29DEDE13 ^ 0x29DEDE10];
            objectArray[0x5D397DFC ^ 0x5D397DFC] = methodNode.name;
            objectArray[0x3E9A15EE ^ 0x3E9A15EF] = mixinTargetContext;
            objectArray[0x309B653A ^ 0x309B6538] = string2;
            this.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2475\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d36\u8e4c\u2475\u8b25\u3437R\ua7c0\ua4bc\ua07f\ua904\u7d7a\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua075\ua900\u7d75\u8e46\u247b\u8b25\u3472v\ua7a6\ua4b7\ua068\ua945\u7d6d\u8e57\u2434\u8b77\u3444y\ua7ef\ua4a5\ua061\ua90c\u7d78\u8e4d\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua94b"), objectArray);
            return (0xEF33C17C ^ 0xEF33C17D) != 0;
        }
        return (0x93034555 ^ 0x93034555) != 0;
    }

    protected boolean mergeIntrinsic(MixinTargetContext mixinTargetContext, MethodNode methodNode, boolean bl, MethodNode methodNode2, AnnotationNode annotationNode) {
        AnnotationNode annotationNode2;
        if (bl) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b34\u3478\u007f\ua7f6\ua4b4\ua065\ua90c\u7d74\u8e46\u247f\u8b77\u3460{\ua7f2\ua4bd\ua031\ua925\u7d59\u8e5c\u247f\u8b25\u3460`\ua7ef\ua4a1\ua074\ua949\u7d36\u8e58\u247f\u8b3a\u3478d\ua7e3\ua4f5\ua07e\ua90b\u7d73\u8e0a\u2475\u8b31\u3437f\ua7ee\ua4b0\ua062\ua900\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78\u8e59\u243a\u8b38\u34792") + methodNode.name + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        String string = methodNode.name + methodNode.desc;
        if (Bytecode.hasFlag(methodNode, 0xA632620 ^ 0xA632628)) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b34\u3476|\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b24\u3463s\ua7f2\ua4bc\ua072\ua949\u7d36\u8e4c\u2475\u8b22\u3479v\ua7a6") + string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        if (!(Bytecode.hasFlag(methodNode, 0x856FE54F ^ 0x856FF54F) || (annotationNode2 = Annotations.getVisible(methodNode, MixinRenamed.class)) != null && Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("{\ua7f5\ua49c\ua07f\ua911\u7d73\u8e58\u247c\u8b36\u3474w\ua7cb\ua4b0\ua07c\ua907\u7d73\u8e58"), Boolean.FALSE).booleanValue())) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e5a\u2468\u8b32\u3471{\ua7fe\ua4b0\ua075\ua945\u7d7f\u8e44\u246e\u8b32\u3465t\ua7e7\ua4b6\ua074\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7aa\ua4f5\ua07f\ua90a\u7d36\u8e58\u247f\u8b39\u3476\u007f\ua7e3\ua4f5\ua074\ua90b\u7d75\u8e45\u246f\u8b39\u3463w\ua7f4\ua4b0\ua075\ua945\u7d79\u8e44\u243a") + string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        if (!Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("v\ua7ef\ua4a6\ua061\ua909\u7d77\u8e49\u247f"), Boolean.FALSE).booleanValue()) {
            Object[] objectArray = new Object[0x73E6B75E ^ 0x73E6B75C];
            objectArray[0xB026FFFB ^ 0xB026FFFB] = string;
            objectArray[0xEE21D78E ^ 0xEE21D78F] = mixinTargetContext.getTargetClassRef();
            this.logger.log(mixinTargetContext.getLoggingLevel(), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("A\ua7ed\ua4bc\ua061\ua915\u7d7f\u8e44\u247d\u8b77\u345e|\ua7f2\ua4a7\ua078\ua90b\u7d65\u8e43\u2479\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4ae\ua06c\ua945\u7d70\u8e45\u2468\u8b77\u346co"), objectArray);
            return (0x3BB542E ^ 0x3BB542F) != 0;
        }
        this.displaceIntrinsic(mixinTargetContext, methodNode, methodNode2);
        return (0x2EEF2DA1 ^ 0x2EEF2DA1) != 0;
    }

    protected void displaceIntrinsic(MixinTargetContext mixinTargetContext, MethodNode methodNode, MethodNode methodNode2) {
        String string = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("b\ua7f4\ua4ba\ua069\ua91c\u7d3d") + methodNode2.name;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() == (0xEA1F6085 ^ 0xEA1F603D)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!methodInsnNode.owner.equals(this.targetClass.name) || !methodInsnNode.name.equals(methodNode2.name) || !methodInsnNode.desc.equals(methodNode2.desc)) continue;
            methodInsnNode.name = string;
        }
        methodNode2.name = string;
    }

    protected final void appendInsns(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        if (Type.getReturnType(methodNode.desc) != Type.VOID_TYPE) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua07c\ua900\u7d64\u8e4d\u247f\u8b77\u347e|\ua7f5\ua4bb\ua062\ua945\u7d70\u8e58\u2475\u8b3a\u3437s\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3460z\ua7ef\ua4b6\ua079\ua945\u7d72\u8e45\u247f\u8b24\u3437|\ua7e9\ua4a1\ua031\ua917\u7d73\u8e5e\u246f\u8b25\u34792\ua7f0\ua4ba\ua078\ua901"));
        }
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            AbstractInsnNode abstractInsnNode = Bytecode.findInsn(methodNode2, 0xEA109830 ^ 0xEA109881);
            if (abstractInsnNode != null) {
                ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
                while (listIterator.hasNext()) {
                    AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
                    if (abstractInsnNode2 instanceof LineNumberNode) continue;
                    if (abstractInsnNode2.getOpcode() == (0x841D6583 ^ 0x841D6532)) continue;
                    methodNode2.instructions.insertBefore(abstractInsnNode, abstractInsnNode2);
                }
                methodNode2.maxLocals = Math.max(methodNode2.maxLocals, methodNode.maxLocals);
                methodNode2.maxStack = Math.max(methodNode2.maxStack, methodNode.maxStack);
            }
            return;
        }
        this.targetClass.methods.add(methodNode);
    }

    protected void applyInitialisers(MixinTargetContext mixinTargetContext) {
        MethodNode methodNode = this.getConstructor(mixinTargetContext);
        if (methodNode == null) {
            return;
        }
        Deque<AbstractInsnNode> deque = this.getInitialiser(mixinTargetContext, methodNode);
        if (deque == null || deque.size() == 0) {
            return;
        }
        for (MethodNode methodNode2 : this.targetClass.methods) {
            if (!\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode2.name)) continue;
            methodNode2.maxStack = Math.max(methodNode2.maxStack, methodNode.maxStack);
            this.injectInitialiser(mixinTargetContext, methodNode2, deque);
        }
    }

    protected MethodNode getConstructor(MixinTargetContext mixinTargetContext) {
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : mixinTargetContext.getMethods()) {
            if (!\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode2.name) || !Bytecode.methodHasLineNumbers(methodNode2)) continue;
            if (methodNode == null) {
                methodNode = methodNode2;
                continue;
            }
            Object[] objectArray = new Object[0x2564585E ^ 0x2564585C];
            objectArray[0x818ABEBD ^ 0x818ABEBD] = mixinTargetContext;
            objectArray[0x7704C2D0 ^ 0x7704C2D1] = methodNode.desc;
            this.logger.warn(String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u347fs\ua7f5\ua4f5\ua07c\ua910\u7d7a\u8e5e\u2473\u8b27\u347bw\ua7a6\ua4b6\ua07e\ua90b\u7d65\u8e5e\u2468\u8b22\u3474f\ua7e9\ua4a7\ua062\ua949\u7d36\u8e0f\u2469\u8b77\u3460s\ua7f5\ua4f5\ua062\ua900\u7d7a\u8e4f\u2479\u8b23\u3472v\ua78c"), objectArray));
        }
        return methodNode;
    }

    private Range getConstructorRange(MethodNode methodNode) {
        int n = 0xADC629CC ^ 0xADC629CC;
        AbstractInsnNode abstractInsnNode = null;
        int n2 = 0x785CF07A ^ 0x785CF07A;
        int n3 = 0x63E6F21E ^ 0x63E6F21E;
        int n4 = 0xAF7F5D79 ^ 0xAF7F5D79;
        int n5 = 0x9056C560 ^ 0x6FA93A9F;
        Object object = methodNode.instructions.iterator();
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)object.next();
            if (abstractInsnNode2 instanceof LineNumberNode) {
                n2 = ((LineNumberNode)abstractInsnNode2).line;
                n = 0x702A3BE9 ^ 0x702A3BE8;
                continue;
            }
            if (abstractInsnNode2 instanceof MethodInsnNode) {
                if (abstractInsnNode2.getOpcode() != (0xFE6581A9 ^ 0xFE65811E) || !\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(((MethodInsnNode)abstractInsnNode2).name)) continue;
                if (n5 != (0x55BAF119 ^ 0xAA450EE6)) continue;
                n5 = methodNode.instructions.indexOf(abstractInsnNode2);
                n3 = n2;
                continue;
            }
            if (abstractInsnNode2.getOpcode() == (0x9DAFBC6F ^ 0x9DAFBCDA)) {
                n = 0x82497B5B ^ 0x82497B5B;
                continue;
            }
            if (abstractInsnNode2.getOpcode() != (0xD282C23F ^ 0xD282C28E)) continue;
            if (n != 0) {
                n4 = n2;
                continue;
            }
            n4 = n3;
            abstractInsnNode = abstractInsnNode2;
        }
        if (abstractInsnNode != null) {
            object = new LabelNode(new Label());
            methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)object);
            methodNode.instructions.insertBefore(abstractInsnNode, new LineNumberNode(n3, (LabelNode)object));
        }
        return new Range(n3, n4, n5);
    }

    protected final Deque<AbstractInsnNode> getInitialiser(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        Range range = this.getConstructorRange(methodNode);
        if (!range.isValid()) {
            return null;
        }
        int n = 0x7CDA68DF ^ 0x7CDA68DF;
        ArrayDeque<AbstractInsnNode> arrayDeque = new ArrayDeque<AbstractInsnNode>();
        int n2 = 0x63AD88BD ^ 0x63AD88BD;
        int n3 = 0x2CB5AFE7 ^ 0xD34A5018;
        LabelNode labelNode = null;
        Object object = methodNode.instructions.iterator(range.marker);
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)object.next();
            if (abstractInsnNode instanceof LineNumberNode) {
                n = ((LineNumberNode)abstractInsnNode).line;
                AbstractInsnNode abstractInsnNode2 = methodNode.instructions.get(methodNode.instructions.indexOf(abstractInsnNode) + (0x82D71AE ^ 0x82D71AF));
                if (n == range.end) {
                    if (abstractInsnNode2.getOpcode() != (0x7F3F21FF ^ 0x7F3F214E)) {
                        n2 = 0xF63BD48 ^ 0xF63BD49;
                        n3 = 0xCA7E2D14 ^ 0xCA7E2DA5;
                        continue;
                    }
                }
                n2 = range.excludes(n) ? 1 : 0;
                n3 = 0xBF98C541 ^ 0x40673ABE;
                continue;
            }
            if (n2 == 0) continue;
            if (labelNode != null) {
                arrayDeque.add(labelNode);
                labelNode = null;
            }
            if (abstractInsnNode instanceof LabelNode) {
                labelNode = (LabelNode)abstractInsnNode;
                continue;
            }
            int n4 = abstractInsnNode.getOpcode();
            if (n4 == n3) {
                n3 = 0x6917E5CF ^ 0x96E81A30;
                continue;
            }
            int[] nArray = INITIALISER_OPCODE_BLACKLIST;
            int n5 = nArray.length;
            for (int i = 0xD2142C0 ^ 0xD2142C0; i < n5; ++i) {
                int n6 = nArray[i];
                if (n4 != n6) continue;
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2472\u8b36\u3479v\ua7ea\ua4b0\ua031") + Bytecode.getOpcodeName(n4) + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e9\ua4a5\ua072\ua90a\u7d72\u8e4f\u243a\u8b7f\u3427j") + Integer.toHexString(n4).toUpperCase() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(";\ua7a6\ua4bc\ua07f\ua945\u7d75\u8e46\u247b\u8b24\u34642\ua7ef\ua4bb\ua078\ua911\u7d7f\u8e4b\u2476\u8b3e\u3464w\ua7f4"));
            }
            arrayDeque.add(abstractInsnNode);
        }
        object = (AbstractInsnNode)arrayDeque.peekLast();
        if (object != null) {
            if (((AbstractInsnNode)object).getOpcode() != (0xC0AB1F4E ^ 0xC0AB1FFB)) {
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437b\ua7e7\ua4a7\ua062\ua900\u7d36\u8e43\u2474\u8b3e\u3463{\ua7e7\ua4b9\ua078\ua916\u7d73\u8e58\u2436\u8b77\u3472j\ua7f6\ua4b0\ua072\ua911\u7d73\u8e4e\u243a\u8b67\u346fP\ua7b3\ua4f9\ua031\ua903\u7d79\u8e5f\u2474\u8b33\u3437\"\ua7fe") + Integer.toHexString(((AbstractInsnNode)object).getOpcode()) + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
            }
        }
        return arrayDeque;
    }

    protected final void injectInitialiser(MixinTargetContext mixinTargetContext, MethodNode methodNode, Deque<AbstractInsnNode> deque) {
        Map<LabelNode, LabelNode> map = Bytecode.cloneLabels(methodNode.instructions);
        AbstractInsnNode abstractInsnNode = this.findInitialiserInjectionPoint(mixinTargetContext, methodNode, deque);
        if (abstractInsnNode == null) {
            Object[] objectArray = new Object[0xD27C1086 ^ 0xD27C1087];
            objectArray[0x1E2525AC ^ 0x1E2525AC] = methodNode.desc;
            this.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437~\ua7e9\ua4b6\ua070\ua911\u7d73\u8e0a\u2473\u8b39\u347ef\ua7ef\ua4b4\ua07d\ua90c\u7d65\u8e4f\u2468\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3467}\ua7ef\ua4bb\ua065\ua945\u7d7f\u8e44\u243a\u8b6b\u347e|\ua7ef\ua4a1\ua02f\ua91e\u7d6b\u8e06\u243a\u8b3e\u3479{\ua7f2\ua4bc\ua070\ua909\u7d7f\u8e59\u247f\u8b25\u3437e\ua7e7\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b3a\u347ej\ua7e3\ua4b1\ua031\ua90c\u7d78\u8e04"), objectArray);
            return;
        }
        for (AbstractInsnNode abstractInsnNode2 : deque) {
            if (abstractInsnNode2 instanceof LabelNode) continue;
            if (abstractInsnNode2 instanceof JumpInsnNode) {
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("G\ua7e8\ua4a6\ua064\ua915\u7d66\u8e45\u2468\u8b23\u3472v\ua7a6\ua49f\ua044\ua928\u7d46\u8e0a\u2475\u8b27\u3474}\ua7e2\ua4b0\ua031\ua90c\u7d78\u8e0a\u2473\u8b39\u347ef\ua7ef\ua4b4\ua07d\ua90c\u7d65\u8e4f\u2468\u8b77\u347e|\ua7a6") + mixinTargetContext);
            }
            AbstractInsnNode abstractInsnNode3 = abstractInsnNode2.clone(map);
            methodNode.instructions.insert(abstractInsnNode, abstractInsnNode3);
            abstractInsnNode = abstractInsnNode3;
        }
    }

    protected AbstractInsnNode findInitialiserInjectionPoint(MixinTargetContext mixinTargetContext, MethodNode methodNode, Deque<AbstractInsnNode> deque) {
        HashSet<String> hashSet = new HashSet<String>();
        for (AbstractInsnNode object2 : deque) {
            if (object2.getOpcode() != (0xA816871E ^ 0xA81687AB)) continue;
            hashSet.add(MixinApplicatorStandard.fieldKey((FieldInsnNode)object2));
        }
        Object object3 = this.getInitialiserInjectionMode(mixinTargetContext.getEnvironment());
        String string = mixinTargetContext.getTargetClassInfo().getName();
        String string2 = mixinTargetContext.getTargetClassInfo().getSuperName();
        AbstractInsnNode abstractInsnNode = null;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            String string3;
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode2.getOpcode() == (0x1771DF91 ^ 0x1771DF26) && \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(((MethodInsnNode)abstractInsnNode2).name)) {
                string3 = ((MethodInsnNode)abstractInsnNode2).owner;
                if (!string3.equals(string) && !string3.equals(string2)) continue;
                abstractInsnNode = abstractInsnNode2;
                if (object3 != InitialiserInjectionMode.SAFE) continue;
                break;
            }
            if (abstractInsnNode2.getOpcode() != (0x23E68B ^ 0x23E63E) || object3 != InitialiserInjectionMode.DEFAULT || !hashSet.contains(string3 = MixinApplicatorStandard.fieldKey((FieldInsnNode)abstractInsnNode2))) continue;
            abstractInsnNode = abstractInsnNode2;
        }
        return abstractInsnNode;
    }

    private InitialiserInjectionMode getInitialiserInjectionMode(MixinEnvironment mixinEnvironment) {
        String string = mixinEnvironment.getOptionValue(MixinEnvironment.Option.INITIALISER_INJECTION_MODE);
        if (string == null) {
            return InitialiserInjectionMode.DEFAULT;
        }
        try {
            return InitialiserInjectionMode.valueOf(string.toUpperCase());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[0x2D335DE8 ^ 0x2D335DE9];
            objectArray[0xFC82534D ^ 0xFC82534D] = string;
            this.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437b\ua7e7\ua4a7\ua062\ua900\u7d36\u8e5f\u2474\u8b32\u346fb\ua7e3\ua4b6\ua065\ua900\u7d72\u8e0a\u246c\u8b36\u347bg\ua7e3\ua4f5\ua033\ua91e\u7d6b\u8e08\u243a\u8b31\u3478`\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u2434\u8b3e\u3479{\ua7f2\ua4bc\ua070\ua909\u7d7f\u8e59\u247f\u8b25\u345e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b1a\u3478v\ua7e3\ua4f9\ua031\ua917\u7d73\u8e5c\u247f\u8b25\u3463{\ua7e8\ua4b2\ua031\ua911\u7d79\u8e0a\u245e\u8b12\u3451S\ua7d3\ua499\ua045"), objectArray);
            return InitialiserInjectionMode.DEFAULT;
        }
    }

    private static String fieldKey(FieldInsnNode fieldInsnNode) {
        Object[] objectArray = new Object[0xD6880C0F ^ 0xD6880C0D];
        objectArray[0x28182941 ^ 0x28182941] = fieldInsnNode.desc;
        objectArray[0x327224CE ^ 0x327224CF] = fieldInsnNode.name;
        return String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4ef\ua034\ua916"), objectArray);
    }

    protected void prepareInjections(MixinTargetContext mixinTargetContext) {
        mixinTargetContext.prepareInjections();
    }

    protected void applyInjections(MixinTargetContext mixinTargetContext) {
        mixinTargetContext.applyInjections();
    }

    protected void applyAccessors(MixinTargetContext mixinTargetContext) {
        List<MethodNode> list = mixinTargetContext.generateAccessors();
        for (MethodNode methodNode : list) {
            if (methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("."))) continue;
            this.mergeMethod(mixinTargetContext, methodNode);
        }
    }

    protected void checkMethodVisibility(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        if (Bytecode.hasFlag(methodNode, 0x489E5CA9 ^ 0x489E5CA1)) {
            if (!Bytecode.hasFlag(methodNode, 0xBB1D3FCA ^ 0xBB1D3FC8)) {
                if (!Bytecode.hasFlag(methodNode, 0x6A26EE96 ^ 0x6A26FE96) && Annotations.getVisible(methodNode, Overwrite.class) == null) {
                    Object[] objectArray = new Object[0x207A06F6 ^ 0x207A06F4];
                    objectArray[0x8F98DCB0 ^ 0x8F98DCB0] = mixinTargetContext;
                    objectArray[0x9260693 ^ 0x9260692] = methodNode;
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474}\ua7e8\ua4a1\ua070\ua90c\u7d78\u8e59\u243a\u8b39\u3478|\ua7ab\ua4a5\ua063\ua90c\u7d60\u8e4b\u246e\u8b32\u3437a\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua940\u7d65"), objectArray));
                }
            }
        }
    }

    protected void applySourceMap(TargetClassContext targetClassContext) {
        this.targetClass.sourceDebug = targetClassContext.getSourceMap().toString();
    }

    protected void checkMethodConstraints(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        for (Class<? extends Annotation> clazz : CONSTRAINED_ANNOTATIONS) {
            AnnotationNode annotationNode = Annotations.getVisible(methodNode, clazz);
            if (annotationNode == null) continue;
            this.checkConstraints(mixinTargetContext, methodNode, annotationNode);
        }
    }

    protected final void checkConstraints(MixinTargetContext mixinTargetContext, MethodNode methodNode, AnnotationNode annotationNode) {
        try {
            ConstraintParser.Constraint constraint = ConstraintParser.parse(annotationNode);
            try {
                constraint.check(mixinTargetContext.getEnvironment());
            }
            catch (ConstraintViolationException constraintViolationException) {
                Object[] objectArray = new Object[0x6811953E ^ 0x6811953D];
                objectArray[0x59788CE1 ^ 0x59788CE1] = constraintViolationException.getMessage();
                objectArray[0x5CF98299 ^ 0x5CF98298] = methodNode;
                objectArray[0x394C896E ^ 0x394C896C] = mixinTargetContext;
                String string = String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e9\ua4bb\ua062\ua911\u7d64\u8e4b\u2473\u8b39\u34632\ua7f0\ua4bc\ua07e\ua909\u7d77\u8e5e\u2473\u8b38\u3479(\ua7a6\ua4f0\ua062\ua945\u7d79\u8e44\u243a\u8b72\u34642\ua7ef\ua4bb\ua031\ua940\u7d65"), objectArray);
                this.logger.warn(string);
                if (!mixinTargetContext.getEnvironment().getOption(MixinEnvironment.Option.IGNORE_CONSTRAINTS)) {
                    throw new InvalidMixinException(mixinTargetContext, string, (Throwable)constraintViolationException);
                }
            }
        }
        catch (InvalidConstraintException invalidConstraintException) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, invalidConstraintException.getMessage());
        }
    }

    protected final MethodNode findTargetMethod(MethodNode methodNode) {
        for (MethodNode methodNode2 : this.targetClass.methods) {
            if (!methodNode2.name.equals(methodNode.name) || !methodNode2.desc.equals(methodNode.desc)) continue;
            return methodNode2;
        }
        return null;
    }

    protected final FieldNode findTargetField(FieldNode fieldNode) {
        for (FieldNode fieldNode2 : this.targetClass.fields) {
            if (!fieldNode2.name.equals(fieldNode.name)) continue;
            return fieldNode2;
        }
        return null;
    }

    static {
        int[] nArray = new int[0x27F67886 ^ 0x27F6789C];
        nArray[0xCB1CB009 ^ 0xCB1CB009] = 0xBEBA91E9 ^ 0xBEBA9158;
        nArray[0x9A925BB2 ^ 0x9A925BB3] = 0xC82623D1 ^ 0xC82623C4;
        nArray[0x380F3594 ^ 0x380F3596] = 0x26B1E23A ^ 0x26B1E22C;
        nArray[0x94D4CFE0 ^ 0x94D4CFE3] = 0x38E0CC47 ^ 0x38E0CC50;
        nArray[0xD333C051 ^ 0xD333C055] = 0xFBE36A98 ^ 0xFBE36A80;
        nArray[0xB017E9A9 ^ 0xB017E9AC] = 0xBA485E84 ^ 0xBA485EAA;
        nArray[0x335BE7FE ^ 0x335BE7F8] = 0xFD067A1C ^ 0xFD067A33;
        nArray[0x93EB5D39 ^ 0x93EB5D3E] = 0x37819D4F ^ 0x37819D7F;
        nArray[0xE46A94A9 ^ 0xE46A94A1] = 0xD153BA59 ^ 0xD153BA68;
        nArray[0x257BCE88 ^ 0x257BCE81] = 0x2D03B6A4 ^ 0x2D03B696;
        nArray[0x966D084E ^ 0x966D0844] = 0x7A832AC7 ^ 0x7A832AF4;
        nArray[0xD36862C9 ^ 0xD36862C2] = 0xCB16456A ^ 0xCB16455E;
        nArray[0x24330A0F ^ 0x24330A03] = 0x8BCBD1A2 ^ 0x8BCBD197;
        nArray[0xFE73C981 ^ 0xFE73C98C] = 0xDAA8D879 ^ 0xDAA8D84F;
        nArray[0x22B9FE70 ^ 0x22B9FE7E] = 0xB0A4D93B ^ 0xB0A4D90C;
        nArray[0x73724E7C ^ 0x73724E73] = 0x6A3F9501 ^ 0x6A3F9539;
        nArray[0xE91EDBD2 ^ 0xE91EDBC2] = 0x93AB8F41 ^ 0x93AB8F78;
        nArray[0x14512E61 ^ 0x14512E70] = 0x816EAD8E ^ 0x816EADB4;
        nArray[0xDECD07AE ^ 0xDECD07BC] = 0x2AA655EA ^ 0x2AA655A5;
        nArray[0xF3AB1BFA ^ 0xF3AB1BE9] = 0xC15105FD ^ 0xC15105AD;
        nArray[0x590EBE72 ^ 0x590EBE66] = 0x20A01454 ^ 0x20A01405;
        nArray[0x6BC05979 ^ 0x6BC0596C] = 0x2FB9A429 ^ 0x2FB9A47B;
        nArray[0xBB9C6FC2 ^ 0xBB9C6FD4] = 0xD773E78A ^ 0xD773E7D9;
        nArray[0x8517A399 ^ 0x8517A38E] = 0x9ECA37DF ^ 0x9ECA378B;
        nArray[0xFCFABA70 ^ 0xFCFABA68] = 0x816537CC ^ 0x81653799;
        nArray[0xF2C989BE ^ 0xF2C989A7] = 0xD7EB3511 ^ 0xD7EB3547;
        INITIALISER_OPCODE_BLACKLIST = nArray;
    }

    class Range {
        final int start;
        final int end;
        final int marker;

        Range(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.marker = n3;
        }

        boolean isValid() {
            return (this.start != 0 && this.end != 0 && this.end >= this.start ? 0xDF002EFD ^ 0xDF002EFC : 0x74B403A3 ^ 0x74B403A3) != 0;
        }

        boolean contains(int n) {
            return (n >= this.start && n <= this.end ? 0x3E8DD56E ^ 0x3E8DD56F : 0x4D0213F7 ^ 0x4D0213F7) != 0;
        }

        boolean excludes(int n) {
            return (n < this.start || n > this.end ? 0xA470E81A ^ 0xA470E81B : 0x94F80971 ^ 0x94F80971) != 0;
        }

        public String toString() {
            Object[] objectArray = new Object[0x5FA512B0 ^ 0x5FA512B4];
            objectArray[0xED9357C ^ 0xED9357C] = this.start;
            objectArray[0x94B067FA ^ 0x94B067FB] = this.end;
            objectArray[0x33FFF7F4 ^ 0x33FFF7F6] = this.marker;
            objectArray[0xA0F2D035 ^ 0xA0F2D036] = this.isValid();
            return String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("@\ua7e7\ua4bb\ua076\ua900\u7d4d\u8e0f\u247e\u8b7a\u3432v\ua7aa\ua4f0\ua075\ua949\u7d60\u8e4b\u2476\u8b3e\u3473/\ua7a3\ua4a6\ua038"), objectArray);
        }
    }

    static final class InitialiserInjectionMode
    extends Enum<InitialiserInjectionMode> {
        public static final /* enum */ InitialiserInjectionMode DEFAULT = new InitialiserInjectionMode();
        public static final /* enum */ InitialiserInjectionMode SAFE = new InitialiserInjectionMode();
        private static final /* synthetic */ InitialiserInjectionMode[] $VALUES;

        public static InitialiserInjectionMode[] values() {
            return (InitialiserInjectionMode[])$VALUES.clone();
        }

        public static InitialiserInjectionMode valueOf(String string) {
            return Enum.valueOf(InitialiserInjectionMode.class, string);
        }

        static {
            InitialiserInjectionMode[] initialiserInjectionModeArray = new InitialiserInjectionMode[0xB698DB1 ^ 0xB698DB3];
            initialiserInjectionModeArray[0x9475C2E8 ^ 0x9475C2E8] = DEFAULT;
            initialiserInjectionModeArray[0xB1432514 ^ 0xB1432515] = SAFE;
            $VALUES = initialiserInjectionModeArray;
        }
    }

    static final class ApplicatorPass
    extends Enum<ApplicatorPass> {
        public static final /* enum */ ApplicatorPass MAIN = new ApplicatorPass();
        public static final /* enum */ ApplicatorPass PREINJECT = new ApplicatorPass();
        public static final /* enum */ ApplicatorPass INJECT = new ApplicatorPass();
        private static final /* synthetic */ ApplicatorPass[] $VALUES;

        public static ApplicatorPass[] values() {
            return (ApplicatorPass[])$VALUES.clone();
        }

        public static ApplicatorPass valueOf(String string) {
            return Enum.valueOf(ApplicatorPass.class, string);
        }

        static {
            ApplicatorPass[] applicatorPassArray = new ApplicatorPass[0x16897A5A ^ 0x16897A59];
            applicatorPassArray[0x579BF6E9 ^ 0x579BF6E9] = MAIN;
            applicatorPassArray[0xCE91C093 ^ 0xCE91C092] = PREINJECT;
            applicatorPassArray[0x90230991 ^ 0x90230993] = INJECT;
            $VALUES = applicatorPassArray;
        }
    }
}

