/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.transformers.MixinClassWriter;
import org.spongepowered.asm.transformers.TreeTransformer;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

class MixinPostProcessor
extends TreeTransformer
implements MixinConfig.IListener {
    private final Set<String> syntheticInnerClasses = new HashSet<String>();
    private final Map<String, MixinInfo> accessorMixins = new HashMap<String, MixinInfo>();
    private final Set<String> loadable = new HashSet<String>();

    MixinPostProcessor() {
    }

    @Override
    public void onInit(MixinInfo mixinInfo) {
        for (String string : mixinInfo.getSyntheticInnerClasses()) {
            this.registerSyntheticInner(string.replace((char)(0x269D3C5B ^ 0x269D3C74), (char)(0xB192DDE ^ 0xB192DF0)));
        }
    }

    @Override
    public void onPrepare(MixinInfo mixinInfo) {
        String string = mixinInfo.getClassName();
        if (mixinInfo.isLoadable()) {
            this.registerLoadable(string);
        }
        if (mixinInfo.isAccessor()) {
            this.registerAccessor(mixinInfo);
        }
    }

    void registerSyntheticInner(String string) {
        this.syntheticInnerClasses.add(string);
    }

    void registerLoadable(String string) {
        this.loadable.add(string);
    }

    void registerAccessor(MixinInfo mixinInfo) {
        this.registerLoadable(mixinInfo.getClassName());
        this.accessorMixins.put(mixinInfo.getClassName(), mixinInfo);
    }

    boolean canTransform(String string) {
        return (this.syntheticInnerClasses.contains(string) || this.loadable.contains(string) ? 0x5201AA9 ^ 0x5201AA8 : 0x3A2704AE ^ 0x3A2704AE) != 0;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isDelegationExcluded() {
        return (0x1D647ECB ^ 0x1D647ECA) != 0;
    }

    @Override
    public byte[] transformClassBytes(String string, String string2, byte[] byArray) {
        if (this.syntheticInnerClasses.contains(string2)) {
            return this.processSyntheticInner(byArray);
        }
        if (this.accessorMixins.containsKey(string2)) {
            MixinInfo mixinInfo = this.accessorMixins.get(string2);
            return this.processAccessor(byArray, mixinInfo);
        }
        return byArray;
    }

    private byte[] processSyntheticInner(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        MixinClassWriter mixinClassWriter = new MixinClassWriter(classReader, 0x88F00A04 ^ 0x88F00A04);
        ClassVisitor classVisitor = new ClassVisitor(0xCA9700D ^ 0xCAC700D, mixinClassWriter){

            @Override
            public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
                super.visit(n, n2 | 0x8977AF94 ^ 0x8977AF95, string, string2, string3, stringArray);
            }

            @Override
            public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
                if ((n & (0x54635F2F ^ 0x54635F29)) == 0) {
                    n |= 0x91C455BE ^ 0x91C455BF;
                }
                return super.visitField(n, string, string2, string3, object);
            }

            @Override
            public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
                if ((n & (0xDF07B298 ^ 0xDF07B29E)) == 0) {
                    n |= 0x9956004E ^ 0x9956004F;
                }
                return super.visitMethod(n, string, string2, string3, stringArray);
            }
        };
        classReader.accept(classVisitor, 0xC7AC20EA ^ 0xC7AC20E2);
        return mixinClassWriter.toByteArray();
    }

    private byte[] processAccessor(byte[] byArray, MixinInfo mixinInfo) {
        if (!MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8)) {
            return byArray;
        }
        int n = 0xB7ADB16 ^ 0xB7ADB16;
        MixinInfo.MixinClassNode mixinClassNode = mixinInfo.getClassNode(0x57312A2C ^ 0x57312A2C);
        ClassInfo classInfo = mixinInfo.getTargets().get(0xB92F4C9E ^ 0xB92F4C9E);
        for (MixinInfo.MixinMethodNode mixinMethodNode : mixinClassNode.mixinMethods) {
            if (!Bytecode.hasFlag(mixinMethodNode, 0x3E6D1ED6 ^ 0x3E6D1EDE)) continue;
            AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(Accessor.class);
            AnnotationNode annotationNode2 = mixinMethodNode.getVisibleAnnotation(Invoker.class);
            if (annotationNode == null && annotationNode2 == null) continue;
            ClassInfo.Method method = MixinPostProcessor.getAccessorMethod(mixinInfo, mixinMethodNode, classInfo);
            MixinPostProcessor.createProxy(mixinMethodNode, classInfo, method);
            n = 0xD2B7C9B7 ^ 0xD2B7C9B6;
        }
        if (n != 0) {
            return this.writeClass(mixinClassNode);
        }
        return byArray;
    }

    private static ClassInfo.Method getAccessorMethod(MixinInfo mixinInfo, MethodNode methodNode, ClassInfo classInfo) throws MixinTransformerError {
        ClassInfo.Method method = mixinInfo.getClassInfo().findMethod(methodNode, 0xA650B156 ^ 0xA650B15C);
        if (!method.isRenamed()) {
            throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7f5\ua4a1\ua070\ua911\u7d73\u8e10\u243a") + mixinInfo + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ea\ua4ba\ua070\ua901\u7d73\u8e4e\u243a\u8b35\u3472t\ua7e9\ua4a7\ua074\ua945") + classInfo + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7f1\ua4b4\ua062\ua945\u7d75\u8e45\u2474\u8b31\u3478`\ua7eb\ua4b0\ua075"));
        }
        return method;
    }

    private static void createProxy(MethodNode methodNode, ClassInfo classInfo, ClassInfo.Method method) {
        methodNode.instructions.clear();
        Type[] typeArray = Type.getArgumentTypes(methodNode.desc);
        Type type = Type.getReturnType(methodNode.desc);
        Bytecode.loadArgs(typeArray, methodNode.instructions, 0x3F47CB3D ^ 0x3F47CB3D);
        methodNode.instructions.add(new MethodInsnNode(0xAB9D1FBC ^ 0xAB9D1F04, classInfo.getName(), method.getName(), methodNode.desc, (0xF6563F62 ^ 0xF6563F62) != 0));
        methodNode.instructions.add(new InsnNode(type.getOpcode(0x9A4B29FA ^ 0x9A4B2956)));
        methodNode.maxStack = Bytecode.getFirstNonArgLocalIndex(typeArray, (0x6979BF70 ^ 0x6979BF70) != 0);
        methodNode.maxLocals = 0xEDB5D1CB ^ 0xEDB5D1CB;
    }
}

