/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.gen.throwables.InvalidAccessorException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MethodMapper;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.perf.Profiler;
import org.spongepowered.asm.util.throwables.SyntheticBridgeException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

class MixinPreProcessorStandard {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected final MixinInfo mixin;
    protected final MixinInfo.MixinClassNode classNode;
    protected final MixinEnvironment env;
    protected final Profiler profiler = MixinEnvironment.getProfiler();
    private final boolean verboseLogging;
    private final boolean strictUnique;
    private boolean prepared;
    private boolean attached;

    MixinPreProcessorStandard(MixinInfo mixinInfo, MixinInfo.MixinClassNode mixinClassNode) {
        this.mixin = mixinInfo;
        this.classNode = mixinClassNode;
        this.env = mixinInfo.getParent().getEnvironment();
        this.verboseLogging = this.env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE);
        this.strictUnique = this.env.getOption(MixinEnvironment.Option.DEBUG_UNIQUE);
    }

    final MixinPreProcessorStandard prepare() {
        if (this.prepared) {
            return this;
        }
        this.prepared = 0xDDB01878 ^ 0xDDB01879;
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("b\ua7f4\ua4b0\ua061\ua904\u7d64\u8e4f"));
        for (MixinInfo.MixinMethodNode object : this.classNode.mixinMethods) {
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(object);
            this.prepareMethod(object, method);
        }
        for (FieldNode fieldNode : this.classNode.fields) {
            this.prepareField(fieldNode);
        }
        section.end();
        return this;
    }

    protected void prepareMethod(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        this.prepareShadow(mixinMethodNode, method);
        this.prepareSoftImplements(mixinMethodNode, method);
    }

    protected void prepareShadow(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        AnnotationNode annotationNode = Annotations.getVisible(mixinMethodNode, Shadow.class);
        if (annotationNode == null) {
            return;
        }
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"), Shadow.class);
        if (mixinMethodNode.name.startsWith(string)) {
            Object[] objectArray = new Object[0x978608F7 ^ 0x978608F5];
            objectArray[0xE35032E2 ^ 0xE35032E2] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("}\ua7f4\ua4bc\ua076\ua90c\u7d78\u8e4b\u2476\u8b19\u3476\u007f\ua7e3");
            objectArray[0x359F35B4 ^ 0x359F35B5] = mixinMethodNode.name;
            Annotations.setVisible(mixinMethodNode, MixinRenamed.class, objectArray);
            String string2 = mixinMethodNode.name.substring(string.length());
            mixinMethodNode.name = method.renameTo(string2);
        }
    }

    protected void prepareSoftImplements(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        for (InterfaceInfo interfaceInfo : this.mixin.getSoftImplements()) {
            if (!interfaceInfo.renameMethod(mixinMethodNode)) continue;
            method.renameTo(mixinMethodNode.name);
        }
    }

    protected void prepareField(FieldNode fieldNode) {
    }

    final MixinPreProcessorStandard conform(TargetClassContext targetClassContext) {
        return this.conform(targetClassContext.getClassInfo());
    }

    final MixinPreProcessorStandard conform(ClassInfo classInfo) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7e9\ua4bb\ua077\ua90a\u7d64\u8e47"));
        for (MixinInfo.MixinMethodNode mixinMethodNode : this.classNode.mixinMethods) {
            if (!mixinMethodNode.isInjector()) continue;
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0xB3272381 ^ 0xB327238B);
            this.conformInjector(classInfo, mixinMethodNode, method);
        }
        section.end();
        return this;
    }

    private void conformInjector(ClassInfo classInfo, MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        MethodMapper methodMapper = classInfo.getMethodMapper();
        methodMapper.remapHandlerMethod(this.mixin, mixinMethodNode, method);
    }

    MixinTargetContext createContextFor(TargetClassContext targetClassContext) {
        MixinTargetContext mixinTargetContext = new MixinTargetContext(this.mixin, this.classNode, targetClassContext);
        this.conform(targetClassContext);
        this.attach(mixinTargetContext);
        return mixinTargetContext;
    }

    final MixinPreProcessorStandard attach(MixinTargetContext mixinTargetContext) {
        if (this.attached) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("B\ua7f4\ua4b0\ua061\ua917\u7d79\u8e49\u247f\u8b24\u3464}\ua7f4\ua4f5\ua066\ua904\u7d65\u8e0a\u247b\u8b3b\u3465w\ua7e7\ua4b1\ua068\ua945\u7d77\u8e5e\u246e\u8b36\u3474z\ua7e3\ua4b1"));
        }
        this.attached = 0xBB436CAE ^ 0xBB436CAF;
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("s\ua7f2\ua4a1\ua070\ua906\u7d7e"));
        Profiler.Section section2 = this.profiler.begin(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e59"));
        this.attachMethods(mixinTargetContext);
        section2 = section2.next(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("t\ua7ef\ua4b0\ua07d\ua901\u7d65"));
        this.attachFields(mixinTargetContext);
        section2 = section2.next(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("f\ua7f4\ua4b4\ua07f\ua916\u7d70\u8e45\u2468\u8b3a"));
        this.transform(mixinTargetContext);
        section2.end();
        section.end();
        return this;
    }

    protected void attachMethods(MixinTargetContext mixinTargetContext) {
        Iterator<MixinInfo.MixinMethodNode> iterator = this.classNode.mixinMethods.iterator();
        while (iterator.hasNext()) {
            MixinInfo.MixinMethodNode mixinMethodNode = iterator.next();
            if (!this.validateMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            if (this.attachInjectorMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addMixinMethod(mixinMethodNode);
                continue;
            }
            if (this.attachAccessorMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            if (this.attachShadowMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addShadowMethod(mixinMethodNode);
                iterator.remove();
                continue;
            }
            if (this.attachOverwriteMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addMixinMethod(mixinMethodNode);
                continue;
            }
            if (this.attachUniqueMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            this.attachMethod(mixinTargetContext, mixinMethodNode);
            mixinTargetContext.addMixinMethod(mixinMethodNode);
        }
    }

    protected boolean validateMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return (0xA885039B ^ 0xA885039A) != 0;
    }

    protected boolean attachInjectorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return mixinMethodNode.isInjector();
    }

    protected boolean attachAccessorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return (this.attachAccessorMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.ACCESSOR) || this.attachAccessorMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.INVOKER) ? 0xC6B9C900 ^ 0xC6B9C901 : 0x49D4C5F9 ^ 0x49D4C5F9) != 0;
    }

    protected boolean attachAccessorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(specialMethod.annotation);
        if (annotationNode == null) {
            return (0x4458B134 ^ 0x4458B134) != 0;
        }
        String string = (Object)((Object)specialMethod) + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a") + mixinMethodNode.name;
        ClassInfo.Method method = this.getSpecialMethod(mixinMethodNode, specialMethod);
        if (MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8) && method.isStatic()) {
            if (this.mixin.getTargets().size() > (0xD86D39C2 ^ 0xD86D39C3)) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4bb\ua031\ua908\u7d63\u8e46\u246e\u8b3e\u343af\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2477\u8b3e\u346f{\ua7e8\ua4f5\ua078\ua916\u7d36\u8e43\u2474\u8b21\u3476~\ua7ef\ua4b1\ua03f\ua945\u7d5b\u8e43\u2462\u8b3e\u34792\ua7eb\ua4a0\ua062\ua911\u7d36\u8e42\u247b\u8b21\u34722\ua7e3\ua4ad\ua070\ua906\u7d62\u8e46\u2463\u8b77\u34262\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u2434"));
            }
            String string2 = mixinTargetContext.getUniqueName(mixinMethodNode, (0x968EEDC ^ 0x968EEDD) != 0);
            Object[] objectArray = new Object[0x332B3FA8 ^ 0x332B3FAC];
            objectArray[0x31B89369 ^ 0x31B89369] = mixinMethodNode.name;
            objectArray[0x654AAD7E ^ 0x654AAD7F] = mixinMethodNode.desc;
            objectArray[0xC4ED15C2 ^ 0xC4ED15C0] = string2;
            objectArray[0xA6530E58 ^ 0xA6530E5B] = this.mixin;
            logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e51\u2467\u8b77\u3463}\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a"), objectArray);
            mixinMethodNode.name = method.renameTo(string2);
        } else {
            if (!method.isAbstract()) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b36\u3475a\ua7f2\ua4a7\ua070\ua906\u7d62"));
            }
            if (method.isStatic()) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e5\ua4b4\ua07f\ua90b\u7d79\u8e5e\u243a\u8b35\u34722\ua7f5\ua4a1\ua070\ua911\u7d7f\u8e49"));
            }
        }
        mixinTargetContext.addAccessorMethod(mixinMethodNode, specialMethod.annotation);
        return (0x55B09E31 ^ 0x55B09E30) != 0;
    }

    protected boolean attachShadowMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return this.attachSpecialMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.SHADOW);
    }

    protected boolean attachOverwriteMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return this.attachSpecialMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.OVERWRITE);
    }

    protected boolean attachSpecialMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(specialMethod.annotation);
        if (annotationNode == null) {
            return (0x9EAAC122 ^ 0x9EAAC122) != 0;
        }
        if (specialMethod.isOverwrite) {
            this.checkMixinNotUnique(mixinMethodNode, specialMethod);
        }
        ClassInfo.Method method = this.getSpecialMethod(mixinMethodNode, specialMethod);
        MethodNode methodNode = mixinTargetContext.findMethod(mixinMethodNode, annotationNode);
        if (methodNode == null) {
            if (specialMethod.isOverwrite) {
                return (0x2549D056 ^ 0x2549D056) != 0;
            }
            methodNode = mixinTargetContext.findRemappedMethod(mixinMethodNode);
            if (methodNode == null) {
                Object[] objectArray = new Object[0xD6930DC2 ^ 0xD6930DC4];
                objectArray[0x556F690C ^ 0x556F690C] = specialMethod;
                objectArray[0xC222D6CD ^ 0xC222D6CC] = mixinMethodNode.name;
                objectArray[0x14C693C2 ^ 0x14C693C0] = this.mixin;
                objectArray[0x83235A9D ^ 0x83235A9E] = mixinTargetContext.getTarget();
                objectArray[0x290D1E9D ^ 0x290D1E99] = mixinTargetContext.getReferenceMapper().getStatus();
                objectArray[0xD9EDDA58 ^ 0xD9EDDA5D] = MixinPreProcessorStandard.getDynamicInfo(mixinMethodNode);
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3460s\ua7f5\ua4f5\ua07f\ua90a\u7d62\u8e0a\u2476\u8b38\u3474s\ua7f2\ua4b0\ua075\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u3474~\ua7e7\ua4a6\ua062\ua945\u7d33\u8e59\u2434\u8b77\u3432a\ua7a3\ua4a6"), objectArray));
            }
            mixinMethodNode.name = method.renameTo(methodNode.name);
        }
        if (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
            Object[] objectArray = new Object[0x8D27276C ^ 0x8D27276E];
            objectArray[0xD80676CF ^ 0xD80676CF] = mixinMethodNode.name;
            objectArray[0x237A84B3 ^ 0x237A84B2] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\\\ua7ef\ua4b6\ua074\ua945\u7d62\u8e58\u2463\u8b76\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e4b\u2476\u8b3e\u3476a\ua7a6\ua4b4\ua031\ua906\u7d79\u8e44\u2469\u8b23\u3465g\ua7e5\ua4a1\ua07e\ua917"), objectArray));
        }
        if (!Bytecode.compareFlags(mixinMethodNode, methodNode, 0xE1EE82F4 ^ 0xE1EE82FC)) {
            Object[] objectArray = new Object[0xADCB287D ^ 0xADCB287E];
            objectArray[0x8BE0EEC9 ^ 0x8BE0EEC9] = specialMethod;
            objectArray[0x4271BCE ^ 0x4271BCF] = mixinMethodNode.name;
            objectArray[0xF5EF36D4 ^ 0xF5EF36D6] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("A\ua7d2\ua494\ua045\ua92c\u7d55\u8e0a\u2477\u8b38\u3473{\ua7e0\ua4bc\ua074\ua917\u7d36\u8e45\u247c\u8b77\u3432a\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3432a\ua7a6\ua4bc\ua07f\ua945\u7d33\u8e59\u243a\u8b33\u3478w\ua7f5\ua4f5\ua07f\ua90a\u7d62\u8e0a\u2477\u8b36\u3463q\ua7ee\ua4f5\ua065\ua90d\u7d73\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1"), objectArray));
        }
        this.conformVisibility(mixinTargetContext, mixinMethodNode, specialMethod, methodNode);
        if (!methodNode.name.equals(mixinMethodNode.name)) {
            if (specialMethod.isOverwrite) {
                if ((methodNode.access & (0xABDF8A90 ^ 0xABDF8A92)) == 0) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\\\ua7e9\ua4bb\ua03c\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3476~\ua7ef\ua4b4\ua062\ua900\u7d72\u8e04\u243a\u8b11\u3478g\ua7e8\ua4b1\ua031") + methodNode.name);
                }
            }
            mixinMethodNode.name = method.renameTo(methodNode.name);
        }
        return (0xC819ACDB ^ 0xC819ACDA) != 0;
    }

    private void conformVisibility(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod, MethodNode methodNode) {
        Bytecode.Visibility visibility = Bytecode.getVisibility(methodNode);
        Bytecode.Visibility visibility2 = Bytecode.getVisibility(mixinMethodNode);
        if (visibility2.ordinal() >= visibility.ordinal()) {
            if (visibility == Bytecode.Visibility.PRIVATE && visibility2.ordinal() > Bytecode.Visibility.PRIVATE.ordinal()) {
                mixinTargetContext.getTarget().addUpgradedMethod(methodNode);
            }
            return;
        }
        Object[] objectArray = new Object[0x9CEA0EB3 ^ 0x9CEA0EB6];
        objectArray[0x4C81B8F9 ^ 0x4C81B8F9] = visibility2;
        objectArray[0xA0462685 ^ 0xA0462684] = specialMethod;
        objectArray[0x95B6C52 ^ 0x95B6C50] = mixinMethodNode.name;
        objectArray[0x3066BE3F ^ 0x3066BE3C] = this.mixin;
        objectArray[0x437FBC86 ^ 0x437FBC82] = visibility;
        String string = String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f5\ua034\ua916\u7d36\u8e47\u247f\u8b23\u347f}\ua7e2\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b6\ua070\ua90b\u7d78\u8e45\u246e\u8b77\u3465w\ua7e2\ua4a0\ua072\ua900\u7d36\u8e5c\u2473\u8b24\u347ep\ua7ef\ua4b9\ua078\ua91c\u7d36\u8e45\u247c\u8b77\u3432a\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901"), objectArray);
        if (specialMethod.isOverwrite && !this.mixin.getParent().conformOverwriteVisibility()) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, string);
        }
        if (visibility2 == Bytecode.Visibility.PRIVATE) {
            if (specialMethod.isOverwrite) {
                Object[] objectArray2 = new Object[0x1E76F2DE ^ 0x1E76F2DF];
                objectArray2[0xD636A54A ^ 0xD636A54A] = string;
                logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("A\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u2478\u8b3e\u3479v\ua7ef\ua4bb\ua076\ua945\u7d60\u8e43\u2475\u8b3b\u3476f\ua7ef\ua4ba\ua07f\ua95f\u7d36\u8e51\u2467\u8b7b\u3437d\ua7ef\ua4a6\ua078\ua907\u7d7f\u8e46\u2473\u8b23\u346e2\ua7f1\ua4bc\ua07d\ua909\u7d36\u8e48\u247f\u8b77\u3462b\ua7e1\ua4a7\ua070\ua901\u7d73\u8e4e\u2434"), objectArray2);
            }
            mixinTargetContext.addUpgradedMethod(mixinMethodNode);
            Bytecode.setVisibility((MethodNode)mixinMethodNode, visibility);
        }
    }

    protected ClassInfo.Method getSpecialMethod(MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0xC9611708 ^ 0xC9611702);
        this.checkMethodNotUnique(method, specialMethod);
        return method;
    }

    protected void checkMethodNotUnique(ClassInfo.Method method, SpecialMethod specialMethod) {
        if (method.isUnique()) {
            Object[] objectArray = new Object[0x93BC800D ^ 0x93BC800E];
            objectArray[0xFA67568C ^ 0xFA67568C] = specialMethod;
            objectArray[0x58860A3A ^ 0x58860A3B] = method.getName();
            objectArray[0x4B2F734B ^ 0x4B2F7349] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73"), objectArray));
        }
    }

    protected void checkMixinNotUnique(MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        if (this.mixin.isUnique()) {
            Object[] objectArray = new Object[0x27625F7C ^ 0x27625F7F];
            objectArray[0x33065E05 ^ 0x33065E05] = specialMethod;
            objectArray[0x1ACBFEF4 ^ 0x1ACBFEF5] = mixinMethodNode.name;
            objectArray[0x4F528AE0 ^ 0x4F528AE2] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77\u347e|\ua7a6\ua4b4\ua031\ua925\u7d43\u8e44\u2473\u8b26\u3462w\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b72\u3464"), objectArray));
        }
    }

    protected boolean attachUniqueMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        String string;
        MethodNode methodNode;
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0xE6CA5041 ^ 0xE6CA504B);
        if (method == null || !method.isUnique() && !this.mixin.isUnique() && !method.isSynthetic()) {
            return (0x290C2F13 ^ 0x290C2F13) != 0;
        }
        if (method.isSynthetic()) {
            mixinTargetContext.transformDescriptor(mixinMethodNode);
            method.remapTo(mixinMethodNode.desc);
        }
        if ((methodNode = mixinTargetContext.findMethod(mixinMethodNode, null)) == null) {
            return (0x6299D65D ^ 0x6299D65D) != 0;
        }
        String string2 = string = method.isSynthetic() ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("a\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("R\ua7d3\ua4bb\ua078\ua914\u7d63\u8e4f");
        if (Bytecode.getVisibility(mixinMethodNode).ordinal() < Bytecode.Visibility.PUBLIC.ordinal()) {
            String string3 = mixinTargetContext.getUniqueName(mixinMethodNode, (0x39611483 ^ 0x39611483) != 0);
            Object[] objectArray = new Object[0x7168B127 ^ 0x7168B122];
            objectArray[0x86F74877 ^ 0x86F74877] = string;
            objectArray[0xD18CC337 ^ 0xD18CC336] = mixinMethodNode.name;
            objectArray[0x64F79183 ^ 0x64F79181] = mixinMethodNode.desc;
            objectArray[0xDE229214 ^ 0xDE229217] = string3;
            objectArray[0x9B76C6A ^ 0x9B76C6E] = this.mixin;
            logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u346co\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7fd\ua4a8\ua031\ua911\u7d79\u8e0a\u2461\u8b2a\u3437{\ua7e8\ua4f5\ua06a\ua918"), objectArray);
            mixinMethodNode.name = method.renameTo(string3);
            return (0x546279D1 ^ 0x546279D1) != 0;
        }
        if (this.strictUnique) {
            Object[] objectArray = new Object[0x8BAE3E9E ^ 0x8BAE3E98];
            objectArray[0xE37762B9 ^ 0xE37762B9] = string;
            objectArray[0xBCD1640D ^ 0xBCD1640C] = mixinMethodNode.name;
            objectArray[0x240EBE59 ^ 0x240EBE5B] = this.mixin;
            objectArray[0xFB8566EC ^ 0xFB8566EF] = methodNode.name;
            objectArray[0x340A2FF2 ^ 0x340A2FF6] = methodNode.desc;
            objectArray[0xB829CC51 ^ 0xB829CC54] = mixinTargetContext.getTarget();
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d3a\u8e0a\u243f\u8b24\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u243f\u8b24\u3437{\ua7e8\ua4f5\ua034\ua916\u7d36\u8e49\u247b\u8b39\u3479}\ua7f2\ua4f5\ua07e\ua913\u7d73\u8e58\u246d\u8b25\u347ef\ua7e3\ua4f5\ua034\ua916\u7d33\u8e59\u243a\u8b3e\u34792\ua7a3\ua4a6"), objectArray));
        }
        AnnotationNode annotationNode = Annotations.getVisible(mixinMethodNode, Unique.class);
        if (annotationNode == null || !Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("a\ua7ef\ua4b9\ua074\ua90b\u7d62"), Boolean.FALSE).booleanValue()) {
            if (Bytecode.hasFlag(mixinMethodNode, 0xCC5B32F6 ^ 0xCC5B32B6)) {
                try {
                    Bytecode.compareBridgeMethods(methodNode, mixinMethodNode);
                    Object[] objectArray = new Object[0xCACDC839 ^ 0xCACDC83D];
                    objectArray[0x91ABF55C ^ 0x91ABF55C] = string;
                    objectArray[0x4865FA0F ^ 0x4865FA0E] = mixinMethodNode.name;
                    objectArray[0x3ABB0790 ^ 0x3ABB0792] = this.mixin;
                    objectArray[0xDB8444BF ^ 0xDB8444BC] = mixinTargetContext.getTarget();
                    logger.debug(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7f5\ua4ac\ua065\ua90d\u7d73\u8e5e\u2473\u8b34\u3437p\ua7f4\ua4bc\ua075\ua902\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua073\ua900\u7d75\u8e4b\u246f\u8b24\u34722\ua7e3\ua4ad\ua078\ua916\u7d62\u8e43\u2474\u8b30\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua078\ua916\u7d36\u8e49\u2475\u8b3a\u3467s\ua7f2\ua4bc\ua073\ua909\u7d73"), objectArray);
                    return (0xD2259500 ^ 0xD2259501) != 0;
                }
                catch (SyntheticBridgeException syntheticBridgeException) {
                    if (this.verboseLogging || this.env.getOption(MixinEnvironment.Option.DEBUG_VERIFY)) {
                        syntheticBridgeException.printAnalysis(mixinTargetContext, methodNode, mixinMethodNode);
                    }
                    throw new InvalidMixinException((IMixinInfo)this.mixin, syntheticBridgeException.getMessage());
                }
            }
            Object[] objectArray = new Object[0x8385C816 ^ 0x8385C812];
            objectArray[0x4064BF19 ^ 0x4064BF19] = string;
            objectArray[0xA3A5F4ED ^ 0xA3A5F4EC] = mixinMethodNode.name;
            objectArray[0x509995AF ^ 0x509995AD] = this.mixin;
            objectArray[0x4252B3AD ^ 0x4252B3AE] = mixinTargetContext.getTarget();
            logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7fd\ua4a8\ua031\ua915\u7d63\u8e48\u2476\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b2c\u346a2\ua7ef\ua4bb\ua031\ua91e\u7d6b\u8e0a\u2478\u8b32\u3474s\ua7f3\ua4a6\ua074\ua945\u7d7f\u8e5e\u243a\u8b36\u347b`\ua7e3\ua4b4\ua075\ua91c\u7d36\u8e4f\u2462\u8b3e\u3464f\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e51\u2467"), objectArray);
            return (0x53BC5E5E ^ 0x53BC5E5F) != 0;
        }
        mixinTargetContext.addMixinMethod(mixinMethodNode);
        return (0xE5565947 ^ 0xE5565946) != 0;
    }

    protected void attachMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        MethodNode methodNode;
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode);
        if (method == null) {
            return;
        }
        ClassInfo.Method method2 = this.mixin.getClassInfo().findMethodInHierarchy(mixinMethodNode, ClassInfo.SearchType.SUPER_CLASSES_ONLY);
        if (method2 != null && method2.isRenamed()) {
            mixinMethodNode.name = method.renameTo(method2.getName());
        }
        if ((methodNode = mixinTargetContext.findMethod(mixinMethodNode, null)) != null) {
            this.conformVisibility(mixinTargetContext, mixinMethodNode, SpecialMethod.MERGE, methodNode);
        }
    }

    protected void attachFields(MixinTargetContext mixinTargetContext) {
        Iterator iterator = this.classNode.fields.iterator();
        while (iterator.hasNext()) {
            int n;
            FieldNode fieldNode = (FieldNode)iterator.next();
            AnnotationNode annotationNode = Annotations.getVisible(fieldNode, Shadow.class);
            int n2 = annotationNode != null ? 0xBA4D7D50 ^ 0xBA4D7D51 : (n = 0x3782CD4E ^ 0x3782CD4E);
            if (!this.validateField(mixinTargetContext, fieldNode, annotationNode)) {
                iterator.remove();
                continue;
            }
            ClassInfo.Field field = this.mixin.getClassInfo().findField(fieldNode);
            mixinTargetContext.transformDescriptor(fieldNode);
            field.remapTo(fieldNode.desc);
            if (field.isUnique() && n != 0) {
                Object[] objectArray = new Object[0x4E67AC4C ^ 0x4E67AC4D];
                objectArray[0xEF965CD5 ^ 0xEF965CD5] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua940\u7d65\u8e0a\u2479\u8b36\u3479|\ua7e9\ua4a1\ua031\ua907\u7d73\u8e0a\u245a\u8b02\u3479{\ua7f7\ua4a0\ua074"), objectArray));
            }
            FieldNode fieldNode2 = mixinTargetContext.findField(fieldNode, annotationNode);
            if (fieldNode2 == null) {
                if (annotationNode == null) continue;
                fieldNode2 = mixinTargetContext.findRemappedField(fieldNode);
                if (fieldNode2 == null) {
                    Object[] objectArray = new Object[0xD6BC12E5 ^ 0xD6BC12E1];
                    objectArray[0xA9CF519 ^ 0xA9CF519] = fieldNode.name;
                    objectArray[0xD4006232 ^ 0xD4006233] = mixinTargetContext.getTarget();
                    objectArray[0x514D63B ^ 0x514D639] = mixinTargetContext.getReferenceMapper().getStatus();
                    objectArray[0x2691BEE9 ^ 0x2691BEEA] = MixinPreProcessorStandard.getDynamicInfo(fieldNode);
                    throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("A\ua7ee\ua4b4\ua075\ua90a\u7d61\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d36\u8e5d\u247b\u8b24\u3437|\ua7e9\ua4a1\ua031\ua909\u7d79\u8e49\u247b\u8b23\u3472v\ua7a6\ua4bc\ua07f\ua945\u7d62\u8e42\u247f\u8b77\u3463s\ua7f4\ua4b2\ua074\ua911\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4f0\ua062\ua94b\u7d36\u8e0f\u2469\u8b72\u3464"), objectArray));
                }
                fieldNode.name = field.renameTo(fieldNode2.name);
            }
            if (!Bytecode.compareFlags(fieldNode, fieldNode2, 0x2095A382 ^ 0x2095A38A)) {
                Object[] objectArray = new Object[0xF18CC384 ^ 0xF18CC386];
                objectArray[0xC1F59CB9 ^ 0xC1F59CB9] = fieldNode.name;
                objectArray[0x3FB67A9E ^ 0x3FB67A9F] = this.mixin;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("A\ua7d2\ua494\ua045\ua92c\u7d55\u8e0a\u2477\u8b38\u3473{\ua7e0\ua4bc\ua074\ua917\u7d36\u8e45\u247c\u8b77\u3457A\ua7ee\ua4b4\ua075\ua90a\u7d61\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b1\ua07e\ua900\u7d65\u8e0a\u2474\u8b38\u34632\ua7eb\ua4b4\ua065\ua906\u7d7e\u8e0a\u246e\u8b3f\u34722\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e"), objectArray));
            }
            if (field.isUnique()) {
                if ((fieldNode.access & (0x64CA40C4 ^ 0x64CA40C2)) != 0) {
                    String string = mixinTargetContext.getUniqueName(fieldNode);
                    Object[] objectArray = new Object[0x91474AD ^ 0x91474A9];
                    objectArray[0x86D03464 ^ 0x86D03464] = fieldNode.name;
                    objectArray[0x3483A819 ^ 0x3483A818] = fieldNode.desc;
                    objectArray[0x2FC51E7 ^ 0x2FC51E5] = string;
                    objectArray[0xE31DA65D ^ 0xE31DA65E] = this.mixin;
                    logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua06a\ua918\u7d6d\u8e57\u243a\u8b23\u34782\ua7fd\ua4a8\ua031\ua90c\u7d78\u8e0a\u2461\u8b2a"), objectArray);
                    fieldNode.name = field.renameTo(string);
                    continue;
                }
                if (this.strictUnique) {
                    Object[] objectArray = new Object[0xDDF11FD8 ^ 0xDDF11FDD];
                    objectArray[0x8937EAAC ^ 0x8937EAAC] = fieldNode.name;
                    objectArray[0x8D9200B5 ^ 0x8D9200B4] = this.mixin;
                    objectArray[0xAE632C57 ^ 0xAE632C55] = fieldNode2.name;
                    objectArray[0xFC21874B ^ 0xFC218748] = fieldNode2.desc;
                    objectArray[0x213C18D6 ^ 0x213C18D2] = mixinTargetContext.getTarget();
                    throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7ef\ua4b0\ua07d\ua901\u7d36\u8e49\u2475\u8b39\u3471~\ua7ef\ua4b6\ua065\ua949\u7d36\u8e6a\u244f\u8b39\u347ec\ua7f3\ua4b0\ua031\ua903\u7d7f\u8e4f\u2476\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e45\u246c\u8b32\u3465e\ua7f4\ua4bc\ua065\ua900\u7d36\u8e0f\u2469\u8b72\u34642\ua7ef\ua4bb\ua031\ua940\u7d65"), objectArray));
                }
                Object[] objectArray = new Object[0xC485CCCB ^ 0xC485CCC8];
                objectArray[0x87F98371 ^ 0x87F98371] = fieldNode.name;
                objectArray[0x58F66728 ^ 0x58F66729] = this.mixin;
                objectArray[0x2526D1 ^ 0x2526D3] = mixinTargetContext.getTarget();
                logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7c6\ua480\ua07f\ua90c\u7d67\u8e5f\u247f\u8b77\u3467g\ua7e4\ua4b9\ua078\ua906\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a2\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u347ef\ua7a6\ua4b4\ua07d\ua917\u7d73\u8e4b\u247e\u8b2e\u3437w\ua7fe\ua4bc\ua062\ua911\u7d65\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4fb\ua031\ua92b\u7d79\u8e5e\u247f\u8b77\u3463z\ua7e7\ua4a1\ua031\ua901\u7d73\u8e49\u2476\u8b36\u3465w\ua7e2\ua4f5\ua057\ua92c\u7d53\u8e66\u245e\u8b77\u345e\\\ua7cf\ua481\ua058\ua924\u7d5a\u8e63\u2449\u8b12\u3445A\ua7a6\ua4a2\ua078\ua909\u7d7a\u8e0a\u2454\u8b18\u34432\ua7e4\ua4b0\ua031\ua917\u7d73\u8e47\u2475\u8b21\u3472v\ua7a7"), objectArray);
                iterator.remove();
                continue;
            }
            if (!fieldNode2.desc.equals(fieldNode.desc)) {
                Object[] objectArray = new Object[0xA6A42A6 ^ 0xA6A42A7];
                objectArray[0xAA1B9740 ^ 0xAA1B9740] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("F\ua7ee\ua4b0\ua031\ua903\u7d7f\u8e4f\u2476\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e5e\u2472\u8b32\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua079\ua904\u7d65\u8e0a\u247b\u8b77\u3474}\ua7e8\ua4b3\ua07d\ua90c\u7d75\u8e5e\u2473\u8b39\u34702\ua7f5\ua4bc\ua076\ua90b\u7d77\u8e5e\u246f\u8b25\u3472"), objectArray));
            }
            if (!fieldNode2.name.equals(fieldNode.name)) {
                if ((fieldNode2.access & (0x4916F17A ^ 0x4916F178)) == 0) {
                    if ((fieldNode2.access & (0xB5012142 ^ 0xB5013142)) == 0) {
                        throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\\\ua7e9\ua4bb\ua03c\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a\u8b34\u3476|\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b36\u347b{\ua7e7\ua4a6\ua074\ua901\u7d38\u8e0a\u245c\u8b38\u3462|\ua7e2\ua4f5") + fieldNode2.name);
                    }
                }
                fieldNode.name = field.renameTo(fieldNode2.name);
            }
            iterator.remove();
            if (n == 0) continue;
            boolean bl = field.isDecoratedFinal();
            if (this.verboseLogging) {
                if (Bytecode.hasFlag(fieldNode2, 0xB53F4D5D ^ 0xB53F4D4D) != bl) {
                    String string = bl ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua91e\u7d6b\u8e10\u2420\u8b2c\u346a2\ua7ef\ua4a6\ua031\ua901\u7d73\u8e49\u2475\u8b25\u3476f\ua7e3\ua4b1\ua031\ua912\u7d7f\u8e5e\u2472\u8b77\u3457T\ua7ef\ua4bb\ua070\ua909\u7d36\u8e48\u246f\u8b23\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2473\u8b24\u3437|\ua7e9\ua4a1\ua031\ua903\u7d7f\u8e44\u247b\u8b3b") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b23\u3476`\ua7e1\ua4b0\ua065\ua945\u7d6d\u8e57\u2420\u8b6d\u346co\ua7a6\ua4bc\ua062\ua945\u7d70\u8e43\u2474\u8b36\u347b2\ua7e4\ua4a0\ua065\ua945\u7d65\u8e42\u247b\u8b33\u3478e\ua7a6\ua4bc\ua062\ua945\u7d78\u8e45\u246e\u8b77\u3473w\ua7e5\ua4ba\ua063\ua904\u7d62\u8e4f\u247e\u8b77\u3460{\ua7f2\ua4bd\ua031\ua925\u7d50\u8e43\u2474\u8b36\u347b");
                    Object[] objectArray = new Object[0x1601B4C1 ^ 0x1601B4C3];
                    objectArray[0x281F6889 ^ 0x281F6889] = this.mixin;
                    objectArray[0x68090ABB ^ 0x68090ABA] = fieldNode.name;
                    logger.warn(string, objectArray);
                }
            }
            mixinTargetContext.addShadowField(fieldNode, field);
        }
    }

    protected boolean validateField(MixinTargetContext mixinTargetContext, FieldNode fieldNode, AnnotationNode annotationNode) {
        String string;
        if (Bytecode.hasFlag(fieldNode, 0xCCFCFBA8 ^ 0xCCFCFBA0)) {
            if (!Bytecode.hasFlag(fieldNode, 0xDADB1D98 ^ 0xDADB1D9A)) {
                if (!Bytecode.hasFlag(fieldNode, 0xA08CC3FA ^ 0xA08CD3FA) && annotationNode == null) {
                    Object[] objectArray = new Object[0xF5491DE3 ^ 0xF5491DE0];
                    objectArray[0x6251F552 ^ 0x6251F552] = mixinTargetContext;
                    objectArray[0xB1BC5522 ^ 0xB1BC5523] = fieldNode.name;
                    objectArray[0xDD7145B3 ^ 0xDD7145B1] = fieldNode.desc;
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474}\ua7e8\ua4a1\ua070\ua90c\u7d78\u8e59\u243a\u8b39\u3478|\ua7ab\ua4a5\ua063\ua90c\u7d60\u8e4b\u246e\u8b32\u3437a\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d2c\u8e0f\u2469"), objectArray));
                }
            }
        }
        if (fieldNode.name.startsWith(string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"), Shadow.class))) {
            Object[] objectArray = new Object[0xAC210E1C ^ 0xAC210E1E];
            objectArray[0x412B7A91 ^ 0x412B7A91] = mixinTargetContext;
            objectArray[0xCC40A9CB ^ 0xCC40A9CA] = fieldNode.name;
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua940\u7d65\u8e04\u243f\u8b24\u3437z\ua7e7\ua4a6\ua031\ua904\u7d36\u8e59\u2472\u8b36\u3473}\ua7f1\ua4f5\ua061\ua917\u7d73\u8e4c\u2473\u8b2f\u34392\ua7d2\ua4bd\ua078\ua916\u7d36\u8e43\u2469\u8b77\u3479}\ua7f2\ua4f5\ua070\ua909\u7d7a\u8e45\u246d\u8b32\u3473<"), objectArray));
        }
        if (\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("a\ua7f3\ua4a5\ua074\ua917\u7d32").equals(fieldNode.name)) {
            if (fieldNode.access != (0x12EE2DC4 ^ 0x12EE2DC6)) {
                Object[] objectArray = new Object[0x8BCB95F6 ^ 0x8BCB95F4];
                objectArray[0x3875FDF6 ^ 0x3875FDF6] = mixinTargetContext;
                objectArray[0x437E48EF ^ 0x437E48EE] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7eb\ua4b4\ua076\ua90c\u7d78\u8e4b\u2468\u8b2e\u3437a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4f0\ua062\ua94b\u7d33\u8e59\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e5a\u2468\u8b3e\u3461s\ua7f2\ua4b0\ua031\ua904\u7d78\u8e4e\u243a\u8b39\u3478|\ua7ab\ua4b3\ua078\ua90b\u7d77\u8e46"), objectArray));
            }
            if (!fieldNode.desc.equals(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^") + this.mixin.getClassRef() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(")"))) {
                Object[] objectArray = new Object[0xC8A25696 ^ 0xC8A25695];
                objectArray[0x9A1F7F7B ^ 0x9A1F7F7B] = mixinTargetContext;
                objectArray[0xD1434CCF ^ 0xD1434CCE] = fieldNode.name;
                objectArray[0x83E3868C ^ 0x83E3868E] = this.mixin.getClassName();
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7eb\ua4b4\ua076\ua90c\u7d78\u8e4b\u2468\u8b2e\u3437a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4f0\ua062\ua94b\u7d33\u8e59\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua079\ua904\u7d60\u8e4f\u243a\u8b23\u347fw\ua7a6\ua4a6\ua070\ua908\u7d73\u8e0a\u246e\u8b2e\u3467w\ua7a6\ua4b4\ua062\ua945\u7d62\u8e42\u247f\u8b77\u3467s\ua7f4\ua4b0\ua07f\ua911\u7d36\u8e47\u2473\u8b2f\u347e|\ua7a6\ua4fd\ua034\ua916\u7d3f"), objectArray));
            }
            return (0x4B00F65F ^ 0x4B00F65F) != 0;
        }
        return (0x71C8B848 ^ 0x71C8B849) != 0;
    }

    protected void transform(MixinTargetContext mixinTargetContext) {
        for (MethodNode methodNode : this.classNode.methods) {
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (abstractInsnNode instanceof MethodInsnNode) {
                    this.transformMethod((MethodInsnNode)abstractInsnNode);
                    continue;
                }
                if (!(abstractInsnNode instanceof FieldInsnNode)) continue;
                this.transformField((FieldInsnNode)abstractInsnNode);
            }
        }
    }

    protected void transformMethod(MethodInsnNode methodInsnNode) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7e3\ua4a1\ua070"));
        ClassInfo classInfo = ClassInfo.forName(methodInsnNode.owner);
        if (classInfo == null) {
            throw new RuntimeException(new ClassNotFoundException(methodInsnNode.owner.replace((char)(0x92516E5B ^ 0x92516E74), (char)(0x29505AA6 ^ 0x29505A88))));
        }
        ClassInfo.Method method = classInfo.findMethodInHierarchy(methodInsnNode, ClassInfo.SearchType.ALL_CLASSES, 0x8101961E ^ 0x8101961C);
        section.end();
        if (method != null && method.isRenamed()) {
            methodInsnNode.name = method.getName();
        }
    }

    protected void transformField(FieldInsnNode fieldInsnNode) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7e3\ua4a1\ua070"));
        ClassInfo classInfo = ClassInfo.forName(fieldInsnNode.owner);
        if (classInfo == null) {
            throw new RuntimeException(new ClassNotFoundException(fieldInsnNode.owner.replace((char)(0xF2EB2F46 ^ 0xF2EB2F69), (char)(0x279DE0EA ^ 0x279DE0C4))));
        }
        ClassInfo.Field field = classInfo.findField(fieldInsnNode, 0x92CA7A7B ^ 0x92CA7A79);
        section.end();
        if (field != null && field.isRenamed()) {
            fieldInsnNode.name = field.getName();
        }
    }

    protected static String getDynamicInfo(MethodNode methodNode) {
        return MixinPreProcessorStandard.getDynamicInfo(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("_\ua7e3\ua4a1\ua079\ua90a\u7d72"), Annotations.getInvisible(methodNode, Dynamic.class));
    }

    protected static String getDynamicInfo(FieldNode fieldNode) {
        return MixinPreProcessorStandard.getDynamicInfo(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7ef\ua4b0\ua07d\ua901"), Annotations.getInvisible(fieldNode, Dynamic.class));
    }

    private static String getDynamicInfo(String string, AnnotationNode annotationNode) {
        String string2;
        String string3 = Strings.nullToEmpty((String)((String)Annotations.getValue(annotationNode)));
        Type type = (Type)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        if (type != null) {
            Object[] objectArray = new Object[0x2F7C4343 ^ 0x2F7C4341];
            objectArray[0xE2A8AC88 ^ 0xE2A8AC88] = type.getClassName();
            objectArray[0x953D2C98 ^ 0x953D2C99] = string3;
            string3 = String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("i\ua7a3\ua4a6\ua06c\ua945\u7d33\u8e59"), objectArray).trim();
        }
        if (string3.length() > 0) {
            Object[] objectArray = new Object[0x356F6521 ^ 0x356F6523];
            objectArray[0x6BA7F597 ^ 0x6BA7F597] = string;
            objectArray[0xF55CF458 ^ 0xF55CF459] = string3;
            string2 = String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a3\ua4a6\ua031\ua90c\u7d65\u8e0a\u245a\u8b13\u346e|\ua7e7\ua4b8\ua078\ua906\u7d3e\u8e0f\u2469\u8b7e"), objectArray);
        } else {
            string2 = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("");
        }
        return string2;
    }

    static final class SpecialMethod
    extends Enum<SpecialMethod> {
        public static final /* enum */ SpecialMethod MERGE = new SpecialMethod((0xFD8FD30F ^ 0xFD8FD30E) != 0);
        public static final /* enum */ SpecialMethod OVERWRITE = new SpecialMethod((0xBB00B8D ^ 0xBB00B8C) != 0, Overwrite.class);
        public static final /* enum */ SpecialMethod SHADOW = new SpecialMethod((0x3DFA46EF ^ 0x3DFA46EF) != 0, Shadow.class);
        public static final /* enum */ SpecialMethod ACCESSOR = new SpecialMethod((0xC7969F72 ^ 0xC7969F72) != 0, Accessor.class);
        public static final /* enum */ SpecialMethod INVOKER = new SpecialMethod((0x5F245A9C ^ 0x5F245A9C) != 0, Invoker.class);
        final boolean isOverwrite;
        final Class<? extends Annotation> annotation;
        final String description;
        private static final /* synthetic */ SpecialMethod[] $VALUES;

        public static SpecialMethod[] values() {
            return (SpecialMethod[])$VALUES.clone();
        }

        public static SpecialMethod valueOf(String string) {
            return Enum.valueOf(SpecialMethod.class, string);
        }

        private SpecialMethod(boolean bl, Class<? extends Annotation> clazz) {
            this.isOverwrite = bl;
            this.annotation = clazz;
            this.description = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("R") + Bytecode.getSimpleName(clazz);
        }

        private SpecialMethod(boolean bl) {
            this.isOverwrite = bl;
            this.annotation = null;
            this.description = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("}\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32");
        }

        public String toString() {
            return this.description;
        }

        static {
            SpecialMethod[] specialMethodArray = new SpecialMethod[0x7A26CF6F ^ 0x7A26CF6A];
            specialMethodArray[0x44DC08FD ^ 0x44DC08FD] = MERGE;
            specialMethodArray[0xAC4B898A ^ 0xAC4B898B] = OVERWRITE;
            specialMethodArray[0x536C73B6 ^ 0x536C73B4] = SHADOW;
            specialMethodArray[0xEDF13D13 ^ 0xEDF13D10] = ACCESSOR;
            specialMethodArray[0x5D337914 ^ 0x5D337910] = INVOKER;
            $VALUES = specialMethodArray;
        }
    }
}

