/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.debug;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.spongepowered.asm.mixin.transformer.ext.IDecompiler;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class RuntimeDecompiler
extends IFernflowerLogger
implements IResultSaver,
IDecompiler {
    private static final Level[] SEVERITY_LEVELS;
    private final Map<String, Object> options = ImmutableMap.builder().put((Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("v\ua7ef\ua4bb"), (Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\"")).put((Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("`\ua7e4\ua4a7"), (Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\"")).put((Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("v\ua7e1\ua4a6"), (Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("#")).put((Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("s\ua7f5\ua4b6"), (Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("#")).put((Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("v\ua7e3\ua4bb"), (Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("#")).put((Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("z\ua7e2\ua4b6"), (Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("#")).put((Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("{\ua7e8\ua4b1"), (Object)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6\ua4f5\ua031")).build();
    private final File outputPath;
    protected final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("t\ua7e3\ua4a7\ua07f\ua903\u7d7a\u8e45\u246d\u8b32\u3465"));

    public RuntimeDecompiler(File file) {
        this.outputPath = file;
        if (this.outputPath.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.outputPath);
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[0xBDB38C54 ^ 0xBDB38C55];
                objectArray[0x602F8086 ^ 0x602F8086] = iOException.getMessage();
                this.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e49\u2476\u8b32\u3476|\ua7ef\ua4bb\ua076\ua945\u7d79\u8e5f\u246e\u8b27\u3462f\ua7a6\ua4b1\ua078\ua917\u7d73\u8e49\u246e\u8b38\u3465k\ua7bc\ua4f5\ua06a\ua918"), objectArray);
            }
        }
    }

    @Override
    public void decompile(File file) {
        try {
            Fernflower fernflower = new Fernflower(new IBytecodeProvider(){
                private byte[] byteCode;

                public byte[] getBytecode(String string, String string2) throws IOException {
                    if (this.byteCode == null) {
                        this.byteCode = InterpreterUtil.getBytes((File)new File(string));
                    }
                    return this.byteCode;
                }
            }, (IResultSaver)this, this.options, (IFernflowerLogger)this);
            fernflower.getStructContext().addSpace(file, (0xB9660D2F ^ 0xB9660D2E) != 0);
            fernflower.decompileContext();
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[0xA5F6E067 ^ 0xA5F6E066];
            objectArray[0x285A1614 ^ 0x285A1614] = file.getName();
            this.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("V\ua7e3\ua4b6\ua07e\ua908\u7d66\u8e43\u2476\u8b36\u3463{\ua7e9\ua4bb\ua031\ua900\u7d64\u8e58\u2475\u8b25\u3437e\ua7ee\ua4bc\ua07d\ua900\u7d36\u8e5a\u2468\u8b38\u3474w\ua7f5\ua4a6\ua078\ua90b\u7d71\u8e0a\u2461\u8b2a"), objectArray);
        }
    }

    public void saveFolder(String string) {
    }

    public void saveClassFile(String string, String string2, String string3, String string4, int[] nArray) {
        File file = new File(this.outputPath, string2 + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("<\ua7ec\ua4b4\ua067\ua904"));
        file.getParentFile().mkdirs();
        try {
            Object[] objectArray = new Object[0xEB8D6EA7 ^ 0xEB8D6EA6];
            objectArray[0xCBB52BD8 ^ 0xCBB52BD8] = file.getAbsolutePath();
            this.logger.info(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("E\ua7f4\ua4bc\ua065\ua90c\u7d78\u8e4d\u243a\u8b2c\u346a"), objectArray);
            Files.write((CharSequence)string4, (File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException iOException) {
            this.writeMessage(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u246d\u8b25\u347ef\ua7e3\ua4f5\ua062\ua90a\u7d63\u8e58\u2479\u8b32\u3437t\ua7ef\ua4b9\ua074\ua945") + file, iOException);
        }
    }

    public void startReadingClass(String string) {
        Object[] objectArray = new Object[0xFD807FC6 ^ 0xFD807FC7];
        objectArray[0x281155B2 ^ 0x281155B2] = string;
        this.logger.info(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("V\ua7e3\ua4b6\ua07e\ua908\u7d66\u8e43\u2476\u8b3e\u3479u\ua7a6\ua4ae\ua06c"), objectArray);
    }

    public void writeMessage(String string, IFernflowerLogger.Severity severity) {
        this.logger.log(SEVERITY_LEVELS[severity.ordinal()], string);
    }

    public void writeMessage(String string, Throwable throwable) {
        Object[] objectArray = new Object[0xA59A39C8 ^ 0xA59A39CB];
        objectArray[0xA006C9B ^ 0xA006C9B] = string;
        objectArray[0x8EA9AD8D ^ 0x8EA9AD8C] = throwable.getClass().getSimpleName();
        objectArray[0xF46887E0 ^ 0xF46887E2] = throwable.getMessage();
        this.logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("i\ua7fb\ua4f5\ua06a\ua918\u7d2c\u8e0a\u2461\u8b2a"), objectArray);
    }

    public void writeMessage(String string, IFernflowerLogger.Severity severity, Throwable throwable) {
        this.logger.log(SEVERITY_LEVELS[severity.ordinal()], string, throwable);
    }

    public void copyFile(String string, String string2, String string3) {
    }

    public void createArchive(String string, String string2, Manifest manifest) {
    }

    public void saveDirEntry(String string, String string2, String string3) {
    }

    public void copyEntry(String string, String string2, String string3, String string4) {
    }

    public void saveClassEntry(String string, String string2, String string3, String string4, String string5) {
    }

    public void closeArchive(String string, String string2) {
    }

    static {
        Level[] levelArray = new Level[0x7BCBE94E ^ 0x7BCBE94A];
        levelArray[0x5C469570 ^ 0x5C469570] = Level.TRACE;
        levelArray[0xE103885B ^ 0xE103885A] = Level.INFO;
        levelArray[0x7519886E ^ 0x7519886C] = Level.WARN;
        levelArray[0x30144178 ^ 0x3014417B] = Level.ERROR;
        SEVERITY_LEVELS = levelArray;
    }
}

