/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Joiner;
import com.google.common.primitives.Ints;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.util.CheckClassAdapter;
import org.spongepowered.asm.lib.util.TraceClassVisitor;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.util.Constants;
import org.spongepowered.asm.util.throwables.SyntheticBridgeException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class Bytecode {
    public static final int[] CONSTANTS_INT;
    public static final int[] CONSTANTS_FLOAT;
    public static final int[] CONSTANTS_DOUBLE;
    public static final int[] CONSTANTS_LONG;
    public static final int[] CONSTANTS_ALL;
    private static final Object[] CONSTANTS_VALUES;
    private static final String[] CONSTANTS_TYPES;
    private static final String[] BOXING_TYPES;
    private static final String[] UNBOXING_METHODS;
    private static final Class<?>[] MERGEABLE_MIXIN_ANNOTATIONS;
    private static Pattern mergeableAnnotationPattern;
    private static final Logger logger;

    private Bytecode() {
    }

    public static MethodNode findMethod(ClassNode classNode, String string, String string2) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(string) || !methodNode.desc.equals(string2)) continue;
            return methodNode;
        }
        return null;
    }

    public static AbstractInsnNode findInsn(MethodNode methodNode, int n) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode.getOpcode() != n) continue;
            return abstractInsnNode;
        }
        return null;
    }

    public static MethodInsnNode findSuperInit(MethodNode methodNode, String string) {
        if (!\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
            return null;
        }
        int n = 0x8E4D8D4 ^ 0x8E4D8D4;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode instanceof TypeInsnNode) {
                if (abstractInsnNode.getOpcode() == (0x826A9B9D ^ 0x826A9B26)) {
                    ++n;
                    continue;
                }
            }
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() != (0xF8214682 ^ 0xF8214635)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodInsnNode.name)) continue;
            if (n > 0) {
                --n;
                continue;
            }
            if (!methodInsnNode.owner.equals(string)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public static void textify(ClassNode classNode, OutputStream outputStream) {
        classNode.accept(new TraceClassVisitor(new PrintWriter(outputStream)));
    }

    public static void textify(MethodNode methodNode, OutputStream outputStream) {
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(new PrintWriter(outputStream));
        MethodVisitor methodVisitor = traceClassVisitor.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0x15BE3454 ^ 0x15BE3454]));
        methodNode.accept(methodVisitor);
        traceClassVisitor.visitEnd();
    }

    public static void dumpClass(ClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(0xA4A7D665 ^ 0xA4A7D666);
        classNode.accept(classWriter);
        Bytecode.dumpClass(classWriter.toByteArray());
    }

    public static void dumpClass(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        CheckClassAdapter.verify(classReader, (0x4CBB76 ^ 0x4CBB77) != 0, new PrintWriter(System.out));
    }

    public static void printMethodWithOpcodeIndices(MethodNode methodNode) {
        Object[] objectArray = new Object[0xC83EF7ED ^ 0xC83EF7EF];
        objectArray[0xE7076C7A ^ 0xE7076C7A] = methodNode.name;
        objectArray[0x1C238D7 ^ 0x1C238D6] = methodNode.desc;
        System.err.printf(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f0\ua062\ua96f"), objectArray);
        int n = 0xEBB122FC ^ 0xEBB122FC;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            Object[] objectArray2 = new Object[0xA55A0BB5 ^ 0xA55A0BB7];
            objectArray2[0x538C167D ^ 0x538C167D] = n++;
            objectArray2[0x79C8B6FA ^ 0x79C8B6FB] = Bytecode.describeNode((AbstractInsnNode)listIterator.next());
            System.err.printf(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7a3\ua4e1\ua075\ua938\u7d36\u8e0f\u2469\u8b5d"), objectArray2);
        }
    }

    public static void printMethod(MethodNode methodNode) {
        Object[] objectArray = new Object[0xEEB407AE ^ 0xEEB407AC];
        objectArray[0x6BFC083A ^ 0x6BFC083A] = methodNode.name;
        objectArray[0x153C4366 ^ 0x153C4367] = methodNode.desc;
        System.err.printf(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4f0\ua062\ua96f"), objectArray);
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            System.err.print(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6"));
            Bytecode.printNode((AbstractInsnNode)listIterator.next());
        }
    }

    public static void printNode(AbstractInsnNode abstractInsnNode) {
        Object[] objectArray = new Object[0x89519343 ^ 0x89519342];
        objectArray[0xD17BBD3 ^ 0xD17BBD3] = Bytecode.describeNode(abstractInsnNode);
        System.err.printf(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("7\ua7f5\ua4df"), objectArray);
    }

    public static String describeNode(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            Object[] objectArray = new Object[0x37989A17 ^ 0x37989A16];
            objectArray[0xF90BA15C ^ 0xF90BA15C] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("|\ua7f3\ua4b9\ua07d");
            return String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6\ua4f5\ua034\ua948\u7d27\u8e1e\u2469\u8b77"), objectArray);
        }
        if (abstractInsnNode instanceof LabelNode) {
            Object[] objectArray = new Object[0xAC53F339 ^ 0xAC53F338];
            objectArray[0xBE947E73 ^ 0xBE947E73] = ((LabelNode)abstractInsnNode).getLabel();
            return String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7a3\ua4a6\ua04c"), objectArray);
        }
        Object[] objectArray = new Object[0xA16AD559 ^ 0xA16AD558];
        objectArray[0x156CF0B6 ^ 0x156CF0B6] = abstractInsnNode.getClass().getSimpleName().replace(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\\\ua7e9\ua4b1\ua074"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(""));
        String string = String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6\ua4f5\ua034\ua948\u7d27\u8e1e\u2469\u8b77"), objectArray);
        if (abstractInsnNode instanceof JumpInsnNode) {
            Object[] objectArray2 = new Object[0x46F2CDFC ^ 0x46F2CDFE];
            objectArray2[0x1737B0A1 ^ 0x1737B0A1] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray2[0xBF044599 ^ 0xBF044598] = ((JumpInsnNode)abstractInsnNode).label.getLabel();
            string = string + String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7a3\ua4a6\ua04c\ua945\u7d4d\u8e0f\u2469\u8b0a"), objectArray2);
        } else if (abstractInsnNode instanceof VarInsnNode) {
            Object[] objectArray3 = new Object[0x9F58FD2 ^ 0x9F58FD0];
            objectArray3[0xC1B4E613 ^ 0xC1B4E613] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray3[0x15F5037E ^ 0x15F5037F] = ((VarInsnNode)abstractInsnNode).var;
            string = string + String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e4e"), objectArray3);
        } else if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            Object[] objectArray4 = new Object[0x41621793 ^ 0x41621797];
            objectArray4[0x3453C450 ^ 0x3453C450] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray4[0x3670E1B ^ 0x3670E1A] = methodInsnNode.owner;
            objectArray4[0xF0FCAE1E ^ 0xF0FCAE1C] = methodInsnNode.name;
            objectArray4[0xB0F5C6E0 ^ 0xB0F5C6E3] = methodInsnNode.desc;
            string = string + String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e59\u243a\u8b72\u34642\ua7a3\ua4a6"), objectArray4);
        } else if (abstractInsnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
            Object[] objectArray5 = new Object[0x1024E58B ^ 0x1024E58F];
            objectArray5[0xD5E6ABEC ^ 0xD5E6ABEC] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray5[0x1DF533E3 ^ 0x1DF533E2] = fieldInsnNode.owner;
            objectArray5[0x37DAD5A0 ^ 0x37DAD5A2] = fieldInsnNode.name;
            objectArray5[0xA498373 ^ 0xA498370] = fieldInsnNode.desc;
            string = string + String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e59\u243a\u8b72\u34642\ua7a3\ua4a6"), objectArray5);
        } else if (abstractInsnNode instanceof LineNumberNode) {
            LineNumberNode lineNumberNode = (LineNumberNode)abstractInsnNode;
            Object[] objectArray6 = new Object[0xF905B720 ^ 0xF905B722];
            objectArray6[0xFF946FCC ^ 0xFF946FCC] = lineNumberNode.line;
            objectArray6[0x41FBAB3F ^ 0x41FBAB3E] = lineNumberNode.start.getLabel();
            string = string + String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^\ua7cf\ua49b\ua054\ua958\u7d4d\u8e0f\u247e\u8b0a\u3437^\ua7c7\ua497\ua054\ua929\u7d2b\u8e71\u243f\u8b24\u344a"), objectArray6);
        } else if (abstractInsnNode instanceof LdcInsnNode) {
            string = string + ((LdcInsnNode)abstractInsnNode).cst;
        } else if (abstractInsnNode instanceof IntInsnNode) {
            string = string + ((IntInsnNode)abstractInsnNode).operand;
        } else if (abstractInsnNode instanceof FrameNode) {
            Object[] objectArray7 = new Object[0x50938B3A ^ 0x50938B3B];
            objectArray7[0xCC316B83 ^ 0xCC316B83] = Bytecode.getOpcodeName(((FrameNode)abstractInsnNode).type, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Z\ua7d9\ua49c\ua05f\ua933\u7d59\u8e61\u245f\u8b1e\u3459F\ua7c3\ua487\ua057\ua924\u7d55\u8e6f"), 0x8CBACD7F ^ 0x73453280);
            string = string + String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7a3\ua4a6\ua04c\ua945"), objectArray7);
        } else {
            Object[] objectArray8 = new Object[0xCEBF4E0E ^ 0xCEBF4E0F];
            objectArray8[0xB7DEAEDC ^ 0xB7DEAEDC] = Bytecode.getOpcodeName(abstractInsnNode);
            string = string + String.format(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7a3\ua4a6\ua04c\ua945"), objectArray8);
        }
        return string;
    }

    public static String getOpcodeName(AbstractInsnNode abstractInsnNode) {
        return abstractInsnNode != null ? Bytecode.getOpcodeName(abstractInsnNode.getOpcode()) : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("");
    }

    public static String getOpcodeName(int n) {
        return Bytecode.getOpcodeName(n, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("G\ua7c8\ua49c\ua05f\ua92c\u7d42\u8e63\u245b\u8b1b\u345eH\ua7c3\ua491\ua04e\ua931\u7d5e\u8e63\u2449"), 0x85F70EBC ^ 0x85F70EBD);
    }

    private static String getOpcodeName(int n, String string, int n2) {
        if (n >= n2) {
            int n3 = 0x88FDBEFA ^ 0x88FDBEFA;
            try {
                Field[] fieldArray = Opcodes.class.getDeclaredFields();
                int n4 = fieldArray.length;
                for (int i = 0x58B9D517 ^ 0x58B9D517; i < n4; ++i) {
                    Field field = fieldArray[i];
                    if (n3 == 0 && !field.getName().equals(string)) continue;
                    n3 = 0x251B67DE ^ 0x251B67DF;
                    if (field.getType() != Integer.TYPE || field.getInt(null) != n) continue;
                    return field.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n >= 0 ? String.valueOf(n) : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("G\ua7c8\ua49e\ua05f\ua92a\u7d41\u8e64");
    }

    public static boolean methodHasLineNumbers(MethodNode methodNode) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof LineNumberNode)) continue;
            return (0x5062C2E8 ^ 0x5062C2E9) != 0;
        }
        return (0x6D690F3D ^ 0x6D690F3D) != 0;
    }

    public static boolean methodIsStatic(MethodNode methodNode) {
        return ((methodNode.access & (0xAF3CC874 ^ 0xAF3CC87C)) == (0x7E3C93C2 ^ 0x7E3C93CA) ? 0x65AB0B87 ^ 0x65AB0B86 : 0xEF74FBAA ^ 0xEF74FBAA) != 0;
    }

    public static boolean fieldIsStatic(FieldNode fieldNode) {
        return ((fieldNode.access & (0xC274436E ^ 0xC2744366)) == (0x1C4850A5 ^ 0x1C4850AD) ? 0xD3C415D6 ^ 0xD3C415D7 : 0x3AE5D9E6 ^ 0x3AE5D9E6) != 0;
    }

    public static int getFirstNonArgLocalIndex(MethodNode methodNode) {
        return Bytecode.getFirstNonArgLocalIndex(Type.getArgumentTypes(methodNode.desc), ((methodNode.access & (0x73CDC23D ^ 0x73CDC235)) == 0 ? 0x607BCE5 ^ 0x607BCE4 : 0x850F6BAD ^ 0x850F6BAD) != 0);
    }

    public static int getFirstNonArgLocalIndex(Type[] typeArray, boolean bl) {
        return Bytecode.getArgsSize(typeArray) + (bl ? 0x1E723F40 ^ 0x1E723F41 : 0x13FA7D15 ^ 0x13FA7D15);
    }

    public static int getArgsSize(Type[] typeArray) {
        int n = 0x4ADDD132 ^ 0x4ADDD132;
        Type[] typeArray2 = typeArray;
        int n2 = typeArray2.length;
        for (int i = 0x1B699113 ^ 0x1B699113; i < n2; ++i) {
            Type type = typeArray2[i];
            n += type.getSize();
        }
        return n;
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n) {
        Bytecode.loadArgs(typeArray, insnList, n, 0xF168F11E ^ 0xE970EE1);
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n, int n2) {
        Bytecode.loadArgs(typeArray, insnList, n, n2, null);
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n, int n2, Type[] typeArray2) {
        int n3 = n;
        int n4 = 0x7F128BA ^ 0x7F128BA;
        Type[] typeArray3 = typeArray;
        int n5 = typeArray3.length;
        for (int i = 0xBBE345FA ^ 0xBBE345FA; i < n5; ++i) {
            Type type = typeArray3[i];
            insnList.add(new VarInsnNode(type.getOpcode(0x9B582864 ^ 0x9B582871), n3));
            if (typeArray2 != null && n4 < typeArray2.length && typeArray2[n4] != null) {
                insnList.add(new TypeInsnNode(0xAD1E7F73 ^ 0xAD1E7FB3, typeArray2[n4].getInternalName()));
            }
            if (n2 >= n && (n3 += type.getSize()) >= n2) {
                return;
            }
            ++n4;
        }
    }

    public static Map<LabelNode, LabelNode> cloneLabels(InsnList insnList) {
        HashMap<LabelNode, LabelNode> hashMap = new HashMap<LabelNode, LabelNode>();
        ListIterator<AbstractInsnNode> listIterator = insnList.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof LabelNode)) continue;
            hashMap.put((LabelNode)abstractInsnNode, new LabelNode(((LabelNode)abstractInsnNode).getLabel()));
        }
        return hashMap;
    }

    public static String generateDescriptor(Object object, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder().append((char)(0x6157A75 ^ 0x6157A5D));
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0xE0C4EA7D ^ 0xE0C4EA7D; i < n; ++i) {
            Object object2 = objectArray2[i];
            stringBuilder.append(Bytecode.toDescriptor(object2));
        }
        return stringBuilder.append((char)(0xF3B6E1E7 ^ 0xF3B6E1CE)).append(object != null ? Bytecode.toDescriptor(object) : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("D")).toString();
    }

    private static String toDescriptor(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Type) {
            return object.toString();
        }
        if (object instanceof Class) {
            return Type.getDescriptor((Class)object);
        }
        return object == null ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("") : object.toString();
    }

    public static String getDescriptor(Type[] typeArray) {
        return \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(":") + Joiner.on((String)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("")).join((Object[])typeArray) + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(";");
    }

    public static String getDescriptor(Type[] typeArray, Type type) {
        return Bytecode.getDescriptor(typeArray) + type.toString();
    }

    public static String changeDescriptorReturnType(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        return string.substring(0x30FB4307 ^ 0x30FB4307, string.lastIndexOf(0xF52E59E5 ^ 0xF52E59CC) + (0x4A064E6B ^ 0x4A064E6A)) + string2;
    }

    public static String getSimpleName(Class<? extends Annotation> clazz) {
        return clazz.getSimpleName();
    }

    public static String getSimpleName(AnnotationNode annotationNode) {
        return Bytecode.getSimpleName(annotationNode.desc);
    }

    public static String getSimpleName(String string) {
        int n = Math.max(string.lastIndexOf(0x57930FE2 ^ 0x57930FCD), 0x5861A16C ^ 0x5861A16C);
        return string.substring(n + (0x58F50BDF ^ 0x58F50BDE)).replace(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(")"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(""));
    }

    public static boolean isConstant(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            return (0x76E5EAA9 ^ 0x76E5EAA9) != 0;
        }
        return Ints.contains((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
    }

    public static Object getConstant(AbstractInsnNode abstractInsnNode) {
        block5: {
            block7: {
                int n;
                block6: {
                    if (abstractInsnNode == null) {
                        return null;
                    }
                    if (abstractInsnNode instanceof LdcInsnNode) {
                        return ((LdcInsnNode)abstractInsnNode).cst;
                    }
                    if (!(abstractInsnNode instanceof IntInsnNode)) break block5;
                    n = ((IntInsnNode)abstractInsnNode).operand;
                    if (abstractInsnNode.getOpcode() == (0xEA135178 ^ 0xEA135168)) break block6;
                    if (abstractInsnNode.getOpcode() != (0x98B964F8 ^ 0x98B964E9)) break block7;
                }
                return n;
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4a1\ua058\ua90b\u7d65\u8e44\u2454\u8b38\u3473w\ua7a6\ua4a2\ua078\ua911\u7d7e\u8e0a\u2473\u8b39\u3461s\ua7ea\ua4bc\ua075\ua945\u7d79\u8e5a\u2479\u8b38\u3473w\ua7a6") + abstractInsnNode.getOpcode() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4bb\ua031\ua902\u7d73\u8e5e\u2459\u8b38\u3479a\ua7f2\ua4b4\ua07f\ua911"));
        }
        int n = Ints.indexOf((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
        return n < 0 ? null : CONSTANTS_VALUES[n];
    }

    public static Type getConstantType(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            return null;
        }
        if (abstractInsnNode instanceof LdcInsnNode) {
            Object object = ((LdcInsnNode)abstractInsnNode).cst;
            if (object instanceof Integer) {
                return Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("["));
            }
            if (object instanceof Float) {
                return Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T"));
            }
            if (object instanceof Long) {
                return Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("X"));
            }
            if (object instanceof Double) {
                return Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("V"));
            }
            if (object instanceof String) {
                return Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7d5\ua4a1\ua063\ua90c\u7d78\u8e4d\u2421"));
            }
            if (object instanceof Type) {
                return Type.getType(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7c5\ua4b9\ua070\ua916\u7d65\u8e11"));
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^\ua7e2\ua4b6\ua058\ua90b\u7d65\u8e44\u2454\u8b38\u3473w\ua7a6\ua4a2\ua078\ua911\u7d7e\u8e0a\u2473\u8b39\u3461s\ua7ea\ua4bc\ua075\ua945\u7d66\u8e4b\u2463\u8b3b\u3478s\ua7e2\ua4f5\ua065\ua91c\u7d66\u8e4f\u243a") + object.getClass() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ef\ua4bb\ua031\ua902\u7d73\u8e5e\u2459\u8b38\u3479a\ua7f2\ua4b4\ua07f\ua911"));
        }
        int n = Ints.indexOf((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
        return n < 0 ? null : Type.getType(CONSTANTS_TYPES[n]);
    }

    public static boolean hasFlag(ClassNode classNode, int n) {
        return ((classNode.access & n) == n ? 0xAE0961DF ^ 0xAE0961DE : 0x85521200 ^ 0x85521200) != 0;
    }

    public static boolean hasFlag(MethodNode methodNode, int n) {
        return ((methodNode.access & n) == n ? 0xFD6E78F4 ^ 0xFD6E78F5 : 0xDCD02113 ^ 0xDCD02113) != 0;
    }

    public static boolean hasFlag(FieldNode fieldNode, int n) {
        return ((fieldNode.access & n) == n ? 0x398BF68B ^ 0x398BF68A : 0x1D862D10 ^ 0x1D862D10) != 0;
    }

    public static boolean compareFlags(MethodNode methodNode, MethodNode methodNode2, int n) {
        return (Bytecode.hasFlag(methodNode, n) == Bytecode.hasFlag(methodNode2, n) ? 0xEB8D24C6 ^ 0xEB8D24C7 : 0x30987E91 ^ 0x30987E91) != 0;
    }

    public static boolean compareFlags(FieldNode fieldNode, FieldNode fieldNode2, int n) {
        return (Bytecode.hasFlag(fieldNode, n) == Bytecode.hasFlag(fieldNode2, n) ? 0x35C6391B ^ 0x35C6391A : 0xCF0D03BF ^ 0xCF0D03BF) != 0;
    }

    public static Visibility getVisibility(MethodNode methodNode) {
        return Bytecode.getVisibility(methodNode.access & (0x69317213 ^ 0x69317214));
    }

    public static Visibility getVisibility(FieldNode fieldNode) {
        return Bytecode.getVisibility(fieldNode.access & (0x39CDF548 ^ 0x39CDF54F));
    }

    private static Visibility getVisibility(int n) {
        if ((n & (0x6711A070 ^ 0x6711A074)) != 0) {
            return Visibility.PROTECTED;
        }
        if ((n & (0x40AFD845 ^ 0x40AFD847)) != 0) {
            return Visibility.PRIVATE;
        }
        if ((n & (0x11681EED ^ 0x11681EEC)) != 0) {
            return Visibility.PUBLIC;
        }
        return Visibility.PACKAGE;
    }

    public static void setVisibility(MethodNode methodNode, Visibility visibility) {
        methodNode.access = Bytecode.setVisibility(methodNode.access, visibility.access);
    }

    public static void setVisibility(FieldNode fieldNode, Visibility visibility) {
        fieldNode.access = Bytecode.setVisibility(fieldNode.access, visibility.access);
    }

    public static void setVisibility(MethodNode methodNode, int n) {
        methodNode.access = Bytecode.setVisibility(methodNode.access, n);
    }

    public static void setVisibility(FieldNode fieldNode, int n) {
        fieldNode.access = Bytecode.setVisibility(fieldNode.access, n);
    }

    private static int setVisibility(int n, int n2) {
        return n & (0xA636883B ^ 0x59C977C3) | n2 & (0xA8147254 ^ 0xA8147253);
    }

    public static int getMaxLineNumber(ClassNode classNode, int n, int n2) {
        int n3 = 0x4D40F1AA ^ 0x4D40F1AA;
        for (MethodNode methodNode : classNode.methods) {
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (!(abstractInsnNode instanceof LineNumberNode)) continue;
                n3 = Math.max(n3, ((LineNumberNode)abstractInsnNode).line);
            }
        }
        return Math.max(n, n3 + n2);
    }

    public static String getBoxingType(Type type) {
        return type == null ? null : BOXING_TYPES[type.getSort()];
    }

    public static String getUnboxingMethod(Type type) {
        return type == null ? null : UNBOXING_METHODS[type.getSort()];
    }

    public static void mergeAnnotations(ClassNode classNode, ClassNode classNode2) {
        classNode2.visibleAnnotations = Bytecode.mergeAnnotations(classNode.visibleAnnotations, classNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7ea\ua4b4\ua062\ua916"), classNode.name);
        classNode2.invisibleAnnotations = Bytecode.mergeAnnotations(classNode.invisibleAnnotations, classNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7ea\ua4b4\ua062\ua916"), classNode.name);
    }

    public static void mergeAnnotations(MethodNode methodNode, MethodNode methodNode2) {
        methodNode2.visibleAnnotations = Bytecode.mergeAnnotations(methodNode.visibleAnnotations, methodNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), methodNode.name);
        methodNode2.invisibleAnnotations = Bytecode.mergeAnnotations(methodNode.invisibleAnnotations, methodNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), methodNode.name);
    }

    public static void mergeAnnotations(FieldNode fieldNode, FieldNode fieldNode2) {
        fieldNode2.visibleAnnotations = Bytecode.mergeAnnotations(fieldNode.visibleAnnotations, fieldNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("t\ua7ef\ua4b0\ua07d\ua901"), fieldNode.name);
        fieldNode2.invisibleAnnotations = Bytecode.mergeAnnotations(fieldNode.invisibleAnnotations, fieldNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("t\ua7ef\ua4b0\ua07d\ua901"), fieldNode.name);
    }

    private static List<AnnotationNode> mergeAnnotations(List<AnnotationNode> list, List<AnnotationNode> list2, String string, String string2) {
        try {
            if (list == null) {
                return list2;
            }
            if (list2 == null) {
                list2 = new ArrayList<AnnotationNode>();
            }
            for (AnnotationNode annotationNode : list) {
                if (!Bytecode.isMergeableAnnotation(annotationNode)) continue;
                Iterator<AnnotationNode> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().desc.equals(annotationNode.desc)) continue;
                    iterator.remove();
                    break;
                }
                list2.add(annotationNode);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[0x2B56CCC2 ^ 0x2B56CCC0];
            objectArray[0x6F4B8BFA ^ 0x6F4B8BFA] = string;
            objectArray[0x27B0D0CC ^ 0x27B0D0CD] = string2;
            logger.warn(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("W\ua7fe\ua4b6\ua074\ua915\u7d62\u8e43\u2475\u8b39\u3437w\ua7e8\ua4b6\ua07e\ua910\u7d78\u8e5e\u247f\u8b25\u3472v\ua7a6\ua4a2\ua079\ua90c\u7d7a\u8e59\u246e\u8b77\u347aw\ua7f4\ua4b2\ua078\ua90b\u7d71\u8e0a\u247b\u8b39\u3479}\ua7f2\ua4b4\ua065\ua90c\u7d79\u8e44\u2469\u8b77\u3471}\ua7f4\ua4f5\ua06a\ua918\u7d36\u8e51\u2467"), objectArray);
        }
        return list2;
    }

    private static boolean isMergeableAnnotation(AnnotationNode annotationNode) {
        if (annotationNode.desc.startsWith(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("^") + Constants.MIXIN_PACKAGE_REF)) {
            return mergeableAnnotationPattern.matcher(annotationNode.desc).matches();
        }
        return (0xCD2460E4 ^ 0xCD2460E5) != 0;
    }

    private static Pattern getMergeableAnnotationPattern() {
        StringBuilder stringBuilder = new StringBuilder(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("L\ua7ca\ua4fd"));
        for (int i = 0x939484D6 ^ 0x939484D6; i < MERGEABLE_MIXIN_ANNOTATIONS.length; ++i) {
            if (i > 0) {
                stringBuilder.append((char)(0xD6A75606 ^ 0xD6A7567A));
            }
            stringBuilder.append(MERGEABLE_MIXIN_ANNOTATIONS[i].getName().replace((char)(0x6CE5C8F2 ^ 0x6CE5C8DC), (char)(0x46B0725A ^ 0x46B07275)));
        }
        return Pattern.compile(stringBuilder.append(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(";\ua7bd\ua4f1")).toString());
    }

    public static void compareBridgeMethods(MethodNode methodNode, MethodNode methodNode2) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        ListIterator<AbstractInsnNode> listIterator2 = methodNode2.instructions.iterator();
        int n = 0x5906B826 ^ 0x5906B826;
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            AbstractInsnNode abstractInsnNode = listIterator.next();
            AbstractInsnNode abstractInsnNode2 = listIterator2.next();
            if (!(abstractInsnNode instanceof LabelNode)) {
                AbstractInsnNode abstractInsnNode3;
                AbstractInsnNode abstractInsnNode4;
                if (abstractInsnNode instanceof MethodInsnNode) {
                    abstractInsnNode4 = (MethodInsnNode)abstractInsnNode;
                    abstractInsnNode3 = (MethodInsnNode)abstractInsnNode2;
                    if (!((MethodInsnNode)abstractInsnNode4).name.equals(abstractInsnNode3.name)) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INVOKE_NAME, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                    if (!((MethodInsnNode)abstractInsnNode4).desc.equals(abstractInsnNode3.desc)) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INVOKE_DESC, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                } else {
                    if (abstractInsnNode.getOpcode() != abstractInsnNode2.getOpcode()) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INSN, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                    if (abstractInsnNode instanceof VarInsnNode) {
                        abstractInsnNode4 = (VarInsnNode)abstractInsnNode;
                        abstractInsnNode3 = (VarInsnNode)abstractInsnNode2;
                        if (((VarInsnNode)abstractInsnNode4).var != ((VarInsnNode)abstractInsnNode3).var) {
                            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_LOAD, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                        }
                    } else if (abstractInsnNode instanceof TypeInsnNode) {
                        abstractInsnNode4 = (TypeInsnNode)abstractInsnNode;
                        abstractInsnNode3 = (TypeInsnNode)abstractInsnNode2;
                        if (abstractInsnNode4.getOpcode() == (0x7ACA2DC5 ^ 0x7ACA2D05) && !((TypeInsnNode)abstractInsnNode4).desc.equals(((TypeInsnNode)abstractInsnNode3).desc)) {
                            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_CAST, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                        }
                    }
                }
            }
            ++n;
        }
        if (listIterator.hasNext() || listIterator2.hasNext()) {
            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_LENGTH, methodNode.name, methodNode.desc, n, null, null);
        }
    }

    static {
        int[] nArray = new int[0x49B2F893 ^ 0x49B2F894];
        nArray[0xB2A3E8CC ^ 0xB2A3E8CC] = 0x4F4D57F4 ^ 0x4F4D57F6;
        nArray[0x26EA4C31 ^ 0x26EA4C30] = 0xC013D12E ^ 0xC013D12D;
        nArray[0xF5B9A412 ^ 0xF5B9A410] = 0xE0B68B9B ^ 0xE0B68B9F;
        nArray[0xC748910A ^ 0xC7489109] = 0x5E58F1D2 ^ 0x5E58F1D7;
        nArray[0xD5539F42 ^ 0xD5539F46] = 0xF3012B3A ^ 0xF3012B3C;
        nArray[0xDA94C421 ^ 0xDA94C424] = 0x8053BDAE ^ 0x8053BDA9;
        nArray[0xDC145E1F ^ 0xDC145E19] = 0xF51AB860 ^ 0xF51AB868;
        CONSTANTS_INT = nArray;
        int[] nArray2 = new int[0x14B6A27B ^ 0x14B6A278];
        nArray2[0x412E0C07 ^ 0x412E0C07] = 0xF83E3F1C ^ 0xF83E3F17;
        nArray2[0x56915142 ^ 0x56915143] = 0x21C2012A ^ 0x21C20126;
        nArray2[0x4E695E86 ^ 0x4E695E84] = 0x733482E7 ^ 0x733482EA;
        CONSTANTS_FLOAT = nArray2;
        int[] nArray3 = new int[0xB75D72EE ^ 0xB75D72EC];
        nArray3[0xF93D6A4F ^ 0xF93D6A4F] = 0x9DA21C0B ^ 0x9DA21C05;
        nArray3[0x5A6ED25D ^ 0x5A6ED25C] = 0x1BE25058 ^ 0x1BE25057;
        CONSTANTS_DOUBLE = nArray3;
        int[] nArray4 = new int[0x75D3FD54 ^ 0x75D3FD56];
        nArray4[0x9C009B04 ^ 0x9C009B04] = 0xF1A95872 ^ 0xF1A9587B;
        nArray4[0x97D85B48 ^ 0x97D85B49] = 0xF9C49A70 ^ 0xF9C49A7A;
        CONSTANTS_LONG = nArray4;
        int[] nArray5 = new int[0x31EC97F2 ^ 0x31EC97E0];
        nArray5[0xF8E4F070 ^ 0xF8E4F070] = 0xA7C93DDD ^ 0xA7C93DDC;
        nArray5[0xBB4488F6 ^ 0xBB4488F7] = 0x29B7A8A ^ 0x29B7A88;
        nArray5[0x9B80603E ^ 0x9B80603C] = 0xDD9BF1E9 ^ 0xDD9BF1EA;
        nArray5[0xB73F028A ^ 0xB73F0289] = 0x875965FC ^ 0x875965F8;
        nArray5[0xABA6CD8A ^ 0xABA6CD8E] = 0x74093DE6 ^ 0x74093DE3;
        nArray5[0xB73FF500 ^ 0xB73FF505] = 0xF86097D1 ^ 0xF86097D7;
        nArray5[0xE6F40A97 ^ 0xE6F40A91] = 0xBCDB6E80 ^ 0xBCDB6E87;
        nArray5[0x7252F333 ^ 0x7252F334] = 0x86E335D4 ^ 0x86E335DC;
        nArray5[0x3E8F3E7F ^ 0x3E8F3E77] = 0x7C7E2B64 ^ 0x7C7E2B6D;
        nArray5[0x69108C60 ^ 0x69108C69] = 0xF0B2AC19 ^ 0xF0B2AC13;
        nArray5[0x2B24B32A ^ 0x2B24B320] = 0x166F666 ^ 0x166F66D;
        nArray5[0x298AF3C9 ^ 0x298AF3C2] = 0x118E8656 ^ 0x118E865A;
        nArray5[0xF8598839 ^ 0xF8598835] = 0x598CE331 ^ 0x598CE33C;
        nArray5[0x1C3628BB ^ 0x1C3628B6] = 0xFADB4E7F ^ 0xFADB4E71;
        nArray5[0x5D86E942 ^ 0x5D86E94C] = 0xE0A46443 ^ 0xE0A4644C;
        nArray5[0x36E21DB2 ^ 0x36E21DBD] = 0x10409722 ^ 0x10409732;
        nArray5[0x8EF2DC2E ^ 0x8EF2DC3E] = 0xDA47BF9D ^ 0xDA47BF8C;
        nArray5[0x45CC2EC3 ^ 0x45CC2ED2] = 0xABB15E4A ^ 0xABB15E58;
        CONSTANTS_ALL = nArray5;
        Object[] objectArray = new Object[0xCA90C792 ^ 0xCA90C79D];
        objectArray[0xB4A63EC2 ^ 0xB4A63EC2] = null;
        objectArray[0xB3C4F97C ^ 0xB3C4F97D] = 0x7578269F ^ 0x8A87D960;
        objectArray[0x636A910B ^ 0x636A9109] = 0xF4667055 ^ 0xF4667055;
        objectArray[0xC5B45EAD ^ 0xC5B45EAE] = 0xEEF6A11D ^ 0xEEF6A11C;
        objectArray[0x5327D85C ^ 0x5327D858] = 0x19556E3F ^ 0x19556E3D;
        objectArray[0x983E7AC3 ^ 0x983E7AC6] = 0x83B822A2 ^ 0x83B822A1;
        objectArray[0x29C5B462 ^ 0x29C5B464] = 0x52E89B72 ^ 0x52E89B76;
        objectArray[0x4A7C9DA5 ^ 0x4A7C9DA2] = 0xD39C7539 ^ 0xD39C753C;
        objectArray[0x5740C30C ^ 0x5740C304] = 0x18475E05F0F25ECL ^ 0x18475E05F0F25ECL;
        objectArray[0xF956F841 ^ 0xF956F848] = 0x7C74FEAE60B61E8BL ^ 0x7C74FEAE60B61E8AL;
        objectArray[0x26FFC5B3 ^ 0x26FFC5B9] = Float.valueOf(0.0f);
        objectArray[0x174A211 ^ 0x174A21A] = Float.valueOf(1.0f);
        objectArray[0xB177FD4C ^ 0xB177FD40] = Float.valueOf(2.0f);
        objectArray[0x353C7949 ^ 0x353C7944] = 0.0;
        objectArray[0x54A3309 ^ 0x54A3307] = 1.0;
        CONSTANTS_VALUES = objectArray;
        String[] stringArray = new String[0x8CAFF4E3 ^ 0x8CAFF4F2];
        stringArray[0x69062607 ^ 0x69062607] = null;
        stringArray[0x7E664094 ^ 0x7E664095] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[");
        stringArray[0x5782AB9C ^ 0x5782AB9E] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[");
        stringArray[0x5756CC51 ^ 0x5756CC52] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[");
        stringArray[0x2905D169 ^ 0x2905D16D] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[");
        stringArray[0x91ACA62D ^ 0x91ACA628] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[");
        stringArray[0x65DE9377 ^ 0x65DE9371] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[");
        stringArray[0x7B350ABB ^ 0x7B350ABC] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[");
        stringArray[0x3B6F014 ^ 0x3B6F01C] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("X");
        stringArray[0xF22A0CE ^ 0xF22A0C7] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("X");
        stringArray[0xA9F162B1 ^ 0xA9F162BB] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T");
        stringArray[0xB80AE648 ^ 0xB80AE643] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T");
        stringArray[0x744DFFB4 ^ 0x744DFFB8] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T");
        stringArray[0x1D67F701 ^ 0x1D67F70C] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("V");
        stringArray[0x9824F293 ^ 0x9824F29D] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("V");
        stringArray[0x1B553FFB ^ 0x1B553FF4] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[");
        stringArray[0x5BB6A2D9 ^ 0x5BB6A2C9] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[");
        CONSTANTS_TYPES = stringArray;
        String[] stringArray2 = new String[0x3E584E12 ^ 0x3E584E1E];
        stringArray2[0x9B43C9A7 ^ 0x9B43C9A7] = null;
        stringArray2[0xBBED94D8 ^ 0xBBED94D9] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438P\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44");
        stringArray2[0x6B25A173 ^ 0x6B25A171] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438Q\ua7ee\ua4b4\ua063\ua904\u7d75\u8e5e\u247f\u8b25");
        stringArray2[0x4A2AD2BF ^ 0x4A2AD2BC] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438P\ua7ff\ua4a1\ua074");
        stringArray2[0x4419DE70 ^ 0x4419DE74] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438A\ua7ee\ua4ba\ua063\ua911");
        stringArray2[0x2A8154A ^ 0x2A8154F] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438[\ua7e8\ua4a1\ua074\ua902\u7d73\u8e58");
        stringArray2[0x8F5C0629 ^ 0x8F5C062F] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438T\ua7ea\ua4ba\ua070\ua911");
        stringArray2[0xCAC78074 ^ 0xCAC78073] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438^\ua7e9\ua4bb\ua076");
        stringArray2[0x14E2D1C ^ 0x14E2D14] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438V\ua7e9\ua4a0\ua073\ua909\u7d73");
        stringArray2[0x8763DDFA ^ 0x8763DDF3] = null;
        stringArray2[0x9C5D9B8E ^ 0x9C5D9B84] = null;
        stringArray2[0x30917D5A ^ 0x30917D51] = null;
        BOXING_TYPES = stringArray2;
        String[] stringArray3 = new String[0x4BC418A2 ^ 0x4BC418AE];
        stringArray3[0xADE2A2C9 ^ 0xADE2A2C9] = null;
        stringArray3[0x146B82F6 ^ 0x146B82F7] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("p\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44\u244c\u8b36\u347bg\ua7e3");
        stringArray3[0x6342C9FF ^ 0x6342C9FD] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("q\ua7ee\ua4b4\ua063\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0x9FDB97BD ^ 0x9FDB97BE] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("p\ua7ff\ua4a1\ua074\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0xBDEE362D ^ 0xBDEE3629] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("a\ua7ee\ua4ba\ua063\ua911\u7d40\u8e4b\u2476\u8b22\u3472");
        stringArray3[0xCB70A0DB ^ 0xCB70A0DE] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("{\ua7e8\ua4a1\ua047\ua904\u7d7a\u8e5f\u247f");
        stringArray3[0x6CA772C1 ^ 0x6CA772C7] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("t\ua7ea\ua4ba\ua070\ua911\u7d40\u8e4b\u2476\u8b22\u3472");
        stringArray3[0xC6032E3F ^ 0xC6032E38] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("~\ua7e9\ua4bb\ua076\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0xCD75FEB0 ^ 0xCD75FEB8] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("v\ua7e9\ua4a0\ua073\ua909\u7d73\u8e7c\u247b\u8b3b\u3462w");
        stringArray3[0xF9950137 ^ 0xF995013E] = null;
        stringArray3[0x5D5B2AF5 ^ 0x5D5B2AFF] = null;
        stringArray3[0xEF3F4B2E ^ 0xEF3F4B25] = null;
        UNBOXING_METHODS = stringArray3;
        Class[] classArray = new Class[0x48AF26B1 ^ 0x48AF26B5];
        classArray[0x4B71F971 ^ 0x4B71F971] = Overwrite.class;
        classArray[0xE3657E84 ^ 0xE3657E85] = Intrinsic.class;
        classArray[0x27D4EB3A ^ 0x27D4EB38] = Final.class;
        classArray[0xC0A8B11D ^ 0xC0A8B11E] = Debug.class;
        MERGEABLE_MIXIN_ANNOTATIONS = classArray;
        mergeableAnnotationPattern = Bytecode.getMergeableAnnotationPattern();
        logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    }

    public static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility PRIVATE = new Visibility(0xE9F14CA1 ^ 0xE9F14CA3);
        public static final /* enum */ Visibility PROTECTED = new Visibility(0x8D30BEEE ^ 0x8D30BEEA);
        public static final /* enum */ Visibility PACKAGE = new Visibility(0x646F796E ^ 0x646F796E);
        public static final /* enum */ Visibility PUBLIC = new Visibility(0x6F7D6794 ^ 0x6F7D6795);
        static final int MASK = 7;
        final int access;
        private static final /* synthetic */ Visibility[] $VALUES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String string) {
            return Enum.valueOf(Visibility.class, string);
        }

        private Visibility(int n2) {
            this.access = n2;
        }

        static {
            Visibility[] visibilityArray = new Visibility[0x4356262E ^ 0x4356262A];
            visibilityArray[0x3F82C01B ^ 0x3F82C01B] = PRIVATE;
            visibilityArray[0xC46251E0 ^ 0xC46251E1] = PROTECTED;
            visibilityArray[0xE469ADE0 ^ 0xE469ADE2] = PACKAGE;
            visibilityArray[0x950B1738 ^ 0x950B173B] = PUBLIC;
            $VALUES = visibilityArray;
        }
    }
}

