/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.perf;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.spongepowered.asm.util.PrettyPrinter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class Profiler {
    public static final int ROOT = 1;
    public static final int FINE = 2;
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    private final List<String> phases = new ArrayList<String>();
    private final Deque<Section> stack = new LinkedList<Section>();
    private boolean active;

    public Profiler() {
        this.phases.add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46"));
    }

    public void setActive(boolean bl) {
        if (!this.active && bl || !bl) {
            this.reset();
        }
        this.active = bl;
    }

    public void reset() {
        for (Section section : this.sections.values()) {
            section.invalidate();
        }
        this.sections.clear();
        this.phases.clear();
        this.phases.add(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46"));
        this.stack.clear();
    }

    public Section get(String string) {
        Section section = this.sections.get(string);
        if (section == null) {
            section = this.active ? new LiveSection(string, this.phases.size() - (0x8D63606 ^ 0x8D63607)) : new Section(string);
            this.sections.put(string, section);
        }
        return section;
    }

    private Section getSubSection(String string, String string2, Section section) {
        Section section2 = this.sections.get(string);
        if (section2 == null) {
            section2 = new SubSection(string, this.phases.size() - (0x88EDDF42 ^ 0x88EDDF43), string2, section);
            this.sections.put(string, section2);
        }
        return section2;
    }

    boolean isHead(Section section) {
        return (this.stack.peek() == section ? 0x6B3F1805 ^ 0x6B3F1804 : 0x4287F9B7 ^ 0x4287F9B7) != 0;
    }

    public Section begin(String ... stringArray) {
        return this.begin(0x593AD974 ^ 0x593AD974, stringArray);
    }

    public Section begin(int n, String ... stringArray) {
        return this.begin(n, Joiner.on((char)(0x4D3D48E1 ^ 0x4D3D48CF)).join((Object[])stringArray));
    }

    public Section begin(String string) {
        return this.begin(0xBF9A476F ^ 0xBF9A476F, string);
    }

    public Section begin(int n, String string) {
        int n2 = (n & (0x57801ABB ^ 0x57801ABA)) != 0 ? 0x311278A1 ^ 0x311278A0 : 0x662120A5 ^ 0x662120A5;
        int n3 = (n & (0x6E01F6BF ^ 0x6E01F6BD)) != 0 ? 0xC13471F2 ^ 0xC13471F3 : 0x33C9B813 ^ 0x33C9B813;
        String string2 = string;
        Section section = this.stack.peek();
        if (section != null) {
            string2 = section.getName() + (n2 != 0 ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ab\ua4eb\ua031") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("<")) + string2;
            if (section.isRoot() && n2 == 0) {
                int n4 = section.getName().lastIndexOf(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7ab\ua4eb\ua031"));
                string = (n4 > (0x92E82257 ^ 0x6D17DDA8) ? section.getName().substring(n4 + (0xF4C85064 ^ 0xF4C85060)) : section.getName()) + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("<") + string;
                n2 = 0xDDCCBD28 ^ 0xDDCCBD29;
            }
        }
        Section section2 = this.get(n2 != 0 ? string : string2);
        if (n2 != 0 && section != null && this.active) {
            section2 = this.getSubSection(string2, section.getName(), section2);
        }
        section2.setFine(n3 != 0).setRoot(n2 != 0);
        this.stack.push(section2);
        return section2.start();
    }

    void end(Section section) {
        block5: {
            try {
                Section section2;
                Section section3 = section2 = this.stack.pop();
                while (section3 != section) {
                    if (section3 == null && this.active) {
                        if (section2 == null) {
                            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e4\ua4a0\ua065\ua945\u7d62\u8e42\u247f\u8b77\u3464f\ua7e7\ua4b6\ua07a\ua945\u7d7f\u8e59\u243a\u8b32\u347ab\ua7f2\ua4ac"));
                        }
                        throw new IllegalStateException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7f1\ua4bd\ua078\ua906\u7d7e\u8e0a\u246d\u8b36\u34642\ua7e8\ua4ba\ua065\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4a6\ua065\ua904\u7d75\u8e41\u2436\u8b77\u347fw\ua7e7\ua4b1\ua031\ua912\u7d77\u8e59\u243a") + section2);
                    }
                    section3 = this.stack.pop();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (!this.active) break block5;
                throw new IllegalStateException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e4\ua4a0\ua065\ua945\u7d62\u8e42\u247f\u8b77\u3464f\ua7e7\ua4b6\ua07a\ua945\u7d7f\u8e59\u243a\u8b32\u347ab\ua7f2\ua4ac"));
            }
        }
    }

    public void mark(String string) {
        long l = 0x9CD52628D8E2BC6L ^ 0x9CD52628D8E2BC6L;
        for (Section section : this.sections.values()) {
            l += section.getTime();
        }
        if (l == (0x1B734D6FC47C1EC3L ^ 0x1B734D6FC47C1EC3L)) {
            int n = this.phases.size();
            this.phases.set(n - (0x1FAE6972 ^ 0x1FAE6973), string);
            return;
        }
        this.phases.add(string);
        for (Section section : this.sections.values()) {
            section.mark();
        }
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public PrettyPrinter printer(boolean bl, boolean bl2) {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        int n = this.phases.size() + (0xC8E1CC0D ^ 0xC8E1CC09);
        int[] nArray = new int[0x6F2B2D69 ^ 0x6F2B2D6C];
        nArray[0x24D0F108 ^ 0x24D0F108] = 0xD7035540 ^ 0xD7035540;
        nArray[0x2324E0A6 ^ 0x2324E0A7] = 0x669B71E5 ^ 0x669B71E4;
        nArray[0x663B0701 ^ 0x663B0703] = 0x234DBB5 ^ 0x234DBB7;
        nArray[0x801BA1EB ^ 0x801BA1E8] = n - (0x4E6D9A4C ^ 0x4E6D9A4E);
        nArray[0x5F7BBE52 ^ 0x5F7BBE56] = n - (0x2DBC2A9E ^ 0x2DBC2A9F);
        int[] nArray2 = nArray;
        Object[] objectArray = new Object[n * (0xFBB2B39F ^ 0xFBB2B39D)];
        int n2 = 0x1C06D714 ^ 0x1C06D714;
        int n3 = 0x1DA296F0 ^ 0x1DA296F0;
        while (n2 < n) {
            objectArray[n3 + (0x9E79FDB5 ^ 0x9E79FDB4)] = PrettyPrinter.Alignment.RIGHT;
            if (n2 == nArray2[0x6B8C5E6D ^ 0x6B8C5E6D]) {
                objectArray[n3] = (bl2 ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6")) + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("A\ua7e3\ua4b6\ua065\ua90c\u7d79\u8e44");
                objectArray[n3 + (0xEC982BB8 ^ 0xEC982BB9)] = PrettyPrinter.Alignment.LEFT;
            } else {
                objectArray[n3] = n2 == nArray2[0xD7AE947 ^ 0xD7AE946] ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6\ua4f5\ua031\ua931\u7d59\u8e7e\u245b\u8b1b") : (n2 == nArray2[0xB6620502 ^ 0xB6620501] ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6\ua4f5\ua031\ua926\u7d79\u8e5f\u2474\u8b23") : (n2 == nArray2[0xCCE65CA1 ^ 0xCCE65CA5] ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("S\ua7f0\ua4b2\ua03f\ua945") : (n2 - nArray2[0x4209FCBE ^ 0x4209FCBC] < this.phases.size() ? this.phases.get(n2 - nArray2[0x2CADA3F5 ^ 0x2CADA3F7]) : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(""))));
            }
            n3 = ++n2 * (0xDD9A4C75 ^ 0xDD9A4C77);
        }
        prettyPrinter.table(objectArray).th().hr().add();
        for (Section section : this.sections.values()) {
            if (section.isFine() && !bl || bl2 && section.getDelegate() != section) continue;
            this.printSectionRow(prettyPrinter, n, nArray2, section, bl2);
            if (!bl2) continue;
            for (Section section2 : this.sections.values()) {
                Section section3 = section2.getDelegate();
                if (section2.isFine() && !bl || section3 != section || section3 == section2) continue;
                this.printSectionRow(prettyPrinter, n, nArray2, section2, bl2);
            }
        }
        return prettyPrinter.add();
    }

    private void printSectionRow(PrettyPrinter prettyPrinter, int n, int[] nArray, Section section, boolean bl) {
        long[] lArray;
        int n2 = section.getDelegate() != section ? 0xF94E57C7 ^ 0xF94E57C6 : 0x54CCC58 ^ 0x54CCC58;
        Object[] objectArray = new Object[n];
        int n3 = 0x7875DE14 ^ 0x7875DE15;
        if (bl) {
            objectArray[0x377532D1 ^ 0x377532D1] = n2 != 0 ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6\ua4eb\ua031") + section.getBaseName() : section.getName();
        } else {
            objectArray[0x9AA1836E ^ 0x9AA1836E] = (n2 != 0 ? \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("9\ua7a6") : \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6")) + section.getName();
        }
        long[] lArray2 = lArray = section.getTimes();
        int n4 = lArray2.length;
        for (int i = 0x43E0AD1A ^ 0x43E0AD1A; i < n4; ++i) {
            long l = lArray2[i];
            if (n3 == nArray[0xAD97E222 ^ 0xAD97E223]) {
                objectArray[n3++] = section.getTotalTime() + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7eb\ua4a6");
            }
            if (n3 < nArray[0xEB1DCA7A ^ 0xEB1DCA78] || n3 >= objectArray.length) continue;
            objectArray[n3++] = l + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7eb\ua4a6");
        }
        objectArray[nArray[0x9F4A84C1 ^ 0x9F4A84C2]] = section.getTotalCount();
        objectArray[nArray[0x6ED11DB6 ^ 0x6ED11DB2]] = new DecimalFormat(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7a6\ua4f5\ua032\ua946\u7d35\u8e1a\u2434\u8b67\u3427\"\ua7a6\ua4b8\ua062")).format(section.getTotalAverageTime());
        for (int i = 0x1FAC9E4B ^ 0x1FAC9E4B; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            objectArray[i] = \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("?");
        }
        prettyPrinter.tr(objectArray);
    }

    class SubSection
    extends LiveSection {
        private final String baseName;
        private final Section root;

        SubSection(String string, int n, String string2, Section section) {
            super(string, n);
            this.baseName = string2;
            this.root = section;
        }

        @Override
        Section invalidate() {
            this.root.invalidate();
            return super.invalidate();
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public void setInfo(String string) {
            this.root.setInfo(string);
            super.setInfo(string);
        }

        @Override
        Section getDelegate() {
            return this.root;
        }

        @Override
        Section start() {
            this.root.start();
            return super.start();
        }

        @Override
        public Section end() {
            this.root.stop();
            return super.end();
        }

        @Override
        public Section next(String string) {
            super.stop();
            return this.root.next(string);
        }
    }

    class LiveSection
    extends Section {
        private int cursor;
        private long[] times;
        private long start;
        private long time;
        private long markedTime;
        private int count;
        private int markedCount;

        LiveSection(String string, int n) {
            super(string);
            this.cursor = 0x592442E3 ^ 0x592442E3;
            this.times = new long[0xAC23CC58 ^ 0xAC23CC58];
            this.start = 0x5885B6CE620F9ECEL ^ 0x5885B6CE620F9ECEL;
            this.cursor = n;
        }

        @Override
        Section start() {
            this.start = System.currentTimeMillis();
            return this;
        }

        @Override
        protected Section stop() {
            if (this.start > (0x946C0E11E80D5CD0L ^ 0x946C0E11E80D5CD0L)) {
                this.time += System.currentTimeMillis() - this.start;
            }
            this.start = 0xD483F08994D8D2DL ^ 0xD483F08994D8D2DL;
            this.count += 0x3FB662B5 ^ 0x3FB662B4;
            return this;
        }

        @Override
        public Section end() {
            this.stop();
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        @Override
        void mark() {
            if (this.cursor >= this.times.length) {
                this.times = Arrays.copyOf(this.times, this.cursor + (0xCD276DA7 ^ 0xCD276DA3));
            }
            this.times[this.cursor] = this.time;
            this.markedTime += this.time;
            this.markedCount += this.count;
            this.time = 0x3364B6A838298C4DL ^ 0x3364B6A838298C4DL;
            this.count = 0x2BC8C994 ^ 0x2BC8C994;
            this.cursor += 0x1E3ADD0 ^ 0x1E3ADD1;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public long getTotalTime() {
            return this.time + this.markedTime;
        }

        @Override
        public double getSeconds() {
            return (double)this.time * 0.001;
        }

        @Override
        public double getTotalSeconds() {
            return (double)(this.time + this.markedTime) * 0.001;
        }

        @Override
        public long[] getTimes() {
            long[] lArray = new long[this.cursor + (0xC58CB4B9 ^ 0xC58CB4B8)];
            System.arraycopy(this.times, 0x690F23F8 ^ 0x690F23F8, lArray, 0x70597600 ^ 0x70597600, Math.min(this.times.length, this.cursor));
            lArray[this.cursor] = this.time;
            return lArray;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int getTotalCount() {
            return this.count + this.markedCount;
        }

        @Override
        public double getAverageTime() {
            return this.count > 0 ? (double)this.time / (double)this.count : 0.0;
        }

        @Override
        public double getTotalAverageTime() {
            return this.count > 0 ? (double)(this.time + this.markedTime) / (double)(this.count + this.markedCount) : 0.0;
        }
    }

    public class Section {
        static final String SEPARATOR_ROOT = " -> ";
        static final String SEPARATOR_CHILD = ".";
        private final String name;
        private boolean root;
        private boolean fine;
        protected boolean invalidated;
        private String info;

        Section(String string) {
            this.name = string;
            this.info = string;
        }

        Section getDelegate() {
            return this;
        }

        Section invalidate() {
            this.invalidated = 0xCD5EFC59 ^ 0xCD5EFC58;
            return this;
        }

        Section setRoot(boolean bl) {
            this.root = bl;
            return this;
        }

        public boolean isRoot() {
            return this.root;
        }

        Section setFine(boolean bl) {
            this.fine = bl;
            return this;
        }

        public boolean isFine() {
            return this.fine;
        }

        public String getName() {
            return this.name;
        }

        public String getBaseName() {
            return this.name;
        }

        public void setInfo(String string) {
            this.info = string;
        }

        public String getInfo() {
            return this.info;
        }

        Section start() {
            return this;
        }

        protected Section stop() {
            return this;
        }

        public Section end() {
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        public Section next(String string) {
            this.end();
            return Profiler.this.begin(string);
        }

        void mark() {
        }

        public long getTime() {
            return 0xBF463310B3920E47L ^ 0xBF463310B3920E47L;
        }

        public long getTotalTime() {
            return 0xCFC32202CA7C325CL ^ 0xCFC32202CA7C325CL;
        }

        public double getSeconds() {
            return 0.0;
        }

        public double getTotalSeconds() {
            return 0.0;
        }

        public long[] getTimes() {
            return new long[0x7A858C6C ^ 0x7A858C6D];
        }

        public int getCount() {
            return 0x772DA21C ^ 0x772DA21C;
        }

        public int getTotalCount() {
            return 0x51873F18 ^ 0x51873F18;
        }

        public double getAverageTime() {
            return 0.0;
        }

        public double getTotalAverageTime() {
            return 0.0;
        }

        public final String toString() {
            return this.name;
        }
    }
}

