/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.util.ITokenProvider;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.ObfuscationManager;
import org.spongepowered.tools.obfuscation.TargetMap;
import org.spongepowered.tools.obfuscation.interfaces.IJavadocProvider;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IMixinValidator;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;
import org.spongepowered.tools.obfuscation.interfaces.ITypeHandleProvider;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandleSimulated;
import org.spongepowered.tools.obfuscation.mirror.TypeReference;
import org.spongepowered.tools.obfuscation.struct.InjectorRemap;
import org.spongepowered.tools.obfuscation.validation.ParentValidator;
import org.spongepowered.tools.obfuscation.validation.TargetValidator;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

final class AnnotatedMixins
implements ITokenProvider,
IJavadocProvider,
IMixinAnnotationProcessor,
ITypeHandleProvider {
    private static final String MAPID_SYSTEM_PROPERTY = "mixin.target.mapid";
    private static Map<ProcessingEnvironment, AnnotatedMixins> instances = new HashMap<ProcessingEnvironment, AnnotatedMixins>();
    private final IMixinAnnotationProcessor.CompilerEnvironment env;
    private final ProcessingEnvironment processingEnv;
    private final Map<String, AnnotatedMixin> mixins = new HashMap<String, AnnotatedMixin>();
    private final List<AnnotatedMixin> mixinsForPass = new ArrayList<AnnotatedMixin>();
    private final IObfuscationManager obf;
    private final List<IMixinValidator> validators;
    private final Map<String, Integer> tokenCache = new HashMap<String, Integer>();
    private final TargetMap targets;
    private Properties properties;

    private AnnotatedMixins(ProcessingEnvironment processingEnvironment) {
        this.env = this.detectEnvironment(processingEnvironment);
        this.processingEnv = processingEnvironment;
        this.printMessage(Diagnostic.Kind.NOTE, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("A\ua7f6\ua4ba\ua07f\ua902\u7d73\u8e7a\u2475\u8b20\u3472`\ua7e3\ua4b1\ua031\ua928\u7d5f\u8e72\u2453\u8b19\u3437S\ua7e8\ua4bb\ua07e\ua911\u7d77\u8e5e\u2473\u8b38\u34792\ua7d6\ua4a7\ua07e\ua906\u7d73\u8e59\u2469\u8b38\u34652\ua7d0\ua4b0\ua063\ua916\u7d7f\u8e45\u2474\u8b6a\u3427<\ua7b1\ua4fb\ua020\ua954"));
        this.targets = this.initTargetMap();
        this.obf = new ObfuscationManager(this);
        this.obf.init();
        this.validators = ImmutableList.of((Object)new ParentValidator(this), (Object)new TargetValidator(this));
        this.initTokenCache(this.getOption(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("f\ua7e9\ua4be\ua074\ua90b\u7d65")));
    }

    protected TargetMap initTargetMap() {
        TargetMap targetMap = TargetMap.create(System.getProperty(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e5e\u247b\u8b25\u3470w\ua7f2\ua4fb\ua07c\ua904\u7d66\u8e43\u247e")));
        System.setProperty(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e5e\u247b\u8b25\u3470w\ua7f2\ua4fb\ua07c\ua904\u7d66\u8e43\u247e"), targetMap.getSessionId());
        String string = this.getOption(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("v\ua7e3\ua4a5\ua074\ua90b\u7d72\u8e4f\u2474\u8b34\u346eF\ua7e7\ua4a7\ua076\ua900\u7d62\u8e59\u245c\u8b3e\u347bw"));
        if (string != null) {
            try {
                targetMap.readImports(new File(string));
            }
            catch (IOException iOException) {
                this.printMessage(Diagnostic.Kind.WARNING, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437`\ua7e3\ua4b4\ua075\ua945\u7d70\u8e58\u2475\u8b3a\u3437a\ua7f6\ua4b0\ua072\ua90c\u7d70\u8e43\u247f\u8b33\u3437{\ua7eb\ua4a5\ua07e\ua917\u7d62\u8e59\u243a\u8b31\u347e~\ua7e3\ua4ef\ua031") + string);
            }
        }
        return targetMap;
    }

    private void initTokenCache(String string) {
        if (string != null) {
            String[] stringArray;
            Pattern pattern = Pattern.compile(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("L\ua7ae\ua48e\ua050\ua948\u7d4c\u8e1a\u2437\u8b6e\u344b?\ua7d9\ua489\ua03f\ua938\u7d3d\u8e03\u2427\u8b7f\u344c\"\ua7ab\ua4ec\ua04c\ua94e\u7d3f\u8e0e"));
            String[] stringArray2 = stringArray = string.replaceAll(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("N\ua7f5"), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("")).toUpperCase().split(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("I\ua7bd\ua4f9\ua04c"));
            int n = stringArray2.length;
            for (int i = 0x8F443863 ^ 0x8F443863; i < n; ++i) {
                String string2 = stringArray2[i];
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                this.tokenCache.put(matcher.group(0x82ED1F66 ^ 0x82ED1F67), Integer.parseInt(matcher.group(0x98C4D912 ^ 0x98C4D910)));
            }
        }
    }

    @Override
    public ITypeHandleProvider getTypeProvider() {
        return this;
    }

    @Override
    public ITokenProvider getTokenProvider() {
        return this;
    }

    @Override
    public IObfuscationManager getObfuscationManager() {
        return this.obf;
    }

    @Override
    public IJavadocProvider getJavadocProvider() {
        return this;
    }

    @Override
    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    @Override
    public IMixinAnnotationProcessor.CompilerEnvironment getCompilerEnvironment() {
        return this.env;
    }

    @Override
    public Integer getToken(String string) {
        if (this.tokenCache.containsKey(string)) {
            return this.tokenCache.get(string);
        }
        String string2 = this.getOption(string);
        Integer n = null;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tokenCache.put(string, n);
        return n;
    }

    @Override
    public String getOption(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.processingEnv.getOptions().get(string);
        if (string2 != null) {
            return string2;
        }
        return this.getProperties().getProperty(string);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                Filer filer = this.processingEnv.getFiler();
                FileObject fileObject = filer.getResource(StandardLocation.SOURCE_PATH, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(""), \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e5a\u2468\u8b38\u3467w\ua7f4\ua4a1\ua078\ua900\u7d65"));
                if (fileObject != null) {
                    InputStream inputStream = fileObject.openInputStream();
                    this.properties.load(inputStream);
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.properties;
    }

    private IMixinAnnotationProcessor.CompilerEnvironment detectEnvironment(ProcessingEnvironment processingEnvironment) {
        if (processingEnvironment.getClass().getName().contains(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("x\ua7e2\ua4a1"))) {
            return IMixinAnnotationProcessor.CompilerEnvironment.JDT;
        }
        return IMixinAnnotationProcessor.CompilerEnvironment.JAVAC;
    }

    public void writeMappings() {
        this.obf.writeMappings();
    }

    public void writeReferences() {
        this.obf.writeReferences();
    }

    public void clear() {
        this.mixins.clear();
    }

    public void registerMixin(TypeElement typeElement) {
        String string = typeElement.getQualifiedName().toString();
        if (!this.mixins.containsKey(string)) {
            AnnotatedMixin annotatedMixin = new AnnotatedMixin(this, typeElement);
            this.targets.registerTargets(annotatedMixin);
            annotatedMixin.runValidators(IMixinValidator.ValidationPass.EARLY, this.validators);
            this.mixins.put(string, annotatedMixin);
            this.mixinsForPass.add(annotatedMixin);
        }
    }

    public AnnotatedMixin getMixin(TypeElement typeElement) {
        return this.getMixin(typeElement.getQualifiedName().toString());
    }

    public AnnotatedMixin getMixin(String string) {
        return this.mixins.get(string);
    }

    public Collection<TypeMirror> getMixinsTargeting(TypeMirror typeMirror) {
        return this.getMixinsTargeting((TypeElement)((DeclaredType)typeMirror).asElement());
    }

    public Collection<TypeMirror> getMixinsTargeting(TypeElement typeElement) {
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
        for (TypeReference typeReference : this.targets.getMixinsTargeting(typeElement)) {
            TypeHandle typeHandle = typeReference.getHandle(this.processingEnv);
            if (typeHandle == null) continue;
            arrayList.add(typeHandle.getType());
        }
        return arrayList;
    }

    public void registerAccessor(TypeElement typeElement, ExecutableElement executableElement) {
        AnnotatedMixin annotatedMixin = this.getMixin(typeElement);
        if (annotatedMixin == null) {
            this.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e6a\u245b\u8b34\u3474w\ua7f5\ua4a6\ua07e\ua917\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78\u8e0a\u2475\u8b39\u3437s\ua7a6\ua4bb\ua07e\ua90b\u7d3b\u8e47\u2473\u8b2f\u347e|\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e"), executableElement);
            return;
        }
        AnnotationHandle annotationHandle = AnnotationHandle.of(executableElement, Accessor.class);
        annotatedMixin.registerAccessor(executableElement, annotationHandle, this.shouldRemap(annotatedMixin, annotationHandle));
    }

    public void registerInvoker(TypeElement typeElement, ExecutableElement executableElement) {
        AnnotatedMixin annotatedMixin = this.getMixin(typeElement);
        if (annotatedMixin == null) {
            this.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e6a\u245b\u8b34\u3474w\ua7f5\ua4a6\ua07e\ua917\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78\u8e0a\u2475\u8b39\u3437s\ua7a6\ua4bb\ua07e\ua90b\u7d3b\u8e47\u2473\u8b2f\u347e|\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e"), executableElement);
            return;
        }
        AnnotationHandle annotationHandle = AnnotationHandle.of(executableElement, Invoker.class);
        annotatedMixin.registerInvoker(executableElement, annotationHandle, this.shouldRemap(annotatedMixin, annotationHandle));
    }

    public void registerOverwrite(TypeElement typeElement, ExecutableElement executableElement) {
        AnnotatedMixin annotatedMixin = this.getMixin(typeElement);
        if (annotatedMixin == null) {
            this.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e6a\u2455\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u247b\u8b39\u3479}\ua7f2\ua4b4\ua065\ua90c\u7d79\u8e44\u243a\u8b38\u34792\ua7e7\ua4f5\ua07f\ua90a\u7d78\u8e07\u2477\u8b3e\u346f{\ua7e8\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33"), executableElement);
            return;
        }
        AnnotationHandle annotationHandle = AnnotationHandle.of(executableElement, Overwrite.class);
        annotatedMixin.registerOverwrite(executableElement, annotationHandle, this.shouldRemap(annotatedMixin, annotationHandle));
    }

    public void registerShadow(TypeElement typeElement, VariableElement variableElement, AnnotationHandle annotationHandle) {
        AnnotatedMixin annotatedMixin = this.getMixin(typeElement);
        if (annotatedMixin == null) {
            this.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e6a\u2449\u8b3f\u3476v\ua7e9\ua4a2\ua031\ua904\u7d78\u8e44\u2475\u8b23\u3476f\ua7ef\ua4ba\ua07f\ua945\u7d79\u8e44\u243a\u8b36\u3437|\ua7e9\ua4bb\ua03c\ua908\u7d7f\u8e52\u2473\u8b39\u3437t\ua7ef\ua4b0\ua07d\ua901"), variableElement);
            return;
        }
        annotatedMixin.registerShadow(variableElement, annotationHandle, this.shouldRemap(annotatedMixin, annotationHandle));
    }

    public void registerShadow(TypeElement typeElement, ExecutableElement executableElement, AnnotationHandle annotationHandle) {
        AnnotatedMixin annotatedMixin = this.getMixin(typeElement);
        if (annotatedMixin == null) {
            this.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e6a\u2449\u8b3f\u3476v\ua7e9\ua4a2\ua031\ua904\u7d78\u8e44\u2475\u8b23\u3476f\ua7ef\ua4ba\ua07f\ua945\u7d79\u8e44\u243a\u8b36\u3437|\ua7e9\ua4bb\ua03c\ua908\u7d7f\u8e52\u2473\u8b39\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), executableElement);
            return;
        }
        annotatedMixin.registerShadow(executableElement, annotationHandle, this.shouldRemap(annotatedMixin, annotationHandle));
    }

    public void registerInjector(TypeElement typeElement, ExecutableElement executableElement, AnnotationHandle annotationHandle) {
        AnnotatedMixin annotatedMixin = this.getMixin(typeElement);
        if (annotatedMixin == null) {
            this.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e9\ua4a0\ua07f\ua901\u7d36") + annotationHandle + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4ba\ua07f\ua945\u7d77\u8e0a\u2474\u8b38\u3479?\ua7eb\ua4bc\ua069\ua90c\u7d78\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1"), executableElement);
            return;
        }
        InjectorRemap injectorRemap = new InjectorRemap(this.shouldRemap(annotatedMixin, annotationHandle));
        annotatedMixin.registerInjector(executableElement, annotationHandle, injectorRemap);
        injectorRemap.dispatchPendingMessages(this);
    }

    public void registerSoftImplements(TypeElement typeElement, AnnotationHandle annotationHandle) {
        AnnotatedMixin annotatedMixin = this.getMixin(typeElement);
        if (annotatedMixin == null) {
            this.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e6a\u2453\u8b3a\u3467~\ua7e3\ua4b8\ua074\ua90b\u7d62\u8e59\u243a\u8b36\u3479|\ua7e9\ua4a1\ua070\ua911\u7d7f\u8e45\u2474\u8b77\u3478|\ua7a6\ua4b4\ua031\ua90b\u7d79\u8e44\u2437\u8b3a\u347ej\ua7ef\ua4bb\ua031\ua906\u7d7a\u8e4b\u2469\u8b24"));
            return;
        }
        annotatedMixin.registerSoftImplements(annotationHandle);
    }

    public void onPassStarted() {
        this.mixinsForPass.clear();
    }

    public void onPassCompleted(RoundEnvironment roundEnvironment) {
        if (!\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("f\ua7f4\ua4a0\ua074").equalsIgnoreCase(this.getOption(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("v\ua7ef\ua4a6\ua070\ua907\u7d7a\u8e4f\u244e\u8b36\u3465u\ua7e3\ua4a1\ua054\ua91d\u7d66\u8e45\u2468\u8b23")))) {
            this.targets.write((0x6F2B5799 ^ 0x6F2B5798) != 0);
        }
        for (AnnotatedMixin annotatedMixin : roundEnvironment.processingOver() ? this.mixins.values() : this.mixinsForPass) {
            annotatedMixin.runValidators(roundEnvironment.processingOver() ? IMixinValidator.ValidationPass.FINAL : IMixinValidator.ValidationPass.LATE, this.validators);
        }
    }

    private boolean shouldRemap(AnnotatedMixin annotatedMixin, AnnotationHandle annotationHandle) {
        return annotationHandle.getBoolean(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("`\ua7e3\ua4b8\ua070\ua915"), annotatedMixin.remap());
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence charSequence) {
        if (this.env == IMixinAnnotationProcessor.CompilerEnvironment.JAVAC || kind != Diagnostic.Kind.NOTE) {
            this.processingEnv.getMessager().printMessage(kind, charSequence);
        }
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence charSequence, Element element) {
        this.processingEnv.getMessager().printMessage(kind, charSequence, element);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence charSequence, Element element, AnnotationMirror annotationMirror) {
        this.processingEnv.getMessager().printMessage(kind, charSequence, element, annotationMirror);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence charSequence, Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        this.processingEnv.getMessager().printMessage(kind, charSequence, element, annotationMirror, annotationValue);
    }

    @Override
    public TypeHandle getTypeHandle(String string) {
        string = string.replace((char)(0xABBC7B81 ^ 0xABBC7BAE), (char)(0xD7298016 ^ 0xD7298038));
        Elements elements = this.processingEnv.getElementUtils();
        TypeElement typeElement = elements.getTypeElement(string);
        if (typeElement != null) {
            try {
                return new TypeHandle(typeElement);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        int n = string.lastIndexOf(0x7B85922B ^ 0x7B859205);
        if (n > (0x58F97577 ^ 0xA7068A88)) {
            String string2 = string.substring(0x7282F112 ^ 0x7282F112, n);
            PackageElement packageElement = elements.getPackageElement(string2);
            if (packageElement != null) {
                return new TypeHandle(packageElement, string);
            }
        }
        return null;
    }

    @Override
    public TypeHandle getSimulatedHandle(String string, TypeMirror typeMirror) {
        string = string.replace((char)(0x345994F3 ^ 0x345994DC), (char)(0x52A85761 ^ 0x52A8574F));
        int n = string.lastIndexOf(0x6E8C0205 ^ 0x6E8C022B);
        if (n > (0xE94B764F ^ 0x16B489B0)) {
            String string2 = string.substring(0x11273C12 ^ 0x11273C12, n);
            PackageElement packageElement = this.processingEnv.getElementUtils().getPackageElement(string2);
            if (packageElement != null) {
                return new TypeHandleSimulated(packageElement, string, typeMirror);
            }
        }
        return new TypeHandleSimulated(string, typeMirror);
    }

    @Override
    public String getJavadoc(Element element) {
        Elements elements = this.processingEnv.getElementUtils();
        return elements.getDocComment(element);
    }

    public static AnnotatedMixins getMixinsForEnvironment(ProcessingEnvironment processingEnvironment) {
        AnnotatedMixins annotatedMixins = instances.get(processingEnvironment);
        if (annotatedMixins == null) {
            annotatedMixins = new AnnotatedMixins(processingEnvironment);
            instances.put(processingEnvironment, annotatedMixins);
        }
        return annotatedMixins;
    }
}

