/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IOptionProvider;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class ObfuscationType {
    private static final Map<String, ObfuscationType> types = new LinkedHashMap<String, ObfuscationType>();
    private final String key;
    private final ObfuscationTypeDescriptor descriptor;
    private final IMixinAnnotationProcessor ap;
    private final IOptionProvider options;

    private ObfuscationType(ObfuscationTypeDescriptor obfuscationTypeDescriptor, IMixinAnnotationProcessor iMixinAnnotationProcessor) {
        this.key = obfuscationTypeDescriptor.getKey();
        this.descriptor = obfuscationTypeDescriptor;
        this.ap = iMixinAnnotationProcessor;
        this.options = iMixinAnnotationProcessor;
    }

    public final ObfuscationEnvironment createEnvironment() {
        try {
            Class<? extends ObfuscationEnvironment> clazz = this.descriptor.getEnvironmentType();
            Class[] classArray = new Class[0xA11F9B6C ^ 0xA11F9B6D];
            classArray[0x2E597424 ^ 0x2E597424] = ObfuscationType.class;
            Constructor<? extends ObfuscationEnvironment> constructor = clazz.getDeclaredConstructor(classArray);
            constructor.setAccessible((0x3C5D5C60 ^ 0x3C5D5C61) != 0);
            Object[] objectArray = new Object[0xCB73622F ^ 0xCB73622E];
            objectArray[0x4C002199 ^ 0x4C002199] = this;
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return this.key;
    }

    public String getKey() {
        return this.key;
    }

    public ObfuscationTypeDescriptor getConfig() {
        return this.descriptor;
    }

    public IMixinAnnotationProcessor getAnnotationProcessor() {
        return this.ap;
    }

    public boolean isDefault() {
        String string = this.options.getOption(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("v\ua7e3\ua4b3\ua070\ua910\u7d7a\u8e5e\u2455\u8b35\u3471g\ua7f5\ua4b6\ua070\ua911\u7d7f\u8e45\u2474\u8b12\u3479d"));
        return (string == null && this.key.equals(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("a\ua7e3\ua4b4\ua063\ua902\u7d73")) || string != null && this.key.equals(string.toLowerCase()) ? 0x568BB39F ^ 0x568BB39E : 0x58CE3E0D ^ 0x58CE3E0D) != 0;
    }

    public boolean isSupported() {
        return (this.getInputFileNames().size() > 0 ? 0x2799B62 ^ 0x2799B63 : 0x40F6B229 ^ 0x40F6B229) != 0;
    }

    public List<String> getInputFileNames() {
        String string;
        ImmutableList.Builder builder = ImmutableList.builder();
        String string2 = this.options.getOption(this.descriptor.getInputFileOption());
        if (string2 != null) {
            builder.add((Object)string2);
        }
        if ((string = this.options.getOption(this.descriptor.getExtraInputFilesOption())) != null) {
            String[] stringArray = string.split(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(")"));
            int n = stringArray.length;
            for (int i = 0x2E42ECB0 ^ 0x2E42ECB0; i < n; ++i) {
                String string3 = stringArray[i];
                builder.add((Object)string3.trim());
            }
        }
        return builder.build();
    }

    public String getOutputFileName() {
        return this.options.getOption(this.descriptor.getOutputFileOption());
    }

    public static Iterable<ObfuscationType> types() {
        return types.values();
    }

    public static ObfuscationType create(ObfuscationTypeDescriptor obfuscationTypeDescriptor, IMixinAnnotationProcessor iMixinAnnotationProcessor) {
        String string = obfuscationTypeDescriptor.getKey();
        if (types.containsKey(string)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("]\ua7e4\ua4b3\ua064\ua916\u7d75\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4a1\ua068\ua915\u7d73\u8e0a\u246d\u8b3e\u3463z\ua7a6\ua4be\ua074\ua91c\u7d36") + string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7f1\ua4b4\ua062\ua945\u7d77\u8e46\u2468\u8b32\u3476v\ua7ff\ua4f5\ua063\ua900\u7d71\u8e43\u2469\u8b23\u3472`\ua7e3\ua4b1"));
        }
        ObfuscationType obfuscationType = new ObfuscationType(obfuscationTypeDescriptor, iMixinAnnotationProcessor);
        types.put(string, obfuscationType);
        return obfuscationType;
    }

    public static ObfuscationType get(String string) {
        ObfuscationType obfuscationType = types.get(string);
        if (obfuscationType == null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("]\ua7e4\ua4b3\ua064\ua916\u7d75\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4a1\ua068\ua915\u7d73\u8e0a\u246d\u8b3e\u3463z\ua7a6\ua4be\ua074\ua91c\u7d36") + string + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7f1\ua4b4\ua062\ua945\u7d78\u8e45\u246e\u8b77\u3465w\ua7e1\ua4bc\ua062\ua911\u7d73\u8e58\u247f\u8b33"));
        }
        return obfuscationType;
    }
}

