/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.mixin.refmap.ReferenceMapper;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IReferenceManager;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class ReferenceManager
implements IReferenceManager {
    private final IMixinAnnotationProcessor ap;
    private final String outRefMapFileName;
    private final List<ObfuscationEnvironment> environments;
    private final ReferenceMapper refMapper = new ReferenceMapper();
    private boolean allowConflicts;

    public ReferenceManager(IMixinAnnotationProcessor iMixinAnnotationProcessor, List<ObfuscationEnvironment> list) {
        this.ap = iMixinAnnotationProcessor;
        this.environments = list;
        this.outRefMapFileName = this.ap.getOption(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("}\ua7f3\ua4a1\ua043\ua900\u7d70\u8e67\u247b\u8b27\u3451{\ua7ea\ua4b0"));
    }

    @Override
    public boolean getAllowConflicts() {
        return this.allowConflicts;
    }

    @Override
    public void setAllowConflicts(boolean bl) {
        this.allowConflicts = bl;
    }

    @Override
    public void write() {
        if (this.outRefMapFileName == null) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            printWriter = this.newWriter(this.outRefMapFileName, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("`\ua7e3\ua4b3\ua07c\ua904\u7d66"));
            this.refMapper.write(printWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private PrintWriter newWriter(String string, String string2) throws IOException {
        if (string.matches(\u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("L\ua7a8\ua4ff\ua04a\ua939\u7d4a\u8e05\u2420\u8b0a\u34398\ua7a2"))) {
            File file = new File(string);
            file.getParentFile().mkdirs();
            this.ap.printMessage(Diagnostic.Kind.NOTE, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("E\ua7f4\ua4bc\ua065\ua90c\u7d78\u8e4d\u243a") + string2 + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7f2\ua4ba\ua031") + file.getAbsolutePath());
            return new PrintWriter(file);
        }
        FileObject fileObject = this.ap.getProcessingEnvironment().getFiler().createResource(StandardLocation.CLASS_OUTPUT, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af(""), string, new Element[0xA802F0DC ^ 0xA802F0DC]);
        this.ap.printMessage(Diagnostic.Kind.NOTE, \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("E\ua7f4\ua4bc\ua065\ua90c\u7d78\u8e4d\u243a") + string2 + \u7eb3\u897f\u59b2.\u5168\u90fd\u770b\u89c1\u54af("2\ua7f2\ua4ba\ua031") + new File(fileObject.toUri()).getAbsolutePath());
        return new PrintWriter(fileObject.openWriter());
    }

    @Override
    public ReferenceMapper getMapper() {
        return this.refMapper;
    }

    @Override
    public void addMethodMapping(String string, String string2, ObfuscationData<MappingMethod> obfuscationData) {
        for (ObfuscationEnvironment obfuscationEnvironment : this.environments) {
            MappingMethod mappingMethod = obfuscationData.get(obfuscationEnvironment.getType());
            if (mappingMethod == null) continue;
            MemberInfo memberInfo = new MemberInfo(mappingMethod);
            this.addMapping(obfuscationEnvironment.getType(), string, string2, memberInfo.toString());
        }
    }

    @Override
    public void addMethodMapping(String string, String string2, MemberInfo memberInfo, ObfuscationData<MappingMethod> obfuscationData) {
        for (ObfuscationEnvironment obfuscationEnvironment : this.environments) {
            MappingMethod mappingMethod = obfuscationData.get(obfuscationEnvironment.getType());
            if (mappingMethod == null) continue;
            MemberInfo memberInfo2 = memberInfo.remapUsing(mappingMethod, (0xE2C04C8B ^ 0xE2C04C8A) != 0);
            this.addMapping(obfuscationEnvironment.getType(), string, string2, memberInfo2.toString());
        }
    }

    @Override
    public void addFieldMapping(String string, String string2, MemberInfo memberInfo, ObfuscationData<MappingField> obfuscationData) {
        for (ObfuscationEnvironment obfuscationEnvironment : this.environments) {
            MappingField mappingField = obfuscationData.get(obfuscationEnvironment.getType());
            if (mappingField == null) continue;
            MemberInfo memberInfo2 = MemberInfo.fromMapping(mappingField.transform(obfuscationEnvironment.remapDescriptor(memberInfo.desc)));
            this.addMapping(obfuscationEnvironment.getType(), string, string2, memberInfo2.toString());
        }
    }

    @Override
    public void addClassMapping(String string, String string2, ObfuscationData<String> obfuscationData) {
        for (ObfuscationEnvironment obfuscationEnvironment : this.environments) {
            String string3 = obfuscationData.get(obfuscationEnvironment.getType());
            if (string3 == null) continue;
            this.addMapping(obfuscationEnvironment.getType(), string, string2, string3);
        }
    }

    protected void addMapping(ObfuscationType obfuscationType, String string, String string2, String string3) {
        String string4 = this.refMapper.addMapping(obfuscationType.getKey(), string, string2, string3);
        if (obfuscationType.isDefault()) {
            this.refMapper.addMapping(null, string, string2, string3);
        }
        if (!this.allowConflicts && string4 != null && !string4.equals(string3)) {
            throw new ReferenceConflictException(string4, string3);
        }
    }

    public static class ReferenceConflictException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String oldReference;
        private final String newReference;

        public ReferenceConflictException(String string, String string2) {
            this.oldReference = string;
            this.newReference = string2;
        }

        public String getOld() {
            return this.oldReference;
        }

        public String getNew() {
            return this.newReference;
        }
    }
}

