/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.mirror;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.FieldHandle;
import org.spongepowered.tools.obfuscation.mirror.MethodHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeReference;
import org.spongepowered.tools.obfuscation.mirror.TypeUtils;
import org.spongepowered.tools.obfuscation.mirror.mapping.ResolvableMappingMethod;

public class TypeHandle {
    private final String name;
    private final PackageElement pkg;
    private final TypeElement element;
    private TypeReference reference;

    public TypeHandle(PackageElement packageElement, String string) {
        this.name = string.replace((char)(0xCCF079AD ^ 0xCCF07983), (char)(0xAC8E2CA5 ^ 0xAC8E2C8A));
        this.pkg = packageElement;
        this.element = null;
    }

    public TypeHandle(TypeElement typeElement) {
        this.pkg = TypeUtils.getPackage(typeElement);
        this.name = TypeUtils.getInternalName(typeElement);
        this.element = typeElement;
    }

    public TypeHandle(DeclaredType declaredType) {
        this((TypeElement)declaredType.asElement());
    }

    public final String toString() {
        return this.name.replace((char)(0x747A53BC ^ 0x747A5393), (char)(0xAF2F4D4C ^ 0xAF2F4D62));
    }

    public final String getName() {
        return this.name;
    }

    public final PackageElement getPackage() {
        return this.pkg;
    }

    public final TypeElement getElement() {
        return this.element;
    }

    protected TypeElement getTargetElement() {
        return this.element;
    }

    public AnnotationHandle getAnnotation(Class<? extends Annotation> clazz) {
        return AnnotationHandle.of(this.getTargetElement(), clazz);
    }

    public final List<? extends Element> getEnclosedElements() {
        return TypeHandle.getEnclosedElements(this.getTargetElement());
    }

    public <T extends Element> List<T> getEnclosedElements(ElementKind ... elementKindArray) {
        return TypeHandle.getEnclosedElements(this.getTargetElement(), elementKindArray);
    }

    public TypeMirror getType() {
        return this.getTargetElement() != null ? this.getTargetElement().asType() : null;
    }

    public TypeHandle getSuperclass() {
        TypeElement typeElement = this.getTargetElement();
        if (typeElement == null) {
            return null;
        }
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror == null || typeMirror.getKind() == TypeKind.NONE) {
            return null;
        }
        return new TypeHandle((DeclaredType)typeMirror);
    }

    public List<TypeHandle> getInterfaces() {
        if (this.getTargetElement() == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TypeMirror typeMirror : this.getTargetElement().getInterfaces()) {
            builder.add((Object)new TypeHandle((DeclaredType)typeMirror));
        }
        return builder.build();
    }

    public boolean isPublic() {
        return (this.getTargetElement() != null && this.getTargetElement().getModifiers().contains((Object)Modifier.PUBLIC) ? 0xE797571C ^ 0xE797571D : 0x35940D79 ^ 0x35940D79) != 0;
    }

    public boolean isImaginary() {
        return (this.getTargetElement() == null ? 0xC6187AA0 ^ 0xC6187AA1 : 0xF81DE6D3 ^ 0xF81DE6D3) != 0;
    }

    public boolean isSimulated() {
        return (0x7416CF78 ^ 0x7416CF78) != 0;
    }

    public final TypeReference getReference() {
        if (this.reference == null) {
            this.reference = new TypeReference(this);
        }
        return this.reference;
    }

    public MappingMethod getMappingMethod(String string, String string2) {
        return new ResolvableMappingMethod(this, string, string2);
    }

    public String findDescriptor(MemberInfo memberInfo) {
        String string = memberInfo.desc;
        if (string == null) {
            ElementKind[] elementKindArray = new ElementKind[0x573CA210 ^ 0x573CA211];
            elementKindArray[0x3F083CE7 ^ 0x3F083CE7] = ElementKind.METHOD;
            for (ExecutableElement executableElement : this.getEnclosedElements(elementKindArray)) {
                if (!executableElement.getSimpleName().toString().equals(memberInfo.name)) continue;
                string = TypeUtils.getDescriptor(executableElement);
                break;
            }
        }
        return string;
    }

    public final FieldHandle findField(VariableElement variableElement) {
        return this.findField(variableElement, (0xDE53254F ^ 0xDE53254E) != 0);
    }

    public final FieldHandle findField(VariableElement variableElement, boolean bl) {
        return this.findField(variableElement.getSimpleName().toString(), TypeUtils.getTypeName(variableElement.asType()), bl);
    }

    public final FieldHandle findField(String string, String string2) {
        return this.findField(string, string2, (0x3EE295A4 ^ 0x3EE295A5) != 0);
    }

    public FieldHandle findField(String string, String string2, boolean bl) {
        String string3 = TypeUtils.stripGenerics(string2);
        ElementKind[] elementKindArray = new ElementKind[0x94F7DD36 ^ 0x94F7DD37];
        elementKindArray[0x9AE16074 ^ 0x9AE16074] = ElementKind.FIELD;
        for (VariableElement variableElement : this.getEnclosedElements(elementKindArray)) {
            if (TypeHandle.compareElement(variableElement, string, string2, bl)) {
                return new FieldHandle(this.getTargetElement(), variableElement);
            }
            if (!TypeHandle.compareElement(variableElement, string, string3, bl)) continue;
            return new FieldHandle(this.getTargetElement(), variableElement, (0xE25AC15E ^ 0xE25AC15F) != 0);
        }
        return null;
    }

    public final MethodHandle findMethod(ExecutableElement executableElement) {
        return this.findMethod(executableElement, (0x84C6259 ^ 0x84C6258) != 0);
    }

    public final MethodHandle findMethod(ExecutableElement executableElement, boolean bl) {
        return this.findMethod(executableElement.getSimpleName().toString(), TypeUtils.getJavaSignature(executableElement), bl);
    }

    public final MethodHandle findMethod(String string, String string2) {
        return this.findMethod(string, string2, (0xF9B4BDAD ^ 0xF9B4BDAC) != 0);
    }

    public MethodHandle findMethod(String string, String string2, boolean bl) {
        String string3 = TypeUtils.stripGenerics(string2);
        return TypeHandle.findMethod(this, string, string2, string3, bl);
    }

    protected static MethodHandle findMethod(TypeHandle typeHandle, String string, String string2, String string3, boolean bl) {
        ElementKind[] elementKindArray = new ElementKind[0xD4F7DF8B ^ 0xD4F7DF89];
        elementKindArray[0xE073F53F ^ 0xE073F53F] = ElementKind.CONSTRUCTOR;
        elementKindArray[0x5F800D9A ^ 0x5F800D9B] = ElementKind.METHOD;
        for (ExecutableElement executableElement : TypeHandle.getEnclosedElements(typeHandle.getTargetElement(), elementKindArray)) {
            if (!TypeHandle.compareElement(executableElement, string, string2, bl) && !TypeHandle.compareElement(executableElement, string, string3, bl)) continue;
            return new MethodHandle(typeHandle, executableElement);
        }
        return null;
    }

    protected static boolean compareElement(Element element, String string, String string2, boolean bl) {
        try {
            boolean bl2;
            String string3 = element.getSimpleName().toString();
            String string4 = TypeUtils.getJavaSignature(element);
            String string5 = TypeUtils.stripGenerics(string4);
            boolean bl3 = bl2 = bl ? string.equals(string3) : string.equalsIgnoreCase(string3);
            return (bl2 && (string2.length() == 0 || string2.equals(string4) || string2.equals(string5)) ? 0xBC3B943C ^ 0xBC3B943D : 0xDA34FB60 ^ 0xDA34FB60) != 0;
        }
        catch (NullPointerException nullPointerException) {
            return (0x2D2515C5 ^ 0x2D2515C5) != 0;
        }
    }

    protected static <T extends Element> List<T> getEnclosedElements(TypeElement typeElement, ElementKind ... elementKindArray) {
        block7: {
            block6: {
                if (elementKindArray == null) break block6;
                if (elementKindArray.length >= (0x775FDBAA ^ 0x775FDBAB)) break block7;
            }
            return TypeHandle.getEnclosedElements(typeElement);
        }
        if (typeElement == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        block0: for (Element element : typeElement.getEnclosedElements()) {
            ElementKind[] elementKindArray2 = elementKindArray;
            int n = elementKindArray2.length;
            for (int i = 0xD358C452 ^ 0xD358C452; i < n; ++i) {
                ElementKind elementKind = elementKindArray2[i];
                if (element.getKind() != elementKind) continue;
                builder.add((Object)element);
                continue block0;
            }
        }
        return builder.build();
    }

    protected static List<? extends Element> getEnclosedElements(TypeElement typeElement) {
        return typeElement != null ? typeElement.getEnclosedElements() : Collections.emptyList();
    }
}

