/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.analysis.Interpreter;
import org.spongepowered.asm.lib.tree.analysis.SmallSet;
import org.spongepowered.asm.lib.tree.analysis.SourceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceInterpreter
extends Interpreter<SourceValue>
implements Opcodes {
    public SourceInterpreter() {
        super(0xD40FBE25 ^ 0xD40ABE25);
    }

    protected SourceInterpreter(int n) {
        super(n);
    }

    @Override
    public SourceValue newValue(Type type) {
        if (type == Type.\u8513\u5ef6\u5427) {
            return null;
        }
        return new SourceValue(type == null ? 0xB0F7DB15 ^ 0xB0F7DB14 : type.getSize());
    }

    @Override
    public SourceValue newOperation(AbstractInsnNode abstractInsnNode) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                n = 0x810BFA5C ^ 0x810BFA5E;
                break;
            }
            case 18: {
                Object object = ((LdcInsnNode)abstractInsnNode).\u8513\u5ef6\u5427;
                n = object instanceof Long || object instanceof Double ? 0x77705D3 ^ 0x77705D1 : 0x1DB0EE36 ^ 0x1DB0EE37;
                break;
            }
            case 178: {
                n = Type.getType(((FieldInsnNode)abstractInsnNode).\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3).getSize();
                break;
            }
            default: {
                n = 0x32B42F68 ^ 0x32B42F69;
            }
        }
        return new SourceValue(n, abstractInsnNode);
    }

    @Override
    public SourceValue copyOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue) {
        return new SourceValue(sourceValue.getSize(), abstractInsnNode);
    }

    @Override
    public SourceValue unaryOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                n = 0xABE88377 ^ 0xABE88375;
                break;
            }
            case 180: {
                n = Type.getType(((FieldInsnNode)abstractInsnNode).\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3).getSize();
                break;
            }
            default: {
                n = 0x72638BE ^ 0x72638BF;
            }
        }
        return new SourceValue(n, abstractInsnNode);
    }

    @Override
    public SourceValue binaryOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue, SourceValue sourceValue2) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                n = 0xBC82FC14 ^ 0xBC82FC16;
                break;
            }
            default: {
                n = 0xDDB97263 ^ 0xDDB97262;
            }
        }
        return new SourceValue(n, abstractInsnNode);
    }

    @Override
    public SourceValue ternaryOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue, SourceValue sourceValue2, SourceValue sourceValue3) {
        return new SourceValue(0x54F1B57A ^ 0x54F1B57B, abstractInsnNode);
    }

    @Override
    public SourceValue naryOperation(AbstractInsnNode abstractInsnNode, List<? extends SourceValue> list) {
        int n;
        int n2 = abstractInsnNode.getOpcode();
        if (n2 == (0xD9963335 ^ 0xD99633F0)) {
            n = 0xB36287BD ^ 0xB36287BC;
        } else {
            String string = n2 == (0xCD664A44 ^ 0xCD664AFE) ? ((InvokeDynamicInsnNode)abstractInsnNode).\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a : ((MethodInsnNode)abstractInsnNode).\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3;
            n = Type.getReturnType(string).getSize();
        }
        return new SourceValue(n, abstractInsnNode);
    }

    @Override
    public void returnOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue, SourceValue sourceValue2) {
    }

    @Override
    public SourceValue merge(SourceValue sourceValue, SourceValue sourceValue2) {
        if (sourceValue.\u8513\u5ef6\u5427 instanceof SmallSet && sourceValue2.\u8513\u5ef6\u5427 instanceof SmallSet) {
            Set<AbstractInsnNode> set = ((SmallSet)sourceValue.\u8513\u5ef6\u5427).union((SmallSet)sourceValue2.\u8513\u5ef6\u5427);
            if (set == sourceValue.\u8513\u5ef6\u5427 && sourceValue.\u8513\u5ef6\u5427 == sourceValue2.\u8513\u5ef6\u5427) {
                return sourceValue;
            }
            return new SourceValue(Math.min(sourceValue.\u8513\u5ef6\u5427, sourceValue2.\u8513\u5ef6\u5427), set);
        }
        if (sourceValue.\u8513\u5ef6\u5427 != sourceValue2.\u8513\u5ef6\u5427 || !sourceValue.\u8513\u5ef6\u5427.containsAll((Collection<?>)sourceValue2.\u8513\u5ef6\u5427)) {
            HashSet<AbstractInsnNode> hashSet = new HashSet<AbstractInsnNode>();
            hashSet.addAll((Collection<AbstractInsnNode>)sourceValue.\u8513\u5ef6\u5427);
            hashSet.addAll((Collection<AbstractInsnNode>)sourceValue2.\u8513\u5ef6\u5427);
            return new SourceValue(Math.min(sourceValue.\u8513\u5ef6\u5427, sourceValue2.\u8513\u5ef6\u5427), hashSet);
        }
        return sourceValue;
    }
}

