/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.collect.BiMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.SoftOverride;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.gen.AccessorInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectorGroupInfo;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InjectionValidationException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import org.spongepowered.asm.mixin.struct.MemberRef;
import org.spongepowered.asm.mixin.struct.SourceMap;
import org.spongepowered.asm.mixin.transformer.ClassContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InnerClassGenerator;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.obfuscation.RemapperChain;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.ClassSignature;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MixinTargetContext
extends ClassContext
implements IMixinContext {
    private static final Logger \u8513\u5ef6\u5427 = LogManager.getLogger((String)\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final MixinInfo \u8513\u5ef6\u5427;
    private final ClassNode \u8513\u5ef6\u5427;
    private final TargetClassContext \u8513\u5ef6\u5427;
    private final String \u8513\u5ef6\u5427;
    private final ClassInfo \u8513\u5ef6\u5427;
    private final BiMap<String, String> \u8513\u5ef6\u5427;
    private final List<MethodNode> \u8513\u5ef6\u5427;
    private final Map<FieldNode, ClassInfo.Field> \u8513\u5ef6\u5427;
    private final List<MethodNode> \u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a;
    private final InjectorGroupInfo.Map \u8513\u5ef6\u5427;
    private final List<InjectionInfo> \u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3;
    private final List<AccessorInfo> \u4f46\u5927\u53ef\u4e0d\u5fc5\u4e3a\u6b64\u61ca\u6094;
    private final boolean inheritsFromMixin;
    private final boolean detachedSuper;
    private final SourceMap.File \u8513\u5ef6\u5427;
    private int \u8513\u5ef6\u5427 = new LinkedHashMap();

    MixinTargetContext(MixinInfo mixinInfo, ClassNode classNode, TargetClassContext targetClassContext) {
        this.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a = new ArrayList<MethodNode>();
        this.\u8513\u5ef6\u5427 = new InjectorGroupInfo.Map();
        this.\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3 = new ArrayList<InjectionInfo>();
        this.\u4f46\u5927\u53ef\u4e0d\u5fc5\u4e3a\u6b64\u61ca\u6094 = new ArrayList<AccessorInfo>();
        this.\u8513\u5ef6\u5427 = MixinEnvironment.CompatibilityLevel.\u8513\u5ef6\u5427.classVersion();
        this.\u8513\u5ef6\u5427 = mixinInfo;
        this.\u8513\u5ef6\u5427 = classNode;
        this.\u8513\u5ef6\u5427 = targetClassContext;
        this.\u8513\u5ef6\u5427 = ClassInfo.forName(this.getTarget().getClassRef());
        this.\u8513\u5ef6\u5427 = targetClassContext.getSourceMap().addFile(this.\u8513\u5ef6\u5427);
        int n = mixinInfo.getClassInfo().hasMixinInHierarchy() || this.\u8513\u5ef6\u5427.hasMixinTargetInHierarchy() ? 0x67BEB540 ^ 0x67BEB541 : (int)((this.inheritsFromMixin = 0xD2F53A22 ^ 0xD2F53A22) ? 1 : 0);
        this.detachedSuper = !this.\u8513\u5ef6\u5427.\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3.equals(this.getTarget().getClassNode().\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3) ? 0x522D6C88 ^ 0x522D6C89 : 0x8326205C ^ 0x8326205C;
        this.\u8513\u5ef6\u5427 = targetClassContext.getSessionId();
        this.requireVersion(classNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
        InnerClassGenerator innerClassGenerator = (InnerClassGenerator)targetClassContext.getExtensions().getGenerator(InnerClassGenerator.class);
        for (String string : this.\u8513\u5ef6\u5427.getInnerClasses()) {
            this.\u8513\u5ef6\u5427.put((Object)string, (Object)innerClassGenerator.registerInnerClass(this.\u8513\u5ef6\u5427, string, this));
        }
    }

    void addShadowMethod(MethodNode methodNode) {
        this.\u8513\u5ef6\u5427.add(methodNode);
    }

    void addShadowField(FieldNode fieldNode, ClassInfo.Field field) {
        this.\u8513\u5ef6\u5427.put(fieldNode, field);
    }

    void addAccessorMethod(MethodNode methodNode, Class<? extends Annotation> clazz) {
        this.\u4f46\u5927\u53ef\u4e0d\u5fc5\u4e3a\u6b64\u61ca\u6094.add(AccessorInfo.of(this, methodNode, clazz));
    }

    void addMixinMethod(MethodNode methodNode) {
        Object[] objectArray = new Object[0x690181F ^ 0x690181D];
        objectArray[0x49BC3854 ^ 0x49BC3854] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("\u007f\ua7ef\ua4ad\ua078\ua90b");
        objectArray[0x47569385 ^ 0x47569384] = this.getClassName();
        Annotations.setVisible(methodNode, MixinMerged.class, objectArray);
        this.getTarget().addMixinMethod(methodNode);
    }

    void methodMerged(MethodNode methodNode) {
        this.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a.add(methodNode);
        this.\u8513\u5ef6\u5427.addMethod(methodNode);
        this.getTarget().methodMerged(methodNode);
        Object[] objectArray = new Object[0x3ED40233 ^ 0x3ED40235];
        objectArray[0xF87E0374 ^ 0xF87E0374] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("\u007f\ua7ef\ua4ad\ua078\ua90b");
        objectArray[0x889E5048 ^ 0x889E5049] = this.getClassName();
        objectArray[0xD4330087 ^ 0xD4330085] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463");
        objectArray[0xBDDB2DD1 ^ 0xBDDB2DD2] = this.getPriority();
        objectArray[0x5B30FA8E ^ 0x5B30FA8A] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("a\ua7e3\ua4a6\ua062\ua90c\u7d79\u8e44\u2453\u8b33");
        objectArray[0x34D76DA2 ^ 0x34D76DA7] = this.\u8513\u5ef6\u5427;
        Annotations.setVisible(methodNode, MixinMerged.class, objectArray);
    }

    public String toString() {
        return this.\u8513\u5ef6\u5427.toString();
    }

    public MixinEnvironment getEnvironment() {
        return this.\u8513\u5ef6\u5427.getParent().getEnvironment();
    }

    @Override
    public boolean getOption(MixinEnvironment.Option option) {
        return this.getEnvironment().getOption(option);
    }

    @Override
    public ClassNode getClassNode() {
        return this.\u8513\u5ef6\u5427;
    }

    @Override
    public String getClassName() {
        return this.\u8513\u5ef6\u5427.getClassName();
    }

    @Override
    public String getClassRef() {
        return this.\u8513\u5ef6\u5427.getClassRef();
    }

    public TargetClassContext getTarget() {
        return this.\u8513\u5ef6\u5427;
    }

    @Override
    public String getTargetClassRef() {
        return this.getTarget().getClassRef();
    }

    public ClassNode getTargetClassNode() {
        return this.getTarget().getClassNode();
    }

    public ClassInfo getTargetClassInfo() {
        return this.\u8513\u5ef6\u5427;
    }

    @Override
    protected ClassInfo getClassInfo() {
        return this.\u8513\u5ef6\u5427.getClassInfo();
    }

    public ClassSignature getSignature() {
        return this.getClassInfo().getSignature();
    }

    public SourceMap.File getStratum() {
        return this.\u8513\u5ef6\u5427;
    }

    public int getMinRequiredClassVersion() {
        return this.\u8513\u5ef6\u5427;
    }

    public int getDefaultRequiredInjections() {
        return this.\u8513\u5ef6\u5427.getParent().getDefaultRequiredInjections();
    }

    public String getDefaultInjectorGroup() {
        return this.\u8513\u5ef6\u5427.getParent().getDefaultInjectorGroup();
    }

    public int getMaxShiftByValue() {
        return this.\u8513\u5ef6\u5427.getParent().getMaxShiftByValue();
    }

    public InjectorGroupInfo.Map getInjectorGroups() {
        return this.\u8513\u5ef6\u5427;
    }

    public boolean requireOverwriteAnnotations() {
        return this.\u8513\u5ef6\u5427.getParent().requireOverwriteAnnotations();
    }

    public ClassInfo findRealType(ClassInfo classInfo) {
        if (classInfo == this.getClassInfo()) {
            return this.\u8513\u5ef6\u5427;
        }
        ClassInfo classInfo2 = this.\u8513\u5ef6\u5427.findCorrespondingType(classInfo);
        if (classInfo2 == null) {
            throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("@\ua7e3\ua4a6\ua07e\ua909\u7d63\u8e5e\u2473\u8b38\u34792\ua7e3\ua4a7\ua063\ua90a\u7d64\u8e10\u243a\u8b22\u3479s\ua7e4\ua4b9\ua074\ua945\u7d62\u8e45\u243a\u8b31\u347e|\ua7e2\ua4f5\ua072\ua90a\u7d64\u8e58\u247f\u8b24\u3467}\ua7e8\ua4b1\ua078\ua90b\u7d71\u8e0a\u246e\u8b2e\u3467w\ua7a6\ua4b3\ua07e\ua917\u7d36") + classInfo + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7ef\ua4bb\ua031\ua90d\u7d7f\u8e4f\u2468\u8b36\u3465q\ua7ee\ua4ac\ua031\ua90a\u7d70\u8e0a") + this.\u8513\u5ef6\u5427);
        }
        return classInfo2;
    }

    public void transformMethod(MethodNode methodNode) {
        this.validateMethod(methodNode);
        this.transformDescriptor(methodNode);
        this.transformLVT(methodNode);
        this.\u8513\u5ef6\u5427.applyOffset(methodNode);
        AbstractInsnNode abstractInsnNode = null;
        ListIterator<AbstractInsnNode> listIterator = methodNode.\u8513\u5ef6\u5427.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode2 instanceof MethodInsnNode) {
                this.transformMethodRef(methodNode, listIterator, new MemberRef.Method((MethodInsnNode)abstractInsnNode2));
            } else if (abstractInsnNode2 instanceof FieldInsnNode) {
                this.transformFieldRef(methodNode, listIterator, new MemberRef.Field((FieldInsnNode)abstractInsnNode2));
                this.checkFinal(methodNode, listIterator, (FieldInsnNode)abstractInsnNode2);
            } else if (abstractInsnNode2 instanceof TypeInsnNode) {
                this.transformTypeNode(methodNode, listIterator, (TypeInsnNode)abstractInsnNode2, abstractInsnNode);
            } else if (abstractInsnNode2 instanceof LdcInsnNode) {
                this.transformConstantNode(methodNode, listIterator, (LdcInsnNode)abstractInsnNode2);
            } else if (abstractInsnNode2 instanceof InvokeDynamicInsnNode) {
                this.transformInvokeDynamicNode(methodNode, listIterator, (InvokeDynamicInsnNode)abstractInsnNode2);
            }
            abstractInsnNode = abstractInsnNode2;
        }
    }

    private void validateMethod(MethodNode methodNode) {
        ClassInfo.Method method;
        if (!(Annotations.getInvisible(methodNode, SoftOverride.class) == null || (method = this.\u8513\u5ef6\u5427.findMethodInHierarchy(methodNode.\u8513\u5ef6\u5427, methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a, ClassInfo.SearchType.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a, ClassInfo.Traversal.\u4f46\u5927\u53ef\u4e0d\u5fc5\u4e3a\u6b64\u61ca\u6094)) != null && method.isInjected())) {
            throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e47\u247f\u8b23\u347f}\ua7e2\ua4f5") + methodNode.\u8513\u5ef6\u5427 + methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7ef\ua4a6\ua031\ua911\u7d77\u8e4d\u247d\u8b32\u34732\ua7f1\ua4bc\ua065\ua90d\u7d36\u8e6a\u2449\u8b38\u3471f\ua7c9\ua4a3\ua074\ua917\u7d64\u8e43\u247e\u8b32\u3437p\ua7f3\ua4a1\ua031\ua90b\u7d79\u8e0a\u246c\u8b36\u347b{\ua7e2\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u3437e\ua7e7\ua4a6\ua031\ua903\u7d79\u8e5f\u2474\u8b33\u3437{\ua7e8\ua4f5\ua062\ua910\u7d66\u8e4f\u2468\u8b34\u347bs\ua7f5\ua4a6\ua074\ua916\u7d36\u8e45\u247c\u8b77") + this.getTarget().getClassName());
        }
    }

    private void transformLVT(MethodNode methodNode) {
        if (methodNode.\u6211\u5df2\u7ecf\u5173\u6ce8\u4f60\u5f88\u4e45\u4e86 == null) {
            return;
        }
        for (LocalVariableNode localVariableNode : methodNode.\u6211\u5df2\u7ecf\u5173\u6ce8\u4f60\u5f88\u4e45\u4e86) {
            if (localVariableNode == null || localVariableNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a == null) continue;
            localVariableNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a = this.transformSingleDescriptor(Type.getType(localVariableNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a));
        }
    }

    private void transformMethodRef(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, MemberRef memberRef) {
        this.transformDescriptor(memberRef);
        if (memberRef.getOwner().equals(this.getClassRef())) {
            memberRef.setOwner(this.getTarget().getClassRef());
            ClassInfo.Method method = this.getClassInfo().findMethod(memberRef.getName(), memberRef.getDesc(), 0xBE34635C ^ 0xBE346356);
            if (method != null && method.isRenamed() && method.getOriginalName().equals(memberRef.getName()) && method.isSynthetic()) {
                memberRef.setName(method.getName());
            }
            this.upgradeMethodRef(methodNode, memberRef, method);
        } else if (this.\u8513\u5ef6\u5427.containsKey((Object)memberRef.getOwner())) {
            memberRef.setOwner((String)this.\u8513\u5ef6\u5427.get((Object)memberRef.getOwner()));
            memberRef.setDesc(this.transformMethodDescriptor(memberRef.getDesc()));
        } else if (this.detachedSuper || this.inheritsFromMixin) {
            if (memberRef.getOpcode() == (0x6EEB89 ^ 0x6EEB3E)) {
                this.updateStaticBinding(methodNode, memberRef);
            } else if (memberRef.getOpcode() == (0xFA336D44 ^ 0xFA336DF2) && ClassInfo.forName(memberRef.getOwner()).isMixin()) {
                this.updateDynamicBinding(methodNode, memberRef);
            }
        }
    }

    private void transformFieldRef(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, MemberRef memberRef) {
        if (\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("a\ua7f3\ua4a5\ua074\ua917\u7d32").equals(memberRef.getName())) {
            if (memberRef instanceof MemberRef.Field) {
                this.processImaginarySuper(methodNode, ((MemberRef.Field)memberRef).\u8513\u5ef6\u5427);
                iterator.remove();
            } else {
                throw new InvalidMixinException((IMixinInfo)this.\u8513\u5ef6\u5427, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b36\u347b~\ua7a6\ua4bc\ua07c\ua904\u7d71\u8e43\u2474\u8b36\u3465k\ua7a6\ua4a6\ua064\ua915\u7d73\u8e58\u243a\u8b31\u3465}\ua7eb\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u3437z\ua7e7\ua4bb\ua075\ua909\u7d73\u8e04"));
            }
        }
        this.transformDescriptor(memberRef);
        if (memberRef.getOwner().equals(this.getClassRef())) {
            memberRef.setOwner(this.getTarget().getClassRef());
            ClassInfo.Field field = this.getClassInfo().findField(memberRef.getName(), memberRef.getDesc(), 0x516DDC01 ^ 0x516DDC0B);
            if (field != null && field.isRenamed() && field.getOriginalName().equals(memberRef.getName()) && field.isStatic()) {
                memberRef.setName(field.getName());
            }
        } else {
            ClassInfo classInfo = ClassInfo.forName(memberRef.getOwner());
            if (classInfo.isMixin()) {
                ClassInfo classInfo2 = this.\u8513\u5ef6\u5427.findCorrespondingType(classInfo);
                memberRef.setOwner(classInfo2 != null ? classInfo2.getName() : this.getTarget().getClassRef());
            }
        }
    }

    private void checkFinal(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, FieldInsnNode fieldInsnNode) {
        block14: {
            block13: {
                if (!fieldInsnNode.\u8513\u5ef6\u5427.equals(this.getTarget().getClassRef())) {
                    return;
                }
                int n = fieldInsnNode.getOpcode();
                if (n == (0xF2EDE19B ^ 0xF2EDE12F)) break block13;
                if (n != (0xC514DBE0 ^ 0xC514DB52)) break block14;
            }
            return;
        }
        for (Map.Entry entry : this.\u8513\u5ef6\u5427.entrySet()) {
            FieldNode fieldNode = (FieldNode)entry.getKey();
            if (!fieldNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a.equals(fieldInsnNode.\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3) || !fieldNode.\u8513\u5ef6\u5427.equals(fieldInsnNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a)) continue;
            ClassInfo.Field field = (ClassInfo.Field)entry.getValue();
            if (field.isDecoratedFinal()) {
                if (field.isDecoratedMutable()) {
                    if (this.\u8513\u5ef6\u5427.getParent().getEnvironment().getOption(MixinEnvironment.Option.\u6ca1\u53bb\u8fc7\u7684\u5730\u65b9\u8fd8\u6709\u5f88\u591a\u5462)) {
                        Object[] objectArray = new Object[0x7752A02B ^ 0x7752A028];
                        objectArray[0xA1AB7873 ^ 0xA1AB7873] = field;
                        objectArray[0x26C4E197 ^ 0x26C4E196] = this.\u8513\u5ef6\u5427;
                        objectArray[0xC1805BC9 ^ 0xC1805BCB] = methodNode.\u8513\u5ef6\u5427;
                        \u8513\u5ef6\u5427.warn(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("E\ua7f4\ua4bc\ua065\ua900\u7d36\u8e4b\u2479\u8b34\u3472a\ua7f5\ua4f5\ua065\ua90a\u7d36\u8e6a\u2457\u8b22\u3463s\ua7e4\ua4b9\ua074\ua945\u7d56\u8e6c\u2473\u8b39\u3476~\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a\u8b2c\u346a2\ua7ef\ua4bb\ua031\ua91e\u7d6b\u8e10\u2420\u8b2c\u346a"), objectArray);
                    }
                } else if (\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.\u8513\u5ef6\u5427) || \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427(".\ua7e5\ua4b9\ua078\ua90b\u7d7f\u8e5e\u2424").equals(methodNode.\u8513\u5ef6\u5427)) {
                    Object[] objectArray = new Object[0xBDE82B64 ^ 0xBDE82B66];
                    objectArray[0x8249C27B ^ 0x8249C27B] = field;
                    objectArray[0xC62A7754 ^ 0xC62A7755] = this.\u8513\u5ef6\u5427;
                    \u8513\u5ef6\u5427.warn(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("R\ua7c0\ua4bc\ua07f\ua904\u7d7a\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua06a\ua918\u7d36\u8e43\u2474\u8b77\u346co\ua7a6\ua4a6\ua079\ua90a\u7d63\u8e46\u247e\u8b77\u3475w\ua7a6\ua4b3\ua078\ua90b\u7d77\u8e46"), objectArray);
                } else {
                    Object[] objectArray = new Object[0xC384FECA ^ 0xC384FEC9];
                    objectArray[0xD5984BAD ^ 0xD5984BAD] = field;
                    objectArray[0x625FC472 ^ 0x625FC473] = this.\u8513\u5ef6\u5427;
                    objectArray[0x703D15DF ^ 0x703D15DD] = methodNode.\u8513\u5ef6\u5427;
                    \u8513\u5ef6\u5427.error(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("E\ua7f4\ua4bc\ua065\ua900\u7d36\u8e4b\u2479\u8b34\u3472a\ua7f5\ua4f5\ua075\ua900\u7d62\u8e4f\u2479\u8b23\u3472v\ua7a6\ua4a1\ua07e\ua945\u7d56\u8e6c\u2473\u8b39\u3476~\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a\u8b2c\u346a2\ua7ef\ua4bb\ua031\ua91e\u7d6b\u8e10\u2420\u8b2c\u346a"), objectArray);
                    if (this.\u8513\u5ef6\u5427.getParent().getEnvironment().getOption(MixinEnvironment.Option.\u6211\u60f3\u4e86\u60f3\u8981\u5e86\u795d\u4f60\u7684\u751f\u65e5\u81f3\u5c11\u4e5f\u8981\u50cf\u82b1\u795e\u8bde\u796d\u4e00\u6837\u9686\u91cd)) {
                        throw new InvalidMixinException((IMixinInfo)this.\u8513\u5ef6\u5427, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("E\ua7f4\ua4bc\ua065\ua900\u7d36\u8e4b\u2479\u8b34\u3472a\ua7f5\ua4f5\ua075\ua900\u7d62\u8e4f\u2479\u8b23\u3472v\ua7a6\ua4a1\ua07e\ua945\u7d56\u8e6c\u2473\u8b39\u3476~\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a") + field + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7ef\ua4bb\ua031") + this.\u8513\u5ef6\u5427 + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("(\ua7bc") + methodNode.\u8513\u5ef6\u5427);
                    }
                }
            }
            return;
        }
    }

    private void transformTypeNode(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, TypeInsnNode typeInsnNode, AbstractInsnNode abstractInsnNode) {
        if (typeInsnNode.getOpcode() == (0x608D2124 ^ 0x608D21E4) && typeInsnNode.\u8513\u5ef6\u5427.equals(this.getTarget().getClassRef())) {
            if (abstractInsnNode.getOpcode() == (0x804AB7B9 ^ 0x804AB7A0) && ((VarInsnNode)abstractInsnNode).\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462 == 0) {
                iterator.remove();
                return;
            }
        }
        if (typeInsnNode.\u8513\u5ef6\u5427.equals(this.getClassRef())) {
            typeInsnNode.\u8513\u5ef6\u5427 = this.getTarget().getClassRef();
        } else {
            String string = (String)this.\u8513\u5ef6\u5427.get((Object)typeInsnNode.\u8513\u5ef6\u5427);
            if (string != null) {
                typeInsnNode.\u8513\u5ef6\u5427 = string;
            }
        }
        this.transformDescriptor(typeInsnNode);
    }

    private void transformConstantNode(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, LdcInsnNode ldcInsnNode) {
        ldcInsnNode.\u8513\u5ef6\u5427 = this.transformConstant(methodNode, iterator, ldcInsnNode.\u8513\u5ef6\u5427);
    }

    private void transformInvokeDynamicNode(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, InvokeDynamicInsnNode invokeDynamicInsnNode) {
        this.requireVersion(0x6EFCD09C ^ 0x6EFCD0AF);
        invokeDynamicInsnNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a = this.transformMethodDescriptor(invokeDynamicInsnNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
        invokeDynamicInsnNode.\u8513\u5ef6\u5427 = this.transformHandle(methodNode, iterator, invokeDynamicInsnNode.\u8513\u5ef6\u5427);
        for (int i = 0x9D940AF1 ^ 0x9D940AF1; i < invokeDynamicInsnNode.\u8513\u5ef6\u5427.length; ++i) {
            invokeDynamicInsnNode.\u8513\u5ef6\u5427[i] = this.transformConstant(methodNode, iterator, invokeDynamicInsnNode.\u8513\u5ef6\u5427[i]);
        }
    }

    private Object transformConstant(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, Object object) {
        if (object instanceof Type) {
            Type type = (Type)object;
            String string = this.transformDescriptor(type);
            if (!type.toString().equals(string)) {
                return Type.getType(string);
            }
            return object;
        }
        if (object instanceof Handle) {
            return this.transformHandle(methodNode, iterator, (Handle)object);
        }
        return object;
    }

    private Handle transformHandle(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, Handle handle) {
        MemberRef.Handle handle2 = new MemberRef.Handle(handle);
        if (handle2.isField()) {
            this.transformFieldRef(methodNode, iterator, handle2);
        } else {
            this.transformMethodRef(methodNode, iterator, handle2);
        }
        return handle2.getMethodHandle();
    }

    private void processImaginarySuper(MethodNode methodNode, FieldInsnNode fieldInsnNode) {
        block8: {
            block7: {
                if (fieldInsnNode.getOpcode() != (0x70312003 ^ 0x703120B7)) {
                    if (\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.\u8513\u5ef6\u5427)) {
                        throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3e\u347as\ua7e1\ua4bc\ua07f\ua904\u7d64\u8e53\u243a\u8b24\u3462b\ua7e3\ua4a7\ua031\ua901\u7d73\u8e49\u2476\u8b36\u3465s\ua7f2\ua4bc\ua07e\ua90b\u7d2c\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5") + fieldInsnNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7eb\ua4a0\ua062\ua911\u7d36\u8e44\u2475\u8b23\u3437a\ua7f6\ua4b0\ua072\ua90c\u7d70\u8e53\u243a\u8b36\u34792\ua7ef\ua4bb\ua078\ua911\u7d7f\u8e4b\u2476\u8b3e\u3464w\ua7f4"));
                    }
                    throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3e\u347as\ua7e1\ua4bc\ua07f\ua904\u7d64\u8e53\u243a\u8b24\u3462b\ua7e3\ua4a7\ua031\ua904\u7d75\u8e49\u247f\u8b24\u3464(\ua7a6\ua4b3\ua07e\ua910\u7d78\u8e4e\u243a") + Bytecode.getOpcodeName(fieldInsnNode.getOpcode()) + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7e9\ua4a5\ua072\ua90a\u7d72\u8e4f\u243a\u8b3e\u34792") + methodNode.\u8513\u5ef6\u5427 + methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
                }
                if ((methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a & (0x9E6CC45A ^ 0x9E6CC458)) != 0) break block7;
                if ((methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a & (0x1ADF8BE7 ^ 0x1ADF8BEF)) == 0) break block8;
            }
            throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3e\u347as\ua7e1\ua4bc\ua07f\ua904\u7d64\u8e53\u243a\u8b24\u3462b\ua7e3\ua4a7\ua031\ua904\u7d75\u8e49\u247f\u8b24\u3464(\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77") + methodNode.\u8513\u5ef6\u5427 + methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7ef\ua4a6\ua031\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4ba\ua063\ua945\u7d65\u8e5e\u247b\u8b23\u347eq"));
        }
        if (Annotations.getInvisible(methodNode, SoftOverride.class) == null) {
            throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3e\u347as\ua7e1\ua4bc\ua07f\ua904\u7d64\u8e53\u243a\u8b24\u3462b\ua7e3\ua4a7\ua031\ua904\u7d75\u8e49\u247f\u8b24\u3464(\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77") + methodNode.\u8513\u5ef6\u5427 + methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b33\u3472q\ua7e9\ua4a7\ua070\ua911\u7d73\u8e4e\u243a\u8b20\u347ef\ua7ee\ua4f5\ua051\ua936\u7d79\u8e4c\u246e\u8b18\u3461w\ua7f4\ua4a7\ua078\ua901\u7d73"));
        }
        ListIterator<AbstractInsnNode> listIterator = methodNode.\u8513\u5ef6\u5427.iterator(methodNode.\u8513\u5ef6\u5427.indexOf(fieldInsnNode));
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!methodInsnNode.\u8513\u5ef6\u5427.equals(this.getClassRef()) || !methodInsnNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a.equals(methodNode.\u8513\u5ef6\u5427) || !methodInsnNode.\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3.equals(methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a)) continue;
            methodInsnNode.setOpcode(0x640B000A ^ 0x640B00BD);
            this.updateStaticBinding(methodNode, new MemberRef.Method(methodInsnNode));
            return;
        }
        throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3e\u347as\ua7e1\ua4bc\ua07f\ua904\u7d64\u8e53\u243a\u8b24\u3462b\ua7e3\ua4a7\ua031\ua904\u7d75\u8e49\u247f\u8b24\u3464(\ua7a6\ua4b6\ua07e\ua910\u7d7a\u8e4e\u243a\u8b39\u3478f\ua7a6\ua4b3\ua078\ua90b\u7d72\u8e0a\u2453\u8b19\u3441]\ua7cd\ua490\ua031\ua903\u7d79\u8e58\u243a") + methodNode.\u8513\u5ef6\u5427 + methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
    }

    private void updateStaticBinding(MethodNode methodNode, MemberRef memberRef) {
        this.updateBinding(methodNode, memberRef, ClassInfo.Traversal.\u4f46\u5927\u53ef\u4e0d\u5fc5\u4e3a\u6b64\u61ca\u6094);
    }

    private void updateDynamicBinding(MethodNode methodNode, MemberRef memberRef) {
        this.updateBinding(methodNode, memberRef, ClassInfo.Traversal.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
    }

    private void updateBinding(MethodNode methodNode, MemberRef memberRef, ClassInfo.Traversal traversal) {
        if (\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.\u8513\u5ef6\u5427) || memberRef.getOwner().equals(this.getTarget().getClassRef()) || this.getTarget().getClassRef().startsWith(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("."))) {
            return;
        }
        ClassInfo.Method method = this.\u8513\u5ef6\u5427.findMethodInHierarchy(memberRef.getName(), memberRef.getDesc(), traversal.getSearchType(), traversal);
        if (method != null) {
            if (method.getOwner().isMixin()) {
                throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + memberRef + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7ef\ua4bb\ua031") + this + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7f4\ua4b0\ua062\ua90a\u7d7a\u8e5c\u247f\u8b33\u3437") + method.getOwner() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7e4\ua4a0\ua065\ua945\u7d7f\u8e59\u243a\u8b3a\u347ej\ua7ef\ua4bb\ua03f"));
            }
            memberRef.setOwner(method.getImplementor().getName());
        } else if (ClassInfo.forName(memberRef.getOwner()).isMixin()) {
            throw new MixinTransformerError(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e58\u247f\u8b24\u3478~\ua7f0\ua4bc\ua07f\ua902\u7d36") + memberRef + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("2\ua7ef\ua4bb\ua031") + this);
        }
    }

    public void transformDescriptor(FieldNode fieldNode) {
        if (!this.inheritsFromMixin && this.\u8513\u5ef6\u5427.size() == 0) {
            return;
        }
        fieldNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a = this.transformSingleDescriptor(fieldNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a, (0xC63F71AE ^ 0xC63F71AE) != 0);
    }

    public void transformDescriptor(MethodNode methodNode) {
        if (!this.inheritsFromMixin && this.\u8513\u5ef6\u5427.size() == 0) {
            return;
        }
        methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a = this.transformMethodDescriptor(methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
    }

    public void transformDescriptor(MemberRef memberRef) {
        if (!this.inheritsFromMixin && this.\u8513\u5ef6\u5427.size() == 0) {
            return;
        }
        if (memberRef.isField()) {
            memberRef.setDesc(this.transformSingleDescriptor(memberRef.getDesc(), (0xB7E4D2C3 ^ 0xB7E4D2C3) != 0));
        } else {
            memberRef.setDesc(this.transformMethodDescriptor(memberRef.getDesc()));
        }
    }

    public void transformDescriptor(TypeInsnNode typeInsnNode) {
        if (!this.inheritsFromMixin && this.\u8513\u5ef6\u5427.size() == 0) {
            return;
        }
        typeInsnNode.\u8513\u5ef6\u5427 = this.transformSingleDescriptor(typeInsnNode.\u8513\u5ef6\u5427, (0x7D3387A ^ 0x7D3387B) != 0);
    }

    private String transformDescriptor(Type type) {
        if (type.getSort() == (0xF5D45699 ^ 0xF5D45692)) {
            return this.transformMethodDescriptor(type.getDescriptor());
        }
        return this.transformSingleDescriptor(type);
    }

    private String transformSingleDescriptor(Type type) {
        if (type.getSort() < (0x1766FDEB ^ 0x1766FDE2)) {
            return type.toString();
        }
        return this.transformSingleDescriptor(type.toString(), (0x3A7CD510 ^ 0x3A7CD510) != 0);
    }

    private String transformSingleDescriptor(String string, boolean bl) {
        int n;
        String string2 = string;
        while (string2.startsWith(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("I")) || string2.startsWith(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("^"))) {
            if (string2.startsWith(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("I"))) {
                string2 = string2.substring(0x5BB7C20F ^ 0x5BB7C20E);
                continue;
            }
            string2 = string2.substring(0x25041900 ^ 0x25041901, string2.indexOf(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427(")")));
            n = 0xEB8DEC1E ^ 0xEB8DEC1F;
        }
        if (n == 0) {
            return string;
        }
        String string3 = (String)this.\u8513\u5ef6\u5427.get((Object)string2);
        if (string3 != null) {
            return string.replace(string2, string3);
        }
        if (this.\u8513\u5ef6\u5427.inverse().containsKey((Object)string2)) {
            return string;
        }
        ClassInfo classInfo = ClassInfo.forName(string2);
        if (!classInfo.isMixin()) {
            return string;
        }
        return string.replace(string2, this.findRealType(classInfo).toString());
    }

    private String transformMethodDescriptor(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)(0x34F2B782 ^ 0x34F2B7AA));
        Type[] typeArray = Type.getArgumentTypes(string);
        int n = typeArray.length;
        for (int i = 0xDDA12A24 ^ 0xDDA12A24; i < n; ++i) {
            Type type = typeArray[i];
            stringBuilder.append(this.transformSingleDescriptor(type));
        }
        return stringBuilder.append((char)(0x797025C ^ 0x7970275)).append(this.transformSingleDescriptor(Type.getReturnType(string))).toString();
    }

    @Override
    public Target getTargetMethod(MethodNode methodNode) {
        return this.getTarget().getTargetMethod(methodNode);
    }

    MethodNode findMethod(MethodNode methodNode, AnnotationNode annotationNode) {
        List list;
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(methodNode.\u8513\u5ef6\u5427);
        if (annotationNode != null && (list = (List)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("s\ua7ea\ua4bc\ua070\ua916\u7d73\u8e59"))) != null) {
            linkedList.addAll(list);
        }
        return this.getTarget().findMethod(linkedList, methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
    }

    MethodNode findRemappedMethod(MethodNode methodNode) {
        RemapperChain remapperChain = this.getEnvironment().getRemappers();
        String string = remapperChain.mapMethodName(this.getTarget().getClassRef(), methodNode.\u8513\u5ef6\u5427, methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
        if (string.equals(methodNode.\u8513\u5ef6\u5427)) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        return this.getTarget().findAliasedMethod(linkedList, methodNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
    }

    FieldNode findField(FieldNode fieldNode, AnnotationNode annotationNode) {
        List list;
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(fieldNode.\u8513\u5ef6\u5427);
        if (annotationNode != null && (list = (List)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("s\ua7ea\ua4bc\ua070\ua916\u7d73\u8e59"))) != null) {
            linkedList.addAll(list);
        }
        return this.getTarget().findAliasedField(linkedList, fieldNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
    }

    FieldNode findRemappedField(FieldNode fieldNode) {
        RemapperChain remapperChain = this.getEnvironment().getRemappers();
        String string = remapperChain.mapFieldName(this.getTarget().getClassRef(), fieldNode.\u8513\u5ef6\u5427, fieldNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
        if (string.equals(fieldNode.\u8513\u5ef6\u5427)) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        return this.getTarget().findAliasedField(linkedList, fieldNode.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a);
    }

    protected void requireVersion(int n) {
        this.\u8513\u5ef6\u5427 = Math.max(this.\u8513\u5ef6\u5427, n);
        if (n > MixinEnvironment.getCompatibilityLevel().classVersion()) {
            throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("G\ua7e8\ua4a6\ua064\ua915\u7d66\u8e45\u2468\u8b23\u3472v\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua913\u7d73\u8e58\u2469\u8b3e\u3478|\ua7a6") + n);
        }
    }

    @Override
    public Extensions getExtensions() {
        return this.\u8513\u5ef6\u5427.getExtensions();
    }

    @Override
    public IMixinInfo getMixin() {
        return this.\u8513\u5ef6\u5427;
    }

    MixinInfo getInfo() {
        return this.\u8513\u5ef6\u5427;
    }

    @Override
    public int getPriority() {
        return this.\u8513\u5ef6\u5427.getPriority();
    }

    public Set<String> getInterfaces() {
        return this.\u8513\u5ef6\u5427.getInterfaces();
    }

    public Collection<MethodNode> getShadowMethods() {
        return this.\u8513\u5ef6\u5427;
    }

    public List<MethodNode> getMethods() {
        return this.\u8513\u5ef6\u5427.\u6211\u5df2\u7ecf\u5173\u6ce8\u4f60\u5f88\u4e45\u4e86;
    }

    public Set<Map.Entry<FieldNode, ClassInfo.Field>> getShadowFields() {
        return this.\u8513\u5ef6\u5427.entrySet();
    }

    public List<FieldNode> getFields() {
        return this.\u8513\u5ef6\u5427.\u6ca1\u53bb\u8fc7\u7684\u5730\u65b9\u8fd8\u6709\u5f88\u591a\u5462;
    }

    public Level getLoggingLevel() {
        return this.\u8513\u5ef6\u5427.getLoggingLevel();
    }

    public boolean shouldSetSourceFile() {
        return this.\u8513\u5ef6\u5427.getParent().shouldSetSourceFile();
    }

    public String getSourceFile() {
        return this.\u8513\u5ef6\u5427.\u4f46\u5927\u53ef\u4e0d\u5fc5\u4e3a\u6b64\u61ca\u6094;
    }

    @Override
    public IReferenceMapper getReferenceMapper() {
        return this.\u8513\u5ef6\u5427.getParent().getReferenceMapper();
    }

    public void preApply(String string, ClassNode classNode) {
        this.\u8513\u5ef6\u5427.preApply(string, classNode);
    }

    public void postApply(String string, ClassNode classNode) {
        try {
            this.\u8513\u5ef6\u5427.validateAll();
        }
        catch (InjectionValidationException injectionValidationException) {
            InjectorGroupInfo injectorGroupInfo = injectionValidationException.getGroup();
            Object[] objectArray = new Object[0xCCA8D13C ^ 0xCCA8D13F];
            objectArray[0xB6DBA6F7 ^ 0xB6DBA6F7] = injectorGroupInfo;
            objectArray[0x59F08AF4 ^ 0x59F08AF5] = this.\u8513\u5ef6\u5427;
            objectArray[0x59CC7F7F ^ 0x59CC7F7D] = injectionValidationException.getMessage();
            throw new InjectionError(String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u8513\u5ef6\u5427("Q\ua7f4\ua4bc\ua065\ua90c\u7d75\u8e4b\u2476\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3471s\ua7ef\ua4b9\ua064\ua917\u7d73\u8e10\u243a\u8b14\u3476~\ua7ea\ua4b7\ua070\ua906\u7d7d\u8e0a\u247d\u8b25\u3478g\ua7f6\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b3\ua070\ua90c\u7d7a\u8e4f\u247e\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3474z\ua7e3\ua4b6\ua07a\ua95f\u7d36\u8e0f\u2469"), objectArray));
        }
        this.\u8513\u5ef6\u5427.postApply(string, classNode);
    }

    public String getUniqueName(MethodNode methodNode, boolean bl) {
        return this.getTarget().getUniqueName(methodNode, bl);
    }

    public String getUniqueName(FieldNode fieldNode) {
        return this.getTarget().getUniqueName(fieldNode);
    }

    public void prepareInjections() {
        this.\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3.clear();
        for (MethodNode methodNode : this.\u987b\u5f25\u7684\u6c99\u6f20\u770b\u4e0a\u53bb\u6bd4\u96e8\u6797\u7f3a\u4e4f\u751f\u673a) {
            InjectionInfo injectionInfo = InjectionInfo.parse(this, methodNode);
            if (injectionInfo == null) continue;
            if (injectionInfo.isValid()) {
                injectionInfo.prepare();
                this.\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3.add(injectionInfo);
            }
            methodNode.\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3.remove(injectionInfo.getAnnotation());
        }
    }

    public void applyInjections() {
        for (InjectionInfo injectionInfo : this.\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3) {
            injectionInfo.inject();
        }
        for (InjectionInfo injectionInfo : this.\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3) {
            injectionInfo.postInject();
        }
        this.\u73ca\u745a\u771f\u73e0\u627e\u5230\u4e86\u8d1d\u58f3.clear();
    }

    public List<MethodNode> generateAccessors() {
        for (AccessorInfo object : this.\u4f46\u5927\u53ef\u4e0d\u5fc5\u4e3a\u6b64\u61ca\u6094) {
            object.locate();
        }
        ArrayList arrayList = new ArrayList();
        for (AccessorInfo accessorInfo : this.\u4f46\u5927\u53ef\u4e0d\u5fc5\u4e3a\u6b64\u61ca\u6094) {
            MethodNode methodNode = accessorInfo.generate();
            this.getTarget().addMixinMethod(methodNode);
            arrayList.add(methodNode);
        }
        return arrayList;
    }
}

