/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.analysis.Interpreter;
import org.spongepowered.asm.lib.tree.analysis.SmallSet;
import org.spongepowered.asm.lib.tree.analysis.SourceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceInterpreter
extends Interpreter<SourceValue>
implements Opcodes {
    public SourceInterpreter() {
        super(0x1208DDFB ^ 0x120DDDFB);
    }

    protected SourceInterpreter(int n) {
        super(n);
    }

    @Override
    public SourceValue newValue(Type type) {
        if (type == Type.\u522b\u6253\u5566) {
            return null;
        }
        return new SourceValue(type == null ? 0x26B57F1F ^ 0x26B57F1E : type.getSize());
    }

    @Override
    public SourceValue newOperation(AbstractInsnNode abstractInsnNode) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                n = 0xBF10559D ^ 0xBF10559F;
                break;
            }
            case 18: {
                Object object = ((LdcInsnNode)abstractInsnNode).\u522b\u6253\u5566;
                n = object instanceof Long || object instanceof Double ? 0x9FA09BEB ^ 0x9FA09BE9 : 0xA438A388 ^ 0xA438A389;
                break;
            }
            case 178: {
                n = Type.getType(((FieldInsnNode)abstractInsnNode).\u8981\u6211\u5403\u4e0b\u5b83\u4eec\u5c31\u597d\u50cf\u8981\u6211\u54bd\u4e0b\u4e00\u56e2\u810f\u516e\u516e\u7684\u4e4c\u4e91\u4e00\u6837).getSize();
                break;
            }
            default: {
                n = 0x11606A7A ^ 0x11606A7B;
            }
        }
        return new SourceValue(n, abstractInsnNode);
    }

    @Override
    public SourceValue copyOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue) {
        return new SourceValue(sourceValue.getSize(), abstractInsnNode);
    }

    @Override
    public SourceValue unaryOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                n = 0x119733E9 ^ 0x119733EB;
                break;
            }
            case 180: {
                n = Type.getType(((FieldInsnNode)abstractInsnNode).\u8981\u6211\u5403\u4e0b\u5b83\u4eec\u5c31\u597d\u50cf\u8981\u6211\u54bd\u4e0b\u4e00\u56e2\u810f\u516e\u516e\u7684\u4e4c\u4e91\u4e00\u6837).getSize();
                break;
            }
            default: {
                n = 0xC8DCF500 ^ 0xC8DCF501;
            }
        }
        return new SourceValue(n, abstractInsnNode);
    }

    @Override
    public SourceValue binaryOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue, SourceValue sourceValue2) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                n = 0x508B7E99 ^ 0x508B7E9B;
                break;
            }
            default: {
                n = 0xF422FC04 ^ 0xF422FC05;
            }
        }
        return new SourceValue(n, abstractInsnNode);
    }

    @Override
    public SourceValue ternaryOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue, SourceValue sourceValue2, SourceValue sourceValue3) {
        return new SourceValue(0xD8D54E64 ^ 0xD8D54E65, abstractInsnNode);
    }

    @Override
    public SourceValue naryOperation(AbstractInsnNode abstractInsnNode, List<? extends SourceValue> list) {
        int n;
        int n2 = abstractInsnNode.getOpcode();
        if (n2 == (0xC2F34603 ^ 0xC2F346C6)) {
            n = 0x914FF375 ^ 0x914FF374;
        } else {
            String string = n2 == (0x11F9339 ^ 0x11F9383) ? ((InvokeDynamicInsnNode)abstractInsnNode).\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566 : ((MethodInsnNode)abstractInsnNode).\u8981\u6211\u5403\u4e0b\u5b83\u4eec\u5c31\u597d\u50cf\u8981\u6211\u54bd\u4e0b\u4e00\u56e2\u810f\u516e\u516e\u7684\u4e4c\u4e91\u4e00\u6837;
            n = Type.getReturnType(string).getSize();
        }
        return new SourceValue(n, abstractInsnNode);
    }

    @Override
    public void returnOperation(AbstractInsnNode abstractInsnNode, SourceValue sourceValue, SourceValue sourceValue2) {
    }

    @Override
    public SourceValue merge(SourceValue sourceValue, SourceValue sourceValue2) {
        if (sourceValue.\u522b\u6253\u5566 instanceof SmallSet && sourceValue2.\u522b\u6253\u5566 instanceof SmallSet) {
            Set<AbstractInsnNode> set = ((SmallSet)sourceValue.\u522b\u6253\u5566).union((SmallSet)sourceValue2.\u522b\u6253\u5566);
            if (set == sourceValue.\u522b\u6253\u5566 && sourceValue.\u522b\u6253\u5566 == sourceValue2.\u522b\u6253\u5566) {
                return sourceValue;
            }
            return new SourceValue(Math.min(sourceValue.\u522b\u6253\u5566, sourceValue2.\u522b\u6253\u5566), set);
        }
        if (sourceValue.\u522b\u6253\u5566 != sourceValue2.\u522b\u6253\u5566 || !sourceValue.\u522b\u6253\u5566.containsAll((Collection<?>)sourceValue2.\u522b\u6253\u5566)) {
            HashSet<AbstractInsnNode> hashSet = new HashSet<AbstractInsnNode>();
            hashSet.addAll((Collection<AbstractInsnNode>)sourceValue.\u522b\u6253\u5566);
            hashSet.addAll((Collection<AbstractInsnNode>)sourceValue2.\u522b\u6253\u5566);
            return new SourceValue(Math.min(sourceValue.\u522b\u6253\u5566, sourceValue2.\u522b\u6253\u5566), hashSet);
        }
        return sourceValue;
    }
}

