/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.obfuscation.mapping.IMapping;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class Mappings
implements IMappingConsumer {
    private final Map<ObfuscationType, IMappingConsumer.MappingSet<MappingField>> \u522b\u6253\u5566;
    private final Map<ObfuscationType, IMappingConsumer.MappingSet<MappingMethod>> \u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566;
    private UniqueMappings \u522b\u6253\u5566 = new HashMap<ObfuscationType, IMappingConsumer.MappingSet<MappingField>>();

    public Mappings() {
        this.\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566 = new HashMap<ObfuscationType, IMappingConsumer.MappingSet<MappingMethod>>();
        this.init();
    }

    private void init() {
        for (ObfuscationType obfuscationType : ObfuscationType.types()) {
            this.\u522b\u6253\u5566.put(obfuscationType, new IMappingConsumer.MappingSet());
            this.\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566.put(obfuscationType, new IMappingConsumer.MappingSet());
        }
    }

    public IMappingConsumer asUnique() {
        if (this.\u522b\u6253\u5566 == null) {
            this.\u522b\u6253\u5566 = new UniqueMappings(this);
        }
        return this.\u522b\u6253\u5566;
    }

    @Override
    public IMappingConsumer.MappingSet<MappingField> getFieldMappings(ObfuscationType obfuscationType) {
        IMappingConsumer.MappingSet mappingSet = this.\u522b\u6253\u5566.get(obfuscationType);
        return mappingSet != null ? mappingSet : new IMappingConsumer.MappingSet();
    }

    @Override
    public IMappingConsumer.MappingSet<MappingMethod> getMethodMappings(ObfuscationType obfuscationType) {
        IMappingConsumer.MappingSet mappingSet = this.\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566.get(obfuscationType);
        return mappingSet != null ? mappingSet : new IMappingConsumer.MappingSet();
    }

    @Override
    public void clear() {
        this.\u522b\u6253\u5566.clear();
        this.\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566.clear();
        if (this.\u522b\u6253\u5566 != null) {
            this.\u522b\u6253\u5566.clearMaps();
        }
        this.init();
    }

    @Override
    public void addFieldMapping(ObfuscationType obfuscationType, MappingField mappingField, MappingField mappingField2) {
        IMappingConsumer.MappingSet<MappingField> mappingSet = this.\u522b\u6253\u5566.get(obfuscationType);
        if (mappingSet == null) {
            mappingSet = new IMappingConsumer.MappingSet();
            this.\u522b\u6253\u5566.put(obfuscationType, mappingSet);
        }
        mappingSet.add(new IMappingConsumer.MappingSet.Pair<MappingField>(mappingField, mappingField2));
    }

    @Override
    public void addMethodMapping(ObfuscationType obfuscationType, MappingMethod mappingMethod, MappingMethod mappingMethod2) {
        IMappingConsumer.MappingSet<MappingMethod> mappingSet = this.\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566.get(obfuscationType);
        if (mappingSet == null) {
            mappingSet = new IMappingConsumer.MappingSet();
            this.\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566.put(obfuscationType, mappingSet);
        }
        mappingSet.add(new IMappingConsumer.MappingSet.Pair<MappingMethod>(mappingMethod, mappingMethod2));
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    static class UniqueMappings
    implements IMappingConsumer {
        private final IMappingConsumer \u522b\u6253\u5566;
        private final Map<ObfuscationType, Map<MappingField, MappingField>> \u522b\u6253\u5566 = new HashMap();
        private final Map<ObfuscationType, Map<MappingMethod, MappingMethod>> \u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566 = new HashMap<ObfuscationType, Map<MappingMethod, MappingMethod>>();

        public UniqueMappings(IMappingConsumer iMappingConsumer) {
            this.\u522b\u6253\u5566 = iMappingConsumer;
        }

        @Override
        public void clear() {
            this.clearMaps();
            this.\u522b\u6253\u5566.clear();
        }

        protected void clearMaps() {
            this.\u522b\u6253\u5566.clear();
            this.\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566.clear();
        }

        @Override
        public void addFieldMapping(ObfuscationType obfuscationType, MappingField mappingField, MappingField mappingField2) {
            if (!this.checkForExistingMapping(obfuscationType, (IMapping)mappingField, (IMapping)mappingField2, (Map)((Object)this.\u522b\u6253\u5566))) {
                this.\u522b\u6253\u5566.addFieldMapping(obfuscationType, mappingField, mappingField2);
            }
        }

        @Override
        public void addMethodMapping(ObfuscationType obfuscationType, MappingMethod mappingMethod, MappingMethod mappingMethod2) {
            if (!this.checkForExistingMapping(obfuscationType, mappingMethod, mappingMethod2, this.\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566)) {
                this.\u522b\u6253\u5566.addMethodMapping(obfuscationType, mappingMethod, mappingMethod2);
            }
        }

        private <TMapping extends IMapping<TMapping>> boolean checkForExistingMapping(ObfuscationType obfuscationType, TMapping TMapping, TMapping TMapping2, Map<ObfuscationType, Map<TMapping, TMapping>> map) throws MappingConflictException {
            IMapping iMapping;
            Map<TMapping, TMapping> map2 = map.get(obfuscationType);
            if (map2 == null) {
                map2 = new HashMap<TMapping, TMapping>();
                map.put(obfuscationType, map2);
            }
            if ((iMapping = (IMapping)map2.get(TMapping)) != null) {
                if (iMapping.equals(TMapping2)) {
                    return (0x8FC21AFA ^ 0x8FC21AFB) != 0;
                }
                throw new MappingConflictException(iMapping, TMapping2);
            }
            map2.put(TMapping, TMapping2);
            return (0xF29E94A6 ^ 0xF29E94A6) != 0;
        }

        @Override
        public IMappingConsumer.MappingSet<MappingField> getFieldMappings(ObfuscationType obfuscationType) {
            return this.\u522b\u6253\u5566.getFieldMappings(obfuscationType);
        }

        @Override
        public IMappingConsumer.MappingSet<MappingMethod> getMethodMappings(ObfuscationType obfuscationType) {
            return this.\u522b\u6253\u5566.getMethodMappings(obfuscationType);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class MappingConflictException
    extends RuntimeException {
        private static final long \u522b\u6253\u5566 = 1L;
        private final IMapping<?> \u522b\u6253\u5566;
        private final IMapping<?> \u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566;

        public MappingConflictException(IMapping<?> iMapping, IMapping<?> iMapping2) {
            this.\u522b\u6253\u5566 = (long)iMapping;
            this.\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566 = iMapping2;
        }

        public IMapping<?> getOld() {
            return this.\u522b\u6253\u5566;
        }

        public IMapping<?> getNew() {
            return this.\u5b66\u8d39\u800c\u5df2\u518d\u6b63\u5e38\u4e0d\u8fc7\u5566;
        }
    }
}

