/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.Diagnostic;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.service.IObfuscationService;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ObfuscationServices {
    private static ObfuscationServices \u522b\u6253\u5566;
    private final ServiceLoader<IObfuscationService> \u522b\u6253\u5566;
    private final Set<IObfuscationService> \u522b\u6253\u5566 = ServiceLoader.load(IObfuscationService.class, this.getClass().getClassLoader());

    private ObfuscationServices() {
    }

    public static ObfuscationServices getInstance() {
        if (\u522b\u6253\u5566 == null) {
            \u522b\u6253\u5566 = new ObfuscationServices();
        }
        return \u522b\u6253\u5566;
    }

    public void initProviders(IMixinAnnotationProcessor iMixinAnnotationProcessor) {
        try {
            Iterator iterator = ((ServiceLoader)((Object)this.\u522b\u6253\u5566)).iterator();
            while (iterator.hasNext()) {
                IObfuscationService iObfuscationService = (IObfuscationService)iterator.next();
                if (this.\u522b\u6253\u5566.contains(iObfuscationService)) continue;
                this.\u522b\u6253\u5566.add(iObfuscationService);
                String string = iObfuscationService.getClass().getSimpleName();
                Collection<ObfuscationTypeDescriptor> collection = iObfuscationService.getObfuscationTypes();
                if (collection == null) continue;
                for (ObfuscationTypeDescriptor obfuscationTypeDescriptor : collection) {
                    try {
                        ObfuscationType obfuscationType = ObfuscationType.create(obfuscationTypeDescriptor, iMixinAnnotationProcessor);
                        iMixinAnnotationProcessor.printMessage(Diagnostic.Kind.NOTE, string + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u522b\u6253\u5566("2\ua7f5\ua4a0\ua061\ua915\u7d79\u8e58\u246e\u8b24\u3437f\ua7ff\ua4a5\ua074\ua95f\u7d36\u8e08") + obfuscationType + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u522b\u6253\u5566("0"));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            iMixinAnnotationProcessor.printMessage(Diagnostic.Kind.ERROR, serviceConfigurationError.getClass().getSimpleName() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u522b\u6253\u5566("(\ua7a6") + serviceConfigurationError.getMessage());
            serviceConfigurationError.printStackTrace();
        }
    }

    public Set<String> getSupportedOptions() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = ((ServiceLoader)((Object)this.\u522b\u6253\u5566)).iterator();
        while (iterator.hasNext()) {
            IObfuscationService iObfuscationService = (IObfuscationService)iterator.next();
            Set<String> set = iObfuscationService.getSupportedOptions();
            if (set == null) continue;
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public IObfuscationService getService(Class<? extends IObfuscationService> clazz) {
        Iterator iterator = ((ServiceLoader)((Object)this.\u522b\u6253\u5566)).iterator();
        while (iterator.hasNext()) {
            IObfuscationService iObfuscationService = (IObfuscationService)iterator.next();
            if (!clazz.getName().equals(iObfuscationService.getClass().getName())) continue;
            return iObfuscationService;
        }
        return null;
    }
}

