/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

final class Item {
    int index;
    int type;
    int intVal;
    long longVal;
    String strVal1;
    String strVal2;
    String strVal3;
    int hashCode;
    Item next;

    Item() {
    }

    Item(int n) {
        this.index = n;
    }

    Item(int n, Item item) {
        this.index = n;
        this.type = item.type;
        this.intVal = item.intVal;
        this.longVal = item.longVal;
        this.strVal1 = item.strVal1;
        this.strVal2 = item.strVal2;
        this.strVal3 = item.strVal3;
        this.hashCode = item.hashCode;
    }

    void set(int n) {
        this.type = 0x8F75D129 ^ 0x8F75D12A;
        this.intVal = n;
        this.hashCode = (0x81F514AD ^ 0xFE0AEB52) & this.type + n;
    }

    void set(long l) {
        this.type = 0x4353EBC3 ^ 0x4353EBC6;
        this.longVal = l;
        this.hashCode = (0x32B9F35C ^ 0x4D460CA3) & this.type + (int)l;
    }

    void set(float f) {
        this.type = 0xAD112421 ^ 0xAD112425;
        this.intVal = Float.floatToRawIntBits(f);
        this.hashCode = (0xC29C39AD ^ 0xBD63C652) & this.type + (int)f;
    }

    void set(double d) {
        this.type = 0x3633D0B9 ^ 0x3633D0BF;
        this.longVal = Double.doubleToRawLongBits(d);
        this.hashCode = (0x6F06676C ^ 0x10F99893) & this.type + (int)d;
    }

    void set(int n, String string, String string2, String string3) {
        this.type = n;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.strVal3 = string3;
        switch (n) {
            case 7: {
                this.intVal = 0x3570DD79 ^ 0x3570DD79;
            }
            case 1: 
            case 8: 
            case 16: 
            case 30: {
                this.hashCode = (0x13A27D9E ^ 0x6C5D8261) & n + string.hashCode();
                return;
            }
            case 12: {
                this.hashCode = (0x56630A74 ^ 0x299CF58B) & n + string.hashCode() * string2.hashCode();
                return;
            }
        }
        this.hashCode = (0x8B7FFFED ^ 0xF4800012) & n + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    void set(String string, String string2, int n) {
        this.type = 0xFE4B6D8D ^ 0xFE4B6D9F;
        this.longVal = n;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.hashCode = (0x33914176 ^ 0x4C6EBE89) & (0x1DD3B5C4 ^ 0x1DD3B5D6) + n * this.strVal1.hashCode() * this.strVal2.hashCode();
    }

    void set(int n, int n2) {
        this.type = 0xAFCAE472 ^ 0xAFCAE453;
        this.intVal = n;
        this.hashCode = n2;
    }

    boolean isEqualTo(Item item) {
        switch (this.type) {
            case 1: 
            case 7: 
            case 8: 
            case 16: 
            case 30: {
                return item.strVal1.equals(this.strVal1);
            }
            case 5: 
            case 6: 
            case 32: {
                return (item.longVal == this.longVal ? 0xED73C72E ^ 0xED73C72F : 0xD0A6BABA ^ 0xD0A6BABA) != 0;
            }
            case 3: 
            case 4: {
                return (item.intVal == this.intVal ? 0xEAF796FD ^ 0xEAF796FC : 0x89CBE10C ^ 0x89CBE10C) != 0;
            }
            case 31: {
                return (item.intVal == this.intVal && item.strVal1.equals(this.strVal1) ? 0x6B2BFF58 ^ 0x6B2BFF59 : 0xC424EACD ^ 0xC424EACD) != 0;
            }
            case 12: {
                return (item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) ? 0x43B8E1AA ^ 0x43B8E1AB : 0x36043671 ^ 0x36043671) != 0;
            }
            case 18: {
                return (item.longVal == this.longVal && item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) ? 0x631D04F3 ^ 0x631D04F2 : 0x4533EC0E ^ 0x4533EC0E) != 0;
            }
        }
        return (item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) && item.strVal3.equals(this.strVal3) ? 0x84BBA5C6 ^ 0x84BBA5C7 : 0x5ECFF1A3 ^ 0x5ECFF1A3) != 0;
    }
}

