/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.signature;

import org.spongepowered.asm.lib.signature.SignatureVisitor;

public class SignatureWriter
extends SignatureVisitor {
    private final StringBuilder buf = new StringBuilder();
    private boolean hasFormals;
    private boolean hasParameters;
    private int argumentStack;

    public SignatureWriter() {
        super(0x42A1F2B9 ^ 0x42A4F2B9);
    }

    public void visitFormalTypeParameter(String string) {
        if (!this.hasFormals) {
            this.hasFormals = 0x31E3437E ^ 0x31E3437F;
            this.buf.append((char)(0x803B4940 ^ 0x803B497C));
        }
        this.buf.append(string);
        this.buf.append((char)(0x7B7FA03B ^ 0x7B7FA001));
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.buf.append((char)(0xE60965A6 ^ 0xE609659C));
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = 0x8FB5A292 ^ 0x8FB5A293;
            this.buf.append((char)(0x9E54CB66 ^ 0x9E54CB4E));
        }
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.buf.append((char)(0x800A21F7 ^ 0x800A21DF));
        }
        this.buf.append((char)(0x6696807A ^ 0x66968053));
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.buf.append((char)(0x75250050 ^ 0x7525000E));
        return this;
    }

    public void visitBaseType(char c) {
        this.buf.append(c);
    }

    public void visitTypeVariable(String string) {
        this.buf.append((char)(0xD2E98A60 ^ 0xD2E98A34));
        this.buf.append(string);
        this.buf.append((char)(0x8E7612F9 ^ 0x8E7612C2));
    }

    public SignatureVisitor visitArrayType() {
        this.buf.append((char)(0x9ADB1DBB ^ 0x9ADB1DE0));
        return this;
    }

    public void visitClassType(String string) {
        this.buf.append((char)(0xFB6E59A9 ^ 0xFB6E59E5));
        this.buf.append(string);
        this.argumentStack *= 0xB5A7F9D8 ^ 0xB5A7F9DA;
    }

    public void visitInnerClassType(String string) {
        this.endArguments();
        this.buf.append((char)(0x7B8A17B8 ^ 0x7B8A1796));
        this.buf.append(string);
        this.argumentStack *= 0x8C7BD62F ^ 0x8C7BD62D;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % (0xD2B4642E ^ 0xD2B4642C) == 0) {
            this.argumentStack += 0x7F6D0539 ^ 0x7F6D0538;
            this.buf.append((char)(0x8AF28A4E ^ 0x8AF28A72));
        }
        this.buf.append((char)(0x83D46C32 ^ 0x83D46C18));
    }

    public SignatureVisitor visitTypeArgument(char c) {
        if (this.argumentStack % (0xADBA7255 ^ 0xADBA7257) == 0) {
            this.argumentStack += 0x61164141 ^ 0x61164140;
            this.buf.append((char)(0x8B290EF0 ^ 0x8B290ECC));
        }
        if (c != (0x785CE278 ^ 0x785CE245)) {
            this.buf.append(c);
        }
        return this;
    }

    public void visitEnd() {
        this.endArguments();
        this.buf.append((char)(0x37277DDA ^ 0x37277DE1));
    }

    public String toString() {
        return this.buf.toString();
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = 0xFA4DE555 ^ 0xFA4DE555;
            this.buf.append((char)(0x4EC85252 ^ 0x4EC8526C));
        }
    }

    private void endArguments() {
        if (this.argumentStack % (0xFAAC37CD ^ 0xFAAC37CF) != 0) {
            this.buf.append((char)(0x835B086B ^ 0x835B0855));
        }
        this.argumentStack /= 0x17A78167 ^ 0x17A78165;
    }
}

