/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InnerClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeAnnotationNode;

public class ClassNode
extends ClassVisitor {
    public int version;
    public int access;
    public String name;
    public String signature;
    public String superName;
    public List<String> interfaces = new ArrayList<String>();
    public String sourceFile;
    public String sourceDebug;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public List<InnerClassNode> innerClasses = new ArrayList<InnerClassNode>();
    public List<FieldNode> fields = new ArrayList<FieldNode>();
    public List<MethodNode> methods = new ArrayList<MethodNode>();

    public ClassNode() {
        this(0xB400BD2E ^ 0xB405BD2E);
        if (this.getClass() != ClassNode.class) {
            throw new IllegalStateException();
        }
    }

    public ClassNode(int n) {
        super(n);
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.version = n;
        this.access = n2;
        this.name = string;
        this.signature = string2;
        this.superName = string3;
        if (stringArray != null) {
            this.interfaces.addAll(Arrays.asList(stringArray));
        }
    }

    public void visitSource(String string, String string2) {
        this.sourceFile = string;
        this.sourceDebug = string2;
    }

    public void visitOuterClass(String string, String string2, String string3) {
        this.outerClass = string;
        this.outerMethod = string2;
        this.outerMethodDesc = string3;
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(0xE8506610 ^ 0xE8506611);
            }
            this.visibleAnnotations.add(annotationNode);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(0xE69B0483 ^ 0xE69B0482);
            }
            this.invisibleAnnotations.add(annotationNode);
        }
        return annotationNode;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xB6A97B5A ^ 0xB6A97B5B);
            }
            this.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xAC69B748 ^ 0xAC69B749);
            }
            this.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(0x1DC66F40 ^ 0x1DC66F41);
        }
        this.attrs.add(attribute);
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        InnerClassNode innerClassNode = new InnerClassNode(string, string2, string3, n);
        this.innerClasses.add(innerClassNode);
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        FieldNode fieldNode = new FieldNode(n, string, string2, string3, object);
        this.fields.add(fieldNode);
        return fieldNode;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodNode methodNode = new MethodNode(n, string, string2, string3, stringArray);
        this.methods.add(methodNode);
        return methodNode;
    }

    public void visitEnd() {
    }

    public void check(int n) {
        if (n == (0x9E390D91 ^ 0x9E3D0D91)) {
            if (this.visibleTypeAnnotations != null && this.visibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleTypeAnnotations != null && this.invisibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            for (FieldNode object : this.fields) {
                object.check(n);
            }
            for (MethodNode methodNode : this.methods) {
                methodNode.check(n);
            }
        }
    }

    public void accept(ClassVisitor classVisitor) {
        AnnotationNode annotationNode;
        int n;
        String[] stringArray = new String[this.interfaces.size()];
        this.interfaces.toArray(stringArray);
        classVisitor.visit(this.version, this.access, this.name, this.signature, this.superName, stringArray);
        if (this.sourceFile != null || this.sourceDebug != null) {
            classVisitor.visitSource(this.sourceFile, this.sourceDebug);
        }
        if (this.outerClass != null) {
            classVisitor.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        int n2 = this.visibleAnnotations == null ? 0x4A5FBFA9 ^ 0x4A5FBFA9 : this.visibleAnnotations.size();
        for (n = 0xCCF8C24 ^ 0xCCF8C24; n < n2; ++n) {
            annotationNode = this.visibleAnnotations.get(n);
            annotationNode.accept(classVisitor.visitAnnotation(annotationNode.desc, (0xD8A98C3E ^ 0xD8A98C3F) != 0));
        }
        n2 = this.invisibleAnnotations == null ? 0x40FA136C ^ 0x40FA136C : this.invisibleAnnotations.size();
        for (n = 0x30667065 ^ 0x30667065; n < n2; ++n) {
            annotationNode = this.invisibleAnnotations.get(n);
            annotationNode.accept(classVisitor.visitAnnotation(annotationNode.desc, (0x5054D9C6 ^ 0x5054D9C6) != 0));
        }
        n2 = this.visibleTypeAnnotations == null ? 0xE53AC9C1 ^ 0xE53AC9C1 : this.visibleTypeAnnotations.size();
        for (n = 0x959C6A42 ^ 0x959C6A42; n < n2; ++n) {
            annotationNode = this.visibleTypeAnnotations.get(n);
            annotationNode.accept(classVisitor.visitTypeAnnotation(((TypeAnnotationNode)annotationNode).typeRef, ((TypeAnnotationNode)annotationNode).typePath, ((TypeAnnotationNode)annotationNode).desc, (0x316C544E ^ 0x316C544F) != 0));
        }
        n2 = this.invisibleTypeAnnotations == null ? 0x5A2215CC ^ 0x5A2215CC : this.invisibleTypeAnnotations.size();
        for (n = 0xBA31B5FD ^ 0xBA31B5FD; n < n2; ++n) {
            annotationNode = this.invisibleTypeAnnotations.get(n);
            annotationNode.accept(classVisitor.visitTypeAnnotation(((TypeAnnotationNode)annotationNode).typeRef, ((TypeAnnotationNode)annotationNode).typePath, ((TypeAnnotationNode)annotationNode).desc, (0x9A2E0DB6 ^ 0x9A2E0DB6) != 0));
        }
        n2 = this.attrs == null ? 0x6D0146D7 ^ 0x6D0146D7 : this.attrs.size();
        for (n = 0x38D7235 ^ 0x38D7235; n < n2; ++n) {
            classVisitor.visitAttribute(this.attrs.get(n));
        }
        for (n = 0x3B1B3E50 ^ 0x3B1B3E50; n < this.innerClasses.size(); ++n) {
            this.innerClasses.get(n).accept(classVisitor);
        }
        for (n = 0xD69FFF79 ^ 0xD69FFF79; n < this.fields.size(); ++n) {
            this.fields.get(n).accept(classVisitor);
        }
        for (n = 0x3DE5FB14 ^ 0x3DE5FB14; n < this.methods.size(); ++n) {
            this.methods.get(n).accept(classVisitor);
        }
        classVisitor.visitEnd();
    }
}

