/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsnList {
    private int size;
    private AbstractInsnNode first;
    private AbstractInsnNode last;
    AbstractInsnNode[] cache;

    public int size() {
        return this.size;
    }

    public AbstractInsnNode getFirst() {
        return this.first;
    }

    public AbstractInsnNode getLast() {
        return this.last;
    }

    public AbstractInsnNode get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.cache == null) {
            this.cache = this.toArray();
        }
        return this.cache[n];
    }

    public boolean contains(AbstractInsnNode abstractInsnNode) {
        AbstractInsnNode abstractInsnNode2 = this.first;
        while (abstractInsnNode2 != null && abstractInsnNode2 != abstractInsnNode) {
            abstractInsnNode2 = abstractInsnNode2.next;
        }
        return (abstractInsnNode2 != null ? 0xB591817E ^ 0xB591817F : 0x691B258A ^ 0x691B258A) != 0;
    }

    public int indexOf(AbstractInsnNode abstractInsnNode) {
        if (this.cache == null) {
            this.cache = this.toArray();
        }
        return abstractInsnNode.index;
    }

    public void accept(MethodVisitor methodVisitor) {
        AbstractInsnNode abstractInsnNode = this.first;
        while (abstractInsnNode != null) {
            abstractInsnNode.accept(methodVisitor);
            abstractInsnNode = abstractInsnNode.next;
        }
    }

    public ListIterator<AbstractInsnNode> iterator() {
        return this.iterator(0x408FD900 ^ 0x408FD900);
    }

    public ListIterator<AbstractInsnNode> iterator(int n) {
        return new InsnListIterator(n);
    }

    public AbstractInsnNode[] toArray() {
        int n = 0x5A7B7456 ^ 0x5A7B7456;
        AbstractInsnNode abstractInsnNode = this.first;
        AbstractInsnNode[] abstractInsnNodeArray = new AbstractInsnNode[this.size];
        while (abstractInsnNode != null) {
            abstractInsnNodeArray[n] = abstractInsnNode;
            abstractInsnNode.index = n++;
            abstractInsnNode = abstractInsnNode.next;
        }
        return abstractInsnNodeArray;
    }

    public void set(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        AbstractInsnNode abstractInsnNode3;
        AbstractInsnNode abstractInsnNode4;
        abstractInsnNode2.next = abstractInsnNode4 = abstractInsnNode.next;
        if (abstractInsnNode4 != null) {
            abstractInsnNode4.prev = abstractInsnNode2;
        } else {
            this.last = abstractInsnNode2;
        }
        abstractInsnNode2.prev = abstractInsnNode3 = abstractInsnNode.prev;
        if (abstractInsnNode3 != null) {
            abstractInsnNode3.next = abstractInsnNode2;
        } else {
            this.first = abstractInsnNode2;
        }
        if (this.cache != null) {
            int n = abstractInsnNode.index;
            this.cache[n] = abstractInsnNode2;
            abstractInsnNode2.index = n;
        } else {
            abstractInsnNode2.index = 0x877799C0 ^ 0x877799C0;
        }
        abstractInsnNode.index = 0x99B6B13B ^ 0x66494EC4;
        abstractInsnNode.prev = null;
        abstractInsnNode.next = null;
    }

    public void add(AbstractInsnNode abstractInsnNode) {
        this.size += 0x59246D8 ^ 0x59246D9;
        if (this.last == null) {
            this.first = abstractInsnNode;
            this.last = abstractInsnNode;
        } else {
            this.last.next = abstractInsnNode;
            abstractInsnNode.prev = this.last;
        }
        this.last = abstractInsnNode;
        this.cache = null;
        abstractInsnNode.index = 0x480251DF ^ 0x480251DF;
    }

    public void add(InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        if (this.last == null) {
            this.first = insnList.first;
            this.last = insnList.last;
        } else {
            AbstractInsnNode abstractInsnNode;
            this.last.next = abstractInsnNode = insnList.first;
            abstractInsnNode.prev = this.last;
            this.last = insnList.last;
        }
        this.cache = null;
        insnList.removeAll((0xF0D95207 ^ 0xF0D95207) != 0);
    }

    public void insert(AbstractInsnNode abstractInsnNode) {
        this.size += 0xCCA08F30 ^ 0xCCA08F31;
        if (this.first == null) {
            this.first = abstractInsnNode;
            this.last = abstractInsnNode;
        } else {
            this.first.prev = abstractInsnNode;
            abstractInsnNode.next = this.first;
        }
        this.first = abstractInsnNode;
        this.cache = null;
        abstractInsnNode.index = 0x6E45FDB8 ^ 0x6E45FDB8;
    }

    public void insert(InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        if (this.first == null) {
            this.first = insnList.first;
            this.last = insnList.last;
        } else {
            AbstractInsnNode abstractInsnNode;
            this.first.prev = abstractInsnNode = insnList.last;
            abstractInsnNode.next = this.first;
            this.first = insnList.first;
        }
        this.cache = null;
        insnList.removeAll((0xAB53FCE4 ^ 0xAB53FCE4) != 0);
    }

    public void insert(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        this.size += 0x7B167C6B ^ 0x7B167C6A;
        AbstractInsnNode abstractInsnNode3 = abstractInsnNode.next;
        if (abstractInsnNode3 == null) {
            this.last = abstractInsnNode2;
        } else {
            abstractInsnNode3.prev = abstractInsnNode2;
        }
        abstractInsnNode.next = abstractInsnNode2;
        abstractInsnNode2.next = abstractInsnNode3;
        abstractInsnNode2.prev = abstractInsnNode;
        this.cache = null;
        abstractInsnNode2.index = 0x2D373F99 ^ 0x2D373F99;
    }

    public void insert(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        AbstractInsnNode abstractInsnNode2 = insnList.first;
        AbstractInsnNode abstractInsnNode3 = insnList.last;
        AbstractInsnNode abstractInsnNode4 = abstractInsnNode.next;
        if (abstractInsnNode4 == null) {
            this.last = abstractInsnNode3;
        } else {
            abstractInsnNode4.prev = abstractInsnNode3;
        }
        abstractInsnNode.next = abstractInsnNode2;
        abstractInsnNode3.next = abstractInsnNode4;
        abstractInsnNode2.prev = abstractInsnNode;
        this.cache = null;
        insnList.removeAll((0xFF7140E6 ^ 0xFF7140E6) != 0);
    }

    public void insertBefore(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        this.size += 0xE56D49CC ^ 0xE56D49CD;
        AbstractInsnNode abstractInsnNode3 = abstractInsnNode.prev;
        if (abstractInsnNode3 == null) {
            this.first = abstractInsnNode2;
        } else {
            abstractInsnNode3.next = abstractInsnNode2;
        }
        abstractInsnNode.prev = abstractInsnNode2;
        abstractInsnNode2.next = abstractInsnNode;
        abstractInsnNode2.prev = abstractInsnNode3;
        this.cache = null;
        abstractInsnNode2.index = 0x64F10094 ^ 0x64F10094;
    }

    public void insertBefore(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        AbstractInsnNode abstractInsnNode2 = insnList.first;
        AbstractInsnNode abstractInsnNode3 = insnList.last;
        AbstractInsnNode abstractInsnNode4 = abstractInsnNode.prev;
        if (abstractInsnNode4 == null) {
            this.first = abstractInsnNode2;
        } else {
            abstractInsnNode4.next = abstractInsnNode2;
        }
        abstractInsnNode.prev = abstractInsnNode3;
        abstractInsnNode3.next = abstractInsnNode;
        abstractInsnNode2.prev = abstractInsnNode4;
        this.cache = null;
        insnList.removeAll((0x45726380 ^ 0x45726380) != 0);
    }

    public void remove(AbstractInsnNode abstractInsnNode) {
        this.size -= 0x5A27809A ^ 0x5A27809B;
        AbstractInsnNode abstractInsnNode2 = abstractInsnNode.next;
        AbstractInsnNode abstractInsnNode3 = abstractInsnNode.prev;
        if (abstractInsnNode2 == null) {
            if (abstractInsnNode3 == null) {
                this.first = null;
                this.last = null;
            } else {
                abstractInsnNode3.next = null;
                this.last = abstractInsnNode3;
            }
        } else if (abstractInsnNode3 == null) {
            this.first = abstractInsnNode2;
            abstractInsnNode2.prev = null;
        } else {
            abstractInsnNode3.next = abstractInsnNode2;
            abstractInsnNode2.prev = abstractInsnNode3;
        }
        this.cache = null;
        abstractInsnNode.index = 0x2F419F09 ^ 0xD0BE60F6;
        abstractInsnNode.prev = null;
        abstractInsnNode.next = null;
    }

    void removeAll(boolean bl) {
        if (bl) {
            AbstractInsnNode abstractInsnNode = this.first;
            while (abstractInsnNode != null) {
                AbstractInsnNode abstractInsnNode2 = abstractInsnNode.next;
                abstractInsnNode.index = 0xA12DA016 ^ 0x5ED25FE9;
                abstractInsnNode.prev = null;
                abstractInsnNode.next = null;
                abstractInsnNode = abstractInsnNode2;
            }
        }
        this.size = 0x44C6E4 ^ 0x44C6E4;
        this.first = null;
        this.last = null;
        this.cache = null;
    }

    public void clear() {
        this.removeAll((0x60F05CAE ^ 0x60F05CAE) != 0);
    }

    public void resetLabels() {
        AbstractInsnNode abstractInsnNode = this.first;
        while (abstractInsnNode != null) {
            if (abstractInsnNode instanceof LabelNode) {
                ((LabelNode)abstractInsnNode).resetLabel();
            }
            abstractInsnNode = abstractInsnNode.next;
        }
    }

    private final class InsnListIterator
    implements ListIterator {
        AbstractInsnNode next;
        AbstractInsnNode prev;
        AbstractInsnNode remove;

        InsnListIterator(int n) {
            if (n == InsnList.this.size()) {
                this.next = null;
                this.prev = InsnList.this.getLast();
            } else {
                this.next = InsnList.this.get(n);
                this.prev = this.next.prev;
            }
        }

        public boolean hasNext() {
            return (this.next != null ? 0x92888216 ^ 0x92888217 : 0x19CEBEBE ^ 0x19CEBEBE) != 0;
        }

        public Object next() {
            AbstractInsnNode abstractInsnNode;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.prev = abstractInsnNode = this.next;
            this.next = abstractInsnNode.next;
            this.remove = abstractInsnNode;
            return abstractInsnNode;
        }

        public void remove() {
            if (this.remove != null) {
                if (this.remove == this.next) {
                    this.next = this.next.next;
                } else {
                    this.prev = this.prev.prev;
                }
            } else {
                throw new IllegalStateException();
            }
            InsnList.this.remove(this.remove);
            this.remove = null;
        }

        public boolean hasPrevious() {
            return (this.prev != null ? 0xA8111F1D ^ 0xA8111F1C : 0x3EA9ED2B ^ 0x3EA9ED2B) != 0;
        }

        public Object previous() {
            AbstractInsnNode abstractInsnNode;
            this.next = abstractInsnNode = this.prev;
            this.prev = abstractInsnNode.prev;
            this.remove = abstractInsnNode;
            return abstractInsnNode;
        }

        public int nextIndex() {
            if (this.next == null) {
                return InsnList.this.size();
            }
            if (InsnList.this.cache == null) {
                InsnList.this.cache = InsnList.this.toArray();
            }
            return this.next.index;
        }

        public int previousIndex() {
            if (this.prev == null) {
                return 0xB1925666 ^ 0x4E6DA999;
            }
            if (InsnList.this.cache == null) {
                InsnList.this.cache = InsnList.this.toArray();
            }
            return this.prev.index;
        }

        public void add(Object object) {
            if (this.next != null) {
                InsnList.this.insertBefore(this.next, (AbstractInsnNode)object);
            } else if (this.prev != null) {
                InsnList.this.insert(this.prev, (AbstractInsnNode)object);
            } else {
                InsnList.this.add((AbstractInsnNode)object);
            }
            this.prev = (AbstractInsnNode)object;
            this.remove = null;
        }

        public void set(Object object) {
            if (this.remove != null) {
                InsnList.this.set(this.remove, (AbstractInsnNode)object);
                if (this.remove == this.prev) {
                    this.prev = (AbstractInsnNode)object;
                } else {
                    this.next = (AbstractInsnNode)object;
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

