/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.IincInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.LocalVariableAnnotationNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.LookupSwitchInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MultiANewArrayInsnNode;
import org.spongepowered.asm.lib.tree.ParameterNode;
import org.spongepowered.asm.lib.tree.TableSwitchInsnNode;
import org.spongepowered.asm.lib.tree.TryCatchBlockNode;
import org.spongepowered.asm.lib.tree.TypeAnnotationNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;

public class MethodNode
extends MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List<String> exceptions;
    public List<ParameterNode> parameters;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public Object annotationDefault;
    public List<AnnotationNode>[] visibleParameterAnnotations;
    public List<AnnotationNode>[] invisibleParameterAnnotations;
    public InsnList instructions;
    public List<TryCatchBlockNode> tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List<LocalVariableNode> localVariables;
    public List<LocalVariableAnnotationNode> visibleLocalVariableAnnotations;
    public List<LocalVariableAnnotationNode> invisibleLocalVariableAnnotations;
    private boolean visited;

    public MethodNode() {
        this(0x2375D344 ^ 0x2370D344);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    public MethodNode(int n) {
        super(n);
        this.instructions = new InsnList();
    }

    public MethodNode(int n, String string, String string2, String string3, String[] stringArray) {
        this(0x31DB5147 ^ 0x31DE5147, n, string, string2, string3, stringArray);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    public MethodNode(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        super(n);
        int n3;
        this.access = n2;
        this.name = string;
        this.desc = string2;
        this.signature = string3;
        this.exceptions = new ArrayList<String>(stringArray == null ? 0x4DAC4187 ^ 0x4DAC4187 : stringArray.length);
        int n4 = (n2 & (0x5BC94323 ^ 0x5BC94723)) != 0 ? 0x997F461 ^ 0x997F460 : (n3 = 0x4D118929 ^ 0x4D118929);
        if (n3 == 0) {
            this.localVariables = new ArrayList<LocalVariableNode>(0x35FE57D5 ^ 0x35FE57D0);
        }
        this.tryCatchBlocks = new ArrayList<TryCatchBlockNode>();
        if (stringArray != null) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
        this.instructions = new InsnList();
    }

    public void visitParameter(String string, int n) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterNode>(0x3D852874 ^ 0x3D852871);
        }
        this.parameters.add(new ParameterNode(string, n));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode((List<Object>)new ArrayList<Object>(0x1D1E077B ^ 0x1D1E077B){

            @Override
            public boolean add(Object object) {
                MethodNode.this.annotationDefault = object;
                return super.add(object);
            }
        });
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(0xA84EF878 ^ 0xA84EF879);
            }
            this.visibleAnnotations.add(annotationNode);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(0x58083264 ^ 0x58083265);
            }
            this.invisibleAnnotations.add(annotationNode);
        }
        return annotationNode;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x5768FBAF ^ 0x5768FBAE);
            }
            this.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xAE6B130B ^ 0xAE6B130A);
            }
            this.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleParameterAnnotations == null) {
                int n2 = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[n2];
            }
            if (this.visibleParameterAnnotations[n] == null) {
                this.visibleParameterAnnotations[n] = new ArrayList<AnnotationNode>(0x5E02A4DC ^ 0x5E02A4DD);
            }
            this.visibleParameterAnnotations[n].add(annotationNode);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int n3 = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[n3];
            }
            if (this.invisibleParameterAnnotations[n] == null) {
                this.invisibleParameterAnnotations[n] = new ArrayList<AnnotationNode>(0xBAA42BDF ^ 0xBAA42BDE);
            }
            this.invisibleParameterAnnotations[n].add(annotationNode);
        }
        return annotationNode;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(0xEB1E32BD ^ 0xEB1E32BC);
        }
        this.attrs.add(attribute);
    }

    public void visitCode() {
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.instructions.add(new FrameNode(n, n2, objectArray == null ? null : this.getLabelNodes(objectArray), n3, objectArray2 == null ? null : this.getLabelNodes(objectArray2)));
    }

    public void visitInsn(int n) {
        this.instructions.add(new InsnNode(n));
    }

    public void visitIntInsn(int n, int n2) {
        this.instructions.add(new IntInsnNode(n, n2));
    }

    public void visitVarInsn(int n, int n2) {
        this.instructions.add(new VarInsnNode(n, n2));
    }

    public void visitTypeInsn(int n, String string) {
        this.instructions.add(new TypeInsnNode(n, string));
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.instructions.add(new FieldInsnNode(n, string, string2, string3));
    }

    @Deprecated
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (this.api >= (0x7BFAC610 ^ 0x7BFFC610)) {
            super.visitMethodInsn(n, string, string2, string3);
            return;
        }
        this.instructions.add(new MethodInsnNode(n, string, string2, string3));
    }

    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (this.api < (0x5367F424 ^ 0x5362F424)) {
            super.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.instructions.add(new MethodInsnNode(n, string, string2, string3, bl));
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.instructions.add(new InvokeDynamicInsnNode(string, string2, handle, objectArray));
    }

    public void visitJumpInsn(int n, Label label) {
        this.instructions.add(new JumpInsnNode(n, this.getLabelNode(label)));
    }

    public void visitLabel(Label label) {
        this.instructions.add(this.getLabelNode(label));
    }

    public void visitLdcInsn(Object object) {
        this.instructions.add(new LdcInsnNode(object));
    }

    public void visitIincInsn(int n, int n2) {
        this.instructions.add(new IincInsnNode(n, n2));
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        this.instructions.add(new TableSwitchInsnNode(n, n2, this.getLabelNode(label), this.getLabelNodes(labelArray)));
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.instructions.add(new LookupSwitchInsnNode(this.getLabelNode(label), nArray, this.getLabelNodes(labelArray)));
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.instructions.add(new MultiANewArrayInsnNode(string, n));
    }

    public AnnotationVisitor visitInsnAnnotation(int n, TypePath typePath, String string, boolean bl) {
        AbstractInsnNode abstractInsnNode = this.instructions.getLast();
        while (true) {
            if (abstractInsnNode.getOpcode() != (0x7B46962F ^ 0x84B969D0)) break;
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (abstractInsnNode.visibleTypeAnnotations == null) {
                abstractInsnNode.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xA1B7B2B5 ^ 0xA1B7B2B4);
            }
            abstractInsnNode.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (abstractInsnNode.invisibleTypeAnnotations == null) {
                abstractInsnNode.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xA3803BD4 ^ 0xA3803BD5);
            }
            abstractInsnNode.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(this.getLabelNode(label), this.getLabelNode(label2), this.getLabelNode(label3), string));
    }

    public AnnotationVisitor visitTryCatchAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TryCatchBlockNode tryCatchBlockNode = this.tryCatchBlocks.get((n & (0x68FF4E17 ^ 0x6800B117)) >> (0xDA951940 ^ 0xDA951948));
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (tryCatchBlockNode.visibleTypeAnnotations == null) {
                tryCatchBlockNode.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x87A1C0FF ^ 0x87A1C0FE);
            }
            tryCatchBlockNode.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (tryCatchBlockNode.invisibleTypeAnnotations == null) {
                tryCatchBlockNode.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xC45996ED ^ 0xC45996EC);
            }
            tryCatchBlockNode.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.localVariables.add(new LocalVariableNode(string, string2, string3, this.getLabelNode(label), this.getLabelNode(label2), n));
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        LocalVariableAnnotationNode localVariableAnnotationNode = new LocalVariableAnnotationNode(n, typePath, this.getLabelNodes(labelArray), this.getLabelNodes(labelArray2), nArray, string);
        if (bl) {
            if (this.visibleLocalVariableAnnotations == null) {
                this.visibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>(0xFE0A6BF8 ^ 0xFE0A6BF9);
            }
            this.visibleLocalVariableAnnotations.add(localVariableAnnotationNode);
        } else {
            if (this.invisibleLocalVariableAnnotations == null) {
                this.invisibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>(0x66EAEA9F ^ 0x66EAEA9E);
            }
            this.invisibleLocalVariableAnnotations.add(localVariableAnnotationNode);
        }
        return localVariableAnnotationNode;
    }

    public void visitLineNumber(int n, Label label) {
        this.instructions.add(new LineNumberNode(n, this.getLabelNode(label)));
    }

    public void visitMaxs(int n, int n2) {
        this.maxStack = n;
        this.maxLocals = n2;
    }

    public void visitEnd() {
    }

    protected LabelNode getLabelNode(Label label) {
        if (!(label.info instanceof LabelNode)) {
            label.info = new LabelNode();
        }
        return (LabelNode)label.info;
    }

    private LabelNode[] getLabelNodes(Label[] labelArray) {
        LabelNode[] labelNodeArray = new LabelNode[labelArray.length];
        for (int i = 0xB05BA243 ^ 0xB05BA243; i < labelArray.length; ++i) {
            labelNodeArray[i] = this.getLabelNode(labelArray[i]);
        }
        return labelNodeArray;
    }

    private Object[] getLabelNodes(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0x582418B0 ^ 0x582418B0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof Label) {
                object = this.getLabelNode((Label)object);
            }
            objectArray2[i] = object;
        }
        return objectArray2;
    }

    public void check(int n) {
        if (n == (0xA19E1613 ^ 0xA19A1613)) {
            Object object;
            int n2;
            if (this.visibleTypeAnnotations != null && this.visibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleTypeAnnotations != null && this.invisibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            int n3 = this.tryCatchBlocks == null ? 0x6B8B0890 ^ 0x6B8B0890 : this.tryCatchBlocks.size();
            for (n2 = 0x49552F3 ^ 0x49552F3; n2 < n3; ++n2) {
                object = this.tryCatchBlocks.get(n2);
                if (((TryCatchBlockNode)object).visibleTypeAnnotations != null && ((TryCatchBlockNode)object).visibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (((TryCatchBlockNode)object).invisibleTypeAnnotations == null || ((TryCatchBlockNode)object).invisibleTypeAnnotations.size() <= 0) continue;
                throw new RuntimeException();
            }
            for (n2 = 0x1F22FA94 ^ 0x1F22FA94; n2 < this.instructions.size(); ++n2) {
                object = this.instructions.get(n2);
                if (((AbstractInsnNode)object).visibleTypeAnnotations != null && ((AbstractInsnNode)object).visibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (((AbstractInsnNode)object).invisibleTypeAnnotations != null && ((AbstractInsnNode)object).invisibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (!(object instanceof MethodInsnNode)) continue;
                int n4 = ((MethodInsnNode)object).itf;
                if (n4 == (((AbstractInsnNode)object).opcode == (0x74AA6EAA ^ 0x74AA6E13) ? 0xF93640BC ^ 0xF93640BD : 0xD0E20327 ^ 0xD0E20327)) continue;
                throw new RuntimeException();
            }
            if (this.visibleLocalVariableAnnotations != null && this.visibleLocalVariableAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleLocalVariableAnnotations != null && this.invisibleLocalVariableAnnotations.size() > 0) {
                throw new RuntimeException();
            }
        }
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        MethodVisitor methodVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, stringArray);
        if (methodVisitor != null) {
            this.accept(methodVisitor);
        }
    }

    public void accept(MethodVisitor methodVisitor) {
        AnnotationNode annotationNode;
        int n;
        List<AnnotationNode> list;
        int n2;
        int n3 = this.parameters == null ? 0xF8C3ED86 ^ 0xF8C3ED86 : this.parameters.size();
        for (n2 = 0x552C6929 ^ 0x552C6929; n2 < n3; ++n2) {
            list = this.parameters.get(n2);
            methodVisitor.visitParameter(((ParameterNode)((Object)list)).name, ((ParameterNode)((Object)list)).access);
        }
        if (this.annotationDefault != null) {
            list = methodVisitor.visitAnnotationDefault();
            AnnotationNode.accept((AnnotationVisitor)((Object)list), null, this.annotationDefault);
            if (list != null) {
                ((AnnotationVisitor)((Object)list)).visitEnd();
            }
        }
        n3 = this.visibleAnnotations == null ? 0x80FBF3A8 ^ 0x80FBF3A8 : this.visibleAnnotations.size();
        for (n2 = 0x352C289 ^ 0x352C289; n2 < n3; ++n2) {
            list = this.visibleAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitAnnotation(((AnnotationNode)((Object)list)).desc, (0x62960AD1 ^ 0x62960AD0) != 0));
        }
        n3 = this.invisibleAnnotations == null ? 0x2A56316F ^ 0x2A56316F : this.invisibleAnnotations.size();
        for (n2 = 0xC2F0165 ^ 0xC2F0165; n2 < n3; ++n2) {
            list = this.invisibleAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitAnnotation(((AnnotationNode)((Object)list)).desc, (0xAD0676E4 ^ 0xAD0676E4) != 0));
        }
        n3 = this.visibleTypeAnnotations == null ? 0x8E414878 ^ 0x8E414878 : this.visibleTypeAnnotations.size();
        for (n2 = 0x98DA20B4 ^ 0x98DA20B4; n2 < n3; ++n2) {
            list = this.visibleTypeAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitTypeAnnotation(((TypeAnnotationNode)((Object)list)).typeRef, ((TypeAnnotationNode)((Object)list)).typePath, ((TypeAnnotationNode)((Object)list)).desc, (0xBE9F7209 ^ 0xBE9F7208) != 0));
        }
        n3 = this.invisibleTypeAnnotations == null ? 0x7EC02444 ^ 0x7EC02444 : this.invisibleTypeAnnotations.size();
        for (n2 = 0x8F6CEDAC ^ 0x8F6CEDAC; n2 < n3; ++n2) {
            list = this.invisibleTypeAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitTypeAnnotation(((TypeAnnotationNode)((Object)list)).typeRef, ((TypeAnnotationNode)((Object)list)).typePath, ((TypeAnnotationNode)((Object)list)).desc, (0x90377D0 ^ 0x90377D0) != 0));
        }
        n3 = this.visibleParameterAnnotations == null ? 0xDA7770DC ^ 0xDA7770DC : this.visibleParameterAnnotations.length;
        for (n2 = 0x7E7DAA39 ^ 0x7E7DAA39; n2 < n3; ++n2) {
            list = this.visibleParameterAnnotations[n2];
            if (list == null) continue;
            for (n = 0xD802D607 ^ 0xD802D607; n < list.size(); ++n) {
                annotationNode = list.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, (0x62FE0A1E ^ 0x62FE0A1F) != 0));
            }
        }
        n3 = this.invisibleParameterAnnotations == null ? 0x6B6D2D16 ^ 0x6B6D2D16 : this.invisibleParameterAnnotations.length;
        for (n2 = 0xE47C0861 ^ 0xE47C0861; n2 < n3; ++n2) {
            list = this.invisibleParameterAnnotations[n2];
            if (list == null) continue;
            for (n = 0xF37F467C ^ 0xF37F467C; n < list.size(); ++n) {
                annotationNode = list.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, (0xF9F6B32E ^ 0xF9F6B32E) != 0));
            }
        }
        if (this.visited) {
            this.instructions.resetLabels();
        }
        n3 = this.attrs == null ? 0x975036F9 ^ 0x975036F9 : this.attrs.size();
        for (n2 = 0x6A5AD3E5 ^ 0x6A5AD3E5; n2 < n3; ++n2) {
            methodVisitor.visitAttribute(this.attrs.get(n2));
        }
        if (this.instructions.size() > 0) {
            methodVisitor.visitCode();
            n3 = this.tryCatchBlocks == null ? 0xAAF533B0 ^ 0xAAF533B0 : this.tryCatchBlocks.size();
            for (n2 = 0xCFBC4FDB ^ 0xCFBC4FDB; n2 < n3; ++n2) {
                this.tryCatchBlocks.get(n2).updateIndex(n2);
                this.tryCatchBlocks.get(n2).accept(methodVisitor);
            }
            this.instructions.accept(methodVisitor);
            n3 = this.localVariables == null ? 0xB24D0263 ^ 0xB24D0263 : this.localVariables.size();
            for (n2 = 0xD390102B ^ 0xD390102B; n2 < n3; ++n2) {
                this.localVariables.get(n2).accept(methodVisitor);
            }
            n3 = this.visibleLocalVariableAnnotations == null ? 0x10D9FA13 ^ 0x10D9FA13 : this.visibleLocalVariableAnnotations.size();
            for (n2 = 0x9BD98C1C ^ 0x9BD98C1C; n2 < n3; ++n2) {
                this.visibleLocalVariableAnnotations.get(n2).accept(methodVisitor, (0x12F51420 ^ 0x12F51421) != 0);
            }
            n3 = this.invisibleLocalVariableAnnotations == null ? 0x7034DFB9 ^ 0x7034DFB9 : this.invisibleLocalVariableAnnotations.size();
            for (n2 = 0x6E2300D ^ 0x6E2300D; n2 < n3; ++n2) {
                this.invisibleLocalVariableAnnotations.get(n2).accept(methodVisitor, (0x5ACBB91F ^ 0x5ACBB91F) != 0);
            }
            methodVisitor.visitMaxs(this.maxStack, this.maxLocals);
            this.visited = 0x1F55825C ^ 0x1F55825D;
        }
        methodVisitor.visitEnd();
    }
}

