/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.gen;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.gen.AccessorGenerator;
import org.spongepowered.asm.mixin.gen.AccessorInfo;
import org.spongepowered.asm.util.Bytecode;

public class AccessorGeneratorMethodProxy
extends AccessorGenerator {
    private final MethodNode targetMethod;
    private final Type[] argTypes;
    private final Type returnType;
    private final boolean isInstanceMethod;

    public AccessorGeneratorMethodProxy(AccessorInfo accessorInfo) {
        super(accessorInfo);
        this.targetMethod = accessorInfo.getTargetMethod();
        this.argTypes = accessorInfo.getArgTypes();
        this.returnType = accessorInfo.getReturnType();
        this.isInstanceMethod = !Bytecode.hasFlag(this.targetMethod, 0x294A8264 ^ 0x294A826C) ? 0xD6A0739C ^ 0xD6A0739D : 0x897F0D5 ^ 0x897F0D5;
    }

    @Override
    public MethodNode generate() {
        int n = Bytecode.getArgsSize(this.argTypes) + this.returnType.getSize() + (this.isInstanceMethod ? 0xB4A6DCC1 ^ 0xB4A6DCC0 : 0xEDDBECD9 ^ 0xEDDBECD9);
        MethodNode methodNode = this.createMethod(n, n);
        if (this.isInstanceMethod) {
            methodNode.instructions.add(new VarInsnNode(0xE296C012 ^ 0xE296C00B, 0x5350DF27 ^ 0x5350DF27));
        }
        Bytecode.loadArgs(this.argTypes, methodNode.instructions, this.isInstanceMethod ? 0xA9497160 ^ 0xA9497161 : 0xE64570A5 ^ 0xE64570A5);
        boolean bl = Bytecode.hasFlag(this.targetMethod, 0x80D18CF9 ^ 0x80D18CFB);
        int n2 = this.isInstanceMethod ? (bl ? 0xA4030E6B ^ 0xA4030EDC : 0x25735493 ^ 0x25735425) : 0xCEB335D9 ^ 0xCEB33561;
        methodNode.instructions.add(new MethodInsnNode(n2, this.info.getClassNode().name, this.targetMethod.name, this.targetMethod.desc, (0x1B23CABA ^ 0x1B23CABA) != 0));
        methodNode.instructions.add(new InsnNode(this.returnType.getOpcode(0xEF9AB1F ^ 0xEF9ABB3)));
        return methodNode;
    }
}

