/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.InjectorTarget;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

public abstract class Injector {
    protected static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected InjectionInfo info;
    protected final ClassNode classNode;
    protected final MethodNode methodNode;
    protected final Type[] methodArgs;
    protected final Type returnType;
    protected final boolean isStatic;

    public Injector(InjectionInfo injectionInfo) {
        this(injectionInfo.getClassNode(), injectionInfo.getMethod());
        this.info = injectionInfo;
    }

    private Injector(ClassNode classNode, MethodNode methodNode) {
        this.classNode = classNode;
        this.methodNode = methodNode;
        this.methodArgs = Type.getArgumentTypes(this.methodNode.desc);
        this.returnType = Type.getReturnType(this.methodNode.desc);
        this.isStatic = Bytecode.methodIsStatic(this.methodNode);
    }

    public String toString() {
        Object[] objectArray = new Object[0x773A161F ^ 0x773A161D];
        objectArray[0x96350F5B ^ 0x96350F5B] = this.classNode.name;
        objectArray[0xE5BAFD70 ^ 0xE5BAFD71] = this.methodNode.name;
        return String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4ef\ua02b\ua940\u7d65"), objectArray);
    }

    public final List<InjectionNodes.InjectionNode> find(InjectorTarget injectorTarget, List<InjectionPoint> list) {
        this.sanityCheck(injectorTarget.getTarget(), list);
        ArrayList<InjectionNodes.InjectionNode> arrayList = new ArrayList<InjectionNodes.InjectionNode>();
        for (TargetNode targetNode : this.findTargetNodes(injectorTarget, list)) {
            this.addTargetNode(injectorTarget.getTarget(), arrayList, targetNode.insn, targetNode.nominators);
        }
        return arrayList;
    }

    protected void addTargetNode(Target target, List<InjectionNodes.InjectionNode> list, AbstractInsnNode abstractInsnNode, Set<InjectionPoint> set) {
        list.add(target.addInjectionNode(abstractInsnNode));
    }

    public final void inject(Target target, List<InjectionNodes.InjectionNode> list) {
        for (InjectionNodes.InjectionNode injectionNode : list) {
            if (injectionNode.isRemoved()) {
                if (!this.info.getContext().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) continue;
                Object[] objectArray = new Object[0x690AE58 ^ 0x690AE5A];
                objectArray[0x332406CF ^ 0x332406CF] = this.info;
                objectArray[0xF2110C68 ^ 0xF2110C69] = target;
                logger.warn(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2474\u8b38\u3473w\ua7a6\ua4b3\ua07e\ua917\u7d36\u8e51\u2467\u8b77\u3460s\ua7f5\ua4f5\ua063\ua900\u7d7b\u8e45\u246c\u8b32\u34732\ua7e4\ua4ac\ua031\ua904\u7d36\u8e5a\u2468\u8b32\u3461{\ua7e9\ua4a0\ua062\ua945\u7d7f\u8e44\u2470\u8b32\u3474f\ua7e9\ua4a7\ua031\ua90c\u7d78\u8e0a\u2461\u8b2a"), objectArray);
                continue;
            }
            this.inject(target, injectionNode);
        }
        for (InjectionNodes.InjectionNode injectionNode : list) {
            this.postInject(target, injectionNode);
        }
    }

    private Collection<TargetNode> findTargetNodes(InjectorTarget injectorTarget, List<InjectionPoint> list) {
        IMixinContext iMixinContext = this.info.getContext();
        MethodNode methodNode = injectorTarget.getMethod();
        TreeMap<Integer, TargetNode> treeMap = new TreeMap<Integer, TargetNode>();
        ArrayList<AbstractInsnNode> arrayList = new ArrayList<AbstractInsnNode>(0x59E321B2 ^ 0x59E32192);
        for (InjectionPoint injectionPoint : list) {
            arrayList.clear();
            if (injectorTarget.isMerged() && !iMixinContext.getClassName().equals(injectorTarget.getMergedBy()) && !injectionPoint.checkPriority(injectorTarget.getMergedPriority(), iMixinContext.getPriority())) {
                Object[] objectArray = new Object[0x4BC56E3A ^ 0x4BC56E3C];
                objectArray[0x53262D1C ^ 0x53262D1C] = injectionPoint;
                objectArray[0x9D491DF6 ^ 0x9D491DF7] = this;
                objectArray[0x23EAEC09 ^ 0x23EAEC0B] = iMixinContext.getPriority();
                objectArray[0xD0B337D5 ^ 0xD0B337D6] = injectorTarget;
                objectArray[0x5BA72651 ^ 0x5BA72655] = injectorTarget.getMergedBy();
                objectArray[0x3FF6C7BE ^ 0x3FF6C7BB] = injectorTarget.getMergedPriority();
                throw new InvalidInjectionException(this.info, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f5\ua07e\ua90b\u7d36\u8e0f\u2469\u8b77\u3460{\ua7f2\ua4bd\ua031\ua915\u7d64\u8e43\u2475\u8b25\u347ef\ua7ff\ua4f5\ua034\ua901\u7d36\u8e49\u247b\u8b39\u3479}\ua7f2\ua4f5\ua078\ua90b\u7d7c\u8e4f\u2479\u8b23\u3437{\ua7e8\ua4a1\ua07e\ua945\u7d33\u8e59\u243a\u8b3a\u3472`\ua7e1\ua4b0\ua075\ua945\u7d74\u8e53\u243a\u8b72\u34642\ua7f1\ua4bc\ua065\ua90d\u7d36\u8e5a\u2468\u8b3e\u3478`\ua7ef\ua4a1\ua068\ua945\u7d33\u8e4e"), objectArray));
            }
            if (!this.findTargetNodes(methodNode, injectionPoint, injectorTarget.getSlice(injectionPoint), arrayList)) continue;
            for (AbstractInsnNode abstractInsnNode : arrayList) {
                Integer n = methodNode.instructions.indexOf(abstractInsnNode);
                TargetNode targetNode = (TargetNode)treeMap.get(n);
                if (targetNode == null) {
                    targetNode = new TargetNode(abstractInsnNode);
                    treeMap.put(n, targetNode);
                }
                targetNode.nominators.add(injectionPoint);
            }
        }
        return treeMap.values();
    }

    protected boolean findTargetNodes(MethodNode methodNode, InjectionPoint injectionPoint, InsnList insnList, Collection<AbstractInsnNode> collection) {
        return injectionPoint.find(methodNode.desc, insnList, collection);
    }

    protected void sanityCheck(Target target, List<InjectionPoint> list) {
        if (target.classNode != this.classNode) {
            throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua075\ua90a\u7d73\u8e59\u243a\u8b39\u3478f\ua7a6\ua4b8\ua070\ua911\u7d75\u8e42\u243a\u8b3e\u3479x\ua7e3\ua4b6\ua065\ua90a\u7d64\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua078\ua90b\u7d36") + this);
        }
    }

    protected abstract void inject(Target var1, InjectionNodes.InjectionNode var2);

    protected void postInject(Target target, InjectionNodes.InjectionNode injectionNode) {
    }

    protected AbstractInsnNode invokeHandler(InsnList insnList) {
        return this.invokeHandler(insnList, this.methodNode);
    }

    protected AbstractInsnNode invokeHandler(InsnList insnList, MethodNode methodNode) {
        int n;
        int n2 = (methodNode.access & (0x7FEE990C ^ 0x7FEE990E)) != 0 ? 0xE132C8DC ^ 0xE132C8DD : (n = 0xE36BF3B ^ 0xE36BF3B);
        int n3 = this.isStatic ? 0xBEAFC1CB ^ 0xBEAFC173 : (n != 0 ? 0x271B103E ^ 0x271B1089 : 0x8A1AB776 ^ 0x8A1AB7C0);
        MethodInsnNode methodInsnNode = new MethodInsnNode(n3, this.classNode.name, methodNode.name, methodNode.desc, (0x1BAD9A8C ^ 0x1BAD9A8C) != 0);
        insnList.add(methodInsnNode);
        this.info.addCallbackInvocation(methodNode);
        return methodInsnNode;
    }

    protected void throwException(InsnList insnList, String string, String string2) {
        insnList.add(new TypeInsnNode(0x9F4DFD12 ^ 0x9F4DFDA9, string));
        insnList.add(new InsnNode(0xA5EB69BE ^ 0xA5EB69E7));
        insnList.add(new LdcInsnNode(string2));
        insnList.add(new MethodInsnNode(0x4FA2A52A ^ 0x4FA2A59D, string, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(".\ua7ef\ua4bb\ua078\ua911\u7d28"), \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(":\ua7ca\ua4bf\ua070\ua913\u7d77\u8e05\u2476\u8b36\u3479u\ua7a9\ua486\ua065\ua917\u7d7f\u8e44\u247d\u8b6c\u343eD"), (0x81B95D01 ^ 0x81B95D01) != 0));
        insnList.add(new InsnNode(0x20D95E89 ^ 0x20D95E36));
    }

    public static boolean canCoerce(Type type, Type type2) {
        if (type.getSort() == (0x84C92BD9 ^ 0x84C92BD3)) {
            if (type2.getSort() == (0xAFAA6186 ^ 0xAFAA618C)) {
                return Injector.canCoerce(ClassInfo.forType(type), ClassInfo.forType(type2));
            }
        }
        return Injector.canCoerce(type.getDescriptor(), type2.getDescriptor());
    }

    public static boolean canCoerce(String string, String string2) {
        block3: {
            block2: {
                if (string.length() > (0xC0164D0A ^ 0xC0164D0B)) break block2;
                if (string2.length() <= (0xE41F90E3 ^ 0xE41F90E2)) break block3;
            }
            return (0x4D4C0136 ^ 0x4D4C0136) != 0;
        }
        return Injector.canCoerce(string.charAt(0xED84C428 ^ 0xED84C428), string2.charAt(0xB03C24AE ^ 0xB03C24AE));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean canCoerce(char c, char c2) {
        int n;
        if (c2 == (0x966A226C ^ 0x966A2225)) {
            if (\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7c4\ua486\ua052\ua93f").indexOf(c) > (0xC6BAEA09 ^ 0x394515F6)) {
                n = 0xE2737AFA ^ 0xE2737AFB;
                return n != 0;
            }
        }
        n = 0xC04423C4 ^ 0xC04423C4;
        return n != 0;
    }

    private static boolean canCoerce(ClassInfo classInfo, ClassInfo classInfo2) {
        return (classInfo != null && classInfo2 != null && (classInfo2 == classInfo || classInfo2.hasSuperClass(classInfo)) ? 0x987272B5 ^ 0x987272B4 : 0xC31C6C84 ^ 0xC31C6C84) != 0;
    }

    public static final class TargetNode {
        final AbstractInsnNode insn;
        final Set<InjectionPoint> nominators = new HashSet<InjectionPoint>();

        TargetNode(AbstractInsnNode abstractInsnNode) {
            this.insn = abstractInsnNode;
        }

        public AbstractInsnNode getNode() {
            return this.insn;
        }

        public Set<InjectionPoint> getNominators() {
            return Collections.unmodifiableSet(this.nominators);
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != TargetNode.class) {
                return (0x20820089 ^ 0x20820089) != 0;
            }
            return (((TargetNode)object).insn == this.insn ? 0xFA978EF5 ^ 0xFA978EF4 : 0xB5E65AE6 ^ 0xB5E65AE6) != 0;
        }

        public int hashCode() {
            return this.insn.hashCode();
        }
    }
}

