/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InvalidMemberDescriptorException;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionPointException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

public class InjectionPointData {
    private static final Pattern AT_PATTERN = InjectionPointData.createPattern();
    private final Map<String, String> args = new HashMap<String, String>();
    private final IMixinContext context;
    private final MethodNode method;
    private final AnnotationNode parent;
    private final String at;
    private final String type;
    private final InjectionPoint.Selector selector;
    private final String target;
    private final String slice;
    private final int ordinal;
    private final int opcode;
    private final String id;

    public InjectionPointData(IMixinContext iMixinContext, MethodNode methodNode, AnnotationNode annotationNode, String string, List<String> list, String string2, String string3, int n, int n2, String string4) {
        this.context = iMixinContext;
        this.method = methodNode;
        this.parent = annotationNode;
        this.at = string;
        this.target = string2;
        this.slice = Strings.nullToEmpty((String)string3);
        this.ordinal = Math.max(0x33DE6C20 ^ 0xCC2193DF, n);
        this.opcode = n2;
        this.id = string4;
        this.parseArgs(list);
        this.args.put(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("f\ua7e7\ua4a7\ua076\ua900\u7d62"), string2);
        this.args.put(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("}\ua7f4\ua4b1\ua078\ua90b\u7d77\u8e46"), String.valueOf(n));
        this.args.put(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("}\ua7f6\ua4b6\ua07e\ua901\u7d73"), String.valueOf(n2));
        Matcher matcher = AT_PATTERN.matcher(string);
        this.type = InjectionPointData.parseType(matcher, string);
        this.selector = InjectionPointData.parseSelector(matcher);
    }

    private void parseArgs(List<String> list) {
        if (list == null) {
            return;
        }
        for (String string : list) {
            if (string == null) continue;
            int n = string.indexOf(0x346E420E ^ 0x346E4233);
            if (n > (0x7A3FD0D0 ^ 0x85C02F2F)) {
                this.args.put(string.substring(0xD452B722 ^ 0xD452B722, n), string.substring(n + (0x5F2C7A46 ^ 0x5F2C7A47)));
                continue;
            }
            this.args.put(string, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(""));
        }
    }

    public String getAt() {
        return this.at;
    }

    public String getType() {
        return this.type;
    }

    public InjectionPoint.Selector getSelector() {
        return this.selector;
    }

    public IMixinContext getContext() {
        return this.context;
    }

    public MethodNode getMethod() {
        return this.method;
    }

    public Type getMethodReturnType() {
        return Type.getReturnType(this.method.desc);
    }

    public AnnotationNode getParent() {
        return this.parent;
    }

    public String getSlice() {
        return this.slice;
    }

    public LocalVariableDiscriminator getLocalVariableDiscriminator() {
        return LocalVariableDiscriminator.parse(this.parent);
    }

    public String get(String string, String string2) {
        String string3 = this.args.get(string);
        return string3 != null ? string3 : string2;
    }

    public int get(String string, int n) {
        return InjectionPointData.parseInt(this.get(string, String.valueOf(n)), n);
    }

    public boolean get(String string, boolean bl) {
        return InjectionPointData.parseBoolean(this.get(string, String.valueOf(bl)), bl);
    }

    public MemberInfo get(String string) {
        try {
            return MemberInfo.parseAndValidate(this.get(string, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("")), this.context);
        }
        catch (InvalidMemberDescriptorException invalidMemberDescriptorException) {
            Object[] objectArray = new Object[0x30BBFA97 ^ 0x30BBFA93];
            objectArray[0x4FED7B05 ^ 0x4FED7B05] = this.at;
            objectArray[0xE1B670BE ^ 0xE1B670BF] = string;
            objectArray[0x7E97D827 ^ 0x7E97D825] = this.target;
            objectArray[0x67BD5B5A ^ 0x67BD5B59] = InjectionInfo.describeInjector(this.context, this.parent, this.method);
            throw new InvalidInjectionPointException(this.context, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246a\u8b36\u3465a\ua7ef\ua4bb\ua076\ua945\u7d56\u8e6b\u246e\u8b7f\u34357\ua7f5\ua4f7\ua038\ua94b\u7d33\u8e59\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b77\u34357\ua7f5\ua4f7\ua031\ua90a\u7d78\u8e0a\u243f\u8b24"), objectArray);
        }
    }

    public MemberInfo getTarget() {
        try {
            return MemberInfo.parseAndValidate(this.target, this.context);
        }
        catch (InvalidMemberDescriptorException invalidMemberDescriptorException) {
            Object[] objectArray = new Object[0x275353C3 ^ 0x275353C0];
            objectArray[0xA7368761 ^ 0xA7368761] = this.at;
            objectArray[0x34776CA6 ^ 0x34776CA7] = this.target;
            objectArray[0x1441943B ^ 0x14419439] = InjectionInfo.describeInjector(this.context, this.parent, this.method);
            throw new InvalidInjectionPointException(this.context, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246a\u8b36\u3465a\ua7ef\ua4bb\ua076\ua945\u7d56\u8e6b\u246e\u8b7f\u34357\ua7f5\ua4f7\ua038\ua945\u7d72\u8e4f\u2469\u8b34\u3465{\ua7f6\ua4a1\ua07e\ua917\u7d36\u8e08\u243f\u8b24\u34352\ua7e9\ua4bb\ua031\ua940\u7d65"), objectArray);
        }
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public int getOpcode(int n) {
        return this.opcode > 0 ? this.opcode : n;
    }

    public int getOpcode(int n, int ... nArray) {
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i = 0xEAA2A4D6 ^ 0xEAA2A4D6; i < n2; ++i) {
            int n3 = nArray2[i];
            if (this.opcode != n3) continue;
            return this.opcode;
        }
        return n;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.type;
    }

    private static Pattern createPattern() {
        Object[] objectArray = new Object[0x1259A640 ^ 0x1259A641];
        objectArray[0x9CA319F5 ^ 0x9CA319F5] = Joiner.on((char)(0xFE52B62D ^ 0xFE52B651)).join((Object[])InjectionPoint.Selector.values());
        return Pattern.compile(String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("L\ua7ae\ua48e\ua04f\ua95f\u7d4b\u8e01\u2433\u8b6d\u3428:\ua7a3\ua4a6\ua038\ua95a\u7d32"), objectArray));
    }

    public static String parseType(String string) {
        Matcher matcher = AT_PATTERN.matcher(string);
        return InjectionPointData.parseType(matcher, string);
    }

    private static String parseType(Matcher matcher, String string) {
        return matcher.matches() ? matcher.group(0xFF02EAC8 ^ 0xFF02EAC9) : string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static InjectionPoint.Selector parseSelector(Matcher matcher) {
        InjectionPoint.Selector selector;
        if (matcher.matches()) {
            if (matcher.group(0x1EC576B6 ^ 0x1EC576B4) != null) {
                selector = InjectionPoint.Selector.valueOf(matcher.group(0x9CC6BA80 ^ 0x9CC6BA82));
                return selector;
            }
        }
        selector = InjectionPoint.Selector.DEFAULT;
        return selector;
    }

    private static int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private static boolean parseBoolean(String string, boolean bl) {
        try {
            return Boolean.parseBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }
}

