/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

public class Target
implements Comparable<Target>,
Iterable<AbstractInsnNode> {
    public final ClassNode classNode;
    public final MethodNode method;
    public final InsnList insns;
    public final boolean isStatic;
    public final boolean isCtor;
    public final Type[] arguments;
    public final Type returnType;
    private final int maxStack;
    private final int maxLocals;
    private final InjectionNodes injectionNodes = new InjectionNodes();
    private String callbackInfoClass;
    private String callbackDescriptor;
    private int[] argIndices;
    private List<Integer> argMapVars;
    private LabelNode start;
    private LabelNode end;

    public Target(ClassNode classNode, MethodNode methodNode) {
        this.classNode = classNode;
        this.method = methodNode;
        this.insns = methodNode.instructions;
        this.isStatic = Bytecode.methodIsStatic(methodNode);
        this.isCtor = methodNode.name.equals(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(".\ua7ef\ua4bb\ua078\ua911\u7d28"));
        this.arguments = Type.getArgumentTypes(methodNode.desc);
        this.returnType = Type.getReturnType(methodNode.desc);
        this.maxStack = methodNode.maxStack;
        this.maxLocals = methodNode.maxLocals;
    }

    public InjectionNodes.InjectionNode addInjectionNode(AbstractInsnNode abstractInsnNode) {
        return this.injectionNodes.add(abstractInsnNode);
    }

    public InjectionNodes.InjectionNode getInjectionNode(AbstractInsnNode abstractInsnNode) {
        return this.injectionNodes.get(abstractInsnNode);
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getCurrentMaxLocals() {
        return this.method.maxLocals;
    }

    public int getCurrentMaxStack() {
        return this.method.maxStack;
    }

    public int allocateLocal() {
        return this.allocateLocals(0x1D0F39E ^ 0x1D0F39F);
    }

    public int allocateLocals(int n) {
        int n2 = this.method.maxLocals;
        this.method.maxLocals += n;
        return n2;
    }

    public void addToLocals(int n) {
        this.setMaxLocals(this.maxLocals + n);
    }

    public void setMaxLocals(int n) {
        if (n > this.method.maxLocals) {
            this.method.maxLocals = n;
        }
    }

    public void addToStack(int n) {
        this.setMaxStack(this.maxStack + n);
    }

    public void setMaxStack(int n) {
        if (n > this.method.maxStack) {
            this.method.maxStack = n;
        }
    }

    public int[] generateArgMap(Type[] typeArray, int n) {
        if (this.argMapVars == null) {
            this.argMapVars = new ArrayList<Integer>();
        }
        int[] nArray = new int[typeArray.length];
        int n2 = 0xC98853A0 ^ 0xC98853A0;
        for (int i = n; i < typeArray.length; ++i) {
            int n3 = typeArray[i].getSize();
            nArray[i] = this.allocateArgMapLocal(n2, n3);
            n2 += n3;
        }
        return nArray;
    }

    private int allocateArgMapLocal(int n, int n2) {
        if (n >= this.argMapVars.size()) {
            int n3 = this.allocateLocals(n2);
            for (int i = 0xB408C614 ^ 0xB408C614; i < n2; ++i) {
                this.argMapVars.add(n3 + i);
            }
            return n3;
        }
        int n4 = this.argMapVars.get(n);
        if (n2 > (0xC9EAF3FF ^ 0xC9EAF3FE) && n + n2 > this.argMapVars.size()) {
            int n5 = this.allocateLocals(0x6008E580 ^ 0x6008E581);
            if (n5 == n4 + (0x97BF29B4 ^ 0x97BF29B5)) {
                this.argMapVars.add(n5);
                return n4;
            }
            this.argMapVars.set(n, n5);
            this.argMapVars.add(this.allocateLocals(0xDD612ED ^ 0xDD612EC));
            return n5;
        }
        return n4;
    }

    public int[] getArgIndices() {
        if (this.argIndices == null) {
            this.argIndices = this.calcArgIndices(this.isStatic ? 0x85000BE0 ^ 0x85000BE0 : 0xEFAF1847 ^ 0xEFAF1846);
        }
        return this.argIndices;
    }

    private int[] calcArgIndices(int n) {
        int[] nArray = new int[this.arguments.length];
        for (int i = 0x5A651483 ^ 0x5A651483; i < this.arguments.length; ++i) {
            nArray[i] = n;
            n += this.arguments[i].getSize();
        }
        return nArray;
    }

    public String getCallbackInfoClass() {
        if (this.callbackInfoClass == null) {
            this.callbackInfoClass = CallbackInfo.getCallInfoClassName(this.returnType);
        }
        return this.callbackInfoClass;
    }

    public String getSimpleCallbackDescriptor() {
        Object[] objectArray = new Object[0xF8407BC1 ^ 0xF8407BC0];
        objectArray[0x9DD4CDB0 ^ 0x9DD4CDB0] = this.getCallbackInfoClass();
        return String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(":\ua7ca\ua4f0\ua062\ua95e\u7d3f\u8e7c"), objectArray);
    }

    public String getCallbackDescriptor(Type[] typeArray, Type[] typeArray2) {
        return this.getCallbackDescriptor((0xEC1B81AC ^ 0xEC1B81AC) != 0, typeArray, typeArray2, 0xEDA30663 ^ 0xEDA30663, 0x24F5BCD ^ 0x24F2432);
    }

    public String getCallbackDescriptor(boolean bl, Type[] typeArray, Type[] typeArray2, int n, int n2) {
        if (this.callbackDescriptor == null) {
            Object[] objectArray = new Object[0xFB14FBE2 ^ 0xFB14FBE0];
            objectArray[0xCC98B7B0 ^ 0xCC98B7B0] = this.method.desc.substring(0xA80ECD01 ^ 0xA80ECD00, this.method.desc.indexOf(0x13BF643C ^ 0x13BF6415));
            objectArray[0x62EFE099 ^ 0x62EFE098] = this.getCallbackInfoClass();
            this.callbackDescriptor = String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(":\ua7a3\ua4a6\ua05d\ua940\u7d65\u8e11\u2433\u8b01"), objectArray);
        }
        if (!bl || typeArray == null) {
            return this.callbackDescriptor;
        }
        StringBuilder stringBuilder = new StringBuilder(this.callbackDescriptor.substring(0x8057FD60 ^ 0x8057FD60, this.callbackDescriptor.indexOf(0xCA678684 ^ 0xCA6786AD)));
        for (int i = n; i < typeArray.length && n2 > 0; ++i) {
            if (typeArray[i] == null) continue;
            stringBuilder.append(typeArray[i].getDescriptor());
            --n2;
        }
        return stringBuilder.append(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(";\ua7d0")).toString();
    }

    public String toString() {
        Object[] objectArray = new Object[0xA08CB101 ^ 0xA08CB102];
        objectArray[0xCA766916 ^ 0xCA766916] = this.classNode.name;
        objectArray[0xE0E64244 ^ 0xE0E64245] = this.method.name;
        objectArray[0x33A9DF62 ^ 0x33A9DF60] = this.method.desc;
        return String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4ef\ua02b\ua940\u7d65\u8e0f\u2469"), objectArray);
    }

    @Override
    public int compareTo(Target target) {
        if (target == null) {
            return 0xBD16DE86 ^ 0xC2E92179;
        }
        return this.toString().compareTo(target.toString());
    }

    public int indexOf(InjectionNodes.InjectionNode injectionNode) {
        return this.insns.indexOf(injectionNode.getCurrentTarget());
    }

    public int indexOf(AbstractInsnNode abstractInsnNode) {
        return this.insns.indexOf(abstractInsnNode);
    }

    public AbstractInsnNode get(int n) {
        return this.insns.get(n);
    }

    @Override
    public Iterator<AbstractInsnNode> iterator() {
        return this.insns.iterator();
    }

    public MethodInsnNode findInitNodeFor(TypeInsnNode typeInsnNode) {
        int n = this.indexOf(typeInsnNode);
        ListIterator<AbstractInsnNode> listIterator = this.insns.iterator(n);
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() != (0x82D90B14 ^ 0x82D90BA3)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodInsnNode.name) || !methodInsnNode.owner.equals(typeInsnNode.desc)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public MethodInsnNode findSuperInitNode() {
        if (!this.isCtor) {
            return null;
        }
        return Bytecode.findSuperInit(this.method, ClassInfo.forName(this.classNode.name).getSuperName());
    }

    public void insertBefore(InjectionNodes.InjectionNode injectionNode, InsnList insnList) {
        this.insns.insertBefore(injectionNode.getCurrentTarget(), insnList);
    }

    public void insertBefore(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        this.insns.insertBefore(abstractInsnNode, insnList);
    }

    public void replaceNode(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        this.insns.insertBefore(abstractInsnNode, abstractInsnNode2);
        this.insns.remove(abstractInsnNode);
        this.injectionNodes.replace(abstractInsnNode, abstractInsnNode2);
    }

    public void replaceNode(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2, InsnList insnList) {
        this.insns.insertBefore(abstractInsnNode, insnList);
        this.insns.remove(abstractInsnNode);
        this.injectionNodes.replace(abstractInsnNode, abstractInsnNode2);
    }

    public void wrapNode(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2, InsnList insnList, InsnList insnList2) {
        this.insns.insertBefore(abstractInsnNode, insnList);
        this.insns.insert(abstractInsnNode, insnList2);
        this.injectionNodes.replace(abstractInsnNode, abstractInsnNode2);
    }

    public void replaceNode(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        this.insns.insertBefore(abstractInsnNode, insnList);
        this.removeNode(abstractInsnNode);
    }

    public void removeNode(AbstractInsnNode abstractInsnNode) {
        this.insns.remove(abstractInsnNode);
        this.injectionNodes.remove(abstractInsnNode);
    }

    public void addLocalVariable(int n, String string, String string2) {
        if (this.start == null) {
            this.start = new LabelNode(new Label());
            this.end = new LabelNode(new Label());
            this.insns.insert(this.start);
            this.insns.add(this.end);
        }
        this.addLocalVariable(n, string, string2, this.start, this.end);
    }

    private void addLocalVariable(int n, String string, String string2, LabelNode labelNode, LabelNode labelNode2) {
        if (this.method.localVariables == null) {
            this.method.localVariables = new ArrayList<LocalVariableNode>();
        }
        this.method.localVariables.add(new LocalVariableNode(string, string2, null, labelNode, labelNode2, n));
    }
}

