/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

public abstract class MemberRef {
    private static final int[] H_OPCODES;

    public abstract boolean isField();

    public abstract int getOpcode();

    public abstract void setOpcode(int var1);

    public abstract String getOwner();

    public abstract void setOwner(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract String getDesc();

    public abstract void setDesc(String var1);

    public String toString() {
        String string = Bytecode.getOpcodeName(this.getOpcode());
        Object[] objectArray = new Object[0xCBAF8893 ^ 0xCBAF8896];
        objectArray[0x6BD9C5F3 ^ 0x6BD9C5F3] = string;
        objectArray[0x403DB62A ^ 0x403DB62B] = this.getOwner();
        objectArray[0xCB97549A ^ 0xCB975498] = this.getName();
        objectArray[0x4423AF67 ^ 0x4423AF64] = this.isField() ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("(") : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("");
        objectArray[0x858054A7 ^ 0x858054A3] = this.getDesc();
        return String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f5\ua077\ua90a\u7d64\u8e0a\u243f\u8b24\u34397\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MemberRef)) {
            return (0x1605940C ^ 0x1605940C) != 0;
        }
        MemberRef memberRef = (MemberRef)object;
        return (this.getOpcode() == memberRef.getOpcode() && this.getOwner().equals(memberRef.getOwner()) && this.getName().equals(memberRef.getName()) && this.getDesc().equals(memberRef.getDesc()) ? 0xD1CCE83E ^ 0xD1CCE83F : 0x9670892 ^ 0x9670892) != 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    static int opcodeFromTag(int n) {
        return n >= 0 && n < H_OPCODES.length ? H_OPCODES[n] : 0x20719922 ^ 0x20719922;
    }

    static int tagFromOpcode(int n) {
        for (int i = 0xCAEC55D1 ^ 0xCAEC55D0; i < H_OPCODES.length; ++i) {
            if (H_OPCODES[i] != n) continue;
            return i;
        }
        return 0xEE3B75AF ^ 0xEE3B75AF;
    }

    static {
        int[] nArray = new int[0xFCEAC56B ^ 0xFCEAC561];
        nArray[0xC5E65685 ^ 0xC5E65685] = 0xC185666C ^ 0xC185666C;
        nArray[0x98A35910 ^ 0x98A35911] = 0x8CD3BF9F ^ 0x8CD3BF2B;
        nArray[0x7EEB5119 ^ 0x7EEB511B] = 0xCA629EDA ^ 0xCA629E68;
        nArray[0x16BDBBC9 ^ 0x16BDBBCA] = 0x64CE203A ^ 0x64CE208F;
        nArray[0xBA834CB8 ^ 0xBA834CBC] = 0x69582290 ^ 0x69582223;
        nArray[0x7A56ED11 ^ 0x7A56ED14] = 0xCB168F2 ^ 0xCB16844;
        nArray[0x17B61113 ^ 0x17B61115] = 0xBB4BF397 ^ 0xBB4BF32F;
        nArray[0xC8AD11EA ^ 0xC8AD11ED] = 0xEB610FD9 ^ 0xEB610F6E;
        nArray[0xACE41CE8 ^ 0xACE41CE0] = 0x6AC9BDCB ^ 0x6AC9BD7C;
        nArray[0x89FEEC19 ^ 0x89FEEC10] = 0xF39F088E ^ 0xF39F0837;
        H_OPCODES = nArray;
    }

    public static final class Handle
    extends MemberRef {
        private org.spongepowered.asm.lib.Handle handle;

        public Handle(org.spongepowered.asm.lib.Handle handle) {
            this.handle = handle;
        }

        public org.spongepowered.asm.lib.Handle getMethodHandle() {
            return this.handle;
        }

        @Override
        public boolean isField() {
            switch (this.handle.getTag()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return (0xD6A33654 ^ 0xD6A33654) != 0;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return (0x7DBC77D2 ^ 0x7DBC77D3) != 0;
                }
            }
            throw new MixinTransformerError(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476u\ua7a6") + this.handle.getTag() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("<"));
        }

        @Override
        public int getOpcode() {
            int n = MemberRef.opcodeFromTag(this.handle.getTag());
            if (n == 0) {
                throw new MixinTransformerError(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476u\ua7a6") + this.handle.getTag() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("<"));
            }
            return n;
        }

        @Override
        public void setOpcode(int n) {
            int n2 = MemberRef.tagFromOpcode(n);
            if (n2 == 0) {
                throw new MixinTransformerError(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945") + Bytecode.getOpcodeName(n) + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("<"));
            }
            int n3 = n2 == (0x9B08B6F5 ^ 0x9B08B6FC) ? 0xA290CE05 ^ 0xA290CE04 : 0x23730884 ^ 0x23730884;
            this.handle = new org.spongepowered.asm.lib.Handle(n2, this.handle.getOwner(), this.handle.getName(), this.handle.getDesc(), n3 != 0);
        }

        @Override
        public String getOwner() {
            return this.handle.getOwner();
        }

        @Override
        public void setOwner(String string) {
            int n = this.handle.getTag() == (0xDECCA3EF ^ 0xDECCA3E6) ? 0x1B79AAA7 ^ 0x1B79AAA6 : 0x359BD18C ^ 0x359BD18C;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), string, this.handle.getName(), this.handle.getDesc(), n != 0);
        }

        @Override
        public String getName() {
            return this.handle.getName();
        }

        @Override
        public void setName(String string) {
            int n = this.handle.getTag() == (0x942AA295 ^ 0x942AA29C) ? 0x9D358DA1 ^ 0x9D358DA0 : 0xFA0377A7 ^ 0xFA0377A7;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), string, this.handle.getDesc(), n != 0);
        }

        @Override
        public String getDesc() {
            return this.handle.getDesc();
        }

        @Override
        public void setDesc(String string) {
            int n = this.handle.getTag() == (0x197E071 ^ 0x197E078) ? 0xE85B8202 ^ 0xE85B8203 : 0x9B0ECCAC ^ 0x9B0ECCAC;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), this.handle.getName(), string, n != 0);
        }
    }

    public static final class Field
    extends MemberRef {
        private static final int OPCODES = 183;
        public final FieldInsnNode insn;

        public Field(FieldInsnNode fieldInsnNode) {
            this.insn = fieldInsnNode;
        }

        @Override
        public boolean isField() {
            return (0xE4850ACF ^ 0xE4850ACE) != 0;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int n) {
            if ((n & (0x77802E51 ^ 0x77802EE6)) == 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d70\u8e45\u2468\u8b77\u3471{\ua7e3\ua4b9\ua075\ua945\u7d7f\u8e44\u2469\u8b23\u3465g\ua7e5\ua4a1\ua078\ua90a\u7d78\u8e10\u243a\u8b67\u346f") + Integer.toHexString(n));
            }
            this.insn.setOpcode(n);
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOwner(String string) {
            this.insn.owner = string;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setName(String string) {
            this.insn.name = string;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setDesc(String string) {
            this.insn.desc = string;
        }
    }

    public static final class Method
    extends MemberRef {
        private static final int OPCODES = 191;
        public final MethodInsnNode insn;

        public Method(MethodInsnNode methodInsnNode) {
            this.insn = methodInsnNode;
        }

        @Override
        public boolean isField() {
            return (0xB22DE078 ^ 0xB22DE078) != 0;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int n) {
            if ((n & (0x99E6668F ^ 0x99E66630)) == 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d70\u8e45\u2468\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901\u7d36\u8e43\u2474\u8b24\u3463`\ua7f3\ua4b6\ua065\ua90c\u7d79\u8e44\u2420\u8b77\u3427j") + Integer.toHexString(n));
            }
            this.insn.setOpcode(n);
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOwner(String string) {
            this.insn.owner = string;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setName(String string) {
            this.insn.name = string;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setDesc(String string) {
            this.insn.desc = string;
        }
    }
}

