/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.commons.ClassRemapper;
import org.spongepowered.asm.lib.commons.Remapper;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.transformers.MixinClassWriter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

final class InnerClassGenerator
implements IClassGenerator {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final Map<String, String> innerClassNames = new HashMap<String, String>();
    private final Map<String, InnerClassInfo> innerClasses = new HashMap<String, InnerClassInfo>();

    InnerClassGenerator() {
    }

    public String registerInnerClass(MixinInfo mixinInfo, String string, MixinTargetContext mixinTargetContext) {
        Object[] objectArray = new Object[0x75B1D65D ^ 0x75B1D65F];
        objectArray[0xEF74D0E1 ^ 0xEF74D0E1] = string;
        objectArray[0x36631551 ^ 0x36631550] = mixinTargetContext;
        String string2 = String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f0\ua062"), objectArray);
        String string3 = this.innerClassNames.get(string2);
        if (string3 == null) {
            string3 = InnerClassGenerator.getUniqueReference(string, mixinTargetContext);
            this.innerClassNames.put(string2, string3);
            this.innerClasses.put(string3, new InnerClassInfo(string3, string, mixinInfo, mixinTargetContext));
            Object[] objectArray2 = new Object[0xA215B2D3 ^ 0xA215B2D7];
            objectArray2[0xC5E97DA7 ^ 0xC5E97DA7] = string;
            objectArray2[0x95204F90 ^ 0x95204F91] = mixinInfo.getClassRef();
            objectArray2[0x318F9ED8 ^ 0x318F9EDA] = mixinTargetContext.getTargetClassRef();
            objectArray2[0xF4205AA ^ 0xF4205A9] = string3;
            logger.debug(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4bb\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a2\ua7e9\ua4bb\ua031\ua91e\u7d6b\u8e0a\u247d\u8b32\u3463a\ua7a6\ua4a0\ua07f\ua90c\u7d67\u8e5f\u247f\u8b77\u3479s\ua7eb\ua4b0\ua031\ua91e\u7d6b"), objectArray2);
        }
        return string3;
    }

    @Override
    public byte[] generate(String string) {
        String string2 = string.replace((char)(0xC3F91A87 ^ 0xC3F91AA9), (char)(0x6DEA3C5C ^ 0x6DEA3C73));
        InnerClassInfo innerClassInfo = this.innerClasses.get(string2);
        if (innerClassInfo != null) {
            return this.generate(innerClassInfo);
        }
        return null;
    }

    private byte[] generate(InnerClassInfo innerClassInfo) {
        try {
            Object[] objectArray = new Object[0x93A6EE40 ^ 0x93A6EE42];
            objectArray[0x9D6D3EF1 ^ 0x9D6D3EF1] = innerClassInfo.getName();
            objectArray[0xD3E088EF ^ 0xD3E088EE] = innerClassInfo.getOriginalName();
            logger.debug(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("U\ua7e3\ua4bb\ua074\ua917\u7d77\u8e5e\u2473\u8b39\u34702\ua7eb\ua4b4\ua061\ua915\u7d73\u8e4e\u243a\u8b3e\u3479|\ua7e3\ua4a7\ua031\ua906\u7d7a\u8e4b\u2469\u8b24\u3437i\ua7fb\ua4f5\ua039\ua90a\u7d64\u8e43\u247d\u8b3e\u3479s\ua7ea\ua4b9\ua068\ua945\u7d6d\u8e57\u2433"), objectArray);
            ClassReader classReader = new ClassReader(innerClassInfo.getClassBytes());
            MixinClassWriter mixinClassWriter = new MixinClassWriter(classReader, 0xFA69506E ^ 0xFA69506E);
            classReader.accept(new InnerClassAdapter((ClassVisitor)mixinClassWriter, innerClassInfo), 0x25973943 ^ 0x2597394B);
            return mixinClassWriter.toByteArray();
        }
        catch (InvalidMixinException invalidMixinException) {
            throw invalidMixinException;
        }
        catch (Exception exception) {
            logger.catching((Throwable)exception);
            return null;
        }
    }

    private static String getUniqueReference(String string, MixinTargetContext mixinTargetContext) {
        String string2 = string.substring(string.lastIndexOf(0x1EBF67BA ^ 0x1EBF679E) + (0xF04C0680 ^ 0xF04C0681));
        if (string2.matches(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("L\ua7dd\ua4e5\ua03c\ua95c\u7d4b\u8e01\u243e"))) {
            string2 = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("S\ua7e8\ua4ba\ua07f\ua91c\u7d7b\u8e45\u246f\u8b24");
        }
        Object[] objectArray = new Object[0x2A93DEF2 ^ 0x2A93DEF1];
        objectArray[0xAAF7F562 ^ 0xAAF7F562] = mixinTargetContext.getTargetClassRef();
        objectArray[0xBB3E454E ^ 0xBB3E454F] = string2;
        objectArray[0x223F8995 ^ 0x223F8997] = UUID.randomUUID().toString().replace(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("?"), \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(""));
        return String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f1\ua034\ua916\u7d32\u8e0f\u2469"), objectArray);
    }

    static class InnerClassAdapter
    extends ClassRemapper {
        private final InnerClassInfo info;

        public InnerClassAdapter(ClassVisitor classVisitor, InnerClassInfo innerClassInfo) {
            super(0xC902DD6 ^ 0xC952DD6, classVisitor, innerClassInfo);
            this.info = innerClassInfo;
        }

        @Override
        public void visitSource(String string, String string2) {
            super.visitSource(string, string2);
            AnnotationVisitor annotationVisitor = this.cv.visitAnnotation(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("^\ua7e9\ua4a7\ua076\ua94a\u7d65\u8e5a\u2475\u8b39\u3470w\ua7f6\ua4ba\ua066\ua900\u7d64\u8e4f\u247e\u8b78\u3476a\ua7eb\ua4fa\ua07c\ua90c\u7d6e\u8e43\u2474\u8b78\u3463`\ua7e7\ua4bb\ua062\ua903\u7d79\u8e58\u2477\u8b32\u3465=\ua7eb\ua4b0\ua065\ua904\u7d39\u8e67\u2473\u8b2f\u347e|\ua7cf\ua4bb\ua07f\ua900\u7d64\u8e11"), (0x2CA9CDD2 ^ 0x2CA9CDD2) != 0);
            annotationVisitor.visit(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7ef\ua4ad\ua078\ua90b"), this.info.getOwner().toString());
            annotationVisitor.visit(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("|\ua7e7\ua4b8\ua074"), this.info.getOriginalName().substring(this.info.getOriginalName().lastIndexOf(0x627170D9 ^ 0x627170F6) + (0x1252061C ^ 0x1252061D)));
            annotationVisitor.visitEnd();
        }

        @Override
        public void visitInnerClass(String string, String string2, String string3, int n) {
            if (string.startsWith(this.info.getOriginalName() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("6"))) {
                throw new InvalidMixinException((IMixinInfo)this.info.getOwner(), \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e5f\u2474\u8b24\u3462b\ua7f6\ua4ba\ua063\ua911\u7d73\u8e4e\u243a\u8b39\u3472a\ua7f2\ua4b0\ua075\ua945\u7d7f\u8e44\u2474\u8b32\u34652\ua7e5\ua4b9\ua070\ua916\u7d65\u8e0a") + string + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ef\ua4bb\ua031") + this.info.getOriginalName());
            }
            super.visitInnerClass(string, string2, string3, n);
        }
    }

    static class InnerClassInfo
    extends Remapper {
        private final String name;
        private final String originalName;
        private final MixinInfo owner;
        private final MixinTargetContext target;
        private final String ownerName;
        private final String targetName;

        InnerClassInfo(String string, String string2, MixinInfo mixinInfo, MixinTargetContext mixinTargetContext) {
            this.name = string;
            this.originalName = string2;
            this.owner = mixinInfo;
            this.ownerName = mixinInfo.getClassRef();
            this.target = mixinTargetContext;
            this.targetName = mixinTargetContext.getTargetClassRef();
        }

        String getName() {
            return this.name;
        }

        String getOriginalName() {
            return this.originalName;
        }

        MixinInfo getOwner() {
            return this.owner;
        }

        MixinTargetContext getTarget() {
            return this.target;
        }

        String getOwnerName() {
            return this.ownerName;
        }

        String getTargetName() {
            return this.targetName;
        }

        byte[] getClassBytes() throws ClassNotFoundException, IOException {
            return MixinService.getService().getBytecodeProvider().getClassBytes(this.originalName, (0x1641C7EB ^ 0x1641C7EA) != 0);
        }

        @Override
        public String mapMethodName(String string, String string2, String string3) {
            if (this.ownerName.equalsIgnoreCase(string)) {
                ClassInfo.Method method = this.owner.getClassInfo().findMethod(string2, string3, 0xEF919ED1 ^ 0xEF919EDB);
                if (method != null) {
                    return method.getName();
                }
            }
            return super.mapMethodName(string, string2, string3);
        }

        @Override
        public String map(String string) {
            if (this.originalName.equals(string)) {
                return this.name;
            }
            if (this.ownerName.equals(string)) {
                return this.targetName;
            }
            return string;
        }

        public String toString() {
            return this.name;
        }
    }
}

