/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InnerClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorAccessor;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorInterface;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorStandard;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinReloadException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTargetAlreadyLoadedException;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.perf.Profiler;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

class MixinInfo
implements Comparable<MixinInfo>,
IMixinInfo {
    private static final IMixinService classLoaderUtil = MixinService.getService();
    static int mixinOrder = 0xA75A4F6F ^ 0xA75A4F6F;
    private final transient Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final transient Profiler profiler = MixinEnvironment.getProfiler();
    private final transient MixinConfig parent;
    private final String name;
    private final String className;
    private final int priority;
    private final boolean virtual;
    private final List<ClassInfo> targetClasses;
    private final List<String> targetClassNames;
    private final transient int order;
    private final transient IMixinService service;
    private final transient IMixinConfigPlugin plugin;
    private final transient MixinEnvironment.Phase phase;
    private final transient ClassInfo info;
    private final transient SubType type;
    private final transient boolean strict;
    private transient State pendingState;
    private transient State state;

    MixinInfo(IMixinService iMixinService, MixinConfig mixinConfig, String string, boolean bl, IMixinConfigPlugin iMixinConfigPlugin, boolean bl2) {
        int n = mixinOrder;
        mixinOrder = n + (0xD0C02441 ^ 0xD0C02440);
        this.order = n;
        this.service = iMixinService;
        this.parent = mixinConfig;
        this.name = string;
        this.className = mixinConfig.getMixinPackage() + string;
        this.plugin = iMixinConfigPlugin;
        this.phase = mixinConfig.getEnvironment().getPhase();
        this.strict = mixinConfig.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_TARGETS);
        try {
            byte[] byArray = this.loadMixinClass(this.className, bl);
            this.pendingState = new State(byArray);
            this.info = this.pendingState.getClassInfo();
            this.type = SubType.getTypeFor(this);
        }
        catch (InvalidMixinException invalidMixinException) {
            throw invalidMixinException;
        }
        catch (Exception exception) {
            throw new InvalidMixinException((IMixinInfo)this, (Throwable)exception);
        }
        if (!this.type.isLoadable()) {
            classLoaderUtil.registerInvalidClass(this.className);
        }
        try {
            this.priority = this.readPriority(this.pendingState.getClassNode());
            this.virtual = this.readPseudo(this.pendingState.getClassNode());
            this.targetClasses = this.readTargetClasses(this.pendingState.getClassNode(), bl2);
            this.targetClassNames = Collections.unmodifiableList(Lists.transform(this.targetClasses, (Function)Functions.toStringFunction()));
        }
        catch (InvalidMixinException invalidMixinException) {
            throw invalidMixinException;
        }
        catch (Exception exception) {
            throw new InvalidMixinException((IMixinInfo)this, (Throwable)exception);
        }
    }

    void validate() {
        if (this.pendingState == null) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\\\ua7e9\ua4f5\ua061\ua900\u7d78\u8e4e\u2473\u8b39\u34702\ua7f0\ua4b4\ua07d\ua90c\u7d72\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4a6\ua065\ua904\u7d62\u8e4f\u243a\u8b31\u3478`\ua7a6") + this);
        }
        try {
            this.pendingState.validate(this.type, this.targetClasses);
            this.state = this.pendingState;
        }
        finally {
            this.pendingState = null;
        }
    }

    protected List<ClassInfo> readTargetClasses(MixinClassNode mixinClassNode, boolean bl) {
        if (mixinClassNode == null) {
            return Collections.emptyList();
        }
        AnnotationNode annotationNode = Annotations.getInvisible(mixinClassNode, Mixin.class);
        if (annotationNode == null) {
            Object[] objectArray = new Object[0x3A9BF1D7 ^ 0x3A9BF1D6];
            objectArray[0x321DCE6A ^ 0x321DCE6A] = this.className;
            throw new InvalidMixinException((IMixinInfo)this, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("F\ua7ee\ua4b0\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u34375\ua7a3\ua4a6\ua036\ua945\u7d7f\u8e59\u243a\u8b3a\u347ea\ua7f5\ua4bc\ua07f\ua902\u7d36\u8e4b\u2474\u8b77\u3457_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78"), objectArray));
        }
        ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
        List list = (List)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("d\ua7e7\ua4b9\ua064\ua900"));
        List list2 = (List)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e59"));
        if (list != null) {
            this.readTargets(arrayList, Lists.transform((List)list, (Function)new Function<Type, String>(){

                public String apply(Type type) {
                    return type.getClassName();
                }
            }), bl, (0x803F4854 ^ 0x803F4854) != 0);
        }
        if (list2 != null) {
            this.readTargets(arrayList, Lists.transform((List)list2, (Function)new Function<String, String>(){

                public String apply(String string) {
                    return MixinInfo.this.getParent().remapClassName(MixinInfo.this.getClassRef(), string);
                }
            }), bl, (0xFF25132B ^ 0xFF25132A) != 0);
        }
        return arrayList;
    }

    private void readTargets(Collection<ClassInfo> collection, Collection<String> collection2, boolean bl, boolean bl2) {
        for (String string : collection2) {
            Object object;
            String string2 = string.replace((char)(0x91F631A9 ^ 0x91F63186), (char)(0x293A2316 ^ 0x293A2338));
            if (classLoaderUtil.isClassLoaded(string2) && !this.isReloading()) {
                Object[] objectArray = new Object[0x55444DB1 ^ 0x55444DB3];
                objectArray[0xC59523AA ^ 0xC59523AA] = this;
                objectArray[0x428BD4FC ^ 0x428BD4FD] = string2;
                object = String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("Q\ua7f4\ua4bc\ua065\ua90c\u7d75\u8e4b\u2476\u8b77\u3467`\ua7e9\ua4b7\ua07d\ua900\u7d7b\u8e10\u243a\u8b72\u34642\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b72\u34642\ua7f1\ua4b4\ua062\ua945\u7d77\u8e46\u2468\u8b32\u3476v\ua7ff\ua4f5\ua065\ua917\u7d77\u8e44\u2469\u8b31\u3478`\ua7eb\ua4b0\ua075\ua94b"), objectArray);
                if (this.parent.isRequired()) {
                    throw new MixinTargetAlreadyLoadedException((IMixinInfo)this, (String)object, string2);
                }
                this.logger.error((String)object);
            }
            if (!this.shouldApplyMixin(bl, string2) || (object = this.getTarget(string2, bl2)) == null || collection.contains(object)) continue;
            collection.add((ClassInfo)object);
            ((ClassInfo)object).addMixin(this);
        }
    }

    private boolean shouldApplyMixin(boolean bl, String string) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("b\ua7ea\ua4a0\ua076\ua90c\u7d78"));
        int n = this.plugin == null || bl || this.plugin.shouldApplyMixin(string, this.className) ? 0x5FC5D781 ^ 0x5FC5D780 : 0x3E75A18F ^ 0x3E75A18F;
        section.end();
        return n != 0;
    }

    private ClassInfo getTarget(String string, boolean bl) throws InvalidMixinException {
        ClassInfo classInfo = ClassInfo.forName(string);
        if (classInfo == null) {
            if (this.isVirtual()) {
                Object[] objectArray = new Object[0x3458A845 ^ 0x3458A847];
                objectArray[0x29108DC0 ^ 0x29108DC0] = string;
                objectArray[0x99745020 ^ 0x99745021] = this;
                this.logger.debug(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("A\ua7ed\ua4bc\ua061\ua915\u7d7f\u8e44\u247d\u8b77\u3461{\ua7f4\ua4a1\ua064\ua904\u7d7a\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1\ua031\ua91e\u7d6b\u8e0a\u247c\u8b38\u34652\ua7fd\ua4a8"), objectArray);
            } else {
                Object[] objectArray = new Object[0xA84D28B1 ^ 0xA84D28B3];
                objectArray[0xEE9997B7 ^ 0xEE9997B7] = string;
                objectArray[0x24ADC5A8 ^ 0x24ADC5A9] = this;
                this.handleTargetError(String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R\ua7cb\ua4bc\ua069\ua90c\u7d78\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1\ua031\ua940\u7d65\u8e0a\u246d\u8b36\u34642\ua7e8\ua4ba\ua065\ua945\u7d70\u8e45\u246f\u8b39\u34732\ua7a3\ua4a6"), objectArray));
            }
            return null;
        }
        this.type.validateTarget(string, classInfo);
        if (bl && classInfo.isPublic() && !this.isVirtual()) {
            Object[] objectArray = new Object[0x36D0D8B6 ^ 0x36D0D8B4];
            objectArray[0x126B715A ^ 0x126B715A] = string;
            objectArray[0x74A23B47 ^ 0x74A23B46] = this;
            this.handleTargetError(String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R\ua7cb\ua4bc\ua069\ua90c\u7d78\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1\ua031\ua940\u7d65\u8e0a\u2473\u8b24\u3437b\ua7f3\ua4b7\ua07d\ua90c\u7d75\u8e0a\u2473\u8b39\u34377\ua7f5\ua4f5\ua070\ua90b\u7d72\u8e0a\u2469\u8b3f\u3478g\ua7ea\ua4b1\ua031\ua907\u7d73\u8e0a\u2469\u8b27\u3472q\ua7ef\ua4b3\ua078\ua900\u7d72\u8e0a\u2473\u8b39\u3437d\ua7e7\ua4b9\ua064\ua900"), objectArray));
        }
        return classInfo;
    }

    private void handleTargetError(String string) {
        if (this.strict) {
            this.logger.error(string);
            throw new InvalidMixinException((IMixinInfo)this, string);
        }
        this.logger.warn(string);
    }

    protected int readPriority(ClassNode classNode) {
        if (classNode == null) {
            return this.parent.getDefaultMixinPriority();
        }
        AnnotationNode annotationNode = Annotations.getInvisible(classNode, Mixin.class);
        if (annotationNode == null) {
            Object[] objectArray = new Object[0xF6364E9C ^ 0xF6364E9D];
            objectArray[0x5FE70BDC ^ 0x5FE70BDC] = this.className;
            throw new InvalidMixinException((IMixinInfo)this, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("F\ua7ee\ua4b0\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u34375\ua7a3\ua4a6\ua036\ua945\u7d7f\u8e59\u243a\u8b3a\u347ea\ua7f5\ua4bc\ua07f\ua902\u7d36\u8e4b\u2474\u8b77\u3457_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78"), objectArray));
        }
        Integer n = (Integer)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463"));
        return n == null ? this.parent.getDefaultMixinPriority() : n.intValue();
    }

    protected boolean readPseudo(ClassNode classNode) {
        return (Annotations.getInvisible(classNode, Pseudo.class) != null ? 0x467761BE ^ 0x467761BF : 0x9576504B ^ 0x9576504B) != 0;
    }

    private boolean isReloading() {
        return this.pendingState instanceof Reloaded;
    }

    private State getState() {
        return this.state != null ? this.state : this.pendingState;
    }

    ClassInfo getClassInfo() {
        return this.info;
    }

    @Override
    public IMixinConfig getConfig() {
        return this.parent;
    }

    MixinConfig getParent() {
        return this.parent;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getClassRef() {
        return this.getClassInfo().getName();
    }

    @Override
    public byte[] getClassBytes() {
        return this.getState().getClassBytes();
    }

    @Override
    public boolean isDetachedSuper() {
        return this.getState().isDetachedSuper();
    }

    public boolean isUnique() {
        return this.getState().isUnique();
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isAccessor() {
        return this.type instanceof SubType.Accessor;
    }

    public boolean isLoadable() {
        return this.type.isLoadable();
    }

    public Level getLoggingLevel() {
        return this.parent.getLoggingLevel();
    }

    @Override
    public MixinEnvironment.Phase getPhase() {
        return this.phase;
    }

    @Override
    public MixinClassNode getClassNode(int n) {
        return this.getState().createClassNode(n);
    }

    @Override
    public List<String> getTargetClasses() {
        return this.targetClassNames;
    }

    List<InterfaceInfo> getSoftImplements() {
        return Collections.unmodifiableList(this.getState().getSoftImplements());
    }

    Set<String> getSyntheticInnerClasses() {
        return Collections.unmodifiableSet(this.getState().getSyntheticInnerClasses());
    }

    Set<String> getInnerClasses() {
        return Collections.unmodifiableSet(this.getState().getInnerClasses());
    }

    List<ClassInfo> getTargets() {
        return Collections.unmodifiableList(this.targetClasses);
    }

    Set<String> getInterfaces() {
        return this.getState().getInterfaces();
    }

    MixinTargetContext createContextFor(TargetClassContext targetClassContext) {
        MixinClassNode mixinClassNode = this.getClassNode(0xC23F09A3 ^ 0xC23F09AB);
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("b\ua7f4\ua4b0"));
        MixinTargetContext mixinTargetContext = this.type.createPreProcessor(mixinClassNode).prepare().createContextFor(targetClassContext);
        section.end();
        return mixinTargetContext;
    }

    private byte[] loadMixinClass(String string, boolean bl) throws ClassNotFoundException {
        byte[] byArray = null;
        try {
            String string2;
            if (bl && (string2 = this.service.getClassRestrictions(string)).length() > 0) {
                Object[] objectArray = new Object[0x246B5F15 ^ 0x246B5F16];
                objectArray[0x4A2F43E5 ^ 0x4A2F43E5] = string2;
                objectArray[0x973F1FF3 ^ 0x973F1FF2] = this;
                objectArray[0xF1D1C074 ^ 0xF1D1C076] = string;
                this.logger.error(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("Q\ua7ea\ua4b4\ua062\ua916\u7d7a\u8e45\u247b\u8b33\u3472`\ua7a6\ua4a7\ua074\ua916\u7d62\u8e58\u2473\u8b34\u3463{\ua7e9\ua4bb\ua062\ua945\u7d4d\u8e51\u2467\u8b0a\u3437w\ua7e8\ua4b6\ua07e\ua910\u7d78\u8e5e\u247f\u8b25\u3472v\ua7a6\ua4b9\ua07e\ua904\u7d72\u8e43\u2474\u8b30\u3437i\ua7fb\ua4f9\ua031\ua90b\u7d77\u8e47\u247f\u8b6d\u3437i\ua7fb"), objectArray);
            }
            byArray = this.service.getBytecodeProvider().getClassBytes(string, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[0x1C89EA13 ^ 0x1C89EA12];
            objectArray[0x7FE2439C ^ 0x7FE2439C] = string;
            throw new ClassNotFoundException(String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("F\ua7ee\ua4b0\ua031\ua916\u7d66\u8e4f\u2479\u8b3e\u3471{\ua7e3\ua4b1\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u34375\ua7a3\ua4a6\ua036\ua945\u7d61\u8e4b\u2469\u8b77\u3479}\ua7f2\ua4f5\ua077\ua90a\u7d63\u8e44\u247e"), objectArray));
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[0x316C6129 ^ 0x316C6128];
            objectArray[0x103FB9EE ^ 0x103FB9EE] = string;
            this.logger.warn(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437~\ua7e9\ua4b4\ua075\ua945\u7d7b\u8e43\u2462\u8b3e\u34792\ua7fd\ua4a8\ua03d\ua945\u7d62\u8e42\u247f\u8b77\u3464b\ua7e3\ua4b6\ua078\ua903\u7d7f\u8e4f\u247e\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua945\u7d61\u8e43\u2476\u8b3b\u3437|\ua7e9\ua4a1\ua031\ua907\u7d73\u8e0a\u247b\u8b27\u3467~\ua7ef\ua4b0\ua075"), objectArray);
            throw new InvalidMixinException(this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("S\ua7e8\ua4f5\ua074\ua917\u7d64\u8e45\u2468\u8b77\u3460s\ua7f5\ua4f5\ua074\ua90b\u7d75\u8e45\u246f\u8b39\u3463w\ua7f4\ua4b0\ua075\ua945\u7d61\u8e42\u2473\u8b3b\u3464f\ua7a6\ua4b9\ua07e\ua904\u7d72\u8e43\u2474\u8b30\u3437f\ua7ee\ua4b0\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u3437q\ua7ea\ua4b4\ua062\ua916"), (Throwable)iOException);
        }
        return byArray;
    }

    void reloadMixin(byte[] byArray) {
        if (this.pendingState != null) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2468\u8b32\u347b}\ua7e7\ua4b1\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u3437e\ua7ee\ua4bc\ua07d\ua900\u7d36\u8e43\u246e\u8b77\u347ea\ua7a6\ua4bc\ua07f\ua90c\u7d62\u8e43\u247b\u8b3b\u347ea\ua7ef\ua4bb\ua076"));
        }
        this.pendingState = new Reloaded(this.state, byArray);
        this.validate();
    }

    @Override
    public int compareTo(MixinInfo mixinInfo) {
        if (mixinInfo == null) {
            return 0x8AA53F79 ^ 0x8AA53F79;
        }
        if (mixinInfo.priority == this.priority) {
            return this.order - mixinInfo.order;
        }
        return this.priority - mixinInfo.priority;
    }

    public void preApply(String string, ClassNode classNode) {
        if (this.plugin != null) {
            Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("b\ua7ea\ua4a0\ua076\ua90c\u7d78"));
            this.plugin.preApply(string, classNode, this.className, this);
            section.end();
        }
    }

    public void postApply(String string, ClassNode classNode) {
        if (this.plugin != null) {
            Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("b\ua7ea\ua4a0\ua076\ua90c\u7d78"));
            this.plugin.postApply(string, classNode, this.className, this);
            section.end();
        }
        this.parent.postApply(string, classNode);
    }

    public String toString() {
        Object[] objectArray = new Object[0xBE75830D ^ 0xBE75830F];
        objectArray[0x3E411E10 ^ 0x3E411E10] = this.parent.getName();
        objectArray[0x96715749 ^ 0x96715748] = this.name;
        return String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4ef\ua034\ua916"), objectArray);
    }

    static abstract class SubType {
        protected final MixinInfo mixin;
        protected final String annotationType;
        protected final boolean targetMustBeInterface;
        protected boolean detached;

        SubType(MixinInfo mixinInfo, String string, boolean bl) {
            this.mixin = mixinInfo;
            this.annotationType = string;
            this.targetMustBeInterface = bl;
        }

        Collection<String> getInterfaces() {
            return Collections.emptyList();
        }

        boolean isDetachedSuper() {
            return this.detached;
        }

        boolean isLoadable() {
            return (0x52D05242 ^ 0x52D05242) != 0;
        }

        void validateTarget(String string, ClassInfo classInfo) {
            boolean bl = classInfo.isInterface();
            if (bl != this.targetMustBeInterface) {
                String string2 = bl ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("") : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("|\ua7e9\ua4a1\ua031");
                throw new InvalidMixinException((IMixinInfo)this.mixin, this.annotationType + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua07c\ua90c\u7d65\u8e47\u247b\u8b23\u3474z\ua7bc\ua4f5") + string + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ef\ua4a6\ua031") + string2 + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("s\ua7e8\ua4f5\ua078\ua90b\u7d62\u8e4f\u2468\u8b31\u3476q\ua7e3\ua4f5\ua078\ua90b\u7d36") + this);
            }
        }

        abstract void validate(State var1, List<ClassInfo> var2);

        abstract MixinPreProcessorStandard createPreProcessor(MixinClassNode var1);

        static SubType getTypeFor(MixinInfo mixinInfo) {
            if (!mixinInfo.getClassInfo().isInterface()) {
                return new Standard(mixinInfo);
            }
            int n = 0xF39869C3 ^ 0xF39869C3;
            for (ClassInfo.Method method : mixinInfo.getClassInfo().getMethods()) {
                n |= !method.isAccessor() ? 0xC033FB9A ^ 0xC033FB9B : 0xB95DA2DF ^ 0xB95DA2DF;
            }
            if (n != 0) {
                return new Interface(mixinInfo);
            }
            return new Accessor(mixinInfo);
        }

        static class Accessor
        extends SubType {
            private final Collection<String> interfaces = new ArrayList<String>();

            Accessor(MixinInfo mixinInfo) {
                super(mixinInfo, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R\ua7cb\ua4bc\ua069\ua90c\u7d78"), (0xC9A4F196 ^ 0xC9A4F196) != 0);
                this.interfaces.add(mixinInfo.getClassRef());
            }

            @Override
            boolean isLoadable() {
                return (0x11A093A1 ^ 0x11A093A0) != 0;
            }

            @Override
            Collection<String> getInterfaces() {
                return this.interfaces;
            }

            @Override
            void validateTarget(String string, ClassInfo classInfo) {
                boolean bl = classInfo.isInterface();
                if (bl && !MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("S\ua7e5\ua4b6\ua074\ua916\u7d65\u8e45\u2468\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua945\u7d62\u8e4b\u2468\u8b30\u3472f\ua7f2\ua4bc\ua07f\ua902\u7d36\u8e4b\u2474\u8b77\u347e|\ua7f2\ua4b0\ua063\ua903\u7d77\u8e49\u247f\u8b77\u347ea\ua7a6\ua4bb\ua07e\ua911\u7d36\u8e59\u246f\u8b27\u3467}\ua7f4\ua4a1\ua074\ua901\u7d36\u8e43\u2474\u8b77\u3474g\ua7f4\ua4a7\ua074\ua90b\u7d62\u8e0a\u247f\u8b39\u3461{\ua7f4\ua4ba\ua07c\ua90b\u7d7b\u8e4f\u2474\u8b23"));
                }
            }

            @Override
            void validate(State state, List<ClassInfo> list) {
                MixinClassNode mixinClassNode = state.getClassNode();
                if (!\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(mixinClassNode.superName)) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("A\ua7f3\ua4a5\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4ba\ua077\ua945") + this + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ef\ua4a6\ua031\ua90c\u7d78\u8e5c\u247b\u8b3b\u347ev\ua7aa\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77") + mixinClassNode.superName.replace((char)(0x1DBF0AC9 ^ 0x1DBF0AE6), (char)(0x8022001C ^ 0x80220032)));
                }
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode mixinClassNode) {
                return new MixinPreProcessorAccessor(this.mixin, mixinClassNode);
            }
        }

        static class Interface
        extends SubType {
            Interface(MixinInfo mixinInfo) {
                super(mixinInfo, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R\ua7cb\ua4bc\ua069\ua90c\u7d78"), (0x626B5383 ^ 0x626B5382) != 0);
            }

            @Override
            void validate(State state, List<ClassInfo> list) {
                if (!MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4a1\ua074\ua917\u7d70\u8e4b\u2479\u8b32\u3437\u007f\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e44\u2475\u8b23\u3437a\ua7f3\ua4a5\ua061\ua90a\u7d64\u8e5e\u247f\u8b33\u3437{\ua7e8\ua4f5\ua072\ua910\u7d64\u8e58\u247f\u8b39\u34632\ua7e3\ua4bb\ua067\ua90c\u7d64\u8e45\u2477\u8b39\u347aw\ua7e8\ua4a1"));
                }
                MixinClassNode mixinClassNode = state.getClassNode();
                if (!\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(mixinClassNode.superName)) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("A\ua7f3\ua4a5\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4ba\ua077\ua945") + this + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ef\ua4a6\ua031\ua90c\u7d78\u8e5c\u247b\u8b3b\u347ev\ua7aa\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77") + mixinClassNode.superName.replace((char)(0x353B787B ^ 0x353B7854), (char)(0x2F9954BA ^ 0x2F995494)));
                }
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode mixinClassNode) {
                return new MixinPreProcessorInterface(this.mixin, mixinClassNode);
            }
        }

        static class Standard
        extends SubType {
            Standard(MixinInfo mixinInfo) {
                super(mixinInfo, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R\ua7cb\ua4bc\ua069\ua90c\u7d78"), (0x50B02736 ^ 0x50B02736) != 0);
            }

            @Override
            void validate(State state, List<ClassInfo> list) {
                MixinClassNode mixinClassNode = state.getClassNode();
                for (ClassInfo classInfo : list) {
                    if (mixinClassNode.superName.equals(classInfo.getSuperName())) continue;
                    if (!classInfo.hasSuperClass(mixinClassNode.superName, ClassInfo.Traversal.SUPER)) {
                        ClassInfo classInfo2 = ClassInfo.forName(mixinClassNode.superName);
                        if (classInfo2.isMixin()) {
                            for (ClassInfo classInfo3 : classInfo2.getTargets()) {
                                if (!list.contains(classInfo3)) continue;
                                throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3f\u347ew\ua7f4\ua4b4\ua063\ua906\u7d7e\u8e53\u243a\u8b33\u3472f\ua7e3\ua4b6\ua065\ua900\u7d72\u8e04\u243a\u8b13\u3472`\ua7ef\ua4a3\ua074\ua901\u7d36\u8e47\u2473\u8b2f\u347e|\ua7a6") + this + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u2469\u8b77\u3463z\ua7e3\ua4f5\ua062\ua904\u7d7b\u8e4f\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031") + classInfo3.getClassName() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7e7\ua4a6\ua031\ua90c\u7d62\u8e59\u243a\u8b24\u3462b\ua7e3\ua4a7\ua072\ua909\u7d77\u8e59\u2469\u8b77") + classInfo2.getClassName());
                            }
                        }
                        throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("A\ua7f3\ua4a5\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4f2") + mixinClassNode.superName.replace((char)(0x53506599 ^ 0x535065B6), (char)(0x83864886 ^ 0x838648A8)) + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("5\ua7a6\ua4ba\ua077\ua945") + this.mixin.getName() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7f1\ua4b4\ua062\ua945\u7d78\u8e45\u246e\u8b77\u3471}\ua7f3\ua4bb\ua075\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4bd\ua078\ua900\u7d64\u8e4b\u2468\u8b34\u347fk\ua7a6\ua4ba\ua077\ua945\u7d62\u8e4b\u2468\u8b30\u3472f\ua7a6\ua4b6\ua07d\ua904\u7d65\u8e59\u243a\u8b70") + classInfo + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("5"));
                    }
                    this.detached = 0x3AE0CFAE ^ 0x3AE0CFAF;
                }
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode mixinClassNode) {
                return new MixinPreProcessorStandard(this.mixin, mixinClassNode);
            }
        }
    }

    class Reloaded
    extends State {
        private final State previous;

        Reloaded(State state, byte[] byArray) {
            super(byArray, state.getClassInfo());
            this.previous = state;
        }

        @Override
        protected void validateChanges(SubType subType, List<ClassInfo> list) {
            if (!this.syntheticInnerClasses.equals(this.previous.syntheticInnerClasses)) {
                throw new MixinReloadException(MixinInfo.this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua031\ua90c\u7d78\u8e44\u247f\u8b25\u3437q\ua7ea\ua4b4\ua062\ua916\u7d73\u8e59"));
            }
            if (!this.interfaces.equals(this.previous.interfaces)) {
                throw new MixinReloadException(MixinInfo.this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua031\ua90c\u7d78\u8e5e\u247f\u8b25\u3471s\ua7e5\ua4b0\ua062"));
            }
            if (!new HashSet(this.softImplements).equals(new HashSet<InterfaceInfo>(this.previous.softImplements))) {
                throw new MixinReloadException(MixinInfo.this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua031\ua916\u7d79\u8e4c\u246e\u8b77\u347e|\ua7f2\ua4b0\ua063\ua903\u7d77\u8e49\u247f\u8b24"));
            }
            List<ClassInfo> list2 = MixinInfo.this.readTargetClasses(this.classNode, (0xA105B8A0 ^ 0xA105B8A1) != 0);
            if (!new HashSet<ClassInfo>(list2).equals(new HashSet<ClassInfo>(list))) {
                throw new MixinReloadException(MixinInfo.this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua031\ua911\u7d77\u8e58\u247d\u8b32\u34632\ua7e5\ua4b9\ua070\ua916\u7d65\u8e4f\u2469"));
            }
            int n = MixinInfo.this.readPriority(this.classNode);
            if (n != MixinInfo.this.getPriority()) {
                throw new MixinReloadException(MixinInfo.this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u3437b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463"));
            }
        }
    }

    class State {
        private byte[] mixinBytes;
        private final ClassInfo classInfo;
        private boolean detachedSuper;
        private boolean unique;
        protected final Set<String> interfaces = new HashSet<String>();
        protected final List<InterfaceInfo> softImplements = new ArrayList<InterfaceInfo>();
        protected final Set<String> syntheticInnerClasses = new HashSet<String>();
        protected final Set<String> innerClasses = new HashSet<String>();
        protected MixinClassNode classNode;

        State(byte[] byArray) {
            this(byArray, null);
        }

        State(byte[] byArray, ClassInfo classInfo) {
            this.mixinBytes = byArray;
            this.connect();
            this.classInfo = classInfo != null ? classInfo : ClassInfo.fromClassNode(this.getClassNode());
        }

        private void connect() {
            this.classNode = this.createClassNode(0xB333CA9D ^ 0xB333CA9D);
        }

        private void complete() {
            this.classNode = null;
        }

        ClassInfo getClassInfo() {
            return this.classInfo;
        }

        byte[] getClassBytes() {
            return this.mixinBytes;
        }

        MixinClassNode getClassNode() {
            return this.classNode;
        }

        boolean isDetachedSuper() {
            return this.detachedSuper;
        }

        boolean isUnique() {
            return this.unique;
        }

        List<? extends InterfaceInfo> getSoftImplements() {
            return this.softImplements;
        }

        Set<String> getSyntheticInnerClasses() {
            return this.syntheticInnerClasses;
        }

        Set<String> getInnerClasses() {
            return this.innerClasses;
        }

        Set<String> getInterfaces() {
            return this.interfaces;
        }

        MixinClassNode createClassNode(int n) {
            MixinClassNode mixinClassNode = new MixinClassNode(MixinInfo.this);
            ClassReader classReader = new ClassReader(this.mixinBytes);
            classReader.accept(mixinClassNode, n);
            return mixinClassNode;
        }

        void validate(SubType subType, List<ClassInfo> list) {
            MixinPreProcessorStandard mixinPreProcessorStandard = subType.createPreProcessor(this.getClassNode()).prepare();
            for (ClassInfo classInfo : list) {
                mixinPreProcessorStandard.conform(classInfo);
            }
            subType.validate(this, list);
            this.detachedSuper = subType.isDetachedSuper();
            this.unique = Annotations.getVisible(this.getClassNode(), Unique.class) != null ? 0x9CD5A608 ^ 0x9CD5A609 : 0xA5A3F740 ^ 0xA5A3F740;
            this.validateInner();
            this.validateClassVersion();
            this.validateRemappables(list);
            this.readImplementations(subType);
            this.readInnerClasses();
            this.validateChanges(subType, list);
            this.complete();
        }

        private void validateInner() {
            if (!this.classInfo.isProbablyStatic()) {
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4bb\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e4e\u247f\u8b34\u347bs\ua7f4\ua4b0\ua075\ua945\u7d65\u8e5e\u247b\u8b23\u347eq"));
            }
        }

        private void validateClassVersion() {
            if (this.classNode.version > MixinEnvironment.getCompatibilityLevel().classVersion()) {
                String string = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("<");
                MixinEnvironment.CompatibilityLevel[] compatibilityLevelArray = MixinEnvironment.CompatibilityLevel.values();
                int n = compatibilityLevelArray.length;
                for (int i = 0x4C548A37 ^ 0x4C548A37; i < n; ++i) {
                    MixinEnvironment.CompatibilityLevel compatibilityLevel = compatibilityLevelArray[i];
                    if (compatibilityLevel.classVersion() < this.classNode.version) continue;
                    Object[] objectArray = new Object[0x3AF4F726 ^ 0x3AF4F727];
                    objectArray[0x2F15BA62 ^ 0x2F15BA62] = compatibilityLevel.name();
                    string = String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("<\ua7a6\ua498\ua078\ua91d\u7d7f\u8e44\u243a\u8b25\u3472c\ua7f3\ua4bc\ua063\ua900\u7d65\u8e0a\u2479\u8b38\u347ab\ua7e7\ua4a1\ua078\ua907\u7d7f\u8e46\u2473\u8b23\u346e2\ua7ea\ua4b0\ua067\ua900\u7d7a\u8e0a\u243f\u8b24\u3437}\ua7f4\ua4f5\ua070\ua907\u7d79\u8e5c\u247f\u8b79"), objectArray);
                }
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("G\ua7e8\ua4a6\ua064\ua915\u7d66\u8e45\u2468\u8b23\u3472v\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua913\u7d73\u8e58\u2469\u8b3e\u3478|\ua7a6") + this.classNode.version + string);
            }
        }

        private void validateRemappables(List<ClassInfo> list) {
            if (list.size() > (0x6CD5B472 ^ 0x6CD5B473)) {
                for (Object object : this.classNode.fields) {
                    this.validateRemappable(Shadow.class, ((FieldNode)object).name, Annotations.getVisible((FieldNode)object, Shadow.class));
                }
                for (Object object : this.classNode.methods) {
                    this.validateRemappable(Shadow.class, ((MethodNode)object).name, Annotations.getVisible((MethodNode)object, Shadow.class));
                    AnnotationNode annotationNode = Annotations.getVisible((MethodNode)object, Overwrite.class);
                    if (annotationNode == null) continue;
                    if ((((MethodNode)object).access & (0xFF6ADF0E ^ 0xFF6ADF06)) != 0) {
                        if ((((MethodNode)object).access & (0x83FBB017 ^ 0x83FBB016)) != 0) continue;
                    }
                    throw new InvalidMixinException((IMixinInfo)MixinInfo.this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e6a\u2455\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u247b\u8b39\u3479}\ua7f2\ua4b4\ua065\ua90c\u7d79\u8e44\u243a\u8b38\u34792") + ((MethodNode)object).name + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ef\ua4bb\ua031") + MixinInfo.this);
                }
            }
        }

        private void validateRemappable(Class<Shadow> clazz, String string, AnnotationNode annotationNode) {
            if (annotationNode != null && Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("`\ua7e3\ua4b8\ua070\ua915"), Boolean.TRUE).booleanValue()) {
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e4b\u243a\u8b25\u3472\u007f\ua7e7\ua4a5\ua061\ua904\u7d74\u8e46\u247f\u8b77\u3457") + clazz.getSimpleName() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4ba\ua07f\ua945") + string + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ef\ua4bb\ua031") + this);
            }
        }

        void readImplementations(SubType subType) {
            this.interfaces.addAll(this.classNode.interfaces);
            this.interfaces.addAll(subType.getInterfaces());
            AnnotationNode annotationNode = Annotations.getInvisible(this.classNode, Implements.class);
            if (annotationNode == null) {
                return;
            }
            List list = (List)Annotations.getValue(annotationNode);
            if (list == null) {
                return;
            }
            for (AnnotationNode annotationNode2 : list) {
                InterfaceInfo interfaceInfo = InterfaceInfo.fromAnnotation(MixinInfo.this, annotationNode2);
                this.softImplements.add(interfaceInfo);
                this.interfaces.add(interfaceInfo.getInternalName());
                if (this instanceof Reloaded) continue;
                this.classInfo.addInterface(interfaceInfo.getInternalName());
            }
        }

        void readInnerClasses() {
            for (InnerClassNode innerClassNode : this.classNode.innerClasses) {
                ClassInfo classInfo = ClassInfo.forName(innerClassNode.name);
                if ((innerClassNode.outerName == null || !innerClassNode.outerName.equals(this.classInfo.getName())) && !innerClassNode.name.startsWith(this.classNode.name + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("6"))) continue;
                if (classInfo.isProbablyStatic() && classInfo.isSynthetic()) {
                    this.syntheticInnerClasses.add(innerClassNode.name);
                    continue;
                }
                this.innerClasses.add(innerClassNode.name);
            }
        }

        protected void validateChanges(SubType subType, List<ClassInfo> list) {
            subType.createPreProcessor(this.classNode).prepare();
        }
    }

    class MixinClassNode
    extends ClassNode {
        public final List<MixinMethodNode> mixinMethods;

        public MixinClassNode(MixinInfo mixinInfo2) {
            this(0xDF7D465C ^ 0xDF78465C);
        }

        public MixinClassNode(int n) {
            super(n);
            this.mixinMethods = this.methods;
        }

        public MixinInfo getMixin() {
            return MixinInfo.this;
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            MixinMethodNode mixinMethodNode = new MixinMethodNode(n, string, string2, string3, stringArray);
            this.methods.add(mixinMethodNode);
            return mixinMethodNode;
        }
    }

    class MixinMethodNode
    extends MethodNode {
        private final String originalName;

        public MixinMethodNode(int n, String string, String string2, String string3, String[] stringArray) {
            super(0xE61E6C10 ^ 0xE61B6C10, n, string, string2, string3, stringArray);
            this.originalName = string;
        }

        public String toString() {
            Object[] objectArray = new Object[0x1E38D3A0 ^ 0x1E38D3A2];
            objectArray[0xE6937868 ^ 0xE6937868] = this.originalName;
            objectArray[0x19DA352D ^ 0x19DA352C] = this.desc;
            return String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f0\ua062"), objectArray);
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public boolean isInjector() {
            return (this.getInjectorAnnotation() != null || this.isSurrogate() ? 0x4B2257FC ^ 0x4B2257FD : 0xA5151F01 ^ 0xA5151F01) != 0;
        }

        public boolean isSurrogate() {
            return (this.getVisibleAnnotation(Surrogate.class) != null ? 0x2E26C740 ^ 0x2E26C741 : 0xB9A8FD39 ^ 0xB9A8FD39) != 0;
        }

        public boolean isSynthetic() {
            return Bytecode.hasFlag(this, 0x5F0E4CED ^ 0x5F0E5CED);
        }

        public AnnotationNode getVisibleAnnotation(Class<? extends Annotation> clazz) {
            return Annotations.getVisible(this, clazz);
        }

        public AnnotationNode getInjectorAnnotation() {
            return InjectionInfo.getInjectorAnnotation(MixinInfo.this, this);
        }

        public IMixinInfo getOwner() {
            return MixinInfo.this;
        }
    }
}

